/*
 * File:   main.c
 * Author: wolleDD
 *
 * Created on 11. September 2025, 10:43
 */

// PIC16F887 Configuration Bit Settings

// 'C' source line config statements

// CONFIG1
#pragma config FOSC = INTRC_NOCLKOUT// Oscillator Selection bits (INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN)
#pragma config WDTE = ON        // Watchdog Timer Enable bit (WDT enabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config MCLRE = ON       // RE3/MCLR pin function select bit (RE3/MCLR pin function is MCLR)
#pragma config CP = OFF         // Code Protection bit (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Code Protection bit (Data memory code protection is disabled)
#pragma config BOREN = ON       // Brown Out Reset Selection bits (BOR enabled)
#pragma config IESO = ON        // Internal External Switchover bit (Internal/External Switchover mode is enabled)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enabled bit (Fail-Safe Clock Monitor is enabled)
#pragma config LVP = OFF        // Low Voltage Programming Enable bit (RB3 pin has digital I/O, HV on MCLR must be used for programming)

// CONFIG2
#pragma config BOR4V = BOR40V   // Brown-out Reset Selection bit (Brown-out Reset set to 4.0V)
#pragma config WRT = OFF        // Flash Program Memory Self Write Enable bits (Write protection off)

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

#include <xc.h>

#define _XTAL_FREQ 1000000 

void main(void) 
{
    OSCCON = 0b01110101;        // OSC settings
    ADCON0bits.ADON = 0;        // ADC off
    ADCON1 = 0x00;              // Vref internal
    ANSEL = 0x00;               // PORTA analog off
    ANSELH = 0x00;              // PORTB/E analog off  
    CM1CON0bits.C1ON = 0;       // Comperator 1 off
    CM2CON0bits.C2ON = 0;       // Comperator 2 off
    
    TRISA = 0x00;
    
    while (1)
    {
        PORTA = 0x00;
        __delay_ms(250);
        PORTA = 0xff;
        __delay_ms(250);
    }
    
    return;
}