# ***************************************************************************
#     Copyright (C) 2026 by Stefan Persson                                  *
#                                                                           *
# ***( see copyright.txt file at root folder )*******************************

# This is an example file for python processes
# An object is heated with a power that depends in input signal
# 5 V input gives 100 W
# It is also a thermal flow away from it to a heat sink

class ThermalPlant:
    def __init__(self):
        self.temperature = 0 # [C]
        self.temperature_sink = 5 # [C]

        self.last_sim_time_ps = 0
        self.mass = 1 # [kg]
        self.Cp = 200 # [j/(kg*K)
        self.kappa = 2 # [W/K]

    def process(self, sim_time_ps: int, inputs: list[float]) -> list[float]:
        delta_time = (sim_time_ps - self.last_sim_time_ps) / 1.0E12
        print(delta_time)
        power = 200/5*inputs[0] # 5V input gives 100 W
        print(delta_time*power/(self.Cp*self.mass))
                           # increase in temp due to heat element        thermal flow away from the object
        self.temperature = delta_time*power/(self.Cp*self.mass) - self.kappa*(self.temperature-self.temperature_sink)*delta_time/self.Cp + self.temperature

        self.last_sim_time_ps = sim_time_ps
        return [self.temperature]
        

