/*  Name     : main.c
 *  Purpose  : Main file for LED blinking code for PIC12F675.
 *  Author   : M.Saeed Yasin
 *  Date     : 20-06-12
 *  Revision : None
 */
#include<htc.h>

// Config word
__CONFIG(FOSC_INTRCIO & WDTE_OFF & PWRTE_ON & MCLRE_OFF & BOREN_ON & CP_OFF & CPD_OFF);

// Define LED pin
#define LED  GP0

// Define CPU Frequency
// This must be defined, if __delay_ms() or 
// __delay_us() functions are used in the code
#define _XTAL_FREQ   4000000    

// Main function
void main()
{	
	ANSEL  = 0x00;       // Set ports as digital I/O, not analog input
	ADCON0 = 0x00;		 // Shut off the A/D Converter
	CMCON  = 0x07;		 // Shut off the Comparator
	VRCON  = 0x00;	     // Shut off the Voltage Reference
	TRISIO = 0x08;       // GP3 input, rest all output
	GPIO   = 0x00;       // Make all pins 0
	
	while(1)
	{
		__delay_ms(500);       // Half sec delay
		LED = 0;               // LED off
		__delay_ms(500);       // Half sec delay
		LED = 1;               // LED on
	}
}

