;--------------------------------------------;
; Program : eeprom_test.asm                  ;
;--------------------------------------------;
; Exercise from the book "Pic in Practice"   ;
; Chapter 13                                 ;
; Using internal eeprom                      ;
; Binary count of switch presses on PORTA0   ;
; Count display on  PORTB                    ;
; Store the counter in eeprom                ; 
;--------------------------------------------;
; Leds on PORTB                              ;
;--------------------------------------------; 

; Disable 302 Assembler Message
ERRORLEVEL -302
    
    processor p16f84a
    #include "./p16f84.inc"
    
    __CONFIG H'3FFF' & H'3FF7' & H'3FFB' & H'3FFE'

    cblock 0x0C
        COUNT       ; Generic Counter
    endc

; Init eeprom       
 ;   org 0x2100      ; Init EEprom address
 ;       DE  0x00    ; First eeprom address = 0x00 

    org 0x00
;Init ports and devices
Main:
    banksel     TRISA
        movlw   B'00011111'
        movwf   TRISA
        clrf    TRISB
        movlw   B'00000111'
        movwf   OPTION_REG
        clrf    EECON1
    banksel     PORTA
        clrf    PORTB
        clrf    COUNT
        call    Read_EE0    ; Restore COUNT from EEprom
        movf    COUNT,W
        movwf   PORTB       ; Display value of COUNT
Start:
        btfsc   PORTA,0
        goto    $-1         ; Wait for Key press
        btfss   PORTA,0
        goto    $-1         ; Wait for Key release
        call    DelayP1
        incf    COUNT,F
        movf    COUNT,W
        movwf   PORTB
        call    Write_EE0   ; Store COUNT
        goto    Start
            
;-----------------------------;
;Soubroutine : Read_EE0       ;
;-----------------------------;
; Read EEprom address 0       ;
; And store in COUNT          ;
;-----------------------------;
Read_EE0:
        movlw   0x00
        movwf   EEADR       ; Set EEprom Address (0x00)
        bsf     STATUS,5
        bsf     EECON1,RD   ; Set EECON1 read bit
        bcf     STATUS,5
        movf    EEDATA,W    ; Copy data from EEprom
        movwf   COUNT       ; in COUNT
        return
        
;-----------------------------;
;Soubroutine : Write_EE0      ;
;-----------------------------;
; Write the value of COUNT in ;
; EEprom address 0            ;
;-----------------------------;
Write_EE0:
        bsf     STATUS,5
        bsf     EECON1,WREN ; Set EECON1 write enable bit
        bcf     STATUS,5
        movf    COUNT,W
        movwf   EEDATA      ; Copy COUNT -> EEDATA
        movlw   0x00
        movwf   EEADR       ; Set EEprom address 0
        
        ; Special sequence to activate write
        ; Sequentially write in EECON2
        ; 0x55
        ; 0xAA
        ; Set Write BIT in EECON1
        bsf     STATUS,5
        movlw   0x55        ; Set 0x55
        movwf   EECON2
        movlw   0xAA        ; Set 0xAA
        movwf   EECON2
        bsf     EECON1,WR   ; Set Write BIT
        
        ; Wait for the write to complete
        ;btfsc   EECON1,WR   ; WR bit cleared
        ;goto    $-1         ; no, keep waiting
        bcf     EECON1,WREN ; Yes, clear write enable bit
        bcf     STATUS,5    ; Set Bank 0
        return              
    
;-----------------------------;
;Soubroutine : DelayP1        ;
;-----------------------------;
; Delay of 0.1 Sec            ;
;-----------------------------;
DelayP1:
        clrf    TMR0
LoopA:
        movf    TMR0,W
        sublw   D'3'
        btfss   STATUS,Z
        goto    LoopA
        return
    end
