IoPort@ PortA = component.getPort("PORTA");
IoPort@ PortB = component.getPort("PORTB");
IoPin@ pin14 = component.getPin("IO14");
IoPin@ pin15 = component.getPin("IO15");
IoPin@ pin16 = component.getPin("IO16");
IoPin@ pin17 = component.getPin("IO17");
IoPin@ pin18 = component.getPin("IO18");
IoPin@ pin19 = component.getPin("IO19");
IoPin@ pin20 = component.getPin("IO20");
IoPin@ pin21 = component.getPin("IO21");
IoPin@ pin22 = component.getPin("IO22");
IoPin@ pin23 = component.getPin("IO23");

enum pinMode_t{
    undef_mode=0,
    input,
    openCo,
    output,
    source
};

array<bool> fuses(1671);
array<bool> pinval(22);
array<bool> fbval(10);
array<bool> fbprev(10);
array<bool> AC0(10);
array<bool> AC1(10);
array<bool> XORval(10);
array<bool> dval(10);
array<bool> dprev(10);
array<bool> qval(10);
array<bool> outval(10);
array<bool> oeval(10);
array<bool> oeprev(10);
array<bool> oe(10);
array<bool> prevoe(10);
bool        SYN;

uint delay = 5;

uint16 _prevA, _prevB;
bool pin1prev, ar, arprev, sp, spprev;
bool dchanged;
bool fbchanged;
bool clk;

void setup() // Executed at setScript()
{
    print("GAL setup()"); 
}

void reset() // Executed at Simulation start
{ 
int ix;

    print("GAL reset()");

    for( ix = 0; ix < 1671; ix++ )
      fuses[ix] = component.readPGM( ix ) > 0 ? true : false;
    for( ix = 0; ix < 22; ix++ )
    {
      pinval[ix] = false;
    }
    for( ix = 0; ix < 10; ix++ )
    {
      dval[ix] = false; dprev[ix] = false; qval[ix] = false;
      fbval[ix] = false; fbprev[ix] = false;
      oeval[ix] = false; oeprev[ix] = false; 
      oe[ix] = false; prevoe[ix] = false; 
      AC0[ix] = fuses[1620+ix]; AC0[ix] = fuses[1610+ix]; XORval[ix] = fuses[1600+ix];
    }
    SYN = fuses[1630];
    pin1prev = true; fbchanged = true; dchanged = true;
    clk = false;
    
    PortA.setPinMode( 1 ); // Input
    PortB.setPinMode( 1 ); // Input
//    PortA.changeCallBack( element, true ); // Register for Input Port voltage changes
    _prevA = 65535;
    _prevB = 65535;
    component.addEvent( 1000 );
}

void setDelay( uint delayval )
{
  if( delayval > 50 )
    delay = 50;
  else if( delayval < 1 )
    delay = 1;
  else
    delay = delayval;
}

uint getDelay()
{
    return delay;
}

void extClock( bool clkState )  // Function called 1e6 times per sec.
{
    print("extClock() : " + clkState );
}

void runEvent()
{
    voltChanged();
    component.addEvent( 1000 * delay );
}

void voltChanged()
{
int i;
uint16 _portA, _portB;
bool	or1, or2;

  _portA = PortA.getInpState();
  _portB = PortB.getInpState();
  for( i = 0; i < 12; i++ )
  {
    pinval[i] = (_portA & 1<<i) > 0 ? true : false;
  }
  for( i = 0; i < 10; i++ )
  {
    pinval[12+i] = (_portB & 1<<(9-i)) > 0 ? true : false;
  }
  fbchanged = false;
  for( i = 0; i < 10; i++ )
  {
    if( SYN && ( i == 0 || i == 9 ) )
    {
      if( i == 0 )
        fbval[0] = pinval[0];
      else
        fbval[9] = pinval[11];
    }
    else
    {
      if( AC1[i] )
        fbval[i] = pinval[21-i];
      else
        fbval[i] = !qval[i];
    }
    if( fbval[i] != fbprev[i] )
      fbchanged = true;
    fbprev[i] = fbval[i];
  }
  if( _portA != _prevA || _portB != _prevB || fbchanged == true )
  {
    _prevA = _portA;
    _prevB = _portB;

    clk = false;
    if( pinval[0] != pin1prev && pinval[0] == true )
    {
      clk = true;
    }
    pin1prev = pinval[0];
    
    for( i = 0; i < 10; i++ )
    {
      if( AC0[i] )
      {
        oeval[i] = calcAND( i * 160 );
        or1 = calcOR( i * 160 + 40, 3 );
        dval[i] = XORval[i] ? !or1 : or1;
      }
      else
      {
        or1 = calcOR( i * 160, 2 );
        or2 = calcOR( i * 160 + 80, 2 );
        dval[i] = or1 xor or2;
      }
    }
    dchanged = true;
  }
  if( dchanged )
  {
    _portB = 0;
    for( i = 0; i < 10; i++ )
    {
      if( clk )
        qval[i] = dprev[i];

      outval[i] = AC1[i] ? !dval[i] : !qval[i];

      if( outval[i] )
        _portB |= 1<<(i);
    }
    clk = false;

    for( i = 0; i < 10; i++ )
    {
      if( AC0[i] )
      {
        oe[i] = oeprev[i];
        oeprev[i] = oeval[i];
      }
      else
      {
        oe[i] = !pinval[11];
      }
    }

    if( oe[0] )
      pin23.setPinMode( output );
    else
      pin23.setPinMode( input );
    if( oe[1] )
      pin22.setPinMode( output );
    else
      pin22.setPinMode( input );
    if( oe[2] )
      pin21.setPinMode( output );
    else
      pin21.setPinMode( input );
    if( oe[3] )
      pin20.setPinMode( output );
    else
      pin20.setPinMode( input );
    if( oe[4] )
      pin19.setPinMode( output );
    else
      pin19.setPinMode( input );
    if( oe[5] )
      pin18.setPinMode( output );
    else
      pin18.setPinMode( input );
    if( oe[6] )
      pin17.setPinMode( output );
    else
      pin17.setPinMode( input );
    if( oe[7] )
      pin16.setPinMode( output );
    else
      pin16.setPinMode( input );
    if( oe[8] )
      pin15.setPinMode( output );
    else
      pin15.setPinMode( input );
    if( oe[9] )
      pin14.setPinMode( output );
    else
      pin14.setPinMode( input );

    PortB.setOutState( _portB );

    dchanged = false;
    for( i = 0; i < 10; i++ )
    {
      if( dval[i] != dprev[i] )
      {
        dprev[i] = dval[i]; dchanged = true;
      }
      if( oe[i] != prevoe[i] )
      {
        prevoe[i] = oe[i]; dchanged = true;
      }
    }
  }
} // voltChanged

bool calcAND( int firstAndFuse )
{
bool retval;
bool tempval;

  retval = pinval[1] || fuses[firstAndFuse];
  tempval = !pinval[1] || fuses[firstAndFuse+1];
  retval = retval && tempval;
  tempval = fbval[0] || fuses[firstAndFuse+2];
  retval = retval && tempval;
  tempval = !fbval[0] || fuses[firstAndFuse+3];
  retval = retval && tempval;
  tempval = pinval[2] || fuses[firstAndFuse+4];
  retval = retval && tempval;
  tempval = !pinval[2] || fuses[firstAndFuse+5];
  retval = retval && tempval;
  tempval = fbval[1] || fuses[firstAndFuse+6];
  retval = retval && tempval;
  tempval = !fbval[1] || fuses[firstAndFuse+7];
  retval = retval && tempval;
  tempval = pinval[3] || fuses[firstAndFuse+8];
  retval = retval && tempval;
  tempval = !pinval[3] || fuses[firstAndFuse+9];
  retval = retval && tempval;
  tempval = fbval[2] || fuses[firstAndFuse+10];
  retval = retval && tempval;
  tempval = !fbval[2] || fuses[firstAndFuse+11];
  retval = retval && tempval;
  tempval = pinval[4] || fuses[firstAndFuse+12];
  retval = retval && tempval;
  tempval = !pinval[4] || fuses[firstAndFuse+13];
  retval = retval && tempval;
  tempval = fbval[3] || fuses[firstAndFuse+14];
  retval = retval && tempval;
  tempval = !fbval[3] || fuses[firstAndFuse+15];
  retval = retval && tempval;
  tempval = pinval[5] || fuses[firstAndFuse+16];
  retval = retval && tempval;
  tempval = !pinval[5] || fuses[firstAndFuse+17];
  retval = retval && tempval;
  tempval = fbval[4] || fuses[firstAndFuse+18];
  retval = retval && tempval;
  tempval = !fbval[4] || fuses[firstAndFuse+19];
  retval = retval && tempval;
  tempval = pinval[6] || fuses[firstAndFuse+20];
  retval = retval && tempval;
  tempval = !pinval[6] || fuses[firstAndFuse+21];
  retval = retval && tempval;
  tempval = fbval[5] || fuses[firstAndFuse+22];
  retval = retval && tempval;
  tempval = !fbval[5] || fuses[firstAndFuse+23];
  retval = retval && tempval;
  tempval = pinval[7] || fuses[firstAndFuse+24];
  retval = retval && tempval;
  tempval = !pinval[7] || fuses[firstAndFuse+25];
  retval = retval && tempval;
  tempval = fbval[6] || fuses[firstAndFuse+26];
  retval = retval && tempval;
  tempval = !fbval[6] || fuses[firstAndFuse+27];
  retval = retval && tempval;
  tempval = pinval[8] || fuses[firstAndFuse+28];
  retval = retval && tempval;
  tempval = !pinval[8] || fuses[firstAndFuse+29];
  retval = retval && tempval;
  tempval = fbval[7] || fuses[firstAndFuse+30];
  retval = retval && tempval;
  tempval = !fbval[7] || fuses[firstAndFuse+31];
  retval = retval && tempval;
  tempval = pinval[9] || fuses[firstAndFuse+32];
  retval = retval && tempval;
  tempval = !pinval[9] || fuses[firstAndFuse+33];
  retval = retval && tempval;
  tempval = fbval[8] || fuses[firstAndFuse+34];
  retval = retval && tempval;
  tempval = !fbval[8] || fuses[firstAndFuse+35];
  retval = retval && tempval;
  tempval = pinval[10] || fuses[firstAndFuse+36];
  retval = retval && tempval;
  tempval = !pinval[10] || fuses[firstAndFuse+37];
  retval = retval && tempval;
  tempval = fbval[9] || fuses[firstAndFuse+38];
  retval = retval && tempval;
  tempval = !fbval[9] || fuses[firstAndFuse+39];
  retval = retval && tempval;

  return retval;
} // calcAND

bool calcOR( uint firstOrFuse, uint andNum)
{
uint ior;
bool retval2;
bool tempval2;

  retval2 = false;
  for( ior = 0; ior < andNum; ior++ )
  {
    tempval2 = calcAND( firstOrFuse + ior * 40 );
    retval2 = retval2 || tempval2;
  }
  return retval2;
} // calcOR
