IoPort@ PortA = component.getPort("PORTA");
IoPort@ PortB = component.getPort("PORTB");
IoPin@ pin12 = component.getPin("IO12");
IoPin@ pin13 = component.getPin("IO13");
IoPin@ pin14 = component.getPin("IO14");
IoPin@ pin15 = component.getPin("IO15");
IoPin@ pin16 = component.getPin("IO16");
IoPin@ pin17 = component.getPin("IO17");
IoPin@ pin18 = component.getPin("IO18");
IoPin@ pin19 = component.getPin("IO19");

enum pinMode_t{
    undef_mode=0,
    input,
    openCo,
    output,
    source
};

array<bool> fuses(2194);
array<bool> pinval(18);
array<bool> fbval(8);
array<bool> fbprev(8);
bool SYN;
bool AC0;
array<bool> AC1(8);
array<bool> XORfuse(8);
array<bool> PTD(64);
array<bool> dval(8);
array<bool> dprev(8);
array<bool> qval(8);
array<bool> outval(8);
array<bool> oeval(8);
array<bool> oeprev(8);
array<bool> oe(8);
array<bool> prevoe(8);
array<uint> oefuse(8);

uint delay = 5;

uint16 _prevA, _prevB;
bool pin1prev;
bool dchanged;
bool fbchanged;
bool clk;


void setup() // Executed at setScript()
{
    print("GAL16V8 setup()"); 
}

void reset() // Executed at Simulation start
{ 
int ix, iy;

    print("GAL16V8 reset()");

    for( ix = 0; ix < 2194; ix++ )
      fuses[ix] = component.readPGM( ix ) > 0 ? true : false;
    for( ix = 0; ix < 18; ix++ )
      pinval[ix] = false;
    for( ix = 0; ix < 8; ix++ )
    {
      dval[ix] = false; dprev[ix] = false; qval[ix] = false;
      fbval[ix] = false; fbprev[ix] = false;
      oeval[ix] = false; oeprev[ix] = false; 
      oe[ix] = false; prevoe[ix] = false; 
      AC1[ix] = fuses[2120+ix]; XORfuse[ix] = fuses[2048+ix];
      for( iy = 0; iy < 8; iy++ )
      {
        PTD[ix*8+iy] = !fuses[2128+ix*8+iy];
      }
    }
    SYN = fuses[2192]; AC0 = fuses[2193];
    pin1prev = true; fbchanged = true; dchanged = true;
    oefuse = { 0, 256, 512, 768, 1024, 1280, 1536, 1792 } ;
    clk = false;
    PortA.setPinMode( 1 ); // Input
    PortB.setPinMode( 1 ); // Input
//    PortA.changeCallBack( element, true ); // Register for Input Port voltage changes
//    PortB.changeCallBack( element, true ); // Register for Input Port voltage changes
    _prevA = 65535;
    _prevB = 65535;
    component.addEvent( 1000 );    // 1 ns
}

void setDelay( uint delayval )
{
  if( delayval > 50 )
    delay = 50;
  else if( delayval < 1 )
    delay = 1;
  else
    delay = delayval;
}

uint getDelay()
{
    return delay;
}

void extClock( bool clkState )  // Function called 1e6 times per sec.
{
    print("extClock() : " + clkState );
}

void runEvent()
{
    voltChanged();
    component.addEvent( 1000 * delay );
}

void voltChanged()
{
uint i;
uint16 _portA, _portB;

    _portA = PortA.getInpState();
    _portB = PortB.getInpState();

    for( i = 0; i < 10; i++ )
    {
      pinval[i] = (_portA & 1<<i) > 0 ? true : false;
    }
    for( i = 0; i < 8; i++ )
    {
      pinval[10+i] = (_portB & 1<<(7-i)) > 0 ? true : false;
    }

    fbchanged = false;

    for( i = 0; i < 8; i++ )
    {
      if( SYN )
      {
        if( AC0 )
        {
          if( i == 0 )
          {
            fbval[i] = pinval[0];
          }
          else if( i == 7 )
          {
            fbval[i] = pinval[9];
          }
          else
          {
            fbval[i] = pinval[17-i];
          }
        }
        else
        {
          if( i == 0 )
          {
            fbval[i] = pinval[0];
          }
          else if( i < 4 )
          {
            fbval[i] = pinval[18-i];
          }
          else if( i < 7 )
          {
            fbval[i] = pinval[16-i];
          }
          else
          {
            fbval[i] = pinval[9];
          }
        }
      }
      else
      {
        fbval[i] = AC1[i] ? pinval[17-i] : !qval[i];
      }
      if( fbval[i] != fbprev[i] )
      {
        fbchanged = true;
      }
      fbprev[i] = fbval[i];
    }

    if( _portA != _prevA || _portB != _prevB || fbchanged == true )
    {
      _prevA = _portA;
      _prevB = _portB;

      clk = false;
      if( !SYN )
      {
        if( pinval[0] != pin1prev && pinval[0] == true )
          clk = true;
        pin1prev = pinval[0];
      }

      for( i = 0; i < 8; i++ )
      {
        if( PTD[i*8] )
          oeval[i] = false;
        else
          oeval[i] = calcAND( oefuse[i] );
        if( AC1[i] )
          dval[i] = calcOR( 1, i );
        else
          dval[i] = calcOR( 0, i );
        if( XORfuse[i] )
          dval[i] = !dval[i];
      }
      dchanged = true;
    }
    if( dchanged )
    {
      _portB = 0;
      for( i = 0; i < 8; i++ )
      {
        if( clk )
        {
          qval[i] = dprev[i];
        }

        if( AC0 && !AC1[i] )
          outval[i] = !qval[i];
        else
          outval[i] = !dprev[i];

        if( outval[i] )
          _portB |= 1<<i;
      }
      clk = false;
      for( i = 0; i < 8; i++ )
      {
        if( SYN )
        {
          if( AC0 )
          {
            oe[i] = oeprev[i];
            oeprev[i] = oeval[i];
          }
          else
          {
            if( i == 3 || i == 4 )
            {
              oe[i] = true;
            }
            else
            {
              oe[i] = AC1[i] ? false : true;
            }
          }
        }
        else
        {
          if( AC1[i] )
          {
            oe[i] = oeprev[i];
            oeprev[i] = oeval[i];
          }
          else
          {
            oe[i] = !pinval[9];
          }
        }
      }
      if( oe[0] )
        pin19.setPinMode( output );
      else
        pin19.setPinMode( input );
      if( oe[1] )
        pin18.setPinMode( output );
      else
        pin18.setPinMode( input );
      if( oe[2] )
        pin17.setPinMode( output );
      else
        pin17.setPinMode( input );
      if( oe[3] )
        pin16.setPinMode( output );
      else
        pin16.setPinMode( input );
      if( oe[4] )
        pin15.setPinMode( output );
      else
        pin15.setPinMode( input );
      if( oe[5] )
        pin14.setPinMode( output );
      else
        pin14.setPinMode( input );
      if( oe[6] )
        pin13.setPinMode( output );
      else
        pin13.setPinMode( input );
      if( oe[7] )
        pin12.setPinMode( output );
      else
        pin12.setPinMode( input );

      PortB.setOutState( _portB );

      dchanged = false;

      for( i = 0; i < 8; i++ )
      {
        if( dval[i] != dprev[i] )
        {
          dprev[i] = dval[i]; dchanged = true;
        }
        if( oe[i] != prevoe[i] )
        {
          prevoe[i] = oe[i]; dchanged = true;
        }
      }
    }

} // voltChanged

bool calcAND( uint firstAndFuse )
{
bool retval;
bool tempval;

    retval = pinval[1] || fuses[firstAndFuse];
    tempval = !pinval[1] || fuses[firstAndFuse+1];
    retval = retval && tempval;
    tempval = fbval[0] || fuses[firstAndFuse+2];
    retval = retval && tempval;
    tempval = !fbval[0] || fuses[firstAndFuse+3];
    retval = retval && tempval;
    tempval = pinval[2] || fuses[firstAndFuse+4];
    retval = retval && tempval;
    tempval = !pinval[2] || fuses[firstAndFuse+5];
    retval = retval && tempval;
    tempval = fbval[1] || fuses[firstAndFuse+6];
    retval = retval && tempval;
    tempval = !fbval[1] || fuses[firstAndFuse+7];
    retval = retval && tempval;
    tempval = pinval[3] || fuses[firstAndFuse+8];
    retval = retval && tempval;
    tempval = !pinval[3] || fuses[firstAndFuse+9];
    retval = retval && tempval;
    tempval = fbval[2] || fuses[firstAndFuse+10];
    retval = retval && tempval;
    tempval = !fbval[2] || fuses[firstAndFuse+11];
    retval = retval && tempval;
    tempval = pinval[4] || fuses[firstAndFuse+12];
    retval = retval && tempval;
    tempval = !pinval[4] || fuses[firstAndFuse+13];
    retval = retval && tempval;
    tempval = fbval[3] || fuses[firstAndFuse+14];
    retval = retval && tempval;
    tempval = !fbval[3] || fuses[firstAndFuse+15];
    retval = retval && tempval;
    tempval = pinval[5] || fuses[firstAndFuse+16];
    retval = retval && tempval;
    tempval = !pinval[5] || fuses[firstAndFuse+17];
    retval = retval && tempval;
    tempval = fbval[4] || fuses[firstAndFuse+18];
    retval = retval && tempval;
    tempval = !fbval[4] || fuses[firstAndFuse+19];
    retval = retval && tempval;
    tempval = pinval[6] || fuses[firstAndFuse+20];
    retval = retval && tempval;
    tempval = !pinval[6] || fuses[firstAndFuse+21];
    retval = retval && tempval;
    tempval = fbval[5] || fuses[firstAndFuse+22];
    retval = retval && tempval;
    tempval = !fbval[5] || fuses[firstAndFuse+23];
    retval = retval && tempval;
    tempval = pinval[7] || fuses[firstAndFuse+24];
    retval = retval && tempval;
    tempval = !pinval[7] || fuses[firstAndFuse+25];
    retval = retval && tempval;
    tempval = fbval[6] || fuses[firstAndFuse+26];
    retval = retval && tempval;
    tempval = !fbval[6] || fuses[firstAndFuse+27];
    retval = retval && tempval;
    tempval = pinval[8] || fuses[firstAndFuse+28];
    retval = retval && tempval;
    tempval = !pinval[8] || fuses[firstAndFuse+29];
    retval = retval && tempval;
    tempval = fbval[7] || fuses[firstAndFuse+30];
    retval = retval && tempval;
    tempval = !fbval[7] || fuses[firstAndFuse+31];
    retval = retval && tempval;

    return retval;
} // calcAND

bool calcOR( uint firstPT, uint olmcnum)
{
uint ior;
bool retval2;
bool tempval2;
uint firstORfuse;

    retval2 = false;
    firstORfuse = 256 * olmcnum;
    for( ior = firstPT; ior < 8; ior++ )
    {
      if( PTD[olmcnum * 8 + ior] )
      {
        tempval2 = false;
      }
      else
      {
        tempval2 = calcAND( firstORfuse + ior * 32 );
      }
      retval2 = retval2 || tempval2;
    }

    return retval2;
} // calcOR
