;_____display_lcd1.h _________________________________________
;descrizione: la seguente libreria prevede lutilizzo della porta B, RB0  RB7
;per la trasmissione dei dati sui pin D0  D7
;il pin RA0 per pilotare il segnale E ed
;il pin RA1 per pilotare il segnale RS, 0 = comando, 1 = dato
;
;Funzione: invio_comando
;	serve ad inviare un comando al display, il codice da inviare deve essere caricato
;	in w prima che la funzione venga chiamata.
;	il file display_lcd1_mem.h contiene la definizione dei codici da poter caricare in w
;
;Funzione: invio_char
;	serve ad inviare un carattere da visualizzare sulla posizione corrente del cursore,
;	prima che la funzione venga chiamata bisogna caricare in w il valore ascii del 
;	carattere da visualizzare
;
;Funzione: cursor_home
;	Riporta il cursore nella prima posizione senza azzerare il contenuto del display
;
;Funzione: clr_home
;	Riporta il cursore nella prima posizione e azzera il contenuto del display
;
;Funzione: setta_ddram
;	setta il puntatore della ddram con il valore contenuto in w, quindi w va opportunamente
;	caricato prima che la funzione venga chiamata
;
invio_dato
	addlw 0
	btfss status,z
	goto $+3
	bcf porta, ra1
 	goto $+2
	bsf porta, ra1
	bsf porta, ra0
	movf dato,w
	movwf portb
	bcf porta, ra0
	return

invio_comando
	movwf  dato
	movlw 0
	call invio_dato
	movlw 11
	movwf time_L
	call delay_short
	return

invio_char
	movwf dato
	movlw 1
	call invio_dato
	movlw 11
	movwf time_L
	call delay_short
	return

cursor_home
	movlw 02h
	goto $+2

clr_home
	movlw 01h
	movwf dato
	movlw 0
	call invio_dato
	clrf time_H
	movlw 2
	movwf time_L
	call delay
	return

setta_ddram
	iorlw 80h
	goto $-26