;_____ delay.h __________________________________________________
;descrizione:
;	Raccolta di subroutine per la generazione dei ritardi
;	I ritardi riportati sono riferiti ad un clock di 4Mhz
;
;Funzione: delay
;	La funzione delay impone un ritardo in millisecondi la cui durata
;	 stabilita dai valori assegnati alle celle di mem. time_L e time_H.
;	la durata va da 00000000 00000001 = 1ms
;	a		11111111 11111111 = 65535ms
;	time_L e time_H vanno settati prima della chiamata di delay
;
;Funzione: delay_short
;	La funzione delay_short inpone delle attese brevi dell'ordine dei
;	microsecondi in funzione del valore di time_L
;	per time_L = 0 la durata  di 6s
;	per time_L <>0 la durata vale: 9s + (n-1)*3s
;	dove n  il valore caricato in time_L
;	dunque si ha un range che va da 6s a 771s con risoluzione di 3s

delay
	movf time_L, f
	btfss status,z
	goto $+5
	movf time_H, f
	btfsc status,z
	return
	decf time_H, f
	decf time_L, f
	movlw 0f8h
 	movwf contatore_delay
	nop
 	decfsz contatore_delay, f
	goto $-2
	nop
	goto delay

delay_short
	movf time_L, f
	btfsc status,z
	return	
	decfsz time_L,f
	goto $-1
	return