#include "ps2_Keyboard.h"

#define DATA  4
#define CLOCK 3

ps2::Keyboard<DATA, CLOCK> ps2Keyboard;
int scanCode;
char selection = 'Z';
bool inSystem = false;
String key = "";
String command = "";
byte LEDstat = 0x000;

void setup( ) {
  Serial.begin( 115200 );
  ps2Keyboard.begin();
  if ( ps2Keyboard.awaitStartup() ) Serial.println(F("Type something!\n(type HOST to enter host commands)\n"));
}


void loop( ) {
  scanCode = (int) ps2Keyboard.readScanCode();

  if ( scanCode != (int) ps2::KeyboardOutput::none ) {
    if ( scanCode == (int) ps2::KeyboardOutput::extend1 ) { // Eliminate E1 extend code
      while ( ( scanCode = (int) ps2Keyboard.readScanCode() ) == (int) ps2::KeyboardOutput::none ) ;
      scanCode |= 0x200;
    }
    else if ( scanCode == (int) ps2::KeyboardOutput::extend ) { // Eliminate E0 extend code
      while ( ( scanCode = (int) ps2Keyboard.readScanCode() ) == (int) ps2::KeyboardOutput::none ) ;
      scanCode |= 0x100;
    }
    if ( ( scanCode & 0xFF ) == (int) ps2::KeyboardOutput::unmake ) { // Eliminate break code
      while ( ps2Keyboard.readScanCode() == ps2::KeyboardOutput::none ) ;
      return;
    }
    key = "\nError Code !!\n";
    switch ( scanCode ) {
      case 0x01C: key = "A";                break;
      case 0x032: key = "B";                break;
      case 0x021: key = "C";                break;
      case 0x023: key = "D";                break;
      case 0x024: key = "E";                break;
      case 0x02B: key = "F";                break;
      case 0x034: key = "G";                break;
      case 0x033: key = "H";                break;
      case 0x043: key = "I";                break;
      case 0x03B: key = "J";                break;
      case 0x042: key = "K";                break;
      case 0x04B: key = "L";                break;
      case 0x03A: key = "M";                break;
      case 0x031: key = "N";                break;
      case 0x044: key = "O";                break;
      case 0x04D: key = "P";                break;
      case 0x015: key = "Q";                break;
      case 0x02D: key = "R";                break;
      case 0x01B: key = "S";                break;
      case 0x02C: key = "T";                break;
      case 0x03C: key = "U";                break;
      case 0x02A: key = "V";                break;
      case 0x01D: key = "W";                break;
      case 0x022: key = "X";                break;
      case 0x035: key = "Y";                break;
      case 0x01A: key = "Z";                break;
      case 0x045: key = "0";                break;
      case 0x016: key = "1";                break;
      case 0x01E: key = "2";                break;
      case 0x026: key = "3";                break;
      case 0x025: key = "4";                break;
      case 0x02E: key = "5";                break;
      case 0x036: key = "6";                break;
      case 0x03D: key = "7";                break;
      case 0x03E: key = "8";                break;
      case 0x046: key = "9";                break;
      case 0x00E: key = "`";                break;
      case 0x04E: key = "-";                break;
      case 0x055: key = "=";                break;
      case 0x05D: key = "\\";               break;
      case 0x066: key = "<Backspace>";      break;
      case 0x029: key = " ";                break;
      case 0x00D: key = "<Tab>";            break;
      case 0x058: key = "<Caps Lock>";      break;
      case 0x012: key = "<Left Shift>";     break;
      case 0x014: key = "<Left Control>";   break;
      case 0x011: key = "<Left Alt>";       break;
      case 0x059: key = "<Right Shift>";    break;
      case 0x05A: key = "<Enter>\n";        break;
      case 0x076: key = "<Escape>";         break;
      case 0x005: key = "<F1>";             break;
      case 0x006: key = "<F2>";             break;
      case 0x004: key = "<F3>";             break;
      case 0x00C: key = "<F4>";             break;
      case 0x003: key = "<F5>";             break;
      case 0x00B: key = "<F6>";             break;
      case 0x083: key = "<F7>";             break;
      case 0x00A: key = "<F8>";             break;
      case 0x001: key = "<F9>";             break;
      case 0x009: key = "<F10>";            break;
      case 0x078: key = "<F11>";            break;
      case 0x007: key = "<F12>";            break;
      case 0x07E: key = "<Scroll Lock>";    break;
      case 0x054: key = "[";                break;
      case 0x077: key = "<Num Lock>";       break;
      case 0x07C: key = "<Num *>";          break; 
      case 0x07B: key = "<Num ->";          break;
      case 0x079: key = "<Num +>";          break;
      case 0x071: key = "<Num .>";          break;
      case 0x070: key = "<Num 0>";          break;
      case 0x069: key = "<Num 1>";          break;
      case 0x072: key = "<Num 2>";          break;
      case 0x07A: key = "<Num 3>";          break; 
      case 0x06B: key = "<Num 4>";          break; 
      case 0x073: key = "<Num 5>";          break;
      case 0x074: key = "<Num 6>";          break;
      case 0x06C: key = "<Num 7>";          break; 
      case 0x075: key = "<Num 8>";          break;
      case 0x07D: key = "<Num 9>";          break;
      case 0x05B: key = "]";                break;
      case 0x04C: key = ";";                break;
      case 0x052: key = "'";                break;
      case 0x041: key = ",";                break;
      case 0x049: key = ".";                break;
      case 0x04A: key = "/";                break;
      case 0x170: key = "<Insert>";         break;
      case 0x16C: key = "<Home>";           break;
      case 0x17D: key = "<Page Up>";        break;
      case 0x171: key = "<Delete>";         break;
      case 0x169: key = "<End>";            break;
      case 0x17A: key = "<Page Down>";      break;
      case 0x175: key = "<Up Arrow>";       break;
      case 0x16B: key = "<Left Arrow>";     break;
      case 0x172: key = "<Down Arrow>";     break;
      case 0x174: key = "<Right Arrow>";    break;
      case 0x14A: key = "<Num />";          break;
      case 0x15A: key = "<Num Enter>\n";    break;
      case 0x114: key = "<Right Control>";  break;
      case 0x111: key = "<Right Alt>";      break;
      case 0x112: // Possible Print Screen. Wait for 0x7C.
        while ( ( scanCode = (int) ps2Keyboard.readScanCode() ) == (int) ps2::KeyboardOutput::none ) ;
        if ( scanCode == (int) ps2::KeyboardOutput::extend ) { // Eliminate E0 extend code
          while ( ( scanCode = (int) ps2Keyboard.readScanCode() ) == (int) ps2::KeyboardOutput::none ) ;
          if ( scanCode == 0x7C ) key = "<Print Screen>";
        }
        break;
      case 0x214: // Possible Pause / Break. Wait for 0x77.
        while ( ( scanCode = (int) ps2Keyboard.readScanCode() ) == (int) ps2::KeyboardOutput::none ) ;
        if ( scanCode == 0x77 ) key = "<Pause/Break>";
        break;
      default: break;
    }
    if ( inSystem ) {
      selection = key.charAt(0);
      switch ( selection ) {
        case 'A':
          if ( ps2Keyboard.reset() ) {
            LEDstat = 0x000;
            Serial.println(F("\nReset Completed Successfully"));
          }
          else Serial.println(F("\nError in Reset!!"));
          break;
        case 'B':
          if ( ps2Keyboard.echo() ) Serial.println(F("\nEcho Completed Successfully"));
          else Serial.println(F("\nError in Echo!!"));
          break;
        case 'C':
          if ( ps2Keyboard.readId() == 0xAB83 ) Serial.println(F("\nID AB83 Received Successfully"));
          else Serial.println(F("\nError in Read ID!!"));
          break;
        case 'D':
          if ( (int) ps2Keyboard.getScanCodeSet() == 2 ) Serial.println(F("\nScan Code Set 2 Received Successfully"));
          else Serial.println(F("\nError in  Get Scancode Set!!"));
          break;
        case 'E':
          LEDstat = LEDstat ^ 0b010;
          if ( ps2Keyboard.sendLedStatus( (ps2::KeyboardLeds) LEDstat ) ) {
            Serial.print(F("\nNum Lock "));
            ( LEDstat & 0b010 ) ? Serial.println("ON") : Serial.println("OFF");
          }
          else Serial.println(F("\nError in Setting LEDS!!"));
          break;
        case 'F':
          LEDstat = LEDstat ^ 0b100;
          if ( ps2Keyboard.sendLedStatus( (ps2::KeyboardLeds) LEDstat ) ) {
            Serial.print(F("\nCaps Lock "));
            ( LEDstat & 0b100 ) ? Serial.println("ON") : Serial.println("OFF");
          }
          else Serial.println(F("\nError in Setting LEDS!!"));
          break;
        case 'G':
          LEDstat = LEDstat ^ 0b001;
          if ( ps2Keyboard.sendLedStatus( (ps2::KeyboardLeds) LEDstat ) ) {
            Serial.print(F("\nScroll Lock "));
            ( LEDstat & 0b001 ) ? Serial.println("ON") : Serial.println("OFF");
          }
          else Serial.println(F("\nError in Setting LEDS!!"));
          break;
        case 'H':
          if ( ps2Keyboard.disable() ) Serial.println(F("\nKeyboard Disabled Successfully"));
          else Serial.println(F("\nError in Keyboard Disable!!"));
          delay(3000);
          if ( ps2Keyboard.enable() ) Serial.println(F("\nKeyboard Enabled Successfully"));
          else Serial.println(F("\nError in Keyboard Enable!!"));
          break;
        case 'I':
          if ( ps2Keyboard.setTypematicRateAndDelay((ps2::TypematicRate) 0x00, (ps2::TypematicStartDelay) 0b00) )
            Serial.println(F("\nTypematic Rate and Delay are 30.0cps and 0.25s"));
          else Serial.println(F("\nError in Setting Typematic Rate and Delay!!"));
          break;
        case 'J':
          if ( ps2Keyboard.setTypematicRateAndDelay((ps2::TypematicRate) 0x08, (ps2::TypematicStartDelay) 0b01) )
            Serial.println(F("\nTypematic Rate and Delay are 15.0cps and 0.50s"));
          else Serial.println(F("\nError in Setting Typematic Rate and Delay!!"));
          break;
        case 'K':
          if ( ps2Keyboard.setTypematicRateAndDelay((ps2::TypematicRate) 0x10, (ps2::TypematicStartDelay) 0b10) )
            Serial.println(F("\nTypematic Rate and Delay are 7.5cps and 0.75s"));
          else Serial.println(F("\nError in Setting Typematic Rate and Delay!!"));
          break;
        case 'L':
          if ( ps2Keyboard.setTypematicRateAndDelay((ps2::TypematicRate) 0x1F, (ps2::TypematicStartDelay) 0b11) )
            Serial.println(F("\nTypematic Rate and Delay are 2.0cps and 1.00s"));
          else Serial.println(F("\nError in Setting Typematic Rate and Delay!!"));
          break;
        case 'M':
          if ( ps2Keyboard.resetToDefaults() ) Serial.println(F("\nDefault Settings Applied"));
          else Serial.println(F("\nError in Setting Default Values!!"));
          break;
        case 'Z':
          Serial.println(F("\n\nType something!\n(type HOST to enter host commands)\n"));
          inSystem = false;
          break;
        default:
          break;
      }
      return;
    }
    Serial.print( key );
    if ( key == "H" ) command = key;
    else if ( command.length() ) {
      if ( command.length() < 4 ) command += key;
      else command = "";
    }
    if ( command == "HOST" ) {
      Serial.println(F("\n\nPress letter to test command:\n"));
      Serial.println(F("A: Reset"));
      Serial.println(F("B: Echo"));
      Serial.println(F("C: Read ID"));
      Serial.println(F("D: Get Scancode Set"));
      Serial.println(F("E: Toggle   Num  Lock"));
      Serial.println(F("F: Toggle  Caps  Lock"));
      Serial.println(F("G: Toggle Scroll Lock"));
      Serial.println(F("H: Disable Keyboard (will be re-enabled in 3s)"));
      Serial.println(F("I: Typematic Rate 30.0cps, Delay 0.25s"));
      Serial.println(F("J: Typematic Rate 15.0cps, Delay 0.50s"));
      Serial.println(F("K: Typematic Rate  7.5cps, Delay 0.75s"));
      Serial.println(F("L: Typematic Rate  2.0cps, Delay 1.00s"));
      Serial.println(F("M: Set Default Typematic Rate and Delay values"));
      Serial.println(F("Z: Exit host commands"));
      inSystem = true;
    }
  }
}