/***************************************************************************
 *   Copyright (C) 2018 by santiago González                               *
 *   santigoro@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/

#ifndef ROTSWITCH_H
#define ROTSWITCH_H

#include "itemlibrary.h"
#include "e-element.h"
#include "mech_contact.h"
#include "component.h"
#include "dialwidget.h"

class RotSwitch : public Component, public eElement
{
    public:
        RotSwitch( QString type, QString id );
        ~RotSwitch();

        static Component* construct( QString type, QString id );
        static LibraryItem *libraryItem();

        double rows();
        void setRows( double rows );
        int ways();
        void setways( int ways );

        virtual void stamp() override;
        virtual void remove() override;
        virtual void updateStep() override;

        virtual void paint( QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *widget ) override;

    public slots:
        virtual void dialChanged( int );

    protected:
        void updateProxy();

    private:
        void setupButtons();
        int m_rows;
        int m_ways;

        bool m_needUpdate;

        QPointF center;
        QPointF center1;
        double r = 32;

        CustomDial* m_dial;
        QGraphicsProxyWidget* m_proxy;
        
        QList<MechContact*> m_positions;

        QMetaObject::Connection m_keyEventConn;

        QVector<QPointF> point_pin1;
        QVector<QPointF> point_pin2;
        QVector<QPointF> point_arc;
        QVector<QPointF> point_arc1;
};

#endif
