// include the necessary libraries
#include <SPI.h>
#include <SD.h>
#include <TFT.h>  // Arduino LCD library

 

// pin definition for the Leonardo
#define sd_cs  5
#define lcd_cs 9
#define dc     10
#define rst    -1  

TFT TFTscreen = TFT(lcd_cs, dc, rst);

// this variable represents the image to be drawn on screen
PImage logo;


void setup() {
  // initialize the GLCD and show a message
  // asking the user to open the serial line
  TFTscreen.begin();
  TFTscreen.background(255, 255, 255);

  TFTscreen.stroke(255,0,0);
  TFTscreen.println();
  TFTscreen.println("Arduino prove lettura A0 A1");
  TFTscreen.stroke(255,0l, 0);
  TFTscreen.println("Open serial monitor");
  TFTscreen.println("to run the sketch");

  // initialize the serial port: it will be used to 
  // print some diagnostic info  
  Serial.begin(9600);
  // while (!Serial) {};
  delay (3000);

  // clear the GLCD screen before starting
  TFTscreen.background(255, 255, 255);
  
  // try to access the SD card. If that fails (e.g.
  // no card present), the setup process will stop.
  Serial.print("Initializing SD card...");
  if (!SD.begin(sd_cs)) {
    Serial.println("failed!");
    return;
  }
  Serial.println("OK!");
  
  // initialize and clear the GLCD screen
  TFTscreen.begin();
  TFTscreen.background(255, 255, 255);

  // now that the SD card can be access, try to load the
  // image file.
  logo = TFTscreen.loadImage("1.bmp");
  if (!logo.isValid()) {
    Serial.println("error while loading 1.bmp");
  }
}

void loop() {
  // don't do anything if the image wasn't loaded correctly.
  if (logo.isValid() == false) {
    return;
  }
  
  Serial.println("drawing image");

  // get a random location where to draw the image.
  // To avoid the image to be draw outside the screen,
  // take into account the image size.
  //int x = random(TFTscreen.width() - logo.width());
  //int y = random(TFTscreen.height() - logo.height());
  
  int x = 1;
  int y = 1;

  // draw the image to the screen
  TFTscreen.image(logo, x, y);

  // wait a little bit before drawing again
  delay(1500);
  TFTscreen.background(255, 255, 255);
}
