/***************************************************************************
 *                                                                         *
 *   For this component I took inspiration from the PICSimLab simulator    *
 *   created by Luis Claudio Gambôa Lopes.                                 *
 *                                                                         *
 *   For Copyright see copyright.txt file at root folder                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SD_H
#define SD_H

#include <QToolButton>
#include <QFile>

#include "e-clocked_device.h"
#include "component.h"
#include "iopin.h"

// SD card commands START
#define CMD0 0X00       // GO_IDLE_STATE Ripristino del software.
#define CMD1 0X01       // INVIA_OP_CONDAvviare il processo di inizializzazione.
// no spi #define CMD2 0X02 /** ALL_SEND_CID - Asks any card to send the CID. */
// no spi #define CMD3 0X03 /** SEND_RELATIVE_ADDR - Ask the card to publish a new RCA. */
// #define CMD6 0X06 /** SWITCH_FUNC - Switch Function Command */
// no spi #define CMD7  0X07 /** SELECT/DESELECT_CARD - toggles between the stand-by and transfer states. */
#define CMD8 0X08       // INVIA_SE_COND Solo per SDC V2. Controllare l'intervallo di tensione.
#define CMD9 0X09       // INVIA_CSD Leggere il registro CSD.
#define CMD10 0X0A      // INVIA_IDC Leggere il registro CID.
#define CMD12 0X0C      // STOP_TRASMISSIONE Fermati a leggere i dati.
#define CMD13 0X0D      //
// CMD14                // MMCPLUS_BUSTEST_R
// CMD15                // GO_INACTIVE
#define CMD16 0X10      // SET_BLOCKLEN Modifica la dimensione del blocco R/W.
#define CMD17 0X11      // LEGGI_SINGOLO_BLOCCO Leggi un blocco.
#define CMD18 0X12      // LEGGI_BLOCCO_MULTIPLO Leggere più blocchi.
// CMD23                // MMC_SET_BLOCK_COUNT
#define CMD24 0X18      // SCRITTURA_BLOCCO Scrivi un blocco.
#define CMD25 0X19      // SCRIVI_BLOCCO_MULTIPLO Scrivi più blocchi.
// CMD26                // PROGRAM_CID - PROGRAM_CSD
// CMD28                // SET_WRITE_PROT
// CMD29                // CLR_WRITE_PROT
// CMD30                // SEND_WRITE_PROT
#define CMD32 0X20      // MMC_ERASE_WR_BLK_START
#define CMD33 0X21      // MMC_ERASE_WR_BLK_END
#define CMD38 0X26      // ERASE erase previously selected blocks
// CMD42                // MMC_LOCK_UNLOCK
#define CMD55 0X37      // APP_CMD Comando principale del comando ACMD<n>.
// CMD56                // GEN_CMD
#define CMD58 0X3A      // LEGGI_OCR Leggi OCR.
#define CMD59 0X3B      // CRC on/off
//  no spi  #define ACMD6 0X06 /** SET_BUS_WIDTH - Defines the data bus width for data transfer. */
#define ACMD13 0X0D     // SD_APP_SEND_STATUS
// ACMD18               // SECURE_READ_MULTI_BLOCK
// ACMD22               // SD_APP_SEND_NUM_WR_BLKS
#define ACMD23 0X17     // SET_WR_BLOCK_ERASE_COUNT Solo per SDC. Definisci il numero di blocchi da pre-cancellare
                        // con il prossimo comando di scrittura multi-blocco.
// ACMD25               // SECURE_WRITE_MULT_BLOCK
// ACMD26               // SECURE_WRITE_MKB
// ACMD38               // SECURE_ERASE
#define ACMD41 0X29     // APP_SEND_OP_COND Solo per SDC. Avvia il processo di inizializzazione.
#define ACMD42 0X2A     // SD_APP_SET_CLR_CARD_DETECT
// ACMD43               // GET_MKB
// ACMD44               // GET_MID
// ACMD45               // SET_CER_RN1
// ACMD46               // GET_CER_RN2
// ACMD47               // SET_CER_RES2
// ACMD48               // GET_CER_RES1
// ACMD49               // Change Secure Area
#define ACMD51 0X33     // SEND SCR
// SD card commands END

#define MAX_REPLY 72    // Max Reply

class LibraryItem;

class  Sd : public Component, public eClockedDevice
{
    public:
        Sd( QString type, QString id );
        ~Sd();
        
        static Component* construct( QString type, QString id );
        static LibraryItem* libraryItem();

        // SD Card
        typedef struct {
            QFile* fd;                      // File Disck image .img
            unsigned char card_present;     // If card is present
            unsigned long arg;              // Argomento
            unsigned char cmd;
            unsigned char crc;
            unsigned short replyc;
            unsigned char reply[MAX_REPLY];
            unsigned char ap_cmd;
            unsigned short data_rc;
            unsigned short data_wc;
            unsigned char multi_rd;
            unsigned char multi_wr;
            unsigned long disk_size;        // in kb
            unsigned long ebstart;
            unsigned long ebend;
            unsigned char R1;               // R1 response
            unsigned char crc_on;
            unsigned int cmd_count;         // used for boot
            unsigned char cmd_buff[5];
            unsigned short crc16;
        } sdcard_t;

        unsigned char CRC7(const unsigned char* buffer, const unsigned int size);
        unsigned short CRC16(const unsigned char* buffer, unsigned int size);
        void sdcard_rst();
        void sdcard_init();
        void sdcard_end();
        void sdcard_set_card_present(unsigned char cp);
        void sdcard_set_filename(QString& fname);
        void LoadFile();

        // Simulide
        virtual void stamp() override;
        virtual void initialize() override;
        virtual void voltChanged() override;
        virtual void remove() override;

        QString fileName() { return m_fileName; }
        void setFile( QString fileName );

        virtual void paint( QPainter* p, const QStyleOptionGraphicsItem* option, QWidget* widget )override;

    public slots:
        void onbuttonclicked();

    protected:
        void proccessCommand();

        unsigned int spi_insr;         // Received value
        unsigned int spi_outsr;        // Valore trasmesso
        unsigned char spi_bit;         // Bit ricevuti
        unsigned int spi_byte;         // Byte ricevuti

        //Inputs
        IoPin m_pinCS;
        IoPin m_pinMosi;
        IoPin m_pinSck;
        IoPin m_pinMiso;

        // unsigned char prev_txReg;

        bool open;
        QString m_fileName;
        unsigned char buff[512];

        sdcard_t m_sd;

        QToolButton *m_button;
        QGraphicsProxyWidget* m_proxy;

        QMetaObject::Connection m_keyEventConn;

        QList<Component*> m_Compsd;
};

#endif

