#include <SPI.h>
#include <SD.h>

#define MIO_FILE "wales.bmp" // Nome del file da leggere
#define CS_PIN 4 // Pin CS della scheda SD

File mioFile;

void setup() {
  Serial.begin(9600);
  while (!Serial) {
    ; // Attende l'apertura del monitor seriale (solo su Arduino Leonardo)
  }

  if (!SD.begin(CS_PIN)) {
    Serial.println("Errore nella inizializzazione della scheda SD!");
    return;
  }
  Serial.println("Scheda SD inizializzata con successo.");

  mioFile = SD.open(MIO_FILE);

  if (mioFile) {
    Serial.print("Contenuto di ");
    Serial.println(MIO_FILE);

    int byteLetto;
    int count = 0;
    while (mioFile.available()) {
      byteLetto = mioFile.read();
      Serial.print("0x");
      if (byteLetto < 0x10) {
        Serial.print("0"); // Aggiunge uno zero iniziale se il valore è inferiore a 0x10
      }
      Serial.print(byteLetto, HEX);
      Serial.print(" ");
      count++;

      if (count % 16 == 0) { // Va a capo ogni 16 byte
        Serial.println();
      }
    }
    mioFile.close();
    Serial.println("\nLettura completata.");
  } else {
    Serial.println("Errore nell'apertura del file!");
  }
}

void loop() {
  // Nessuna operazione necessaria nel loop
}
