
IoPort@ PortM = component.getPort("PORTM");
IoPort@ PortO = component.getPort("PORTO");

// INPUT:
    IoPin@  VDD_Pin    = component.getPin("VDD");
    IoPin@  STEP_Pin   = component.getPin("STEP");
    IoPin@  SLEEP_Pin  = component.getPin("SLEEP");
    IoPin@  DIR_Pin    = component.getPin("DIR");
    IoPin@  ENABLE_Pin = component.getPin("ENABLE");
    IoPin@  RESET_Pin  = component.getPin("RESET");
// OUTPUT:    
    IoPin@  OUT1A_Pin = component.getPin("OUT1A");
    IoPin@  OUT1B_Pin = component.getPin("OUT1B");
    IoPin@  OUT2A_Pin = component.getPin("OUT2A");
    IoPin@  OUT2B_Pin = component.getPin("OUT2B");
    IoPin@  SENSE1    = component.getPin("SENSE1");
    IoPin@  SENSE2    = component.getPin("SENSE2");

// Const Values:
const int START_value = 0;
const float threshold = 2.5;
const float max_V_rate = 0.5;

// Definition of values for intern functions 
int INPUT = 1;
int OUTPUT = 3;

// Array definitions by step size:
const int array_full = 0;
const int array_half = 1;
const int array_quarter = 2;
const int array_eightth = 3;
const int array_sixteenth = 7;
const int array_size = 64;

// :
int ms_input = 0;
int pos_y = START_value;
int array_step = START_value;

bool last_CLK;

const array<double> arr = {
         0, 0.0980, 0.1951, 0.2903, 0.3827, 0.4714, 0.5556, 0.6344,
    0.7071, 0.7730, 0.8315, 0.8819, 0.9239, 0.9569, 0.9808, 0.9952,
         1, 0.9952, 0.9808, 0.9569, 0.9239, 0.8819, 0.8315, 0.7730,
    0.7071, 0.6344, 0.5556, 0.4714, 0.3827, 0.2903, 0.1951, 0.0980,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

void setup()
{
    print("A4988 init ");
}

// Unterscheidet bei der einzugebenden Variable, in diesem Fall "INPUT" nicht zwischen Groß- und Kleinschreibung!
void reset()
{ 
    print("resetting A4988"); 
    pos_y = START_value;   
    // INPUTS:
    VDD_Pin.setPinMode(INPUT);
    STEP_Pin.setPinMode(INPUT);

    SLEEP_Pin.setPinMode(INPUT);
    DIR_Pin.setPinMode(INPUT);
    ENABLE_Pin.setPinMode(INPUT); 
    RESET_Pin.setPinMode(INPUT);
    
    PortM.setPinMode(INPUT);
    
    // OUTPUTS:
    PortO.setPinMode(OUTPUT);
    PortO.setOutState( 0 );
    
    SENSE1.setPinMode(OUTPUT);
    SENSE1.setVoltage( 0 );
    SENSE2.setPinMode(OUTPUT);
    SENSE2.setVoltage( 0 );

    STEP_Pin.changeCallBack( element, true ); // Register for Input Port voltage changes
}

void voltChanged()
{
    // Controll that Step changed value:
    bool clk = STEP_Pin.getVoltage() > threshold;
    bool rising = ( last_CLK != clk && clk );
    last_CLK = clk;

    if( SLEEP_Pin.getVoltage() < threshold ) return; //sleeping

    if( RESET_Pin.getVoltage() < threshold ) // RESET
    {
        pos_y = START_value;
        PortO.setOutState( 0 );
        return;
    }
    // Check SENSE1-Pin and SENSE2-Pin:
    if( SENSE1.getVoltage() > max_V_rate|| SENSE2.getVoltage() > max_V_rate )
    {
        print("SHUTDOWN");
        PortO.setOutState( 0 );
        return;
    }
    if( !rising ) return; // Not a rising edge
    
    int DIR = (DIR_Pin.getVoltage() < threshold) ? 1 : -1;

    int input = PortM.getInpState(); // Determine ms_input:
    if( ms_input != input )
    {
        ms_input = input;

        int old_step = array_step;
        
        switch (ms_input) {
           case array_full:      array_step = 16; break;
           case array_half:      array_step = 8;  break;
           case array_quarter:   array_step = 4;  break;
           case array_eightth:   array_step = 2;  break;
           case array_sixteenth: array_step = 1;  break;
        }
        // Change pos_y if array_step changed:
        int rema = pos_y % array_step;
        if( rema != 0 )
            pos_y = ((pos_y - rema)/array_step + 1) * array_step;
    }
    pos_y += array_step * DIR;    // Change pos_y up by value of the choosed array-step
    pos_y = checkBounds( pos_y );

    if( ENABLE_Pin.getVoltage() > threshold ) PortO.setOutState( 0 ); // DISABLED
    else{
        double VDD_Value = VDD_Pin.getVoltage();
        OUT1A_Pin.setVoltage( VDD_Value*arr[checkBounds(pos_y+32)] );
        OUT1B_Pin.setVoltage( VDD_Value*arr[checkBounds(pos_y+ 0)] );
        OUT2A_Pin.setVoltage( VDD_Value*arr[checkBounds(pos_y+16)] );
        OUT2B_Pin.setVoltage( VDD_Value*arr[checkBounds(pos_y+48)] );
    }
}

int checkBounds( int posy )
{
    if     ( posy < 0           ) posy += array_size;
    else if( posy >= array_size ) posy -= array_size;
    return posy;
}