
IoPin@ pPin = component.getPin("In");
IoPin@ nPin = component.getPin("Ref");

double lastV;
double lastD;
double maxV;

void setup() // Executed when Component is created
{
    print("Linked  setup() OK"); 
}

void reset() // Executed at Simulation start
{
    lastV = 0;
    lastD = 0;
    maxV  = -1e12;
    
    pPin.setPinMode( 1 ); // input
    nPin.setPinMode( 1 ); // input
    
    pPin.changeCallBack( element, true );
    //nPin.changeCallBack( element, true );
    
    component.setLinkedString( 0, "0 V", 0 );
}

void updateStep() // Called at circuit refresh rate (default 20 FPS)
{
    string str="";
    
    if( maxV != -1e12 ){
        str= maxV*0.7071;
        maxV = -1e12;
    }
    else str = pPin.getVoltage()-nPin.getVoltage();
    
    uint strLen = str.length();
    if     ( strLen > 5 ) str = str.substr( 0, 5 );
    else if( strLen < 5 ) while( str.length() < 5 ) str = " "+str;
     
    component.setLinkedString( 0, str+ " V", 0 );
}

void voltChanged() // Called at pin voltage change: pPin.changeCallBack()
{
    double voltage = pPin.getVoltage()-nPin.getVoltage();
    double deltaV  = voltage - lastV;

    if( lastD > 0 && deltaV < 0 ) maxV = lastV; // maximum

    lastD = deltaV;
    lastV = voltage;
}
