    #include <xc.inc>
      CONFIG  FOSC = HS             
      CONFIG  WDTE = OFF            
      CONFIG  PWRTE = OFF           
      CONFIG  BOREN = OFF           
      CONFIG  LVP = OFF             
      CONFIG  CPD = OFF             
      CONFIG  WRT = OFF             
      CONFIG  CP = OFF              
    bit_counter equ 0x70	;variable to store the number of right shifts required in the captured key value     
    rwFlag equ 0x72	;this variable is to store the number of complete cycle for high burst in the 562.5us duration
    tempVar equ 0x73	;this variable is to store the number of complete cycle for high burst in the 9ms duration 
    impliedVal equ 0x74	; this variable is to store the implied value from the key pressed by user.
    slave_address equ 0x71  ; to store the slave address
    A_COUNTER equ 0x76	; a counter
    loop_1 equ 0x77
    loop_2 equ 0x78
    loop_extra equ 0x79
;    tempVar equ 0x7A
 
; ==== Program Flows ====== 
; the SCL cycle freq is going to be 100kHz or 10us cycle period.
; the SDA cycle is the same with 2.5us running ahead of the SCL cycle.
; START CONDITION: set SDA to low first and delay 2.5us to set SCL low 
; 1st MSB, say 1, delay 5us and set SDA=1 then delay 2.5us and set SCL=1    
; delay for 5us then change SCL=0. One bit of SDA has finished transmission here.
; delay for another 2.5us to set the next bit SDA value.
; After processing the last bit, turn PIN to RX from TX and the SDA line will become high. And continue to send the SCL
; i.e. delay for another 2.5us for SCL=0 then change it to SCL=1 for 2.5us, check the ACK/NACK bit 
; delay for another 2.5us and set SCL=0 for 2.5us 
; repeat the above SCL ONLY cycle till SDA line is turned to 'low' by the slave.
; STOP CONDITION: set SDA=1 and delay for 2.5us and set SCL=1 to end to communication,   

;=========  Example3 uart =========
     psect RESET_VECT,class=CODE,delta=2
    RESET_VECT:		;reset vector
	goto setup
    psect INT_VECT,class=CODE,delta=2 ;pic10/12/16
    INT_VECT:		;interrupt vector
	retfie
    setup:		; All of these address needs to be in capital letter
	; ======== bank1 here ==================
	bsf STATUS,5	; bank1 is selected 
	clrf TRISB	;set all PORTB pins as output
	movlw 0b11110000 ; assigns binary 11111111 to W
	movwf TRISC	; set PORTD as input pins	
	movlw 0b00000000 ; assigns binary 0000000 to W
	movwf TRISD	; set PORTD as output pins		
	clrf impliedVal ; clear the variable that stores the value of the pressed key. 
	movlw 0x08	; assign 8 to the bit counter
	movwf bit_counter   ; -> bit counter It nees to right shift 1 more times after 8 counts because the last bit7 is in the carry position.  
			; it needs to shift 1 more time to get all the bit back to the initial position as carry bit is included.
	clrf rwFlag	; by default 0 is write and 1 is read		
	movlw 0x78	; set the slaves address as 0111100 7 bits only
	movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
	
	; ======== bank0 here ========================
	bcf STATUS,5	; now, bank0 is selected
	clrf PORTB  ;initialization
	bsf PORTD,7 ; set PORTD<7,6> high as default. SCL
	bsf PORTD,6 ; SDA
	; =========== end ===============================================
    main:
	clrf rwFlag
	bcf STATUS,5	; now, bank0 is selected
	call clr_output_D_pins
	bsf PORTC,0	; row 1 set as high
	call check_cols_row1
	call clr_output_D_pins	
	bsf PORTC,1	; row 2 is set as high
	call check_cols_row2	
	call clr_output_D_pins	
	bsf PORTC,2	; row 3 is set as high
	call check_cols_row3
	call clr_output_D_pins	
	bsf PORTC,3	; row 4 is set as high
	call check_cols_row4		
	; no need to further check the the 3rd and 4th row in this example 
	; because we only expect user input of 1 to 5
	; repeat the monitoring
	goto main
    pause:
    
	goto pause
    ; === check pressed keys ====	
    check_cols_row1:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000001    ; set MUX ratio
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00000010    ; assign 2 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00000011    ; assign 3 to W		
	; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return
    check_cols_row2:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000100    ; assign 4 to W
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00000101    ; assign 5 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00000110    ; assign 3 to W			
	; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return		
    check_cols_row3:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000111    ; assign 4 to W
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00001000    ; assign 5 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00001001    ; assign 3 to W			
		; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return			
    check_cols_row4:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,5	; column 2 is selected if false	
	goto pic_pre_tx    ; Master to generte tx
	btfss PORTC,4	; column 3 is selected if false	
	return				
	goto pic_rx	; Master to initiate rx
	return			
    check_if_selected:
	bcf STATUS,5	; bank1 is selected 
	movwf impliedVal
	incf impliedVal,1   ; increase impliedVal by 1 bit
	decfsz impliedVal,1 ; check if decrease the impliedVal return zero, if yes, W and impliedVal have not captured the user input
	goto pic_tx ; else goto transmission
	return

	
    clr_output_D_pins:
	bcf STATUS,5	; now, bank0 is selected    
	bcf PORTC,0
	bcf PORTC,1
	bcf PORTC,2
	bcf PORTC,3	
	return
	
    ; === end of pressed keys detection ===========
pic_pre_tx:
    movwf impliedVal    
pic_tx:
    ;== in order to avoid the situation where user keeps holding the pressed key ==
    ;== the transmission only starts when the pressed keys is released ===
    check_keys_released:
    btfsc PORTC,6
    goto check_keys_released
    btfsc PORTC,5
    goto check_keys_released
    btfsc PORTC,4
    goto check_keys_released    
    ; = first send the SoF (Start of Frame) ===
    call startTx
    goto main

    
pic_rx:
    bsf rwFlag,0
    goto pic_tx
    
    
startTx:
    movlw 0x01
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0
    goto setup_process
    movlw 0x02
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0    
    goto send_something
    return

setup_process:
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter
    movlw 0x78	; set the slaves address as 0111100 7 bits only
    movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
    call SDA_tx_mode    
    ;==== START CONDITIONS  ===
    ;== pull SDA low ===
    bcf PORTD,6 ; SDA to low for 2.5us
    call delay_2_5us ; delay for 2.5us
    bcf PORTD,7 ; SCL to low 
    ; === Send the slave address ===
    call us_1 ; delay for 1us+(6xinsx cycle=1.5us) from call write_data,bcf,btfsc,...,bsf PORTD)=2.5us in total
    call send_address
    ; Fundamental cmd
    ; 1.  Display Off AE == 
    call control_cmd
    movlw 0xAE	; send AF cmd 0b10101110
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 2. set contrast control 81
    call control_cmd
    call SDA_tx_mode
    movlw 0x81	; 0b10000001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address           
    call control_data
    call SDA_tx_mode
    movlw 0xFF	; send the contrast value as 255 in dec or 0b11111111 or 0xFF
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address               
    ; 3. set normal display A6 ==
    call control_cmd_M
    call SDA_tx_mode
    movlw 0xA6	; send A6 cmd 0b10100110
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    
    ; scrolling cmd
    ; 4. deActivate Scroll ==
    call SDA_tx_mode
    movlw 0x2E	; send 2E cmd 0b00101111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call control_cmd
    call SDA_tx_mode
    movlw 0x26	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call control_data_M
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
;    call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;    call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode
    movlw 0x07	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;    call control_data
    call SDA_tx_mode
    movlw 0xFF	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address           
    
    ; Address cmd
    ; 5. set memory address mode 0x20 ===
    call control_cmd
    call SDA_tx_mode
    movlw 0x20	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
    ; === Set PAGE addresses 0x22 ============
    call control_cmd
    call SDA_tx_mode
    movlw 0x22	; send 0b00100010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start PAGE and end PAGE addresses
    call control_data_M
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address     
;    call control_data
    call SDA_tx_mode
    movlw 0x07	; send 0b00000111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; === set column address 0x21 ===
    call control_cmd
    call SDA_tx_mode
    movlw 0x21	; send 0b00100001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start column and end column addresses
    call control_data_M
    call SDA_tx_mode
    movlw 0x05	; send 0b00000101
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address   
;    call control_data
    call SDA_tx_mode
    movlw 0x7A	; send 0b01111010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            

    ; Harware config cmds
    ; 5.5 set display start line 40
    call control_cmd
    call SDA_tx_mode
    movlw 0x40	; send 0b01000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                    
    
    ; 6. Set segment re-map
    call control_cmd
    call SDA_tx_mode
    movlw 0xA0	; send 0b10100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 7. set MUX Ratio A8
    call control_cmd
    call SDA_tx_mode
    movlw 0xA8	; send A8 cmd 0b10101000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call control_data        
    call SDA_tx_mode
    movlw 0x3F	; RESET value **111111 as the data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; 8. Set COM output scan direction C0
    call control_cmd
    call SDA_tx_mode
    movlw 0xC0	; cmd 0b11000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    ; 9. Set display offset D3
    call control_cmd
    call SDA_tx_mode
    movlw 0xD3	; cmd 0b11010011
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x00	; RESET value 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 10. set COM PINS hardware DA
    call control_cmd
    call SDA_tx_mode
    movlw 0xDA	; cmd 0b11011010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x12	; RESET value 0b00010010 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    
    ; Timing and driving
    ; 11. Set display clock divide ratio D5
    call control_cmd
    call SDA_tx_mode
    movlw 0xD5	; cmd 0b11010101
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x80	; RESET value 0b10000000  
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                                
    ; 12. Set precharge period D9
    call control_cmd
    call SDA_tx_mode
    movlw 0xD9	; cmd 0b11011001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x22	; RESET value 0b00100010  
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                            
    ; 13. Set Vcomh Deselect level DB
    call control_cmd
    call SDA_tx_mode
    movlw 0xDB	; cmd 0b11011011
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x20	; RESET value 0b00100000 ~0.77xVcc RESET 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                        
    
    ; Charge pump regulator
    ; 14. Set charge pump 8D
    call control_cmd
    call SDA_tx_mode
    movlw 0x8D	; cmd 0b10001101
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    call control_data        
    call SDA_tx_mode
    movlw 0x14	; charge pump enabled 0b00010100 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                        
    
    ; turn the screen back on
    call control_cmd
    call SDA_tx_mode
    movlw 0xA4	; send AF cmd 0b10100100
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address   
    call control_cmd
    call SDA_tx_mode
    movlw 0xAF	; send AF cmd 0b10101111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call trigger_Stop
    
    goto main

send_something:
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter
    movlw 0x78	; set the slaves address as 0111100 7 bits only
    movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
    call SDA_tx_mode    
    ;==== START CONDITIONS  ===
    ;== pull SDA low ===
    bcf PORTD,6 ; SDA to low for 2.5us
    call delay_2_5us ; delay for 2.5us
    bcf PORTD,7 ; SCL to low 
    ; === Send the slave address ===
    call us_1 ; delay for 1us+(6xinsx cycle=1.5us) from call write_data,bcf,btfsc,...,bsf PORTD)=2.5us in total
    call send_address
    
    ; == write some data === 
    call control_data
    call SDA_tx_mode
    movlw 0xFF	; send 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call trigger_Stop        
    goto main
    
    
control_cmd_M:
    ; == send control byte for multiple cmds to follow ==
    call SDA_tx_mode
    movlw 0b10000000	; control byte:10+000000+ack for cmd byte rather than data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return
control_cmd:
    ; == send control byte for a single cmd to follow ==
    call SDA_tx_mode
    movlw 0x00	; control byte:00+000000+ack for cmd byte rather than data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return    
control_data:
    ; == send control byte for a single data byte to follow ==
    call SDA_tx_mode
    movlw 0b01000000	; control byte:01+000000+ack for data byte rather than cmd byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return
control_data_M:
    ; == send control byte for multiple data bytes to follow ==
    call SDA_tx_mode
    movlw 0b11000000	; control byte:01+000000+ack for data byte rather than cmd byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return    
send_address:
    call write_data	; After this, there are 6 insx or 1.5us before the next HIGH value of SCL. The 6 insx cycles are returnx2, decfsz, gotox2, btfsc, 
    decfsz bit_counter,1    ;
    goto the_next_bit	;    
    ; === address bits and W/R bit are all sent 
    ; == change PORTD<6> to RX and continue the SCL ==========
    call SDA_rx_mode ; At the end of this call, 2.75us has passed	
    call delay_2us ; 2us: call a delay of 3.5us so that the total of 3.5us+2.75us=6.25us (half cycle)
    call us_1	; 1us
    movlw 0x04	;  0.25us 
    movwf A_COUNTER ;0.25us We'll repeat a Max of 4 SCL cycles to wait for any slave response.
    ; == turn the SCL to run while listening to the low pulse pull from the slave ===
    call SCL_Listener ;next_SCL  ;In stead of calling SCL_Listener, 
	    ; we call the LOW SCL first in order to avoid the HIGH SDA signal while the MAster is changing from tx to rx 
	    ; and the slave is changing from rx to tx.
    bsf PORTB,0
    bcf PORTD,7	;    this is to start with SCL LOW cycle after ACK received.
    return

trigger_Stop:    
    call SDA_tx_mode	; 6insx=1.5us
    bcf PORTD,6		;0.25us
    call delay_2us	;2us
    call delay_2us	;2us
    nop			;0.25x2=0.5us => total 6.25us (half cycle of SCL)
    nop
    ; == trigger the STOP CONDITION ====    
    bsf PORTD,7	;    
    call delay_2_5us
    bsf PORTD,6    
    return
   
 
write_data:      
;    bcf PORTD,7
    btfsc slave_address,7   ; address is 7bits + write bit & send the MSB first, thus, it starts at slave_address<7>    
    goto set_1_delay
    goto set_0_delay
    end_setting:
    call delay_1_75us	; further 2.5us low for SCL before turning it high
    bsf PORTD,7		; set SCL=1 for 6.25us in total
    call delay_2_5us	; + remaining insxs
    call delay_2_25us
    call delay_1_25us
    bcf PORTD,7
    ;call delay_2us	; delay a totla of 5us=2.5us+2us+2xinsx from the return
    return

scl_High_ONLY:
    bsf PORTD,7
;    call us_1	; There are a total of 5.25us insx time after this line before SCL is turned to LOW.
		; Thus we only need to delay 1us so that a total of 6.25us (half cycle) to be delayed
    return  ;0.25usx2

   
    
set_1_delay:
    nop
    bsf PORTD,6
    goto end_setting
set_0_delay:
    bcf PORTD,6
    goto end_setting
the_next_bit:
    rlf slave_address,1
    goto send_address

    ;==== Master to receive from Slaves ===========
SDA_rx_mode:
    bsf STATUS,5	; bank 1 is selected
    movlw 0x40 ;0b01000000 ; assigns binary 0100000 to W
    movwf TRISD	; set ONLY PORTD<6> as input pin	
    bcf STATUS,5	; bank 0 is selected	
    return

SDA_tx_mode:
    bsf STATUS,5	; bank 1 is selected
    movlw 0x00  ;0b00000000 ; assigns binary 0100000 to W
    movwf TRISD	; set ONLY PORTD<6> as input pin		
    bcf STATUS,5	; bank 0 is selected	
    return
    
SCL_Listener:
    bsf PORTD,7		; set SCL=1
    btfsc PORTD,6   ; it satisfies the condition of both HIGH SCL and LOW SDA in the beginning
    nop		    ; 0.5us upto here	
;    goto next_SCL
    call delay_2_5us ; 2.5us
    call delay_2_5us  ;2.5us    
    btfss PORTD,6   ; if SDA is LOW, 0.25us, at the end of high SCL as well =>ACK received
    return	; if SDA is LOW return to write_register, this will be executed=>0.5us => a total of 0.5us+2.5us+2.5us+0.25us+0.5us=6.25us (half cycle)
    next_SCL:
    nop		    ; last 0.25us from HIGH SCL
    bcf PORTD,7	    ; 0.25us
    call delay_2_5us ; 2.5us
    call delay_2_5us  ;2.5us
    nop		    ; 0.25us
    decfsz A_COUNTER,1	; 0.25us / 0.5us if true
    goto SCL_Listener	;0.5us => a total of delay at LOW SCL=6.25us (half cycle at low)
    ; == process STOP command as there is no response after 255 SCL cycles 
    stop_cmd:
    call SDA_tx_mode
    bcf PORTD,6  
    call us_1
    bsf PORTD,7		; set SCL=1
    call delay_2_5us
    bsf PORTD,6
    goto main

read_byte_2_LED:
    movf impliedVal,0 
    movwf PORTB
    return
    
    ; ===== delay modules =================================================
    delay_xms:	
	inner_loop:
	call us_1
	decfsz loop_1,1	
	goto inner_loop
	call ms_9_loop_1_reset
	decfsz loop_2,1		
	goto inner_loop
	return	

    us_1:
	return

    ms_9_loop_1_reset:
	movlw 0xE8	; 232->W
	movwf loop_1	; -> loop_1	    
	return

    delay_extra:
	inner_loop_extra:
	decfsz loop_extra,1	
	goto inner_loop_extra
	return
    delay_2_5us:
	nop
	nop
	nop
	nop
	nop
	nop
	return
    delay_2_25us:
	nop
	nop
	nop
	nop
	nop
;	nop
	return	
    delay_1_75us:
	nop
	nop
	nop
	return		
    delay_2us:
	nop
	nop
	nop
	nop
	return		
    delay_1_25us:
	nop
;	nop
;	nop
;	nop
	return		
    delay_1s:
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	; == repeat the above for 8 times then add another 180 x 255 loop
	; == total delap will then be around 0.9951 seconds ====
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	; === now 180 x 255 loops ==
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xB4	; 180->W
	movwf loop_2	; -> loop_1	    
	call delay_xms		
	return
	
	
	
; === End of deloay modules ==================	
	
END RESET_VECT