; Compiler: c51asm
; Used some routines from www.refreshnotes.com/p/8051.html

;#DEFINE REALHW 1
#UNDEF REALHW

LCD_Enable	EQU P2.7
LCD_RS 		EQU P2.6
LCD_RW		EQU P2.5
LCD_DATA	EQU	P0
LCD_BUSY	EQU P0.7

DSPORT		EQU P3.7

TML			EQU 0x41
TMH			EQU 0x40
HUNDERDS	EQU 0x42
TENS		EQU 0x43
ONES		EQU 0x44

ORG 0

start:
		MOV SP,#0x2F

		ACALL LCDINIT			
		MOV DPTR, #LCD_HelloWorld
		ACALL LCDPutString
		MOV A,#0x40
		ACALL LCDSetCurPos
		MOV DPTR, #LCD_TempStr
		ACALL LCDPutString

Done:
		MOV A,#0x4C
		ACALL LCDSetCurPos		
		ACALL DS18B20ReadTemp
		ACALL ConvTemp
		MOV A,TMH
		ACALL Hex2DEC
		MOV A,TENS
		ACALL Hex2Char
		
		MOV R7,#0xFF
		ACALL delay	

		LJMP Done
;-------------------	
;ConvTemp Stripsbits from 16 bits temperature data, TMH contains striped temperature
;We dont do negative or partial temp :)
;-------------------
ConvTemp:		
		MOV R1,#0x04
ConvTempLoop:
		MOV A,TML
		RLC A
		MOV TML,A
		MOV A,TMH
		RLC A
		MOV TMH,A
		DJNZ R1,ConvTempLoop
		RET
		
;-------------------
;Hex2DEC converds hex value to decimal
;-------------------
Hex2DEC:		
		MOV B,#0x64
		DIV AB
		MOV HUNDERDS,A
		MOV A,B
		MOV B,#0x0A
		DIV AB
		MOV TENS,A
		MOV A,B
		MOV ONES,B
		MOV A,TENS
		SWAP A
		ADD A,ONES
		MOV TENS,A
		RET
		
;-------------------
;Hex2Char Convert hex value to asci char and print to current position LCD
;-------------------
Hex2Char:
		MOV R1,#0x02
		MOV B,A
		ANL A,#0xF0
		SWAP A
		MOV R2,A
		SJMP Hex2CharFind
Hex2CharLOOP:
		MOV A,B
		ANL A,#0x0F
		MOV R2,A
Hex2CharFind: 
		CLR C
		SUBB A,#0x0A
		JC Hex2CharDown
		MOV A,R2
		ADD A,#0x37
		SJMP Hex2CharStore
Hex2CharDown:
		MOV A,R2
		ADD A,#0x30
Hex2CharStore:
		ACALL LCDSendDATA
		DJNZ R1,Hex2CharLOOP
		RET
		
;-------------------
;DS18B20Init Find a DS18B20
;-------------------
DS18B20Init:
		CLR DSPORT		; 480-980 uSec
		MOV R7,#0x0A 	; 618us Delay
  		ACALL delay	
		SETB DSPORT 	; Set port to read
		MOV R1,#0x05	; max try 5 times
DS18B20InitLoop:		; Loop until DSPORT = 0
		JNB DSPORT, DS18B20InitExit
		MOV R7,#0x01	; 66us delay
		ACALL delay
		DJNZ R1,DS18B20InitLoop
		MOV A,#0x00 	; Error not found
		RET
DS18B20InitExit:
		MOV A,#0x01 	; Found DS18B20
		RET

;-------------------
;DS18B20WriteByte Writes Acc byte to DS18B20
;-------------------
DS18B20WriteByte:
		CLR DSPORT		; 
		MOV R1,#0x08	; Put 8 bit for a byte
DS18B20WriteByteLoop:
		CLR C 
		CLR DSPORT
		RRC A
		CLR P3.6
		MOV DSPORT,C 	; A.0 -> DSPORT		
		MOV R7,#0x01 
		ACALL DELAY 	; 66us
		SETB DSPORT
		SETB P3.6
		DJNZ R1,DS18B20WriteByteLoop
		RET
;-------------------
;DS18B20ReadByte Reads byte from DS18B20 in Acc
;-------------------		
DS18B20ReadByte:
		MOV A,#0x00
		MOV R1,#0x08	; Get 8 bit for a byte
DS18B20ReadByteLoop:
		CLR DSPORT		; 
		NOP				; 1uSec delay
		SETB DSPORT 	; Set port to read
		NOP				; 1uSec delay
		NOP				;
		NOP				; 
		NOP
		NOP
		NOP
		CLR P3.6
		MOV C,DSPORT	; Bit -> Carry
		RRC A 			; Fill the byte
		MOV R7,#0x01 
		ACALL DELAY 	;66us
		DJNZ R1,DS18B20ReadByteLoop		
		RET

DS18B20ChangTemp:
		ACALL DS18B20Init
		MOV R7,#0x11 
		ACALL DELAY ; 1ms
		MOV A,#0xCC	; Skip Rom
		ACALL DS18B20WriteByte ;0xCC
		MOV A,#0x44	; Convert
		ACALL DS18B20WriteByte ;0x44
		RET
		
DS18B20ReadTempCom:
		ACALL DS18B20Init
		MOV R7,#0x11 
		ACALL DELAY ; 1ms
		MOV A,#0xCC 	; Skip Rom
		ACALL DS18B20WriteByte ;0xCC
		MOV A,#0xBE	; Read Scratchpad
		ACALL DS18B20WriteByte ;0xBE
		RET
		
DS18B20ReadTemp:
		ACALL DS18B20ChangTemp
		ACALL DS18B20ReadTempCom
		ACALL DS18B20ReadByte
		MOV TML,A
		ACALL DS18B20ReadByte
		MOV TMH,A			
		RET
																						
;-------------------
;LCD Put String puts a 0x00 terminated textstring to LCD
;-------------------
LCDPutString:
		MOV R1,#0x00
LCDPutStringLoop:
		MOV A,R1
		MOVC A,@A+DPTR
		JZ LCDPutStringDone
		ACALL LCDSendDATA
		INC R1
		LJMP LCDPutStringLoop
LCDPutStringDone:
		RET
		
;-------------------
;LCD Init, Startup LCD
;-------------------	
LCDInit:
;Wait 15ms at start
		MOV R7,#0xFF
		ACALL delay	
		
		MOV R1,#0x00
		MOV DPTR, #LCDInitData
LCDInitLoop:
		MOV A,R1
		MOVC A,@A+DPTR
		JZ LCDINITDone
		ACALL LCDSendCMD
		INC R1
		LJMP LCDInitLoop
LCDINITDone:			
		RET
		
;-------------------
;LCD Clear screen, clear screen and set cursor to home position
;-------------------
LCDClearScreen:
		MOV A,#0x01 	;Clears entire display and sets DDRAM address 0 in address counter. 
		ACALL LCDSendCMD
		RET

;-------------------
;LCD SetCurPos set cursor position from Acc 0x00 - 0x27 first line 0x40-0x67 second line
;-------------------	
LCDSetCurPos:
		ORL A,#0x80 	;Set High Bit for pos. 
		ACALL LCDSendCMD
		RET
		
;-------------------
;LCD SenddCMD, send Command byte to LCD_DATA
;-------------------
LCDSendCMD:
		CLR LCD_RS
		CLR LCD_RW
		CLR LCD_Enable
		
		MOV LCD_DATA,A
		SETB LCD_Enable
;delay 450ns
		ACALL LCDReady
		CLR LCD_Enable
		RET
		
;-------------------
;LCD Senddata, send data byte to LCD_DATA
;-------------------
LCDSendDATA:
		SETB LCD_RS
		CLR LCD_RW
		CLR LCD_Enable
		
		MOV LCD_DATA,A
		SETB LCD_Enable
;delay 450ns
		ACALL LCDReady
		CLR LCD_Enable	
		RET
		
;-------------------
;LCDready for next data/command
;Doesn't work in SimulIDE,edsim51 and in real hardware
;It seems every one uses delay
;void Hd44780::readBusy()
;{
;}
;
;-----------------
LCDReady:
#IFDEF REALHW
		CLR LCD_RS
		SETB LCD_RW
		SETB LCD_BUSY ;turn off open-drain driver, make P0.7 input
LCDWORKING:
		SETB LCD_Enable
		NOP
		NOP
		NOP
;p0.7=1 lcd busy
		JNB	LCD_BUSY,LCDReadyDone
		CLR LCD_Enable
		LJMP LCDWORKING
LCDReadyDone:
		CLR LCD_Enable
		RET
#ELSE	
		MOV R7,#0x56 ;5ms needed for realhardware
		ACALL delay
		RET
#ENDIF

;-------------------
; Delay, Set R7 to a value
;-------------------	
delay: ;@12MHZ
;Time delay = FFh x 1Dh x12 x 83.33ns = 14,7 ms
;Time delay = 0Ah x 1Dh x12 x 83.33ns = 622 us
;Time delay = 01h x 1Dh x12 x 83.33ns = 66 us
;Time delay = 11h x 1Dh x12 x 83.33ns = 1.0ms
;Time delay = 56h x 1Dh x12 x 83.33ns = 4.9ms
delay0:
        MOV R6,#0x1D
delay1: 
        DJNZ R6, delay1
        DJNZ R7, delay0
        RET
		
;-------------------
; Bytes data
;-------------------		
LCDInitData: DB 0x38,0x0C,0x06,0x80,0x01,0x00
; command 0x38 = 8Bit mode, 2 lines, 5x7
; command 0x0c = turn on, cursor off, no blink
; command 0x0E = turn on, cursor on, no blink
; command 0x06 = incr, no shift.
; commans 0x01 = clear display, cursor to home
; commans 0x80 = dd ram adress=0x00
;                   1234567890123456
LCD_HelloWorld: DB ' Pechin Science ',0x00
LCD_TempStr:    DB 'Temperature:',0x00

END
