; Compiler: c51asm

;#DEFINE REALHW 1
#UNDEF REALHW

LCD_Enable	EQU P2.7
LCD_RS 		EQU P2.6
LCD_RW		EQU P2.5
LCD_DATA	EQU	P0
LCD_BUSY	EQU P0.7

KEY1		EQU P3.1
KEY2		EQU P3.0
KEY3		EQU P3.2
KEY4		EQU P3.3

ORG 0

start:
		MOV SP,#0x2F
		ACALL LCDINIT
			
		MOV DPTR, #LCD_HelloWorld
		ACALL LCDPutString
		
Done:
		MOV TMOD,#0x01
		MOV A,P3
		CJNE A,#0xFF,Pressed
		LJMP Done

Pressed: 					;There is a press
		ACALL TimeDelay		; Debounch
		CJNE A,P3, Done
		JNB KEY1, Key1Press
		JNB	KEY2, Key2Press
		JNB KEY3, Key3Press
		JNB KEY4, Key4Press
		LJMP Done
		
Key1Press:
		JNB KEY1,Key1Press	;Wait till depressed
		ACALL LCDCustomChar
		LJMP Done
Key2Press:
		JNB KEY2,Key2Press
		MOV DPTR, #LCD_Key2
		LJMP KeyPressChar
Key3Press:
		JNB KEY3,Key3Press
		MOV DPTR, #LCD_Key3
		LJMP KeyPressChar
Key4Press:
		JNB KEY4,Key4Press
		MOV DPTR, #LCD_Key4
		LJMP KeyPressChar

KeyPressChar:
		ACALL LCDClearScreen
		ACALL LCDPutString
		MOV DPTR, #LCD_Pressed
		ACALL LCDPutString
		LJMP Done

;-------------------
;LCDCustomChar Makes first char custom
;-------------------
LCDCustomChar:
		MOV A,#0x40 	;First custom char
		ACALL LCDSendCMD
		
		MOV R2,#0x08	; Counting backwards
		MOV DPTR, #LCD_CUSTOM
CustomLoop:
		MOV A,R2
		MOVC A,@A+DPTR
		ACALL LCDSendDATA
		DJNZ R2, CustomLoop
		ACALL LCDClearScreen
		MOV A,#0x00
		ACALL LCDSendDATA		
		RET			
		
;-------------------
;LCD Put String puts a 0x00 terminated textstring to LCD
;-------------------
LCDPutString:
		MOV R1,#0x00
LCDPutStringLoop:
		MOV A,R1
		MOVC A,@A+DPTR
		JZ LCDPutStringDone
		ACALL LCDSendDATA
		INC R1
		LJMP LCDPutStringLoop
LCDPutStringDone:
		RET
		
;-------------------
;LCD Init, Startup LCD
;-------------------	
LCDInit:
;Wait 15ms at start
		MOV R7,#0xFF
		ACALL delay	
		
		MOV R1,#0x00
		MOV DPTR, #LCDInitData
LCDInitLoop:
		MOV A,R1
		MOVC A,@A+DPTR
		JZ LCDINITDone
		ACALL LCDSendCMD
		INC R1
		LJMP LCDInitLoop
LCDINITDone:			
		RET
		
;-------------------
;LCD Clear screen, clear screen and set cursor to home position
;-------------------
LCDClearScreen:
		MOV A,#0x01 	;Clears entire display and sets DDRAM address 0 in address counter. 
		ACALL LCDSendCMD
		RET
		
;-------------------
;LCD SenddCMD, send Command byte to LCD_DATA
;-------------------
LCDSendCMD:
		CLR LCD_RS
		CLR LCD_RW
		CLR LCD_Enable
		
		MOV LCD_DATA,A
		SETB LCD_Enable
;delay 450ns
		ACALL LCDReady
		CLR LCD_Enable
		RET
		
;-------------------
;LCD Senddata, send data byte to LCD_DATA
;-------------------
LCDSendDATA:
		SETB LCD_RS
		CLR LCD_RW
		CLR LCD_Enable
		
		MOV LCD_DATA,A
		SETB LCD_Enable
;delay 450ns
		ACALL LCDReady
		CLR LCD_Enable	
		RET
		
;-------------------
;LCDready for next data/command
;Doesn't work in SimulIDE,edsim51 and in real hardware
;It seems every one uses delay
;void Hd44780::readBusy()
;{
;}
;
;-----------------
LCDReady:
#IFDEF REALHW
		CLR LCD_RS
		SETB LCD_RW
		SETB LCD_BUSY ;turn off open-drain driver, make P0.7 input
LCDWORKING:
		SETB LCD_Enable
		NOP
		NOP
		NOP
;p0.7=1 lcd busy
		JNB	LCD_BUSY,LCDReadyDone
		CLR LCD_Enable
		LJMP LCDWORKING
LCDReadyDone:
		CLR LCD_Enable
		RET
#ELSE	
		MOV R7,#0x56 ;5ms needed for realhardware
		ACALL delay
		RET
#ENDIF

;-------------------
; Delay, Set R7 to a value
;-------------------	
delay: ;@12MHZ
;Time delay = FFh x 3Ah x12 x 83.33ns = 14,7 ms
;Time delay = 11h x 3Ah x12 x 83.33ns = 1.0ms
;Time delay = 56h x 3Ah x12 x 83.33ns = 4.9ms
delay0:
        MOV R6,#0x3A
delay1: 
        DJNZ R6, delay1
        DJNZ R7, delay0
        RET

TimeDelay:;0.5ms delay timer used for debounch
		MOV TH0,#0FCH ; high byte base number into TH0
		MOV TL0,#65H ; low byte base number into TL0
		SETB TR0 ; turn Timer 0 on
FLAG:
		JNB TF0,FLAG; repeat until rollover when TF0 = 1
		CLR TR0 ; turn Timer 0 off
		CLR TF0 ; clear TF0 back to 0
		RET
		
;-------------------
; Bytes data
;-------------------		
LCDInitData: DB 0x38,0x0C,0x06,0x80,0x01,0x00
; command 0x38 = 8Bit mode, 2 lines, 5x7
; command 0x0c = turn on, cursor off, no blink
; command 0x0E = turn on, cursor on, no blink
; command 0x06 = incr, no shift.
; commans 0x01 = clear display, cursor to home
; commans 0x80 = dd ram adress=0x00
LCD_CUSTOM: DB 0x00,0x11,0x0E,0x04,0x1F,0x04,0x04,0x0E,0x0E ;https://maxpromer.github.io/LCD-Character-Creator/

LCD_HelloWorld: DB ' Pechin Science ',0x00
LCD_Key1:	DB 0x4B,0x65,0x79,0x20,0x31,0x00
LCD_Key2:	DB 0x4B,0x65,0x79,0x20,0x32,0x00
LCD_Key3:	DB 0x4B,0x65,0x79,0x20,0x33,0x00
LCD_Key4:	DB 0x4B,0x65,0x79,0x20,0x34,0x00
LCD_Pressed: DB 0x20,0x50,0x72,0x65,0x73,0x73,0x65,0x64,0x00

END
