// Control ductos de maniobra de proa - Hovercraft
// Las orientaciones dcha e izda están referidas a la vista desde el puente
// Nombre archivo: Prueba_12

// Librerías incluidas
#include <Servo.h>
//#include <SoftwareSerial.h>
//#include <Mapf.h>
//#include <VarSpeedServo.h> 

// ================== Watchdog Timer Implementation ===================
//  Include the watchdog timer library #include <avr/wdt.h>
//  In setup(), enable the watchdog timer with the desired period:
//   wdt_enable(WDTO_8S); // options: WDTO_1S, WDTO_2S, WDTO_4S, WDTO_8S
//  In loop(), reset the watchdog timer before it reaches the set period
//wdt_reset(); // confirm to watchdog timer that all is well

#include <avr/wdt.h>  // Watchdog timer library

//---------------------------------------------------------------------------------------------------
// Variables 
bool flag = true;
long previoMillis = 0;
long ON = 500;           //Tiempo en On de la intermitencia destello
long OFF = 1000;         //Tiempo en OFF de la intermitencia destello
int periodo = 200;	    //Tiempo de retardo del servo de luz de búsqueda
long Ahora = 0;          //Tiempo actual para servo de luz de búsqueda
int angulo_inicio = 30;  //Almacén angulo inicial de giro servo luz búsqueda
int angulo_fin = 150;    //Almacén angulo final de giro servo luz búsqueda
int angulo;              //Almacén variable angulo de giro servo luz búsqueda
int paro = 0;           //Almacén variable fin de giro servo luz búsqueda
int canal_9;             //Almacén datos del canal 9 (servo luz búsqueda)
int canal_8;             //Almacén datos del canal 8 (luces cubierta)
int canal_7;             //Almacén datos del canal 7 (luces posición e interiores)
int canal_6;             //Almacén datos del canal 6 (radar)
int canal_5;             //Almacén datos del canal 5 (sustentación para luz intermitente)
int ch2;                 //Almacén datos del canal 2 (ducto delante/atrás)
int ch1;                 //Almacén datos del canal 1 (ducto dcha/izda)
int Giro;                //Almacena el dato de salida del giro servo izda-dche
int Giro1;               //Almacena el dato de salida del giro servo luz búsqueda
int Motor;               //Almacena el dato de salida del motor
float calculo_potencia;  //Almacena el dato de cálculo previo

Servo servo;    	//Definimos que servo se va a utilizar para el servomotor izda - dcha
Servo luz;    		//Definimos que servo se va a utilizar para el servo luz búsqueda
Servo potencia;  	//Definimos que servo se va a utilizar para el motor

//---------------------------------------------------------------------------------------------------
//        SETUP
//---------------------------------------------------------------------------------------------------


void setup()
{  

//---------------------------------------------------------------------------------------------------
// ==== Watchdog Timer Implementation ====
//---------------------------------------------------------------------------------------------------
  //Valid options: WDTO_1S, WDTO_2S, WDTO_4S, WDTO_8S

  wdt_enable(WDTO_4S);

  // Espera la señal del procesador cada cuatro segundos máx. Si no, resetea al controlador

//---------------------------------------------------------------------------------------------------

  Serial.begin(9600);

  pinMode(14, INPUT);   //Pin 14(A0) como entrada canal 7 luces posición - interiores
  pinMode(15, INPUT);   //Pin 15(A1) como entrada canal 6 radar
  pinMode(16, OUTPUT);  //Pin 16(A2)como salida canal 7 luces posición
  pinMode(17, OUTPUT);  //Pin 17(A3) como salida canal 7 luces interiores
  pinMode(18, OUTPUT);  //Pin 18(A4)como salida luz destelleante
  pinMode(19, OUTPUT);  //Pin 19(A5) como salida canal 6 rastreador radar
  pinMode(3, INPUT);    //Pin 3(D3) como entrada canal 8 luces cubierta
  pinMode(2, INPUT);    //Pin 2(D2) como entrada canal 5 luz destelleante
  pinMode(4, OUTPUT);   //Pin 4(D4) como salida canal 8 luces cubierta
  pinMode(8, INPUT);    //Pin 8(D8) como entrada canal 9 servo luz búsqueda
  pinMode(9, OUTPUT);   //Pin 9(D9) como salida servo izda
  pinMode(10, OUTPUT);  //Pin 10(D10) como salida motor-potencia
  pinMode(11, OUTPUT);  //Pin 11(D11) como salida servo dcha
  pinMode(5, INPUT);    //Pin 5(D5) para el canal 2 - maniobra adelante/atrás
  pinMode(6, INPUT);    //Pin 6(D6) para el canal 1 - maniobra izda/dcha
  servo.attach(9);      //Los servomotores izda-dcha conectados al pin 9
  potencia.attach(10);  //El motor conectado al pin 10
  luz.attach(11);    //Movimiento luz búsqueda conectado al pin 11

  // Condiciones iniciales
  angulo = 30;
  angulo_inicio=30;
  angulo_fin=150;
  paro = 0;
  Giro = 1800;
  Motor = 1460;
  canal_5 = 0;  //luz destelleante a 0
  canal_6 = 0;  //radar a 0
  canal_7 = 0;  //luces posición/interior a 0
  canal_8 = 0;  //luces cubierta a 0
  canal_9 = 0;  //movimiento luz búsqueda a 0
 
//---------------------------------------------------------------------------------------------------
// ==== Inicialización de los controladores para el motor. Desconectar si no es necesario
//---------------------------------------------------------------------------------------------------
   //Motor = 2000;                       // Deja 2 segundos a 2.000 us para el arranque del ESC
   //potencia.writeMicroseconds(Motor);  //Orden al motor
   //delay (2000); 
   //Motor = 1000;                       //Control al mínimo
   //potencia.writeMicroseconds(Motor);  //Orden al motor
   //delay (1000); 
   //Motor = 1460;                        //Control en neutro

}

//---------------------------------------------------------------------------------------------------
//        LOOP
//---------------------------------------------------------------------------------------------------
void loop() {

  ch2 = pulseIn(6, HIGH, 50000);       //Lee el dato del canal 2
  ch1 = pulseIn(5, HIGH, 50000);       //Lee el dato del canal 1
  canal_8 = pulseIn(3, HIGH, 50000);   //Lee posición del canal 8 - conmutador SD luces cubierta
  canal_7 = pulseIn(14, HIGH, 50000);  //Lee posición del canal 7 - conmutador SC luces posición - interiores
  canal_6 = pulseIn(15, HIGH, 50000);  //Lee posición del canal 6 - conmutador SB radar
  canal_5 = pulseIn(2, HIGH, 50000);   //Lee posición del canal 5 - sustentación para luz intermitente
  canal_9 = pulseIn(8, HIGH, 50000);   //Lee posición del canal 9 - movimiento luz búsqueda

  //---------------------------------------------------------------------------------------------------
  //Tratamiento Posicion canales 1 y 2 para gestión del giro
  //---------------------------------------------------------------------------------------------------

  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 < 1600) && (ch1 > 1300)) {
    Giro = 1800;

  }  //Si canal 1 y 2 en reposo, servo en reposo
  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 > 1600)) {
    Giro = 1100;

  }  //Si canal 2 en reposo y 1 derecha, gira a izqda
  if ((ch1 > 1500) && (ch1 < 1600) && (ch2 > 1600)) {
    Giro = 1800;
 
  }  //Si canal 2 adelante, servo reposo
  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 < 1300)) {
    Giro = 2500;
   
  }  //Si canal 2 en reposo y 1 izda, gira a dcha
  if (ch2 < 1300) {
    Giro = 500;
   
  }  //Si canal 2 atras, servo adelante (freno)
     //---------------------------------------------------------------------------------------------------
     //Tratamiento Potencia adelante-atrás en los ductos
     //---------------------------------------------------------------------------------------------------

  if (ch2 > 1550) { calculo_potencia = 1700; }
  if (ch2 < 1400) { calculo_potencia = 1700; }
  if (ch1 > 1550) { calculo_potencia = 1600; }
  if (ch1 < 1400) { calculo_potencia = 1600; }
  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 < 1600) && (ch1 > 1300)) { calculo_potencia = 1460; }

  //if (ch2>1550) {calculo_potencia=mapf(ch2, 1550, 2100, 1550, 1800) ;}      //Si canal 2 adelante, escala potencia
  //if (ch2<1400)  {calculo_potencia=mapf(ch2, 1300, 900, 1550, 1800) ;}     //Si canal 2 atrás escala potencia invertida
  //if (ch1>1550) {calculo_potencia=mapf(ch1, 1550, 2100, 1550, 1800) ;}     //Si canal 2 derecha, escala potencia
  //if (ch1<1400)  {calculo_potencia=mapf(ch1, 1300, 900, 1550, 1800) ;}     //Si canal 2 atrás escala potencia invertida
  //if ((ch2>1450) && (ch2<1551)) {calculo_potencia=1460;}                   // Si canal 1 en punto medio, sin potencia

  Motor = int(calculo_potencia);

  //---------------------------------------------------------------------------------------------------
  //Tratamiento canal 5 (luz destelleante)
  //---------------------------------------------------------------------------------------------------
  if (canal_5 <= 1600) { digitalWrite(18, LOW); }
  if ((canal_5 > 1600) && (canal_7 > 1400)) {
      if (millis()<previoMillis + ON + OFF) {
	flag = true; 
	}
      else {
	flag=false;
      previoMillis = millis(); 
      }
  }
  if (flag==true) {
    if (millis()>(previoMillis + ON)) {
      digitalWrite(18, LOW);
    }
      else {digitalWrite(18, HIGH);}
  }

    //digitalWrite(18, HIGH);
    //delay(500);
    //digitalWrite(18, LOW);
    //delay(500);
  //} else {
    //digitalWrite(18, LOW);

  //---------------------------------------------------------------------------------------------------
  //Tratamiento canal 6 (radar)
  //---------------------------------------------------------------------------------------------------
  if (canal_6<= 1400) {digitalWrite(19, LOW); }
  if (canal_6 > 1400) {digitalWrite(19, HIGH); }

  //---------------------------------------------------------------------------------------------------
  //Tratamiento canal 7 (luces posición y luces interiores)
  //---------------------------------------------------------------------------------------------------
  if (canal_7 < 1200) {
    digitalWrite(16, LOW);
    digitalWrite(17, LOW);
  }
  if ((canal_7 > 1400) && (canal_7 < 1600)) {
    digitalWrite(16, HIGH);
    digitalWrite(17, LOW);
  }
  if (canal_7 > 1600) {
    digitalWrite(16, HIGH);
    digitalWrite(17, HIGH);
  }

  //---------------------------------------------------------------------------------------------------
  //Tratamiento canal 8 (luces cubierta)
  //---------------------------------------------------------------------------------------------------
  if (canal_8 <= 1400) { digitalWrite(4, LOW); }
  if (canal_8 > 1400) { digitalWrite(4, HIGH); }

//---------------------------------------------------------------------------------------------------
  //Tratamiento canal 9 (Movimiento luz búsqueda)
  //---------------------------------------------------------------------------------------------------
  if (canal_9 <= 1400) { luz.write (angulo_inicio); }
  if (canal_9 > 1400)  {
	delay (2000);
	for (angulo_inicio; angulo< angulo_fin; angulo++){
	luz.write(angulo);
	delay (50);
	}
  if ((canal_9 > 1400) && (angulo=angulo_fin))  { 
	luz.write(angulo_fin);
	delay (2000);
   }
	
 	for (angulo_fin; angulo>angulo_inicio; angulo--){
	luz.write(angulo);
	delay (50);
	}
   }


	
  //---------------------------------------------------------------------------------------------------
  //Salida del datos de los ductos delanteros
  //----------------------------------------------------------------------------------------------------
  servo.writeMicroseconds(Giro);      //Orden al servomotor izda-dcha
  potencia.writeMicroseconds(Motor);  //Orden al motor


  //------------------------------------------------------------------------------------------------
  //  PARA PRUEBAS
  //------------------------------------------------------------------------------------------------

  Serial.print(" Canal 2: ");
  Serial.print(ch2);
  Serial.print(" Canal 1: ");
  Serial.println(ch1);
  Serial.print(" Giro:  ");
  Serial.print(Giro);
  Serial.print(" Giro1:  ");
  Serial.print(Giro1);
  Serial.print(" Motor:  ");
  Serial.print(Motor);
  Serial.print(" valor entrada 4 luces cubierta:  ");
  Serial.print(canal_8);
  Serial.print(" valor entrada 14 luces:  ");
  Serial.print(canal_7);
  Serial.print(" valor entrada 15 radar:  ");
  Serial.print(canal_6);
  Serial.print(" Canal 5:  ");
  Serial.print(canal_5);
  Serial.print(" Motor:  ");
  Serial.print(Motor);
  Serial.println("");

  //------------------------------------------------------------------------------------------------
  //  Reset Watchdog timer
  //-----------------------------------------------------------------------------------------------

  wdt_reset();  // Confirma al Watchdog que todo va bien, le manda la señal de reset al final del ciclo de programa,
  //              si tarda mas de cuatro segundos en hacerlo resetea al controlador

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}  // Fin de Loop()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


