// Control ductos de maniobra de proa - Hovercraft
// Las orientaciones dcha e izda están referidas a la vista desde el puente
// Nombre archivo: Prueba_8

// Librerías incluidas
#include <Servo.h>
//#include <SoftwareSerial.h>
#include <Mapf.h>


//definición de constantes
//int sensorvalue;            //Almacén datos in analógica A0
//int canal_8;             //Almacén datos del canal 8 (luces cubierta)
//int canal_7;             //Almacén datos del canal 7 (luces posición e interiores)
//int canal_6;             //Almacén datos del canal 6 (radar)
//int canal_5;             //Almacén datos del canal 5 (sustentación para luz intermitente)
int ch2;                 //Almacén datos del canal 2 (ducto delante/atrás)
int ch1;                 //Almacén datos del canal 1 (ducto dcha/izda)
int Giro;                //Almacena el dato de salida del giro servo izda
int Giro1;               //Almacena el dato de salida del giro servo dcha

//float calculo_potencia;  //Almacena el dato de cálculo previo

Servo servo;     //Definimos que servo se va a utilizar para el servomotor izda
Servo servo1;    //Definimos que servo se va a utilizar para el servomotor dcha
//Servo potencia;  //Definimos que servo se va a utilizar para el motor

//---------------------------------------------------------------------------------------------------
//        SETUP
//---------------------------------------------------------------------------------------------------

void setup()
//    Empieza el Set-Up
{  


  Serial.begin(9600);

  //pinMode(14, INPUT);   //Pin 14(A0) como entrada canal 7 luces posición - interiores
  //pinMode(15, INPUT);   //Pin 15(A1) como entrada canal 6 radar
  //pinMode(16, OUTPUT);  //Pin 16 como salida canal 7 luces posición
  //pinMode(17, OUTPUT);  //Pin 17 como salida canal 7 luces interiores
  //pinMode(18, OUTPUT);  //Pin 18 como salida luz destelleante
  //pinMode(19, OUTPUT);  //Pin 19 como salida canal 6 rastreador radar
  //pinMode(3, INPUT);    //Pin 3 como entrada canal 8 luces cubierta
  //pinMode(2, INPUT);    //Pin 2 como entrada canal 5 luz destelleante
  //pinMode(4, OUTPUT);   //Pin 4 como salida canal 8 luces cubierta
  //pinMode(9, OUTPUT);   //Pin 9 como salida servo izda
  //pinMode(10, OUTPUT);  //Pin 10 como salida motor-potencia
  //pinMode(11, OUTPUT);  //Pin 9 como salida servo dcha
  pinMode(5, INPUT);    //Pin 5 para el canal 2 - maniobra adelante/atrás
  pinMode(6, INPUT);    //Pin 6 para el canal 1 - maniobra izda/dcha
  servo.attach(9);      //El servomotor izda conectado al pin 9
  servo1.attach(11);    //El servomotor dcha conectado al pin 11


  // Condiciones iniciales
  Giro = 1500;
  Giro1 = 1500;

  //canal_5 = 0;  //luz destelleante a 0
  //canal_6 = 0;  //radar a 0
  //canal_7 = 0;  //luces posición/interior a 0
  //canal_8 = 0;  //luces cubierta a 0
}

//---------------------------------------------------------------------------------------------------
//        LOOP
//---------------------------------------------------------------------------------------------------
void loop() {


  ch2 = pulseIn(6, HIGH, 50000);       //Lee el dato del canal 2
  ch1 = pulseIn(5, HIGH, 50000);       //Lee el dato del canal 1
  //canal_8 = pulseIn(3, HIGH, 50000);   //Lee posición del canal 8 - conmutador SD luces cubierta
  //canal_7 = pulseIn(14, HIGH, 50000);  //Lee posición del canal 7 - conmutador SC luces posición - interiores
  //canal_6 = pulseIn(15, HIGH, 50000);  //Lee posición del canal 6 - conmutador SB radar
  //canal_5 = pulseIn(2, HIGH, 50000);   //Lee posición del canal 5 - sustentación para luz intermitente


  //---------------------------------------------------------------------------------------------------
  //Tratamiento Posicion canales 1 y 2 para gestión del giro
  //---------------------------------------------------------------------------------------------------

  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 < 1600) && (ch1 > 1300)) {
    Giro = 1500;
    Giro1 = 1500;
  }  //Si canal 1 y 2 en reposo, servo en reposo
  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 > 1600)) {
    Giro = 1000;
    Giro1 = 1000;
  }  //Si canal 2 en reposo y 1 derecha, gira a izqda
  if ((ch1 > 1500) && (ch1 < 1600) && (ch2 > 1600)) {
    Giro = 1500;
    Giro1 = 1500;
  }  //Si canal 2 adelante, servo reposo
  if ((ch2 < 1500) && (ch2 > 1300) && (ch1 < 1300)) {
    Giro = 2000;
    Giro1 = 2000;
  }  //Si canal 2 en reposo y 1 izda, gira a dcha
  if (ch2 < 1300) {
    Giro = 1000;
    Giro1 = 1000;
  }  //Si canal 2 atras, servo adelante (freno)

	servo.writeMicroseconds(Giro);
	servo1.writeMicroseconds(Giro1);
    
  }