//---------------------------------------------------------
// ascii_segments.as
// Version : tableau constant de floats
//
// Pour chaque caractère ASCII (0..127), on stocke un
// array<float> contenant des quadruplets : x1, y1, x2, y2
// Chacun de ces quadruplets correspond à un segment.
//
// Exemple : FONT[33] = { 5,2, 5,8 }
//  => un seul segment (5,2) → (5,8) pour le caractère '!'.
//
// Nécessite une fonction de dessin fournie par le moteur :
//   void drawFatLine(float x1, float y1, float x2, float y2, int color, int thickness);
//   (ou similaire, ex. drawLine(...))
//
//---------------------------------------------------------


//  Require "graphics.h"


//---------------------------------------------------------------------------
// Tableau constant FONT : array<array<float>>
// Chaque entrée (0..127) correspond aux segments d'un caractère ASCII.
// Les indices 0..31 et 127 sont des caractères de contrôle → tableaux vides.
//
// Pour un code c, FONT[c] est un tableau de floats :
//   { x1, y1, x2, y2, x1, y1, x2, y2, ... } 
// En groupes de 4, chaque quadruplet décrit un segment.
//---------------------------------------------------------------------------
const array<array<float>> FONT =
{
    {  // code=0
    },
    {  // code=1
    },
    {  // code=2
    },
    {  // code=3
    },
    {  // code=4
    },
    {  // code=5
    },
    {  // code=6
    },
    {  // code=7
    },
    {  // code=8
    },
    {  // code=9
    },
    {  // code=10
    },
    {  // code=11
    },
    {  // code=12
    },
    {  // code=13
    },
    {  // code=14
    },
    {  // code=15
    },
    {  // code=16
    },
    {  // code=17
    },
    {  // code=18
    },
    {  // code=19
    },
    {  // code=20
    },
    {  // code=21
    },
    {  // code=22
    },
    {  // code=23
    },
    {  // code=24
    },
    {  // code=25
    },
    {  // code=26
    },
    {  // code=27
    },
    {  // code=28
    },
    {  // code=29
    },
    {  // code=30
    },
    {  // code=31
    },
    {  // code=32
    },
    {  // code=33, char='!'
        6, 5, 7, 5,
        5, 6, 8, 6,
        5, 7, 8, 7,
        5, 8, 8, 8,
        5, 9, 8, 9,
        6, 10, 8, 10,
        6, 11, 8, 11,
        6, 12, 8, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 18, 7, 18,
        6, 19, 7, 19,
        5, 6, 5, 9,
        6, 5, 6, 15,
        6, 18, 6, 19,
        7, 5, 7, 15,
        7, 18, 7, 19,
        8, 6, 8, 12,
    },
    {  // code=34, char='"'
        3, 6, 5, 6,
        8, 6, 10, 6,
        3, 7, 5, 7,
        8, 7, 10, 7,
        3, 8, 5, 8,
        8, 8, 10, 8,
        4, 9, 5, 9,
        9, 9, 10, 9,
        4, 10, 5, 10,
        9, 10, 10, 10,
        4, 11, 4, 11,
        9, 11, 10, 11,
        4, 12, 4, 12,
        9, 12, 9, 12,
        3, 6, 3, 8,
        4, 6, 4, 12,
        5, 6, 5, 10,
        8, 6, 8, 8,
        9, 6, 9, 12,
        10, 6, 10, 11,
    },
    {  // code=35, char='#'
        5, 5, 6, 5,
        9, 5, 10, 5,
        4, 6, 6, 6,
        9, 6, 10, 6,
        4, 7, 6, 7,
        9, 7, 10, 7,
        4, 8, 6, 8,
        8, 8, 10, 8,
        4, 9, 6, 9,
        8, 9, 10, 9,
        2, 10, 12, 10,
        2, 11, 12, 11,
        4, 12, 5, 12,
        8, 12, 10, 12,
        4, 13, 5, 13,
        8, 13, 9, 13,
        2, 14, 11, 14,
        2, 15, 11, 15,
        4, 16, 5, 16,
        8, 16, 9, 16,
        4, 17, 5, 17,
        8, 17, 9, 17,
        3, 18, 5, 18,
        8, 18, 9, 18,
        3, 19, 5, 19,
        8, 19, 9, 19,
        4, 20, 4, 20,
        8, 20, 9, 20,
        2, 10, 2, 11,
        2, 14, 2, 15,
        3, 10, 3, 11,
        3, 14, 3, 15,
        3, 18, 3, 19,
        4, 6, 4, 20,
        5, 5, 5, 19,
        6, 5, 6, 11,
        6, 14, 6, 15,
        7, 10, 7, 11,
        7, 14, 7, 15,
        8, 8, 8, 20,
        9, 5, 9, 20,
        10, 5, 10, 12,
        10, 14, 10, 15,
        11, 10, 11, 11,
        11, 14, 11, 15,
        12, 10, 12, 11,
    },
    {  // code=36, char='$'
        6, 4, 7, 4,
        6, 5, 7, 5,
        5, 6, 8, 6,
        10, 6, 11, 6,
        3, 7, 11, 7,
        3, 8, 5, 8,
        9, 8, 11, 8,
        3, 9, 4, 9,
        10, 9, 11, 9,
        3, 10, 5, 10,
        3, 11, 8, 11,
        4, 12, 10, 12,
        8, 13, 11, 13,
        2, 14, 3, 14,
        10, 14, 11, 14,
        2, 15, 3, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        9, 16, 11, 16,
        2, 17, 10, 17,
        2, 18, 3, 18,
        5, 18, 9, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        6, 21, 7, 21,
        6, 22, 7, 22,
        2, 14, 2, 18,
        3, 7, 3, 11,
        3, 14, 3, 18,
        4, 7, 4, 12,
        4, 16, 4, 17,
        5, 6, 5, 8,
        5, 10, 5, 12,
        5, 17, 5, 18,
        6, 4, 6, 7,
        6, 11, 6, 12,
        6, 17, 6, 22,
        7, 4, 7, 7,
        7, 11, 7, 12,
        7, 17, 7, 22,
        8, 6, 8, 7,
        8, 11, 8, 13,
        8, 17, 8, 18,
        9, 7, 9, 8,
        9, 12, 9, 13,
        9, 16, 9, 18,
        10, 6, 10, 9,
        10, 12, 10, 17,
        11, 6, 11, 9,
        11, 13, 11, 16,
    },
    {  // code=37, char='%'
        4, 5, 6, 5,
        3, 6, 7, 6,
        3, 7, 3, 7,
        7, 7, 8, 7,
        2, 8, 3, 8,
        7, 8, 8, 8,
        2, 9, 3, 9,
        7, 9, 8, 9,
        3, 10, 3, 10,
        7, 10, 8, 10,
        3, 11, 11, 11,
        4, 12, 10, 12,
        2, 13, 4, 13,
        6, 13, 10, 13,
        6, 14, 7, 14,
        10, 14, 11, 14,
        5, 15, 6, 15,
        11, 15, 11, 15,
        5, 16, 6, 16,
        11, 16, 11, 16,
        6, 17, 7, 17,
        10, 17, 11, 17,
        6, 18, 10, 18,
        7, 19, 9, 19,
        2, 8, 2, 9,
        2, 13, 2, 13,
        3, 6, 3, 11,
        3, 13, 3, 13,
        4, 5, 4, 6,
        4, 11, 4, 13,
        5, 5, 5, 6,
        5, 11, 5, 12,
        5, 15, 5, 16,
        6, 5, 6, 6,
        6, 11, 6, 18,
        7, 6, 7, 14,
        7, 17, 7, 19,
        8, 7, 8, 13,
        8, 18, 8, 19,
        9, 11, 9, 13,
        9, 18, 9, 19,
        10, 11, 10, 14,
        10, 17, 10, 18,
        11, 11, 11, 11,
        11, 14, 11, 17,
    },
    {  // code=38, char='&'
        6, 7, 10, 7,
        5, 8, 10, 8,
        4, 9, 6, 9,
        9, 9, 9, 9,
        4, 10, 6, 10,
        4, 11, 6, 11,
        5, 12, 7, 12,
        5, 13, 7, 13,
        3, 14, 8, 14,
        10, 14, 12, 14,
        3, 15, 5, 15,
        7, 15, 12, 15,
        3, 16, 4, 16,
        7, 16, 11, 16,
        3, 17, 4, 17,
        8, 17, 11, 17,
        3, 18, 12, 18,
        5, 19, 8, 19,
        10, 19, 12, 19,
        3, 14, 3, 18,
        4, 9, 4, 11,
        4, 14, 4, 18,
        5, 8, 5, 15,
        5, 18, 5, 19,
        6, 7, 6, 14,
        6, 18, 6, 19,
        7, 7, 7, 8,
        7, 12, 7, 16,
        7, 18, 7, 19,
        8, 7, 8, 8,
        8, 14, 8, 19,
        9, 7, 9, 9,
        9, 15, 9, 18,
        10, 7, 10, 8,
        10, 14, 10, 19,
        11, 14, 11, 19,
        12, 14, 12, 15,
        12, 18, 12, 19,
    },
    {  // code=39, char='''
        6, 6, 8, 6,
        6, 7, 8, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        7, 12, 7, 12,
        6, 6, 6, 11,
        7, 6, 7, 12,
        8, 6, 8, 7,
    },
    {  // code=40, char='('
        10, 5, 10, 5,
        9, 6, 11, 6,
        8, 7, 10, 7,
        8, 8, 10, 8,
        7, 9, 9, 9,
        7, 10, 9, 10,
        7, 11, 8, 11,
        6, 12, 8, 12,
        6, 13, 8, 13,
        6, 14, 8, 14,
        6, 15, 8, 15,
        7, 16, 8, 16,
        7, 17, 9, 17,
        7, 18, 9, 18,
        8, 19, 10, 19,
        8, 20, 10, 20,
        9, 21, 11, 21,
        10, 22, 10, 22,
        6, 12, 6, 15,
        7, 9, 7, 18,
        8, 7, 8, 20,
        9, 6, 9, 10,
        9, 17, 9, 21,
        10, 5, 10, 8,
        10, 19, 10, 22,
        11, 6, 11, 6,
        11, 21, 11, 21,
    },
    {  // code=41, char=')'
        3, 5, 4, 5,
        3, 6, 5, 6,
        3, 7, 5, 7,
        4, 8, 6, 8,
        5, 9, 6, 9,
        5, 10, 7, 10,
        5, 11, 7, 11,
        5, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        5, 15, 7, 15,
        5, 16, 7, 16,
        5, 17, 7, 17,
        5, 18, 6, 18,
        4, 19, 6, 19,
        3, 20, 5, 20,
        3, 21, 5, 21,
        3, 22, 4, 22,
        3, 5, 3, 7,
        3, 20, 3, 22,
        4, 5, 4, 8,
        4, 19, 4, 22,
        5, 6, 5, 12,
        5, 15, 5, 21,
        6, 8, 6, 19,
        7, 10, 7, 17,
    },
    {  // code=42, char='*'
        6, 5, 7, 5,
        6, 6, 7, 6,
        6, 7, 7, 7,
        2, 8, 4, 8,
        6, 8, 11, 8,
        2, 9, 11, 9,
        3, 10, 10, 10,
        5, 11, 8, 11,
        4, 12, 9, 12,
        4, 13, 5, 13,
        8, 13, 10, 13,
        4, 14, 5, 14,
        9, 14, 10, 14,
        2, 8, 2, 9,
        3, 8, 3, 10,
        4, 8, 4, 10,
        4, 12, 4, 14,
        5, 9, 5, 14,
        6, 5, 6, 12,
        7, 5, 7, 12,
        8, 8, 8, 13,
        9, 8, 9, 10,
        9, 12, 9, 14,
        10, 8, 10, 10,
        10, 13, 10, 14,
        11, 8, 11, 9,
    },
    {  // code=43, char='+'
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        1, 12, 12, 12,
        1, 13, 12, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        1, 12, 1, 13,
        2, 12, 2, 13,
        3, 12, 3, 13,
        4, 12, 4, 13,
        5, 12, 5, 13,
        6, 7, 6, 18,
        7, 7, 7, 18,
        8, 12, 8, 13,
        9, 12, 9, 13,
        10, 12, 10, 13,
        11, 12, 11, 13,
        12, 12, 12, 13,
    },
    {  // code=44, char=','
        6, 17, 9, 17,
        6, 18, 8, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        5, 21, 6, 21,
        5, 22, 6, 22,
        5, 23, 5, 23,
        5, 21, 5, 23,
        6, 17, 6, 22,
        7, 17, 7, 20,
        8, 17, 8, 18,
        9, 17, 9, 17,
    },
    {  // code=45, char='-'
        2, 12, 11, 12,
        2, 13, 11, 13,
        2, 12, 2, 13,
        3, 12, 3, 13,
        4, 12, 4, 13,
        5, 12, 5, 13,
        6, 12, 6, 13,
        7, 12, 7, 13,
        8, 12, 8, 13,
        9, 12, 9, 13,
        10, 12, 10, 13,
        11, 12, 11, 13,
    },
    {  // code=46, char='.'
        6, 17, 8, 17,
        5, 18, 8, 18,
        6, 19, 8, 19,
        5, 18, 5, 18,
        6, 17, 6, 19,
        7, 17, 7, 19,
        8, 17, 8, 19,
    },
    {  // code=47, char='/'
        10, 3, 11, 3,
        10, 4, 11, 4,
        9, 5, 11, 5,
        9, 6, 11, 6,
        8, 7, 10, 7,
        8, 8, 10, 8,
        8, 9, 9, 9,
        7, 10, 9, 10,
        7, 11, 8, 11,
        6, 12, 8, 12,
        6, 13, 7, 13,
        5, 14, 7, 14,
        5, 15, 6, 15,
        4, 16, 6, 16,
        4, 17, 5, 17,
        3, 18, 5, 18,
        3, 19, 4, 19,
        2, 20, 4, 20,
        2, 21, 4, 21,
        2, 22, 3, 22,
        2, 20, 2, 22,
        3, 18, 3, 22,
        4, 16, 4, 21,
        5, 14, 5, 18,
        6, 12, 6, 16,
        7, 10, 7, 14,
        8, 7, 8, 12,
        9, 5, 9, 10,
        10, 3, 10, 8,
        11, 3, 11, 6,
    },
    {  // code=48, char='0'
        5, 5, 8, 5,
        4, 6, 10, 6,
        3, 7, 5, 7,
        9, 7, 10, 7,
        3, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 11, 9,
        2, 10, 3, 10,
        10, 10, 11, 10,
        2, 11, 3, 11,
        10, 11, 11, 11,
        2, 12, 3, 12,
        10, 12, 11, 12,
        2, 13, 3, 13,
        10, 13, 11, 13,
        2, 14, 3, 14,
        10, 14, 11, 14,
        2, 15, 4, 15,
        10, 15, 11, 15,
        3, 16, 4, 16,
        9, 16, 11, 16,
        3, 17, 5, 17,
        9, 17, 10, 17,
        4, 18, 10, 18,
        5, 19, 8, 19,
        2, 9, 2, 15,
        3, 7, 3, 17,
        4, 6, 4, 9,
        4, 15, 4, 18,
        5, 5, 5, 7,
        5, 17, 5, 19,
        6, 5, 6, 6,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 18, 8, 19,
        9, 6, 9, 8,
        9, 16, 9, 18,
        10, 6, 10, 18,
        11, 8, 11, 16,
    },
    {  // code=49, char='1'
        7, 5, 7, 5,
        3, 6, 7, 6,
        2, 7, 7, 7,
        2, 8, 4, 8,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        2, 18, 11, 18,
        2, 19, 11, 19,
        2, 7, 2, 8,
        2, 18, 2, 19,
        3, 6, 3, 8,
        3, 18, 3, 19,
        4, 6, 4, 8,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 19,
        7, 5, 7, 19,
        8, 18, 8, 19,
        9, 18, 9, 19,
        10, 18, 10, 19,
        11, 18, 11, 19,
    },
    {  // code=50, char='2'
        5, 5, 8, 5,
        3, 6, 10, 6,
        2, 7, 4, 7,
        9, 7, 11, 7,
        2, 8, 3, 8,
        10, 8, 11, 8,
        2, 9, 3, 9,
        10, 9, 11, 9,
        9, 10, 11, 10,
        9, 11, 11, 11,
        8, 12, 10, 12,
        6, 13, 9, 13,
        5, 14, 8, 14,
        4, 15, 7, 15,
        3, 16, 6, 16,
        2, 17, 5, 17,
        1, 18, 11, 18,
        1, 19, 11, 19,
        1, 18, 1, 19,
        2, 7, 2, 9,
        2, 17, 2, 19,
        3, 6, 3, 9,
        3, 16, 3, 19,
        4, 6, 4, 7,
        4, 15, 4, 19,
        5, 5, 5, 6,
        5, 14, 5, 19,
        6, 5, 6, 6,
        6, 13, 6, 16,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 13, 7, 15,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 12, 8, 14,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 10, 9, 13,
        9, 18, 9, 19,
        10, 6, 10, 12,
        10, 18, 10, 19,
        11, 7, 11, 11,
        11, 18, 11, 19,
    },
    {  // code=51, char='3'
        4, 5, 9, 5,
        3, 6, 10, 6,
        3, 7, 4, 7,
        9, 7, 11, 7,
        10, 8, 11, 8,
        10, 9, 11, 9,
        9, 10, 11, 10,
        6, 11, 10, 11,
        6, 12, 10, 12,
        9, 13, 11, 13,
        10, 14, 12, 14,
        10, 15, 12, 15,
        10, 16, 12, 16,
        2, 17, 3, 17,
        9, 17, 11, 17,
        2, 18, 10, 18,
        3, 19, 9, 19,
        2, 17, 2, 18,
        3, 6, 3, 7,
        3, 17, 3, 19,
        4, 5, 4, 7,
        4, 18, 4, 19,
        5, 5, 5, 6,
        5, 18, 5, 19,
        6, 5, 6, 6,
        6, 11, 6, 12,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 11, 7, 12,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 11, 8, 12,
        8, 18, 8, 19,
        9, 5, 9, 7,
        9, 10, 9, 13,
        9, 17, 9, 19,
        10, 6, 10, 18,
        11, 7, 11, 10,
        11, 13, 11, 17,
        12, 14, 12, 16,
    },
    {  // code=52, char='4'
        7, 5, 10, 5,
        7, 6, 10, 6,
        6, 7, 10, 7,
        6, 8, 10, 8,
        5, 9, 10, 9,
        4, 10, 10, 10,
        4, 11, 6, 11,
        8, 11, 10, 11,
        3, 12, 5, 12,
        8, 12, 10, 12,
        3, 13, 5, 13,
        8, 13, 10, 13,
        2, 14, 4, 14,
        8, 14, 10, 14,
        2, 15, 11, 15,
        2, 16, 11, 16,
        8, 17, 10, 17,
        6, 18, 11, 18,
        6, 19, 11, 19,
        2, 14, 2, 16,
        3, 12, 3, 16,
        4, 10, 4, 16,
        5, 9, 5, 13,
        5, 15, 5, 16,
        6, 7, 6, 11,
        6, 15, 6, 16,
        6, 18, 6, 19,
        7, 5, 7, 10,
        7, 15, 7, 16,
        7, 18, 7, 19,
        8, 5, 8, 19,
        9, 5, 9, 19,
        10, 5, 10, 19,
        11, 15, 11, 16,
        11, 18, 11, 19,
    },
    {  // code=53, char='5'
        3, 5, 10, 5,
        3, 6, 10, 6,
        3, 7, 4, 7,
        3, 8, 4, 8,
        3, 9, 4, 9,
        3, 10, 4, 10,
        6, 10, 9, 10,
        3, 11, 10, 11,
        3, 12, 4, 12,
        9, 12, 11, 12,
        10, 13, 12, 13,
        10, 14, 12, 14,
        10, 15, 12, 15,
        10, 16, 12, 16,
        2, 17, 3, 17,
        9, 17, 11, 17,
        2, 18, 10, 18,
        3, 19, 9, 19,
        2, 17, 2, 18,
        3, 5, 3, 12,
        3, 17, 3, 19,
        4, 5, 4, 12,
        4, 18, 4, 19,
        5, 5, 5, 6,
        5, 11, 5, 11,
        5, 18, 5, 19,
        6, 5, 6, 6,
        6, 10, 6, 11,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 10, 7, 11,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 10, 8, 11,
        8, 18, 8, 19,
        9, 5, 9, 6,
        9, 10, 9, 12,
        9, 17, 9, 19,
        10, 5, 10, 6,
        10, 11, 10, 18,
        11, 12, 11, 17,
        12, 13, 12, 16,
    },
    {  // code=54, char='6'
        8, 5, 11, 5,
        6, 6, 12, 6,
        5, 7, 7, 7,
        4, 8, 6, 8,
        3, 9, 5, 9,
        3, 10, 4, 10,
        3, 11, 4, 11,
        6, 11, 9, 11,
        3, 12, 11, 12,
        3, 13, 6, 13,
        9, 13, 11, 13,
        3, 14, 5, 14,
        10, 14, 12, 14,
        3, 15, 4, 15,
        11, 15, 12, 15,
        3, 16, 5, 16,
        10, 16, 12, 16,
        4, 17, 5, 17,
        10, 17, 12, 17,
        4, 18, 11, 18,
        6, 19, 10, 19,
        3, 9, 3, 16,
        4, 8, 4, 18,
        5, 7, 5, 9,
        5, 12, 5, 14,
        5, 16, 5, 18,
        6, 6, 6, 8,
        6, 11, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 11, 7, 12,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 11, 8, 12,
        8, 18, 8, 19,
        9, 5, 9, 6,
        9, 11, 9, 13,
        9, 18, 9, 19,
        10, 5, 10, 6,
        10, 12, 10, 14,
        10, 16, 10, 19,
        11, 5, 11, 6,
        11, 12, 11, 18,
        12, 6, 12, 6,
        12, 14, 12, 17,
    },
    {  // code=55, char='7'
        2, 5, 11, 5,
        2, 6, 11, 6,
        2, 7, 3, 7,
        10, 7, 11, 7,
        2, 8, 3, 8,
        9, 8, 11, 8,
        9, 9, 10, 9,
        9, 10, 10, 10,
        8, 11, 10, 11,
        8, 12, 9, 12,
        8, 13, 9, 13,
        7, 14, 9, 14,
        7, 15, 8, 15,
        7, 16, 8, 16,
        6, 17, 8, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        2, 5, 2, 8,
        3, 5, 3, 8,
        4, 5, 4, 6,
        5, 5, 5, 6,
        6, 5, 6, 6,
        6, 17, 6, 19,
        7, 5, 7, 6,
        7, 14, 7, 19,
        8, 5, 8, 6,
        8, 11, 8, 17,
        9, 5, 9, 6,
        9, 8, 9, 14,
        10, 5, 10, 11,
        11, 5, 11, 8,
    },
    {  // code=56, char='8'
        5, 5, 9, 5,
        3, 6, 10, 6,
        3, 7, 5, 7,
        9, 7, 11, 7,
        2, 8, 4, 8,
        10, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 11, 9,
        3, 10, 4, 10,
        9, 10, 11, 10,
        3, 11, 10, 11,
        3, 12, 10, 12,
        3, 13, 5, 13,
        9, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 11, 14,
        2, 15, 3, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        2, 17, 4, 17,
        9, 17, 11, 17,
        3, 18, 10, 18,
        5, 19, 9, 19,
        2, 8, 2, 9,
        2, 14, 2, 17,
        3, 6, 3, 18,
        4, 6, 4, 14,
        4, 16, 4, 18,
        5, 5, 5, 7,
        5, 11, 5, 13,
        5, 18, 5, 19,
        6, 5, 6, 6,
        6, 11, 6, 12,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 11, 7, 12,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 11, 8, 12,
        8, 18, 8, 19,
        9, 5, 9, 7,
        9, 10, 9, 13,
        9, 17, 9, 19,
        10, 6, 10, 18,
        11, 7, 11, 10,
        11, 13, 11, 17,
    },
    {  // code=57, char='9'
        5, 5, 8, 5,
        4, 6, 10, 6,
        3, 7, 5, 7,
        9, 7, 11, 7,
        3, 8, 4, 8,
        10, 8, 11, 8,
        3, 9, 4, 9,
        10, 9, 12, 9,
        3, 10, 4, 10,
        10, 10, 12, 10,
        3, 11, 5, 11,
        9, 11, 12, 11,
        4, 12, 12, 12,
        5, 13, 12, 13,
        10, 14, 12, 14,
        10, 15, 11, 15,
        9, 16, 11, 16,
        7, 17, 10, 17,
        3, 18, 9, 18,
        3, 19, 7, 19,
        3, 7, 3, 11,
        3, 18, 3, 19,
        4, 6, 4, 12,
        4, 18, 4, 19,
        5, 5, 5, 7,
        5, 11, 5, 13,
        5, 18, 5, 19,
        6, 5, 6, 6,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 5, 7, 6,
        7, 12, 7, 13,
        7, 17, 7, 19,
        8, 5, 8, 6,
        8, 12, 8, 13,
        8, 17, 8, 18,
        9, 6, 9, 7,
        9, 11, 9, 13,
        9, 16, 9, 18,
        10, 6, 10, 17,
        11, 7, 11, 16,
        12, 9, 12, 14,
    },
    {  // code=58, char=':'
        6, 9, 7, 9,
        5, 10, 8, 10,
        6, 11, 8, 11,
        6, 17, 8, 17,
        5, 18, 8, 18,
        6, 19, 8, 19,
        5, 10, 5, 10,
        5, 18, 5, 18,
        6, 9, 6, 11,
        6, 17, 6, 19,
        7, 9, 7, 11,
        7, 17, 7, 19,
        8, 10, 8, 11,
        8, 17, 8, 19,
    },
    {  // code=59, char=';'
        7, 9, 9, 9,
        7, 10, 9, 10,
        7, 11, 9, 11,
        6, 16, 8, 16,
        6, 17, 8, 17,
        6, 18, 7, 18,
        5, 19, 6, 19,
        5, 20, 6, 20,
        5, 21, 5, 21,
        5, 19, 5, 21,
        6, 16, 6, 20,
        7, 9, 7, 11,
        7, 16, 7, 18,
        8, 9, 8, 11,
        8, 16, 8, 17,
        9, 9, 9, 11,
    },
    {  // code=60, char='<'
        11, 7, 12, 7,
        9, 8, 12, 8,
        7, 9, 11, 9,
        5, 10, 9, 10,
        3, 11, 7, 11,
        2, 12, 6, 12,
        0, 13, 4, 13,
        2, 14, 5, 14,
        3, 15, 7, 15,
        5, 16, 9, 16,
        7, 17, 11, 17,
        9, 18, 12, 18,
        11, 19, 12, 19,
        0, 13, 0, 13,
        1, 13, 1, 13,
        2, 12, 2, 14,
        3, 11, 3, 15,
        4, 11, 4, 15,
        5, 10, 5, 12,
        5, 14, 5, 16,
        6, 10, 6, 12,
        6, 15, 6, 16,
        7, 9, 7, 11,
        7, 15, 7, 17,
        8, 9, 8, 10,
        8, 16, 8, 17,
        9, 8, 9, 10,
        9, 16, 9, 18,
        10, 8, 10, 9,
        10, 17, 10, 18,
        11, 7, 11, 9,
        11, 17, 11, 19,
        12, 7, 12, 8,
        12, 18, 12, 19,
    },
    {  // code=61, char='='
        1, 10, 13, 10,
        1, 11, 13, 11,
        1, 14, 13, 14,
        1, 15, 13, 15,
        1, 10, 1, 11,
        1, 14, 1, 15,
        2, 10, 2, 11,
        2, 14, 2, 15,
        3, 10, 3, 11,
        3, 14, 3, 15,
        4, 10, 4, 11,
        4, 14, 4, 15,
        5, 10, 5, 11,
        5, 14, 5, 15,
        6, 10, 6, 11,
        6, 14, 6, 15,
        7, 10, 7, 11,
        7, 14, 7, 15,
        8, 10, 8, 11,
        8, 14, 8, 15,
        9, 10, 9, 11,
        9, 14, 9, 15,
        10, 10, 10, 11,
        10, 14, 10, 15,
        11, 10, 11, 11,
        11, 14, 11, 15,
        12, 10, 12, 11,
        12, 14, 12, 15,
        13, 10, 13, 11,
        13, 14, 13, 15,
    },
    {  // code=62, char='>'
        1, 7, 2, 7,
        1, 8, 4, 8,
        2, 9, 6, 9,
        4, 10, 8, 10,
        6, 11, 10, 11,
        8, 12, 12, 12,
        9, 13, 13, 13,
        8, 14, 12, 14,
        6, 15, 10, 15,
        4, 16, 8, 16,
        3, 17, 6, 17,
        1, 18, 4, 18,
        1, 19, 2, 19,
        1, 7, 1, 8,
        1, 18, 1, 19,
        2, 7, 2, 9,
        2, 18, 2, 19,
        3, 8, 3, 9,
        3, 17, 3, 18,
        4, 8, 4, 10,
        4, 16, 4, 18,
        5, 9, 5, 10,
        5, 16, 5, 17,
        6, 9, 6, 11,
        6, 15, 6, 17,
        7, 10, 7, 11,
        7, 15, 7, 16,
        8, 10, 8, 12,
        8, 14, 8, 16,
        9, 11, 9, 15,
        10, 11, 10, 15,
        11, 12, 11, 14,
        12, 12, 12, 14,
        13, 13, 13, 13,
    },
    {  // code=63, char='?'
        5, 6, 9, 6,
        3, 7, 10, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 11, 9,
        3, 10, 3, 10,
        10, 10, 11, 10,
        9, 11, 11, 11,
        8, 12, 11, 12,
        6, 13, 10, 13,
        6, 14, 8, 14,
        6, 15, 7, 15,
        6, 18, 8, 18,
        6, 19, 8, 19,
        2, 8, 2, 9,
        3, 7, 3, 10,
        4, 7, 4, 9,
        5, 6, 5, 7,
        6, 6, 6, 7,
        6, 13, 6, 15,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 13, 7, 15,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 12, 8, 14,
        8, 18, 8, 19,
        9, 6, 9, 8,
        9, 11, 9, 13,
        10, 7, 10, 13,
        11, 8, 11, 12,
    },
    {  // code=64, char='@'
        5, 5, 8, 5,
        4, 6, 9, 6,
        3, 7, 5, 7,
        9, 7, 10, 7,
        3, 8, 4, 8,
        10, 8, 10, 8,
        2, 9, 3, 9,
        8, 9, 10, 9,
        2, 10, 3, 10,
        6, 10, 10, 10,
        2, 11, 3, 11,
        6, 11, 7, 11,
        10, 11, 10, 11,
        2, 12, 3, 12,
        5, 12, 6, 12,
        10, 12, 10, 12,
        2, 13, 3, 13,
        5, 13, 6, 13,
        10, 13, 10, 13,
        2, 14, 3, 14,
        6, 14, 7, 14,
        10, 14, 10, 14,
        2, 15, 3, 15,
        6, 15, 11, 15,
        2, 16, 3, 16,
        7, 16, 11, 16,
        2, 17, 3, 17,
        3, 18, 4, 18,
        3, 19, 5, 19,
        9, 19, 10, 19,
        4, 20, 10, 20,
        5, 21, 9, 21,
        2, 9, 2, 17,
        3, 7, 3, 19,
        4, 6, 4, 8,
        4, 18, 4, 20,
        5, 5, 5, 7,
        5, 12, 5, 13,
        5, 19, 5, 21,
        6, 5, 6, 6,
        6, 10, 6, 15,
        6, 20, 6, 21,
        7, 5, 7, 6,
        7, 10, 7, 11,
        7, 14, 7, 16,
        7, 20, 7, 21,
        8, 5, 8, 6,
        8, 9, 8, 10,
        8, 15, 8, 16,
        8, 20, 8, 21,
        9, 6, 9, 7,
        9, 9, 9, 10,
        9, 15, 9, 16,
        9, 19, 9, 21,
        10, 7, 10, 16,
        10, 19, 10, 20,
        11, 15, 11, 16,
    },
    {  // code=65, char='A'
        2, 6, 8, 6,
        2, 7, 8, 7,
        5, 8, 9, 8,
        4, 9, 9, 9,
        4, 10, 6, 10,
        8, 10, 9, 10,
        4, 11, 5, 11,
        8, 11, 10, 11,
        3, 12, 5, 12,
        9, 12, 10, 12,
        3, 13, 4, 13,
        9, 13, 10, 13,
        2, 14, 11, 14,
        2, 15, 11, 15,
        2, 16, 3, 16,
        10, 16, 12, 16,
        1, 17, 3, 17,
        11, 17, 12, 17,
        0, 18, 5, 18,
        9, 18, 14, 18,
        0, 19, 5, 19,
        9, 19, 14, 19,
        0, 18, 0, 19,
        1, 17, 1, 19,
        2, 6, 2, 7,
        2, 14, 2, 19,
        3, 6, 3, 7,
        3, 12, 3, 19,
        4, 6, 4, 7,
        4, 9, 4, 15,
        4, 18, 4, 19,
        5, 6, 5, 12,
        5, 14, 5, 15,
        5, 18, 5, 19,
        6, 6, 6, 10,
        6, 14, 6, 15,
        7, 6, 7, 9,
        7, 14, 7, 15,
        8, 6, 8, 11,
        8, 14, 8, 15,
        9, 8, 9, 15,
        9, 18, 9, 19,
        10, 11, 10, 16,
        10, 18, 10, 19,
        11, 14, 11, 19,
        12, 16, 12, 19,
        13, 18, 13, 19,
        14, 18, 14, 19,
    },
    {  // code=66, char='B'
        0, 6, 9, 6,
        0, 7, 11, 7,
        2, 8, 4, 8,
        10, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 12, 9,
        2, 10, 4, 10,
        10, 10, 12, 10,
        2, 11, 4, 11,
        9, 11, 11, 11,
        2, 12, 11, 12,
        2, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 12, 14,
        2, 15, 4, 15,
        11, 15, 13, 15,
        2, 16, 4, 16,
        11, 16, 13, 16,
        2, 17, 4, 17,
        11, 17, 13, 17,
        0, 18, 12, 18,
        0, 19, 11, 19,
        0, 6, 0, 7,
        0, 18, 0, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 7,
        5, 12, 5, 13,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 12, 7, 13,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 12, 8, 13,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 11, 9, 13,
        9, 18, 9, 19,
        10, 7, 10, 14,
        10, 18, 10, 19,
        11, 7, 11, 19,
        12, 9, 12, 10,
        12, 14, 12, 18,
        13, 15, 13, 17,
    },
    {  // code=67, char='C'
        5, 6, 9, 6,
        11, 6, 12, 6,
        3, 7, 12, 7,
        2, 8, 4, 8,
        10, 8, 12, 8,
        2, 9, 3, 9,
        11, 9, 12, 9,
        1, 10, 3, 10,
        11, 10, 12, 10,
        1, 11, 2, 11,
        1, 12, 2, 12,
        1, 13, 2, 13,
        1, 14, 2, 14,
        1, 15, 2, 15,
        1, 16, 3, 16,
        12, 16, 12, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        3, 18, 12, 18,
        5, 19, 10, 19,
        1, 10, 1, 16,
        2, 8, 2, 17,
        3, 7, 3, 10,
        3, 16, 3, 18,
        4, 7, 4, 8,
        4, 17, 4, 18,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 18, 9, 19,
        10, 7, 10, 8,
        10, 17, 10, 19,
        11, 6, 11, 10,
        11, 17, 11, 18,
        12, 6, 12, 10,
        12, 16, 12, 18,
    },
    {  // code=68, char='D'
        1, 6, 8, 6,
        1, 7, 10, 7,
        2, 8, 3, 8,
        9, 8, 11, 8,
        2, 9, 3, 9,
        10, 9, 11, 9,
        2, 10, 3, 10,
        10, 10, 12, 10,
        2, 11, 3, 11,
        11, 11, 12, 11,
        2, 12, 3, 12,
        11, 12, 12, 12,
        2, 13, 3, 13,
        11, 13, 12, 13,
        2, 14, 3, 14,
        11, 14, 12, 14,
        2, 15, 3, 15,
        11, 15, 12, 15,
        2, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 3, 17,
        9, 17, 11, 17,
        1, 18, 10, 18,
        1, 19, 9, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 7,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 7, 9, 8,
        9, 17, 9, 19,
        10, 7, 10, 10,
        10, 16, 10, 18,
        11, 8, 11, 17,
        12, 10, 12, 16,
    },
    {  // code=69, char='E'
        1, 6, 12, 6,
        1, 7, 12, 7,
        2, 8, 4, 8,
        10, 8, 12, 8,
        2, 9, 4, 9,
        10, 9, 12, 9,
        2, 10, 4, 10,
        7, 10, 8, 10,
        11, 10, 11, 10,
        2, 11, 4, 11,
        7, 11, 8, 11,
        2, 12, 8, 12,
        2, 13, 8, 13,
        2, 14, 4, 14,
        7, 14, 8, 14,
        2, 15, 4, 15,
        7, 15, 8, 15,
        11, 15, 12, 15,
        2, 16, 4, 16,
        11, 16, 12, 16,
        2, 17, 4, 17,
        11, 17, 12, 17,
        1, 18, 12, 18,
        1, 19, 12, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 7,
        5, 12, 5, 13,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 10, 7, 15,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 10, 8, 15,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 18, 9, 19,
        10, 6, 10, 9,
        10, 18, 10, 19,
        11, 6, 11, 10,
        11, 15, 11, 19,
        12, 6, 12, 9,
        12, 15, 12, 19,
    },
    {  // code=70, char='F'
        1, 6, 13, 6,
        1, 7, 13, 7,
        3, 8, 5, 8,
        12, 8, 13, 8,
        3, 9, 5, 9,
        12, 9, 13, 9,
        3, 10, 5, 10,
        8, 10, 9, 10,
        12, 10, 13, 10,
        3, 11, 5, 11,
        8, 11, 9, 11,
        3, 12, 9, 12,
        3, 13, 9, 13,
        3, 14, 5, 14,
        8, 14, 9, 14,
        3, 15, 5, 15,
        8, 15, 9, 15,
        3, 16, 5, 16,
        3, 17, 5, 17,
        1, 18, 8, 18,
        1, 19, 8, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 7,
        2, 18, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 12, 7, 13,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 10, 8, 15,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 10, 9, 15,
        10, 6, 10, 7,
        11, 6, 11, 7,
        12, 6, 12, 10,
        13, 6, 13, 10,
    },
    {  // code=71, char='G'
        5, 6, 9, 6,
        11, 6, 12, 6,
        3, 7, 12, 7,
        2, 8, 4, 8,
        10, 8, 12, 8,
        2, 9, 3, 9,
        11, 9, 12, 9,
        1, 10, 3, 10,
        11, 10, 12, 10,
        1, 11, 2, 11,
        1, 12, 2, 12,
        1, 13, 2, 13,
        7, 13, 13, 13,
        1, 14, 2, 14,
        7, 14, 13, 14,
        1, 15, 2, 15,
        11, 15, 12, 15,
        1, 16, 3, 16,
        11, 16, 12, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        3, 18, 12, 18,
        5, 19, 10, 19,
        1, 10, 1, 16,
        2, 8, 2, 17,
        3, 7, 3, 10,
        3, 16, 3, 18,
        4, 7, 4, 8,
        4, 17, 4, 18,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 13, 7, 14,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 13, 8, 14,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 13, 9, 14,
        9, 18, 9, 19,
        10, 7, 10, 8,
        10, 13, 10, 14,
        10, 17, 10, 19,
        11, 6, 11, 10,
        11, 13, 11, 18,
        12, 6, 12, 10,
        12, 13, 12, 18,
        13, 13, 13, 14,
    },
    {  // code=72, char='H'
        1, 6, 6, 6,
        8, 6, 12, 6,
        1, 7, 6, 7,
        8, 7, 12, 7,
        2, 8, 4, 8,
        10, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 11, 9,
        2, 10, 4, 10,
        10, 10, 11, 10,
        2, 11, 4, 11,
        10, 11, 11, 11,
        2, 12, 11, 12,
        2, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 11, 14,
        2, 15, 4, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        2, 17, 4, 17,
        10, 17, 11, 17,
        1, 18, 6, 18,
        8, 18, 13, 18,
        1, 19, 6, 19,
        8, 19, 13, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 7,
        5, 12, 5, 13,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 12, 7, 13,
        8, 6, 8, 7,
        8, 12, 8, 13,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 12, 9, 13,
        9, 18, 9, 19,
        10, 6, 10, 19,
        11, 6, 11, 19,
        12, 6, 12, 7,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=73, char='I'
        2, 6, 11, 6,
        2, 7, 11, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        2, 18, 11, 18,
        2, 19, 11, 19,
        2, 6, 2, 7,
        2, 18, 2, 19,
        3, 6, 3, 7,
        3, 18, 3, 19,
        4, 6, 4, 7,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 19,
        7, 6, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 18, 9, 19,
        10, 6, 10, 7,
        10, 18, 10, 19,
        11, 6, 11, 7,
        11, 18, 11, 19,
    },
    {  // code=74, char='J'
        5, 6, 14, 6,
        5, 7, 14, 7,
        9, 8, 11, 8,
        9, 9, 11, 9,
        9, 10, 11, 10,
        9, 11, 11, 11,
        9, 12, 11, 12,
        2, 13, 2, 13,
        9, 13, 11, 13,
        1, 14, 3, 14,
        9, 14, 11, 14,
        1, 15, 3, 15,
        9, 15, 11, 15,
        1, 16, 3, 16,
        9, 16, 11, 16,
        1, 17, 3, 17,
        8, 17, 10, 17,
        1, 18, 9, 18,
        4, 19, 8, 19,
        1, 14, 1, 18,
        2, 13, 2, 18,
        3, 14, 3, 18,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 17, 8, 19,
        9, 6, 9, 18,
        10, 6, 10, 17,
        11, 6, 11, 16,
        12, 6, 12, 7,
        13, 6, 13, 7,
        14, 6, 14, 7,
    },
    {  // code=75, char='K'
        0, 6, 6, 6,
        8, 6, 13, 6,
        0, 7, 6, 7,
        8, 7, 13, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 4, 9,
        8, 9, 10, 9,
        2, 10, 4, 10,
        7, 10, 9, 10,
        2, 11, 4, 11,
        6, 11, 8, 11,
        2, 12, 8, 12,
        2, 13, 9, 13,
        2, 14, 5, 14,
        7, 14, 10, 14,
        2, 15, 4, 15,
        8, 15, 10, 15,
        2, 16, 4, 16,
        9, 16, 11, 16,
        2, 17, 4, 17,
        10, 17, 11, 17,
        0, 18, 6, 18,
        10, 18, 13, 18,
        0, 19, 6, 19,
        11, 19, 13, 19,
        0, 6, 0, 7,
        0, 18, 0, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 7,
        5, 12, 5, 14,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 11, 6, 13,
        6, 18, 6, 19,
        7, 10, 7, 14,
        8, 6, 8, 7,
        8, 9, 8, 15,
        9, 6, 9, 10,
        9, 13, 9, 16,
        10, 6, 10, 9,
        10, 14, 10, 18,
        11, 6, 11, 8,
        11, 16, 11, 19,
        12, 6, 12, 7,
        12, 18, 12, 19,
        13, 6, 13, 7,
        13, 18, 13, 19,
    },
    {  // code=76, char='L'
        1, 6, 8, 6,
        1, 7, 8, 7,
        4, 8, 5, 8,
        4, 9, 5, 9,
        4, 10, 5, 10,
        4, 11, 5, 11,
        4, 12, 5, 12,
        4, 13, 5, 13,
        4, 14, 5, 14,
        12, 14, 13, 14,
        4, 15, 5, 15,
        11, 15, 13, 15,
        4, 16, 5, 16,
        11, 16, 13, 16,
        4, 17, 5, 17,
        11, 17, 13, 17,
        1, 18, 13, 18,
        1, 19, 13, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 7,
        2, 18, 2, 19,
        3, 6, 3, 7,
        3, 18, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 18, 9, 19,
        10, 18, 10, 19,
        11, 15, 11, 19,
        12, 14, 12, 19,
        13, 14, 13, 19,
    },
    {  // code=77, char='M'
        0, 6, 3, 6,
        10, 6, 14, 6,
        0, 7, 4, 7,
        10, 7, 14, 7,
        1, 8, 4, 8,
        9, 8, 12, 8,
        1, 9, 5, 9,
        9, 9, 12, 9,
        1, 10, 5, 10,
        8, 10, 12, 10,
        1, 11, 6, 11,
        8, 11, 12, 11,
        1, 12, 2, 12,
        4, 12, 9, 12,
        11, 12, 12, 12,
        1, 13, 2, 13,
        5, 13, 9, 13,
        11, 13, 12, 13,
        1, 14, 2, 14,
        5, 14, 8, 14,
        11, 14, 12, 14,
        1, 15, 2, 15,
        6, 15, 8, 15,
        11, 15, 12, 15,
        1, 16, 2, 16,
        6, 16, 7, 16,
        11, 16, 12, 16,
        1, 17, 2, 17,
        11, 17, 12, 17,
        0, 18, 5, 18,
        9, 18, 14, 18,
        0, 19, 5, 19,
        9, 19, 14, 19,
        0, 6, 0, 7,
        0, 18, 0, 19,
        1, 6, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 11,
        3, 18, 3, 19,
        4, 7, 4, 12,
        4, 18, 4, 19,
        5, 9, 5, 14,
        5, 18, 5, 19,
        6, 11, 6, 16,
        7, 12, 7, 16,
        8, 10, 8, 15,
        9, 8, 9, 13,
        9, 18, 9, 19,
        10, 6, 10, 11,
        10, 18, 10, 19,
        11, 6, 11, 19,
        12, 6, 12, 19,
        13, 6, 13, 7,
        13, 18, 13, 19,
        14, 6, 14, 7,
        14, 18, 14, 19,
    },
    {  // code=78, char='N'
        0, 6, 4, 6,
        8, 6, 13, 6,
        0, 7, 4, 7,
        8, 7, 13, 7,
        2, 8, 5, 8,
        10, 8, 12, 8,
        2, 9, 5, 9,
        10, 9, 12, 9,
        2, 10, 6, 10,
        10, 10, 12, 10,
        2, 11, 3, 11,
        5, 11, 7, 11,
        10, 11, 12, 11,
        2, 12, 3, 12,
        6, 12, 7, 12,
        10, 12, 12, 12,
        2, 13, 3, 13,
        6, 13, 8, 13,
        10, 13, 12, 13,
        2, 14, 3, 14,
        7, 14, 12, 14,
        2, 15, 3, 15,
        7, 15, 12, 15,
        2, 16, 3, 16,
        8, 16, 12, 16,
        2, 17, 3, 17,
        9, 17, 12, 17,
        0, 18, 6, 18,
        9, 18, 12, 18,
        0, 19, 6, 19,
        10, 19, 12, 19,
        0, 6, 0, 7,
        0, 18, 0, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 10,
        4, 18, 4, 19,
        5, 8, 5, 11,
        5, 18, 5, 19,
        6, 10, 6, 13,
        6, 18, 6, 19,
        7, 11, 7, 15,
        8, 6, 8, 7,
        8, 13, 8, 16,
        9, 6, 9, 7,
        9, 14, 9, 18,
        10, 6, 10, 19,
        11, 6, 11, 19,
        12, 6, 12, 19,
        13, 6, 13, 7,
    },
    {  // code=79, char='O'
        5, 6, 9, 6,
        3, 7, 10, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        1, 9, 3, 9,
        10, 9, 12, 9,
        1, 10, 2, 10,
        11, 10, 13, 10,
        1, 11, 2, 11,
        11, 11, 13, 11,
        1, 12, 2, 12,
        12, 12, 13, 12,
        1, 13, 2, 13,
        12, 13, 13, 13,
        1, 14, 2, 14,
        11, 14, 13, 14,
        1, 15, 2, 15,
        11, 15, 13, 15,
        1, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        9, 17, 11, 17,
        3, 18, 10, 18,
        5, 19, 9, 19,
        1, 9, 1, 16,
        2, 8, 2, 17,
        3, 7, 3, 9,
        3, 16, 3, 18,
        4, 7, 4, 8,
        4, 17, 4, 18,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 6, 9, 8,
        9, 17, 9, 19,
        10, 7, 10, 9,
        10, 16, 10, 18,
        11, 8, 11, 11,
        11, 14, 11, 17,
        12, 9, 12, 16,
        13, 10, 13, 15,
    },
    {  // code=80, char='P'
        2, 6, 10, 6,
        2, 7, 12, 7,
        3, 8, 5, 8,
        10, 8, 12, 8,
        3, 9, 5, 9,
        11, 9, 13, 9,
        3, 10, 5, 10,
        11, 10, 13, 10,
        3, 11, 5, 11,
        11, 11, 13, 11,
        3, 12, 5, 12,
        10, 12, 12, 12,
        3, 13, 11, 13,
        3, 14, 10, 14,
        3, 15, 5, 15,
        3, 16, 5, 16,
        3, 17, 5, 17,
        2, 18, 9, 18,
        2, 19, 9, 19,
        2, 6, 2, 7,
        2, 18, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 19,
        6, 6, 6, 7,
        6, 13, 6, 14,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 13, 7, 14,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 13, 8, 14,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 13, 9, 14,
        9, 18, 9, 19,
        10, 6, 10, 8,
        10, 12, 10, 14,
        11, 7, 11, 13,
        12, 7, 12, 12,
        13, 9, 13, 11,
    },
    {  // code=81, char='Q'
        5, 6, 9, 6,
        3, 7, 10, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        1, 9, 3, 9,
        10, 9, 12, 9,
        1, 10, 2, 10,
        11, 10, 12, 10,
        1, 11, 2, 11,
        11, 11, 13, 11,
        1, 12, 2, 12,
        11, 12, 13, 12,
        0, 13, 2, 13,
        11, 13, 13, 13,
        1, 14, 2, 14,
        11, 14, 13, 14,
        1, 15, 2, 15,
        11, 15, 12, 15,
        1, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        9, 17, 11, 17,
        3, 18, 10, 18,
        4, 19, 9, 19,
        4, 20, 8, 20,
        12, 20, 13, 20,
        3, 21, 13, 21,
        3, 22, 4, 22,
        9, 22, 12, 22,
        0, 13, 0, 13,
        1, 9, 1, 16,
        2, 8, 2, 17,
        3, 7, 3, 9,
        3, 16, 3, 18,
        3, 21, 3, 22,
        4, 7, 4, 8,
        4, 17, 4, 22,
        5, 6, 5, 7,
        5, 18, 5, 21,
        6, 6, 6, 7,
        6, 18, 6, 21,
        7, 6, 7, 7,
        7, 18, 7, 21,
        8, 6, 8, 7,
        8, 18, 8, 21,
        9, 6, 9, 8,
        9, 17, 9, 19,
        9, 21, 9, 22,
        10, 7, 10, 9,
        10, 16, 10, 18,
        10, 21, 10, 22,
        11, 8, 11, 17,
        11, 21, 11, 22,
        12, 9, 12, 16,
        12, 20, 12, 22,
        13, 11, 13, 14,
        13, 20, 13, 21,
    },
    {  // code=82, char='R'
        1, 6, 9, 6,
        1, 7, 11, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 4, 9,
        10, 9, 12, 9,
        2, 10, 4, 10,
        10, 10, 12, 10,
        2, 11, 4, 11,
        9, 11, 11, 11,
        2, 12, 10, 12,
        2, 13, 9, 13,
        2, 14, 4, 14,
        8, 14, 10, 14,
        2, 15, 4, 15,
        9, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        1, 18, 6, 18,
        11, 18, 14, 18,
        1, 19, 6, 19,
        12, 19, 14, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 19,
        3, 6, 3, 19,
        4, 6, 4, 19,
        5, 6, 5, 7,
        5, 12, 5, 13,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 12, 7, 13,
        8, 6, 8, 7,
        8, 12, 8, 14,
        9, 6, 9, 8,
        9, 11, 9, 15,
        10, 7, 10, 12,
        10, 14, 10, 17,
        11, 7, 11, 11,
        11, 15, 11, 18,
        12, 9, 12, 10,
        12, 17, 12, 19,
        13, 18, 13, 19,
        14, 18, 14, 19,
    },
    {  // code=83, char='S'
        5, 6, 8, 6,
        11, 6, 11, 6,
        3, 7, 11, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 3, 9,
        10, 9, 11, 9,
        2, 10, 4, 10,
        10, 10, 11, 10,
        2, 11, 5, 11,
        3, 12, 9, 12,
        5, 13, 11, 13,
        9, 14, 12, 14,
        2, 15, 3, 15,
        10, 15, 12, 15,
        2, 16, 3, 16,
        10, 16, 12, 16,
        1, 17, 4, 17,
        9, 17, 12, 17,
        2, 18, 11, 18,
        2, 19, 2, 19,
        5, 19, 9, 19,
        1, 17, 1, 17,
        2, 8, 2, 11,
        2, 15, 2, 19,
        3, 7, 3, 12,
        3, 15, 3, 18,
        4, 7, 4, 8,
        4, 10, 4, 12,
        4, 17, 4, 18,
        5, 6, 5, 7,
        5, 11, 5, 13,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 13,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 12, 7, 13,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 12, 8, 13,
        8, 18, 8, 19,
        9, 7, 9, 8,
        9, 12, 9, 14,
        9, 17, 9, 19,
        10, 7, 10, 10,
        10, 13, 10, 18,
        11, 6, 11, 10,
        11, 13, 11, 18,
        12, 14, 12, 17,
    },
    {  // code=84, char='T'
        1, 6, 12, 6,
        1, 7, 12, 7,
        1, 8, 2, 8,
        6, 8, 7, 8,
        11, 8, 12, 8,
        1, 9, 2, 9,
        6, 9, 7, 9,
        11, 9, 12, 9,
        1, 10, 2, 10,
        6, 10, 7, 10,
        11, 10, 12, 10,
        1, 11, 2, 11,
        6, 11, 7, 11,
        11, 11, 12, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        3, 18, 10, 18,
        3, 19, 10, 19,
        1, 6, 1, 11,
        2, 6, 2, 11,
        3, 6, 3, 7,
        3, 18, 3, 19,
        4, 6, 4, 7,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 18, 5, 19,
        6, 6, 6, 19,
        7, 6, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 18, 9, 19,
        10, 6, 10, 7,
        10, 18, 10, 19,
        11, 6, 11, 11,
        12, 6, 12, 11,
    },
    {  // code=85, char='U'
        0, 6, 5, 6,
        8, 6, 13, 6,
        0, 7, 5, 7,
        8, 7, 13, 7,
        2, 8, 3, 8,
        10, 8, 12, 8,
        2, 9, 3, 9,
        10, 9, 12, 9,
        2, 10, 3, 10,
        10, 10, 12, 10,
        2, 11, 3, 11,
        10, 11, 12, 11,
        2, 12, 3, 12,
        10, 12, 12, 12,
        2, 13, 3, 13,
        10, 13, 12, 13,
        2, 14, 3, 14,
        10, 14, 12, 14,
        2, 15, 3, 15,
        10, 15, 12, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        3, 17, 5, 17,
        9, 17, 11, 17,
        3, 18, 10, 18,
        5, 19, 9, 19,
        0, 6, 0, 7,
        1, 6, 1, 7,
        2, 6, 2, 16,
        3, 6, 3, 18,
        4, 6, 4, 7,
        4, 16, 4, 18,
        5, 6, 5, 7,
        5, 17, 5, 19,
        6, 18, 6, 19,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 18, 8, 19,
        9, 6, 9, 7,
        9, 17, 9, 19,
        10, 6, 10, 18,
        11, 6, 11, 17,
        12, 6, 12, 15,
        13, 6, 13, 7,
    },
    {  // code=86, char='V'
        0, 6, 5, 6,
        9, 6, 14, 6,
        0, 7, 5, 7,
        9, 7, 14, 7,
        1, 8, 3, 8,
        10, 8, 12, 8,
        2, 9, 3, 9,
        10, 9, 12, 9,
        2, 10, 4, 10,
        10, 10, 11, 10,
        3, 11, 4, 11,
        9, 11, 11, 11,
        3, 12, 5, 12,
        9, 12, 10, 12,
        3, 13, 5, 13,
        8, 13, 10, 13,
        4, 14, 5, 14,
        8, 14, 10, 14,
        4, 15, 6, 15,
        8, 15, 9, 15,
        5, 16, 9, 16,
        5, 17, 8, 17,
        5, 18, 8, 18,
        6, 19, 8, 19,
        0, 6, 0, 7,
        1, 6, 1, 8,
        2, 6, 2, 10,
        3, 6, 3, 13,
        4, 6, 4, 7,
        4, 10, 4, 15,
        5, 6, 5, 7,
        5, 12, 5, 18,
        6, 15, 6, 19,
        7, 16, 7, 19,
        8, 13, 8, 19,
        9, 6, 9, 7,
        9, 11, 9, 16,
        10, 6, 10, 14,
        11, 6, 11, 11,
        12, 6, 12, 9,
        13, 6, 13, 7,
        14, 6, 14, 7,
    },
    {  // code=87, char='W'
        0, 6, 5, 6,
        8, 6, 14, 6,
        0, 7, 5, 7,
        8, 7, 14, 7,
        1, 8, 2, 8,
        11, 8, 12, 8,
        1, 9, 2, 9,
        11, 9, 12, 9,
        1, 10, 3, 10,
        6, 10, 8, 10,
        11, 10, 12, 10,
        1, 11, 3, 11,
        5, 11, 8, 11,
        11, 11, 12, 11,
        1, 12, 3, 12,
        5, 12, 8, 12,
        11, 12, 12, 12,
        2, 13, 3, 13,
        5, 13, 9, 13,
        11, 13, 12, 13,
        2, 14, 6, 14,
        8, 14, 12, 14,
        2, 15, 6, 15,
        8, 15, 12, 15,
        2, 16, 5, 16,
        8, 16, 12, 16,
        2, 17, 5, 17,
        9, 17, 11, 17,
        2, 18, 4, 18,
        9, 18, 11, 18,
        2, 19, 4, 19,
        9, 19, 11, 19,
        0, 6, 0, 7,
        1, 6, 1, 12,
        2, 6, 2, 19,
        3, 6, 3, 7,
        3, 10, 3, 19,
        4, 6, 4, 7,
        4, 14, 4, 19,
        5, 6, 5, 7,
        5, 11, 5, 17,
        6, 10, 6, 15,
        7, 10, 7, 13,
        8, 6, 8, 7,
        8, 10, 8, 16,
        9, 6, 9, 7,
        9, 13, 9, 19,
        10, 6, 10, 7,
        10, 14, 10, 19,
        11, 6, 11, 19,
        12, 6, 12, 16,
        13, 6, 13, 7,
        14, 6, 14, 7,
    },
    {  // code=88, char='X'
        1, 6, 5, 6,
        9, 6, 13, 6,
        1, 7, 5, 7,
        9, 7, 13, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        3, 9, 5, 9,
        8, 9, 10, 9,
        4, 10, 10, 10,
        5, 11, 9, 11,
        5, 12, 8, 12,
        5, 13, 8, 13,
        4, 14, 9, 14,
        4, 15, 6, 15,
        8, 15, 10, 15,
        3, 16, 5, 16,
        9, 16, 11, 16,
        2, 17, 4, 17,
        9, 17, 11, 17,
        0, 18, 5, 18,
        8, 18, 13, 18,
        0, 19, 5, 19,
        8, 19, 13, 19,
        0, 18, 0, 19,
        1, 6, 1, 7,
        1, 18, 1, 19,
        2, 6, 2, 8,
        2, 17, 2, 19,
        3, 6, 3, 9,
        3, 16, 3, 19,
        4, 6, 4, 10,
        4, 14, 4, 19,
        5, 6, 5, 7,
        5, 9, 5, 16,
        5, 18, 5, 19,
        6, 10, 6, 15,
        7, 10, 7, 14,
        8, 9, 8, 15,
        8, 18, 8, 19,
        9, 6, 9, 11,
        9, 14, 9, 19,
        10, 6, 10, 10,
        10, 15, 10, 19,
        11, 6, 11, 8,
        11, 16, 11, 19,
        12, 6, 12, 7,
        12, 18, 12, 19,
        13, 6, 13, 7,
        13, 18, 13, 19,
    },
    {  // code=89, char='Y'
        1, 6, 5, 6,
        9, 6, 13, 6,
        1, 7, 5, 7,
        9, 7, 13, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        3, 9, 5, 9,
        9, 9, 10, 9,
        4, 10, 5, 10,
        8, 10, 10, 10,
        4, 11, 9, 11,
        5, 12, 8, 12,
        6, 13, 8, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        3, 18, 10, 18,
        3, 19, 10, 19,
        1, 6, 1, 7,
        2, 6, 2, 8,
        3, 6, 3, 9,
        3, 18, 3, 19,
        4, 6, 4, 11,
        4, 18, 4, 19,
        5, 6, 5, 7,
        5, 9, 5, 12,
        5, 18, 5, 19,
        6, 11, 6, 19,
        7, 11, 7, 19,
        8, 10, 8, 13,
        8, 18, 8, 19,
        9, 6, 9, 11,
        9, 18, 9, 19,
        10, 6, 10, 10,
        10, 18, 10, 19,
        11, 6, 11, 8,
        12, 6, 12, 7,
        13, 6, 13, 7,
    },
    {  // code=90, char='Z'
        2, 6, 11, 6,
        2, 7, 11, 7,
        2, 8, 4, 8,
        9, 8, 11, 8,
        2, 9, 4, 9,
        8, 9, 10, 9,
        2, 10, 4, 10,
        7, 10, 9, 10,
        3, 11, 3, 11,
        7, 11, 9, 11,
        6, 12, 8, 12,
        5, 13, 7, 13,
        4, 14, 6, 14,
        11, 14, 11, 14,
        4, 15, 6, 15,
        10, 15, 12, 15,
        3, 16, 5, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        2, 18, 12, 18,
        2, 19, 12, 19,
        2, 6, 2, 10,
        2, 17, 2, 19,
        3, 6, 3, 11,
        3, 16, 3, 19,
        4, 6, 4, 10,
        4, 14, 4, 19,
        5, 6, 5, 7,
        5, 13, 5, 16,
        5, 18, 5, 19,
        6, 6, 6, 7,
        6, 12, 6, 15,
        6, 18, 6, 19,
        7, 6, 7, 7,
        7, 10, 7, 13,
        7, 18, 7, 19,
        8, 6, 8, 7,
        8, 9, 8, 12,
        8, 18, 8, 19,
        9, 6, 9, 11,
        9, 18, 9, 19,
        10, 6, 10, 9,
        10, 15, 10, 19,
        11, 6, 11, 8,
        11, 14, 11, 19,
        12, 15, 12, 19,
    },
    {  // code=91, char='['
        6, 5, 10, 5,
        6, 6, 10, 6,
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        6, 21, 10, 21,
        6, 22, 10, 22,
        6, 5, 6, 22,
        7, 5, 7, 22,
        8, 5, 8, 6,
        8, 21, 8, 22,
        9, 5, 9, 6,
        9, 21, 9, 22,
        10, 5, 10, 6,
        10, 21, 10, 22,
    },
    {  // code=92, char='\'
        2, 3, 3, 3,
        2, 4, 4, 4,
        2, 5, 4, 5,
        3, 6, 5, 6,
        3, 7, 5, 7,
        4, 8, 5, 8,
        4, 9, 6, 9,
        5, 10, 6, 10,
        5, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 8, 13,
        7, 14, 8, 14,
        7, 15, 9, 15,
        8, 16, 9, 16,
        8, 17, 10, 17,
        8, 18, 10, 18,
        9, 19, 11, 19,
        9, 20, 11, 20,
        10, 21, 11, 21,
        10, 22, 11, 22,
        2, 3, 2, 5,
        3, 3, 3, 7,
        4, 4, 4, 9,
        5, 6, 5, 11,
        6, 9, 6, 13,
        7, 11, 7, 15,
        8, 13, 8, 18,
        9, 15, 9, 20,
        10, 17, 10, 22,
        11, 19, 11, 22,
    },
    {  // code=93, char=']'
        3, 5, 7, 5,
        3, 6, 7, 6,
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        3, 21, 7, 21,
        3, 22, 7, 22,
        3, 5, 3, 6,
        3, 21, 3, 22,
        4, 5, 4, 6,
        4, 21, 4, 22,
        5, 5, 5, 6,
        5, 21, 5, 22,
        6, 5, 6, 22,
        7, 5, 7, 22,
    },
    {  // code=94, char='^'
        7, 4, 7, 4,
        6, 5, 7, 5,
        5, 6, 8, 6,
        4, 7, 9, 7,
        3, 8, 5, 8,
        8, 8, 10, 8,
        3, 9, 4, 9,
        9, 9, 11, 9,
        2, 10, 4, 10,
        10, 10, 11, 10,
        2, 11, 3, 11,
        11, 11, 11, 11,
        2, 10, 2, 11,
        3, 8, 3, 11,
        4, 7, 4, 10,
        5, 6, 5, 8,
        6, 5, 6, 7,
        7, 4, 7, 7,
        8, 6, 8, 8,
        9, 7, 9, 9,
        10, 8, 10, 10,
        11, 9, 11, 11,
    },
    {  // code=95, char='_'
        0, 25, 14, 25,
        0, 26, 14, 26,
        0, 25, 0, 26,
        1, 25, 1, 26,
        2, 25, 2, 26,
        3, 25, 3, 26,
        4, 25, 4, 26,
        5, 25, 5, 26,
        6, 25, 6, 26,
        7, 25, 7, 26,
        8, 25, 8, 26,
        9, 25, 9, 26,
        10, 25, 10, 26,
        11, 25, 11, 26,
        12, 25, 12, 26,
        13, 25, 13, 26,
        14, 25, 14, 26,
    },
    {  // code=96, char='`'
        5, 4, 6, 4,
        5, 5, 7, 5,
        7, 6, 8, 6,
        8, 7, 8, 7,
        5, 4, 5, 5,
        6, 4, 6, 5,
        7, 5, 7, 6,
        8, 6, 8, 7,
    },
    {  // code=97, char='a'
        3, 9, 9, 9,
        2, 10, 10, 10,
        9, 11, 11, 11,
        9, 12, 11, 12,
        4, 13, 11, 13,
        2, 14, 11, 14,
        1, 15, 4, 15,
        9, 15, 11, 15,
        1, 16, 3, 16,
        9, 16, 11, 16,
        1, 17, 3, 17,
        8, 17, 11, 17,
        2, 18, 13, 18,
        3, 19, 7, 19,
        9, 19, 13, 19,
        1, 15, 1, 17,
        2, 10, 2, 10,
        2, 14, 2, 18,
        3, 9, 3, 10,
        3, 14, 3, 19,
        4, 9, 4, 10,
        4, 13, 4, 15,
        4, 18, 4, 19,
        5, 9, 5, 10,
        5, 13, 5, 14,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 13, 6, 14,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 13, 7, 14,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 13, 8, 14,
        8, 17, 8, 18,
        9, 9, 9, 19,
        10, 10, 10, 19,
        11, 11, 11, 19,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=98, char='b'
        0, 5, 3, 5,
        0, 6, 3, 6,
        2, 7, 3, 7,
        2, 8, 3, 8,
        2, 9, 3, 9,
        5, 9, 9, 9,
        2, 10, 11, 10,
        2, 11, 5, 11,
        10, 11, 12, 11,
        2, 12, 4, 12,
        11, 12, 12, 12,
        2, 13, 3, 13,
        11, 13, 13, 13,
        2, 14, 3, 14,
        11, 14, 13, 14,
        2, 15, 3, 15,
        11, 15, 13, 15,
        2, 16, 4, 16,
        11, 16, 12, 16,
        2, 17, 5, 17,
        10, 17, 12, 17,
        0, 18, 11, 18,
        0, 19, 3, 19,
        5, 19, 9, 19,
        0, 5, 0, 6,
        0, 18, 0, 19,
        1, 5, 1, 6,
        1, 18, 1, 19,
        2, 5, 2, 19,
        3, 5, 3, 19,
        4, 10, 4, 12,
        4, 16, 4, 18,
        5, 9, 5, 11,
        5, 17, 5, 19,
        6, 9, 6, 10,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 10,
        9, 18, 9, 19,
        10, 10, 10, 11,
        10, 17, 10, 18,
        11, 10, 11, 18,
        12, 11, 12, 17,
        13, 13, 13, 15,
    },
    {  // code=99, char='c'
        5, 9, 9, 9,
        11, 9, 12, 9,
        3, 10, 12, 10,
        2, 11, 5, 11,
        10, 11, 12, 11,
        2, 12, 3, 12,
        11, 12, 12, 12,
        1, 13, 3, 13,
        11, 13, 12, 13,
        1, 14, 3, 14,
        1, 15, 3, 15,
        2, 16, 3, 16,
        12, 16, 12, 16,
        2, 17, 4, 17,
        10, 17, 13, 17,
        3, 18, 12, 18,
        5, 19, 10, 19,
        1, 13, 1, 15,
        2, 11, 2, 17,
        3, 10, 3, 18,
        4, 10, 4, 11,
        4, 17, 4, 18,
        5, 9, 5, 11,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 10,
        9, 18, 9, 19,
        10, 10, 10, 11,
        10, 17, 10, 19,
        11, 9, 11, 13,
        11, 17, 11, 18,
        12, 9, 12, 13,
        12, 16, 12, 18,
        13, 17, 13, 17,
    },
    {  // code=100, char='d'
        8, 5, 12, 5,
        8, 6, 12, 6,
        10, 7, 12, 7,
        10, 8, 12, 8,
        4, 9, 8, 9,
        10, 9, 12, 9,
        3, 10, 12, 10,
        2, 11, 4, 11,
        8, 11, 12, 11,
        1, 12, 3, 12,
        10, 12, 12, 12,
        1, 13, 2, 13,
        10, 13, 12, 13,
        1, 14, 2, 14,
        10, 14, 12, 14,
        1, 15, 2, 15,
        10, 15, 12, 15,
        1, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        9, 17, 12, 17,
        2, 18, 14, 18,
        4, 19, 8, 19,
        10, 19, 14, 19,
        1, 12, 1, 16,
        2, 11, 2, 18,
        3, 10, 3, 12,
        3, 16, 3, 18,
        4, 9, 4, 11,
        4, 17, 4, 19,
        5, 9, 5, 10,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 9, 8, 11,
        8, 18, 8, 19,
        9, 5, 9, 6,
        9, 10, 9, 11,
        9, 17, 9, 18,
        10, 5, 10, 19,
        11, 5, 11, 19,
        12, 5, 12, 19,
        13, 18, 13, 19,
        14, 18, 14, 19,
    },
    {  // code=101, char='e'
        4, 9, 9, 9,
        3, 10, 10, 10,
        2, 11, 4, 11,
        9, 11, 11, 11,
        1, 12, 3, 12,
        10, 12, 12, 12,
        1, 13, 12, 13,
        1, 14, 12, 14,
        1, 15, 3, 15,
        1, 16, 3, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        3, 18, 12, 18,
        4, 19, 10, 19,
        1, 12, 1, 16,
        2, 11, 2, 17,
        3, 10, 3, 18,
        4, 9, 4, 11,
        4, 13, 4, 14,
        4, 17, 4, 19,
        5, 9, 5, 10,
        5, 13, 5, 14,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 13, 6, 14,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 13, 7, 14,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 13, 8, 14,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 13, 9, 14,
        9, 18, 9, 19,
        10, 10, 10, 14,
        10, 17, 10, 19,
        11, 11, 11, 14,
        11, 17, 11, 18,
        12, 12, 12, 14,
        12, 17, 12, 18,
    },
    {  // code=102, char='f'
        7, 5, 12, 5,
        5, 6, 12, 6,
        5, 7, 7, 7,
        5, 8, 6, 8,
        2, 9, 11, 9,
        2, 10, 11, 10,
        5, 11, 6, 11,
        5, 12, 6, 12,
        5, 13, 6, 13,
        5, 14, 6, 14,
        5, 15, 6, 15,
        5, 16, 6, 16,
        5, 17, 6, 17,
        2, 18, 11, 18,
        2, 19, 11, 19,
        2, 9, 2, 10,
        2, 18, 2, 19,
        3, 9, 3, 10,
        3, 18, 3, 19,
        4, 9, 4, 10,
        4, 18, 4, 19,
        5, 6, 5, 19,
        6, 6, 6, 19,
        7, 5, 7, 7,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 5, 8, 6,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 5, 9, 6,
        9, 9, 9, 10,
        9, 18, 9, 19,
        10, 5, 10, 6,
        10, 9, 10, 10,
        10, 18, 10, 19,
        11, 5, 11, 6,
        11, 9, 11, 10,
        11, 18, 11, 19,
        12, 5, 12, 6,
    },
    {  // code=103, char='g'
        4, 9, 8, 9,
        10, 9, 13, 9,
        3, 10, 13, 10,
        2, 11, 4, 11,
        8, 11, 11, 11,
        1, 12, 3, 12,
        9, 12, 11, 12,
        1, 13, 2, 13,
        10, 13, 11, 13,
        1, 14, 2, 14,
        10, 14, 11, 14,
        1, 15, 2, 15,
        10, 15, 11, 15,
        1, 16, 3, 16,
        9, 16, 11, 16,
        2, 17, 4, 17,
        8, 17, 11, 17,
        3, 18, 11, 18,
        4, 19, 8, 19,
        10, 19, 11, 19,
        10, 20, 11, 20,
        10, 21, 11, 21,
        9, 22, 11, 22,
        4, 23, 10, 23,
        4, 24, 9, 24,
        1, 12, 1, 16,
        2, 11, 2, 17,
        3, 10, 3, 12,
        3, 16, 3, 18,
        4, 9, 4, 11,
        4, 17, 4, 19,
        4, 23, 4, 24,
        5, 9, 5, 10,
        5, 18, 5, 19,
        5, 23, 5, 24,
        6, 9, 6, 10,
        6, 18, 6, 19,
        6, 23, 6, 24,
        7, 9, 7, 10,
        7, 18, 7, 19,
        7, 23, 7, 24,
        8, 9, 8, 11,
        8, 17, 8, 19,
        8, 23, 8, 24,
        9, 10, 9, 12,
        9, 16, 9, 18,
        9, 22, 9, 24,
        10, 9, 10, 23,
        11, 9, 11, 22,
        12, 9, 12, 10,
        13, 9, 13, 10,
    },
    {  // code=104, char='h'
        0, 5, 4, 5,
        0, 6, 4, 6,
        2, 7, 4, 7,
        2, 8, 4, 8,
        2, 9, 4, 9,
        6, 9, 9, 9,
        2, 10, 10, 10,
        2, 11, 5, 11,
        9, 11, 11, 11,
        2, 12, 4, 12,
        10, 12, 11, 12,
        2, 13, 4, 13,
        10, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 11, 14,
        2, 15, 4, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        2, 17, 4, 17,
        10, 17, 11, 17,
        1, 18, 5, 18,
        8, 18, 13, 18,
        1, 19, 5, 19,
        8, 19, 13, 19,
        0, 5, 0, 6,
        1, 5, 1, 6,
        1, 18, 1, 19,
        2, 5, 2, 19,
        3, 5, 3, 19,
        4, 5, 4, 19,
        5, 10, 5, 11,
        5, 18, 5, 19,
        6, 9, 6, 10,
        7, 9, 7, 10,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 18, 9, 19,
        10, 10, 10, 19,
        11, 11, 11, 19,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=105, char='i'
        5, 5, 7, 5,
        5, 6, 7, 6,
        3, 9, 7, 9,
        3, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        2, 18, 12, 18,
        2, 19, 12, 19,
        2, 18, 2, 19,
        3, 9, 3, 10,
        3, 18, 3, 19,
        4, 9, 4, 10,
        4, 18, 4, 19,
        5, 5, 5, 6,
        5, 9, 5, 10,
        5, 18, 5, 19,
        6, 5, 6, 6,
        6, 9, 6, 19,
        7, 5, 7, 6,
        7, 9, 7, 19,
        8, 18, 8, 19,
        9, 18, 9, 19,
        10, 18, 10, 19,
        11, 18, 11, 19,
        12, 18, 12, 19,
    },
    {  // code=106, char='j'
        7, 5, 9, 5,
        7, 6, 9, 6,
        2, 9, 10, 9,
        2, 10, 10, 10,
        9, 11, 10, 11,
        9, 12, 10, 12,
        9, 13, 10, 13,
        9, 14, 10, 14,
        9, 15, 10, 15,
        9, 16, 10, 16,
        9, 17, 10, 17,
        9, 18, 10, 18,
        9, 19, 10, 19,
        9, 20, 10, 20,
        8, 21, 10, 21,
        8, 22, 10, 22,
        2, 23, 9, 23,
        2, 24, 7, 24,
        2, 9, 2, 10,
        2, 23, 2, 24,
        3, 9, 3, 10,
        3, 23, 3, 24,
        4, 9, 4, 10,
        4, 23, 4, 24,
        5, 9, 5, 10,
        5, 23, 5, 24,
        6, 9, 6, 10,
        6, 23, 6, 24,
        7, 5, 7, 6,
        7, 9, 7, 10,
        7, 23, 7, 24,
        8, 5, 8, 6,
        8, 9, 8, 10,
        8, 21, 8, 23,
        9, 5, 9, 6,
        9, 9, 9, 23,
        10, 9, 10, 22,
    },
    {  // code=107, char='k'
        1, 5, 4, 5,
        1, 6, 4, 6,
        3, 7, 4, 7,
        3, 8, 4, 8,
        3, 9, 4, 9,
        7, 9, 12, 9,
        3, 10, 4, 10,
        7, 10, 12, 10,
        3, 11, 4, 11,
        7, 11, 9, 11,
        3, 12, 8, 12,
        3, 13, 7, 13,
        3, 14, 7, 14,
        3, 15, 8, 15,
        3, 16, 4, 16,
        7, 16, 9, 16,
        3, 17, 4, 17,
        8, 17, 10, 17,
        1, 18, 4, 18,
        8, 18, 13, 18,
        1, 19, 4, 19,
        8, 19, 13, 19,
        1, 5, 1, 6,
        1, 18, 1, 19,
        2, 5, 2, 6,
        2, 18, 2, 19,
        3, 5, 3, 19,
        4, 5, 4, 19,
        5, 12, 5, 15,
        6, 12, 6, 15,
        7, 9, 7, 16,
        8, 9, 8, 12,
        8, 15, 8, 19,
        9, 9, 9, 11,
        9, 16, 9, 19,
        10, 9, 10, 10,
        10, 17, 10, 19,
        11, 9, 11, 10,
        11, 18, 11, 19,
        12, 9, 12, 10,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=108, char='l'
        3, 5, 7, 5,
        3, 6, 7, 6,
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        2, 18, 12, 18,
        2, 19, 12, 19,
        2, 18, 2, 19,
        3, 5, 3, 6,
        3, 18, 3, 19,
        4, 5, 4, 6,
        4, 18, 4, 19,
        5, 5, 5, 6,
        5, 18, 5, 19,
        6, 5, 6, 19,
        7, 5, 7, 19,
        8, 18, 8, 19,
        9, 18, 9, 19,
        10, 18, 10, 19,
        11, 18, 11, 19,
        12, 18, 12, 19,
    },
    {  // code=109, char='m'
        0, 9, 6, 9,
        8, 9, 11, 9,
        0, 10, 12, 10,
        1, 11, 3, 11,
        6, 11, 8, 11,
        11, 11, 12, 11,
        1, 12, 3, 12,
        6, 12, 8, 12,
        11, 12, 13, 12,
        1, 13, 2, 13,
        6, 13, 8, 13,
        11, 13, 13, 13,
        1, 14, 2, 14,
        6, 14, 8, 14,
        11, 14, 13, 14,
        1, 15, 2, 15,
        6, 15, 8, 15,
        11, 15, 13, 15,
        1, 16, 2, 16,
        6, 16, 8, 16,
        11, 16, 13, 16,
        1, 17, 2, 17,
        6, 17, 8, 17,
        11, 17, 13, 17,
        0, 18, 4, 18,
        6, 18, 9, 18,
        11, 18, 14, 18,
        0, 19, 4, 19,
        6, 19, 9, 19,
        11, 19, 14, 19,
        0, 9, 0, 10,
        0, 18, 0, 19,
        1, 9, 1, 19,
        2, 9, 2, 19,
        3, 9, 3, 12,
        3, 18, 3, 19,
        4, 9, 4, 10,
        4, 18, 4, 19,
        5, 9, 5, 10,
        6, 9, 6, 19,
        7, 10, 7, 19,
        8, 9, 8, 19,
        9, 9, 9, 10,
        9, 18, 9, 19,
        10, 9, 10, 10,
        11, 9, 11, 19,
        12, 10, 12, 19,
        13, 12, 13, 19,
        14, 18, 14, 19,
    },
    {  // code=110, char='n'
        1, 9, 4, 9,
        6, 9, 9, 9,
        1, 10, 10, 10,
        2, 11, 5, 11,
        9, 11, 11, 11,
        2, 12, 4, 12,
        10, 12, 11, 12,
        2, 13, 4, 13,
        10, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 11, 14,
        2, 15, 4, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        2, 17, 4, 17,
        10, 17, 11, 17,
        1, 18, 5, 18,
        9, 18, 13, 18,
        1, 19, 5, 19,
        9, 19, 13, 19,
        1, 9, 1, 10,
        1, 18, 1, 19,
        2, 9, 2, 19,
        3, 9, 3, 19,
        4, 9, 4, 19,
        5, 10, 5, 11,
        5, 18, 5, 19,
        6, 9, 6, 10,
        7, 9, 7, 10,
        8, 9, 8, 10,
        9, 9, 9, 11,
        9, 18, 9, 19,
        10, 10, 10, 19,
        11, 11, 11, 19,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=111, char='o'
        5, 9, 9, 9,
        3, 10, 10, 10,
        2, 11, 4, 11,
        9, 11, 11, 11,
        2, 12, 3, 12,
        10, 12, 12, 12,
        1, 13, 3, 13,
        11, 13, 12, 13,
        1, 14, 2, 14,
        11, 14, 12, 14,
        1, 15, 3, 15,
        11, 15, 12, 15,
        1, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        9, 17, 11, 17,
        3, 18, 11, 18,
        5, 19, 9, 19,
        1, 13, 1, 16,
        2, 11, 2, 17,
        3, 10, 3, 13,
        3, 15, 3, 18,
        4, 10, 4, 11,
        4, 17, 4, 18,
        5, 9, 5, 10,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 17, 9, 19,
        10, 10, 10, 12,
        10, 16, 10, 18,
        11, 11, 11, 18,
        12, 12, 12, 16,
    },
    {  // code=112, char='p'
        0, 9, 3, 9,
        5, 9, 9, 9,
        0, 10, 11, 10,
        2, 11, 5, 11,
        9, 11, 12, 11,
        2, 12, 4, 12,
        11, 12, 12, 12,
        2, 13, 3, 13,
        11, 13, 13, 13,
        2, 14, 3, 14,
        11, 14, 13, 14,
        2, 15, 3, 15,
        11, 15, 13, 15,
        2, 16, 4, 16,
        11, 16, 12, 16,
        2, 17, 5, 17,
        10, 17, 12, 17,
        2, 18, 11, 18,
        2, 19, 3, 19,
        5, 19, 9, 19,
        2, 20, 3, 20,
        2, 21, 3, 21,
        2, 22, 3, 22,
        0, 23, 6, 23,
        0, 24, 6, 24,
        0, 9, 0, 10,
        0, 23, 0, 24,
        1, 9, 1, 10,
        1, 23, 1, 24,
        2, 9, 2, 24,
        3, 9, 3, 24,
        4, 10, 4, 12,
        4, 16, 4, 18,
        4, 23, 4, 24,
        5, 9, 5, 11,
        5, 17, 5, 19,
        5, 23, 5, 24,
        6, 9, 6, 10,
        6, 18, 6, 19,
        6, 23, 6, 24,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 18, 9, 19,
        10, 10, 10, 11,
        10, 17, 10, 18,
        11, 10, 11, 18,
        12, 11, 12, 17,
        13, 13, 13, 15,
    },
    {  // code=113, char='q'
        4, 9, 8, 9,
        10, 9, 14, 9,
        3, 10, 14, 10,
        2, 11, 4, 11,
        8, 11, 12, 11,
        1, 12, 3, 12,
        10, 12, 12, 12,
        1, 13, 3, 13,
        10, 13, 12, 13,
        1, 14, 2, 14,
        10, 14, 12, 14,
        1, 15, 2, 15,
        10, 15, 12, 15,
        1, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        9, 17, 12, 17,
        3, 18, 12, 18,
        4, 19, 8, 19,
        10, 19, 12, 19,
        10, 20, 12, 20,
        10, 21, 12, 21,
        10, 22, 12, 22,
        8, 23, 14, 23,
        8, 24, 14, 24,
        1, 12, 1, 16,
        2, 11, 2, 17,
        3, 10, 3, 13,
        3, 16, 3, 18,
        4, 9, 4, 11,
        4, 17, 4, 19,
        5, 9, 5, 10,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 11,
        8, 18, 8, 19,
        8, 23, 8, 24,
        9, 10, 9, 11,
        9, 17, 9, 18,
        9, 23, 9, 24,
        10, 9, 10, 24,
        11, 9, 11, 24,
        12, 9, 12, 24,
        13, 9, 13, 10,
        13, 23, 13, 24,
        14, 9, 14, 10,
        14, 23, 14, 24,
    },
    {  // code=114, char='r'
        2, 9, 6, 9,
        9, 9, 11, 9,
        2, 10, 6, 10,
        8, 10, 13, 10,
        4, 11, 9, 11,
        12, 11, 12, 11,
        4, 12, 7, 12,
        4, 13, 6, 13,
        4, 14, 6, 14,
        4, 15, 6, 15,
        4, 16, 6, 16,
        4, 17, 6, 17,
        1, 18, 11, 18,
        1, 19, 11, 19,
        1, 18, 1, 19,
        2, 9, 2, 10,
        2, 18, 2, 19,
        3, 9, 3, 10,
        3, 18, 3, 19,
        4, 9, 4, 19,
        5, 9, 5, 19,
        6, 9, 6, 19,
        7, 11, 7, 12,
        7, 18, 7, 19,
        8, 10, 8, 11,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 18, 9, 19,
        10, 9, 10, 10,
        10, 18, 10, 19,
        11, 9, 11, 10,
        11, 18, 11, 19,
        12, 10, 12, 11,
        13, 10, 13, 10,
    },
    {  // code=115, char='s'
        5, 9, 11, 9,
        3, 10, 11, 10,
        2, 11, 4, 11,
        9, 11, 11, 11,
        2, 12, 4, 12,
        10, 12, 11, 12,
        3, 13, 9, 13,
        4, 14, 11, 14,
        7, 15, 11, 15,
        2, 16, 3, 16,
        10, 16, 12, 16,
        2, 17, 4, 17,
        10, 17, 12, 17,
        2, 18, 11, 18,
        2, 19, 9, 19,
        2, 11, 2, 12,
        2, 16, 2, 19,
        3, 10, 3, 13,
        3, 16, 3, 19,
        4, 10, 4, 14,
        4, 17, 4, 19,
        5, 9, 5, 10,
        5, 13, 5, 14,
        5, 18, 5, 19,
        6, 9, 6, 10,
        6, 13, 6, 14,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 13, 7, 15,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 13, 8, 15,
        8, 18, 8, 19,
        9, 9, 9, 11,
        9, 13, 9, 15,
        9, 18, 9, 19,
        10, 9, 10, 12,
        10, 14, 10, 18,
        11, 9, 11, 12,
        11, 14, 11, 18,
        12, 16, 12, 17,
    },
    {  // code=116, char='t'
        5, 5, 5, 5,
        4, 6, 6, 6,
        4, 7, 6, 7,
        4, 8, 6, 8,
        2, 9, 11, 9,
        2, 10, 11, 10,
        4, 11, 6, 11,
        4, 12, 6, 12,
        4, 13, 6, 13,
        4, 14, 6, 14,
        4, 15, 6, 15,
        4, 16, 6, 16,
        4, 17, 6, 17,
        11, 17, 13, 17,
        5, 18, 13, 18,
        6, 19, 11, 19,
        2, 9, 2, 10,
        3, 9, 3, 10,
        4, 6, 4, 17,
        5, 5, 5, 18,
        6, 6, 6, 19,
        7, 9, 7, 10,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 18, 8, 19,
        9, 9, 9, 10,
        9, 18, 9, 19,
        10, 9, 10, 10,
        10, 18, 10, 19,
        11, 9, 11, 10,
        11, 17, 11, 19,
        12, 17, 12, 18,
        13, 17, 13, 18,
    },
    {  // code=117, char='u'
        1, 9, 4, 9,
        8, 9, 11, 9,
        1, 10, 4, 10,
        8, 10, 11, 10,
        2, 11, 4, 11,
        10, 11, 11, 11,
        2, 12, 4, 12,
        10, 12, 11, 12,
        2, 13, 4, 13,
        10, 13, 11, 13,
        2, 14, 4, 14,
        10, 14, 11, 14,
        2, 15, 4, 15,
        10, 15, 11, 15,
        2, 16, 4, 16,
        10, 16, 11, 16,
        3, 17, 4, 17,
        8, 17, 11, 17,
        3, 18, 13, 18,
        4, 19, 8, 19,
        10, 19, 13, 19,
        1, 9, 1, 10,
        2, 9, 2, 16,
        3, 9, 3, 18,
        4, 9, 4, 19,
        5, 18, 5, 19,
        6, 18, 6, 19,
        7, 18, 7, 19,
        8, 9, 8, 10,
        8, 17, 8, 19,
        9, 9, 9, 10,
        9, 17, 9, 18,
        10, 9, 10, 19,
        11, 9, 11, 19,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=118, char='v'
        0, 9, 5, 9,
        8, 9, 13, 9,
        0, 10, 5, 10,
        8, 10, 13, 10,
        2, 11, 4, 11,
        10, 11, 11, 11,
        3, 12, 4, 12,
        9, 12, 11, 12,
        3, 13, 5, 13,
        9, 13, 10, 13,
        4, 14, 5, 14,
        8, 14, 10, 14,
        4, 15, 5, 15,
        8, 15, 9, 15,
        4, 16, 6, 16,
        8, 16, 9, 16,
        5, 17, 9, 17,
        5, 18, 8, 18,
        6, 19, 8, 19,
        0, 9, 0, 10,
        1, 9, 1, 10,
        2, 9, 2, 11,
        3, 9, 3, 13,
        4, 9, 4, 16,
        5, 9, 5, 10,
        5, 13, 5, 18,
        6, 16, 6, 19,
        7, 17, 7, 19,
        8, 9, 8, 10,
        8, 14, 8, 19,
        9, 9, 9, 10,
        9, 12, 9, 17,
        10, 9, 10, 14,
        11, 9, 11, 12,
        12, 9, 12, 10,
        13, 9, 13, 10,
    },
    {  // code=119, char='w'
        0, 9, 4, 9,
        9, 9, 13, 9,
        0, 10, 4, 10,
        9, 10, 13, 10,
        1, 11, 3, 11,
        6, 11, 7, 11,
        11, 11, 12, 11,
        2, 12, 3, 12,
        6, 12, 8, 12,
        10, 12, 12, 12,
        2, 13, 3, 13,
        5, 13, 8, 13,
        10, 13, 12, 13,
        2, 14, 11, 14,
        2, 15, 11, 15,
        3, 16, 6, 16,
        8, 16, 11, 16,
        3, 17, 5, 17,
        8, 17, 11, 17,
        3, 18, 5, 18,
        8, 18, 11, 18,
        3, 19, 5, 19,
        9, 19, 10, 19,
        0, 9, 0, 10,
        1, 9, 1, 11,
        2, 9, 2, 15,
        3, 9, 3, 19,
        4, 9, 4, 10,
        4, 14, 4, 19,
        5, 13, 5, 19,
        6, 11, 6, 16,
        7, 11, 7, 15,
        8, 12, 8, 18,
        9, 9, 9, 10,
        9, 14, 9, 19,
        10, 9, 10, 10,
        10, 12, 10, 19,
        11, 9, 11, 18,
        12, 9, 12, 13,
        13, 9, 13, 10,
    },
    {  // code=120, char='x'
        1, 9, 5, 9,
        8, 9, 12, 9,
        1, 10, 5, 10,
        8, 10, 12, 10,
        3, 11, 5, 11,
        8, 11, 11, 11,
        4, 12, 10, 12,
        5, 13, 9, 13,
        5, 14, 8, 14,
        4, 15, 9, 15,
        3, 16, 6, 16,
        8, 16, 10, 16,
        2, 17, 5, 17,
        9, 17, 11, 17,
        1, 18, 5, 18,
        8, 18, 13, 18,
        1, 19, 5, 19,
        8, 19, 13, 19,
        1, 9, 1, 10,
        1, 18, 1, 19,
        2, 9, 2, 10,
        2, 17, 2, 19,
        3, 9, 3, 11,
        3, 16, 3, 19,
        4, 9, 4, 12,
        4, 15, 4, 19,
        5, 9, 5, 19,
        6, 12, 6, 16,
        7, 12, 7, 15,
        8, 9, 8, 16,
        8, 18, 8, 19,
        9, 9, 9, 13,
        9, 15, 9, 19,
        10, 9, 10, 12,
        10, 16, 10, 19,
        11, 9, 11, 11,
        11, 17, 11, 19,
        12, 9, 12, 10,
        12, 18, 12, 19,
        13, 18, 13, 19,
    },
    {  // code=121, char='y'
        1, 9, 5, 9,
        9, 9, 13, 9,
        1, 10, 5, 10,
        9, 10, 13, 10,
        2, 11, 4, 11,
        10, 11, 11, 11,
        2, 12, 4, 12,
        9, 12, 11, 12,
        3, 13, 5, 13,
        9, 13, 11, 13,
        3, 14, 5, 14,
        8, 14, 10, 14,
        4, 15, 5, 15,
        8, 15, 10, 15,
        4, 16, 9, 16,
        5, 17, 9, 17,
        5, 18, 8, 18,
        6, 19, 8, 19,
        6, 20, 7, 20,
        5, 21, 7, 21,
        5, 22, 6, 22,
        1, 23, 8, 23,
        1, 24, 8, 24,
        1, 9, 1, 10,
        1, 23, 1, 24,
        2, 9, 2, 12,
        2, 23, 2, 24,
        3, 9, 3, 14,
        3, 23, 3, 24,
        4, 9, 4, 16,
        4, 23, 4, 24,
        5, 9, 5, 10,
        5, 13, 5, 18,
        5, 21, 5, 24,
        6, 16, 6, 24,
        7, 16, 7, 21,
        7, 23, 7, 24,
        8, 14, 8, 19,
        8, 23, 8, 24,
        9, 9, 9, 10,
        9, 12, 9, 17,
        10, 9, 10, 15,
        11, 9, 11, 13,
        12, 9, 12, 10,
        13, 9, 13, 10,
    },
    {  // code=122, char='z'
        2, 9, 11, 9,
        2, 10, 11, 10,
        2, 11, 4, 11,
        8, 11, 11, 11,
        3, 12, 3, 12,
        7, 12, 10, 12,
        6, 13, 9, 13,
        5, 14, 8, 14,
        4, 15, 7, 15,
        3, 16, 6, 16,
        10, 16, 11, 16,
        2, 17, 5, 17,
        10, 17, 12, 17,
        2, 18, 12, 18,
        2, 19, 12, 19,
        2, 9, 2, 11,
        2, 17, 2, 19,
        3, 9, 3, 12,
        3, 16, 3, 19,
        4, 9, 4, 11,
        4, 15, 4, 19,
        5, 9, 5, 10,
        5, 14, 5, 19,
        6, 9, 6, 10,
        6, 13, 6, 16,
        6, 18, 6, 19,
        7, 9, 7, 10,
        7, 12, 7, 15,
        7, 18, 7, 19,
        8, 9, 8, 14,
        8, 18, 8, 19,
        9, 9, 9, 13,
        9, 18, 9, 19,
        10, 9, 10, 12,
        10, 16, 10, 19,
        11, 9, 11, 11,
        11, 16, 11, 19,
        12, 17, 12, 19,
    },
    {  // code=123, char='{'
        8, 5, 9, 5,
        7, 6, 9, 6,
        6, 7, 8, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        5, 13, 7, 13,
        4, 14, 7, 14,
        5, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        6, 20, 8, 20,
        6, 21, 9, 21,
        7, 22, 9, 22,
        4, 14, 4, 14,
        5, 13, 5, 15,
        6, 7, 6, 21,
        7, 6, 7, 22,
        8, 5, 8, 7,
        8, 20, 8, 22,
        9, 5, 9, 6,
        9, 21, 9, 22,
    },
    {  // code=124, char='|'
        6, 5, 7, 5,
        6, 6, 7, 6,
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 7, 13,
        6, 14, 7, 14,
        6, 15, 7, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        6, 21, 7, 21,
        6, 22, 7, 22,
        6, 5, 6, 22,
        7, 5, 7, 22,
    },
    {  // code=125, char='}'
        4, 5, 6, 5,
        4, 6, 7, 6,
        6, 7, 7, 7,
        6, 8, 7, 8,
        6, 9, 7, 9,
        6, 10, 7, 10,
        6, 11, 7, 11,
        6, 12, 7, 12,
        6, 13, 9, 13,
        6, 14, 9, 14,
        6, 15, 8, 15,
        6, 16, 7, 16,
        6, 17, 7, 17,
        6, 18, 7, 18,
        6, 19, 7, 19,
        6, 20, 7, 20,
        4, 21, 7, 21,
        4, 22, 6, 22,
        4, 5, 4, 6,
        4, 21, 4, 22,
        5, 5, 5, 6,
        5, 21, 5, 22,
        6, 5, 6, 22,
        7, 6, 7, 21,
        8, 13, 8, 15,
        9, 13, 9, 14,
    },
    {  // code=126, char='~'
        4, 11, 5, 11,
        2, 12, 7, 12,
        11, 12, 12, 12,
        2, 13, 3, 13,
        6, 13, 8, 13,
        10, 13, 12, 13,
        2, 14, 3, 14,
        7, 14, 11, 14,
        8, 15, 10, 15,
        2, 12, 2, 14,
        3, 12, 3, 14,
        4, 11, 4, 12,
        5, 11, 5, 12,
        6, 12, 6, 13,
        7, 12, 7, 14,
        8, 13, 8, 15,
        9, 14, 9, 15,
        10, 13, 10, 15,
        11, 12, 11, 14,
        12, 12, 12, 13,
    },
    {  // code=127
    },
};

//---------------------------------------------------------------------------
// Dimensions nominales de la police vectorielle
//---------------------------------------------------------------------------
const uint FONT_WIDTH  = 13;
const uint FONT_HEIGHT = 20;


//---------------------------------------------------------------------------
// drawChar : dessine un caractère (code ASCII c)
//   - (x, y)   : position de base (en pixels, par exemple)
//   - scale    : hauteur finale souhaitée du caractère
//   - color    : couleur (entier géré par votre moteur)
//
// On suppose que le tableau FONT[c] (array<float>) contient des quadruplets
//    (x1, y1, x2, y2)
// définissant chaque segment dans le repère (0..FONT_WIDTH, 0..FONT_HEIGHT).
//---------------------------------------------------------------------------
void drawChar(int c, float x, float y, float scale, int color)
{
    if (c < 0 || c >= 128)
        return;

    // Récupère le tableau de floats correspondant
    const array<float>@ segData = FONT[c];
    if (segData is null) 
        return;

    // Détermine le facteur d'échelle interne
    // de sorte que FONT_HEIGHT (20) devienne "scale" (ex: 10).
    float scaleFactor = scale / float(FONT_HEIGHT);

    // Épaisseur du trait (optionnel)
    float thickness = scaleFactor;
	if (thickness < 1.0) thickness = 1.0;

    // Parcourt chaque quadruplet (x1, y1, x2, y2)
    for (uint i = 0; i + 3 < segData.length(); i += 4)
    {
        float x1 = segData[i + 0];
        float y1 = segData[i + 1];
        float x2 = segData[i + 2];
        float y2 = segData[i + 3];

        // On multiplie chaque coordonnée par scaleFactor
        float xx1 = x + x1 * scaleFactor;
        float yy1 = y + y1 * scaleFactor;
        float xx2 = x + x2 * scaleFactor;
        float yy2 = y + y2 * scaleFactor;

        // Dessin
        // Remplacez "drawFatLine" par "drawLine" si votre moteur ne gère pas l'épaisseur
        // drawFatLine(xx1, yy1, xx2, yy2, color, int(thickness));
		if (scale > 16) {
			drawFatLine(xx1, yy1, xx2, yy2, color, int(thickness));
		} else {
			drawLine(xx1, yy1, xx2, yy2, color);
		}
    }
}


//---------------------------------------------------------------------------
// drawText : dessine une chaîne de caractères "text"
//   - (x, y)   : position de départ
//   - scale    : hauteur finale souhaitée
//   - color    : couleur
//---------------------------------------------------------------------------
void drawText(float x, float y, float scale, int color, const string &in text, float ratio=1.0)
{
    // On recalcule le même facteur d'échelle
    float scaleFactor = scale / float(FONT_HEIGHT);

    // Largeur effective d'un caractère si on le colle directement :
    //   FONT_WIDTH (15) * scaleFactor
    // On peut ajouter un petit espace proportionnel (par ex. +2 * scaleFactor).
    float charWidth = (FONT_WIDTH * scaleFactor) + (2.0f * scaleFactor);

    float cursorX = x;

    for (uint i = 0; i < text.length(); i++)
    {
        int c = text[i]; // code ASCII
        drawChar(c, cursorX, y, scale, color);
        cursorX += charWidth*ratio; 
    }
}
