
volatile unsigned long compteur = 0;  // Compteur total
volatile unsigned long impulsionsPeriode = 0;  // Impulsions par période
volatile unsigned long dernierTemps = 0;  // Dernier temps de réinitialisation
volatile unsigned long affichageImpulsions = 0;  // Pour stocker la valeur à afficher
static unsigned long T = 1000;  // Période en ms

volatile unsigned long dt, last_t;

void interrupt_routine() {
  unsigned long tempsActuel = millis();
  compteur++;  // Compteur total
  impulsionsPeriode++;  // Compteur période courante
  
  // Vérifie si la période T est écoulée
  if (tempsActuel - dernierTemps >= T) {
    affichageImpulsions = impulsionsPeriode;  // Sauvegarde pour affichage
    impulsionsPeriode = 0;  // Réinitialise
    dernierTemps = tempsActuel;  // Met à jour
  }

  unsigned long t = millis();
  dt = t - last_t;
  last_t = t;
}

int segment() {
  return digitalRead(S0)+2*(digitalRead(S1)+2*digitalRead(S2));
}

void afficher() {
  char buffer[32];
  sprintf(buffer, "temps: %ld ms    ", millis());
  display_string(0, 0, buffer);
  sprintf(buffer, "impulsions: %ld      ", compteur);
  display_string(0, 1, buffer);
  sprintf(buffer, "par %ldms (n): %ld    ", T, affichageImpulsions);
  display_string(0, 3, buffer);
  sprintf(buffer, "periode (T): %ld ms    ", dt);
  display_string(0, 4, buffer);
  sprintf(buffer, "commande: %d      ", cmd);
  display_string(0, 6, buffer);
}

void avance(int vitesse) {
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  analogWrite(ENA, vitesse);
}

void recule(int vitesse) {
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  analogWrite(ENA, vitesse);
}

void arreter() {
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, LOW);
  analogWrite(ENA, 255);
}

void attendre(long ms) {
  long tlimit = millis() + ms;
  while (millis() < tlimit) {
    afficher();
    delay(1);  // Laisser loop() gérer l'affichage
  }
}

bool terminus() {
  return digitalRead(END)==HIGH;
}

void attendre_terminus() {
  while (!terminus()) {
    afficher();
    delay(1);
  }
}
