//---------------------------------------------------------
//--- MATH FUNCTIONS --------------------------------------
//---------------------------------------------------------

const double PI = 3.14159265358979323846;

int abs( int n ) {
	return (n >= 0)? n : -n;
}

double abs(double x) {
    return x < 0.0 ? -x : x;
}

double fmod(double a, double b) {
	return a % b;
}

// Implémentation de floor si elle n'est pas disponible
int floor(double x) {
    if (x >= 0) {
        return int(x);
    } else {
        return int(x) - 1;
    }
}

// Implémentation de ceil si elle n'est pas disponible
int ceil(double x) {
    if (x == int(x)) {
        return int(x);
    } else if (x > 0) {
        return int(x) + 1;
    } else {
        return int(x);
    }
}

double sin(double x) {
    // Constantes
    const double TWO_PI = 2*PI;

    // Réduction de l'angle
    x = x - TWO_PI * int(x / TWO_PI);
    if (x > PI) x -= TWO_PI;
    if (x < -PI) x += TWO_PI;

    // Série de Taylor pour sin(x)
    double term = x;
    double sum = x;
    double x2 = x * x;

    term *= -x2 / (2 * 3);
    sum += term;

    term *= -x2 / (4 * 5);
    sum += term;

    term *= -x2 / (6 * 7);
    sum += term;

    term *= -x2 / (8 * 9);
    sum += term;

    return sum;
}

double cos(double x) {
    const double TWO_PI = 2*PI;

    x = x - TWO_PI * int(x / TWO_PI);
    if (x > PI) x -= TWO_PI;
    if (x < -PI) x += TWO_PI;

    double term = 1.0;
    double sum = 1.0;
    double x2 = x * x;

    term *= -x2 / (1 * 2);
    sum += term;

    term *= -x2 / (3 * 4);
    sum += term;

    term *= -x2 / (5 * 6);
    sum += term;

    term *= -x2 / (7 * 8);
    sum += term;

    return sum;
}

double sqrt(double x) {
    if (x < 0.0) {
        return 0.0;
    }

    double guess = x / 2.0;
    const double epsilon = 0.00001;

    while (abs(guess * guess - x) > epsilon) {
        guess = (guess + x / guess) / 2.0;
    }

    return guess;
}

float log(float x) {
    if (x <= 0.0) {
        // Gérer les entrées invalides
        // Ici, nous retournons 0.0, mais vous pouvez gérer différemment
        return 0.0;
    }

    // Transformation pour améliorer la convergence
    float y = (x - 1.0) / (x + 1.0);
    float y_squared = y * y;

    float sum = 0.0;
    float term = y; // Premier terme y^1 / 1
    int n = 1;

    const int MAX_TERMS = 20;      // Nombre maximal de termes
    const float EPSILON = 0.00001; // Précision souhaitée

    while (n <= MAX_TERMS) {
        sum += term / n;
        term *= y_squared; // y^{2k+1}
        n += 2;

        if (abs(term / n) < EPSILON) {
            break; // Arrêt si la contribution est négligeable
        }
    }

    return 2.0 * sum;
}

float exp(float x) {
    float sum = 1.0;        // Term 0: 1
    float term = 1.0;       // Initial term
    int n = 1;              // Term index

    const int MAX_TERMS = 20;      // Nombre maximal de termes
    const float EPSILON = 0.00001; // Précision souhaitée

    while (n < MAX_TERMS) {
        term *= x / n;       // Calcul du terme suivant: x^n / n!
        sum += term;         // Ajout du terme à la somme

        if (abs(term) < EPSILON) {
            break;            // Arrêt si la contribution est négligeable
        }

        n++;
    }

    return sum;
}


double time() {
	uint64 ctime = component.circTime();
	return ctime/1000000000000.0;
}


// Variables globales
int seed = int(time());


// Générateur pseudo-aléatoire (LCG)
// Paramètres choisis classiquement : a=1664525, c=1013904223, m=2^32
// Attention, ici on utilise un int 32 bits, donc on fera un modulo implicite.
int randomInt() {
    // Effectuer la transformation LCG
    seed = (1664525 * seed + 1013904223);
    // Vu que seed est un int, il sera déjà modulo 2^32.
    // Pour éviter les nombres négatifs, on peut forcer la plage positive
    // en utilisant un masquage si nécessaire.
    return seed & 0x7FFFFFFF; // masque pour garder une valeur non signée positive
}


// Pour obtenir un nombre entier dans une fourchette [min, max]
int randomRange(int minVal, int maxVal) {
    int range = maxVal - minVal + 1;
    return minVal + (randomInt() % range);
}


// Pour obtenir un nombre flottant entre 0 et 1
float randomFloat() {
    return float(randomInt()) / 2147483647.0; // 2147483647 = 0x7FFFFFFF
}

