; Compiler: Avrasm2

#define Simu_1
#ifdef Simu_1
#include "m8Adef.inc"
#endif ; Simu_1

;=============================
;=============================

;                 "1234567812345678
#define sourceP   "PowerAC_01-01___"   ; of Project
#define sourceB   "Pac1-1-1________"   ; for Boards
#define HEX_year  0x25
#define HEX_month 0x04
#define HEX_day   0x18
; __DATE__ , __TIME__ are in bin file

;====
.DSEG
;====

    .org 0x0060

; 0x60
; for SHWdspl: [Power and Volt] or [Curr or Ohm]
Digt_1:   .Byte 1 ;68
Digt_2:   .Byte 1 ;69
Digt_3:   .Byte 1 ;6A
Digt_4:   .Byte 1 ;6B

DigtV1:   .Byte 1 ; Voltage display [V], -888
DigtV2:   .Byte 1 ;
DigtV3:   .Byte 1 ;
DigtV4:   .Byte 1 ;

DigtC1:   .Byte 1 ; Current display [A], 88.88
DigtC2:   .Byte 1 ;
DigtC3:   .Byte 1 ;
DigtC4:   .Byte 1 ;

DigtP1:   .Byte 1 ; Power display [W], 8888
DigtP2:   .Byte 1 ;
DigtP3:   .Byte 1 ;
DigtP4:   .Byte 1 ;

DigtR1:   .Byte 1 ; Ohm display [R], 888.8
DigtR2:   .Byte 1 ;
DigtR3:   .Byte 1 ;
DigtR4:   .Byte 1 ;

DigtH1:   .Byte 1 ; Hz display [W], 88.88
DigtH2:   .Byte 1 ;
DigtH3:   .Byte 1 ;
DigtH4:   .Byte 1 ;

DigtE1:   .Byte 1 ; Fatakl error display, E--?
DigtE2:   .Byte 1 ;
DigtE3:   .Byte 1 ;
DigtE4:   .Byte 1 ;

;===

ADCport:  .Byte 1 ;6E current ADC port, RD_Vlo or RD_Vhi or RD_Cin

curSplVx: .Byte 1 ; current sample of input voltage readings
lstSplVx: .Byte 1 ; last    sample of input voltage readings

sum1VxL:  .Byte 1 ;6F sum of in voltage samples in one cycle, low
sum1VxH:  .Byte 1 ;70 sum of in voltage samples in one cycle, high
sum1VxU:  .Byte 1 ;71 sum of in voltage samples in one cycle, upper

sum1C_L:  .Byte 1 ;6F sum of in voltage samples in one cycle, low
sum1C_H:  .Byte 1 ;70 sum of in voltage samples in one cycle, high
sum1C_U:  .Byte 1 ;71 sum of in voltage samples in one cycle, upper

;===

sum2VloL: .Byte 1 ; sum of low voltage values in interval, low
sum2VloH: .Byte 1 ; sum of low voltage values in interval, high

avgVloL:  .Byte 1 ; binary average of low voltage values, low
avgVloH:  .Byte 1 ; binary average of low voltage values, high

adjVloL:  .Byte 1 ; adjusted avgVloH\L as BCD HEX, low
adjVloH:  .Byte 1 ; adjusted avgVloH\L as BCD HEX, high

gainVloL: .Byte 1 ; gain of low voltage, low
gainVloH: .Byte 1 ; gain of low voltage, high

;===

sum2VhiL: .Byte 1 ; sum of high voltage values in interval, low
sum2VhiH: .Byte 1 ; sum of high voltage values in interval, high

avgVhiL:  .Byte 1 ; binary average of high voltage values, low
avgVhiH:  .Byte 1 ; binary average of high voltage values, high

adjVhiL:  .Byte 1 ; adjusted avgVhiH\L as BCD HEX, low
adjVhiH:  .Byte 1 ; adjusted avgVhiH\L as BCD HEX, high

gainVhiL: .Byte 1 ; gain of high voltage, low
gainVhiH: .Byte 1 ; gain of high voltage, high

;===

sum2CinL: .Byte 1 ; sum of input current values in interval, low
sum2CinH: .Byte 1 ; sum of input current values in interval, high

avgCinL:  .Byte 1 ; binary average of input current values, low
avgCinH:  .Byte 1 ; binary average of input current values, high

adjCinL:  .Byte 1 ; adjusted avgCinH\L as BCD HEX, low
adjCinH:  .Byte 1 ; adjusted avgCinH\L as BCD HEX, high

gainCinL: .Byte 1 ; gain of input current, low
gainCinH: .Byte 1 ; gain of input current, high

;===

EEaddr_L: .Byte 1 ; image of EEARL

DlyKvOf:  .Byte 1 ; to be compared to ADJdely=100 [2s key delay]
DlyKvOn:  .Byte 1 ; to be compared to ADJdely=100 [2s key delay]

DlyKcOf:  .Byte 1 ; to be compared to ADJdely=100 [2s key delay]
DlyKcOn:  .Byte 1 ; to be compared to ADJdely=100 [2s key delay]

errHzDly: .Byte 1 ;

;===

ScrDly:   .Byte 1 ; screen delay counter, 4s

;---------------------

; for loop, to clear registers
.equ SRAMstr = 0x60             ; up to 0x00FF (160 SRAM bytes)
;#define SRAMall                 ; to clear all 1024 registers

; more variables in EE, see EE_init and READ_EE
;============================================================================

;====
.CSEG
;====

;==========================
; **** SYSTEM constants ***
;==========================

; PCB: A73, D:\KiCad\Projects\Office\7segDrv\7segDrv_65_V_I-CT

; X2/TOSC2, X1/TOSC1, SCK, MISO, MOSI/OC2, SS/OC1B, OC1A, ICP1
; SWstr=inP,ADJi=inP,SWscn=inP,Dgt1=outH,Dgt4=inP,Dgt2=inP,Dgt3=inP,Hz=inT
.equ DDRBini0 = 0b0_0_0_1000_0  ; i i i oiii i
.equ PRTBini0 = 0b1_1_1_1111_0  ; P P P HPPP T

; PB1= Dgt3, PB2= Dgt2, PB3= Dgt4, PB3= Dgt1
; IMPORTANT: for DDRB (not PORTB), PORTB fixed & DDRB changed
.equ DIGITSof = 0b000_0000_0    ; iii iiii i  all off
.equ DIGIT1on = 0b000_1000_0    ; iii HPPP P, Dgt1 only on
.equ DIGIT2on = 0b000_0010_0    ; iii PPHP P, Dgt2 only on
.equ DIGIT3on = 0b000_0001_0    ; iii PPPH P, Dgt3 only on
.equ DIGIT4on = 0b000_0100_0    ; iii PHPP P, Dgt3 only on

; *** inputs *** 4
#define Hz_In   PINB,0            ; pin monitoring
#define Scrn_In PINB,5
#define AdjC_In PINB,6
#define Strt_In PINB,7

; *** outputs *** 4
; PB1= Dgt3, PB2= Dgt2, PB3= Dgt4, PB3= Dgt1

; *** reserved *** 0
; none

;======

; N/A, RESET(inP), ADC5/SCL, ADC4/SDA, ADC3, ADC2, ADC1, ADC0
; N/A,RST=inP,OUT=outL,MODi=inP,ADCi=inT,ADvH=inT,ADvL=inT,ADJv=inP
.equ DDRCini0  = 0b00_1_0_000_0 ; xi o i iii i
.equ PRTCini0  = 0b01_0_1_000_1 ; xP L P TTT P

; *** inputs *** 5
#define AdjV_In PINC,0
#define ModI_In PINC,4          ; (32A or 8A max)
; PC1= ADC of Vlo
; PC2= ADC of Vhi
; PC3= ADC of Iin

; *** outputs *** 1
#define TRIAC_Out PORTC,5

; *** reserved *** 0+1+1[N/A]
; RST, PC7(N/A)

;======

; AIN1, AIN0, T1, XCK/T0, INT1, INT0, TXD, RXD
; SgB=inT,SgF=inT,SgA=inT,SgE=inT,SgD=inT,SgP=inT,SgC=inT,SgG=outL
; IMPORTANT: fix PORTD and change DDRD
.equ DDRDini0 = 0b00000001      ; iiiiiiio
.equ PRTDini0 = 0b00000000      ; TTTTTTTL

; *** inputs *** 0
; none

; *** outputs *** 8
.equ Seg_dot = 0x04
#define MIDboot DDRD,0          ; if 1, segmentG is lite, mid    seg
; PD7=Sg_B, PD6=Sg_F, PD5=Sg_A, PD4=Sg_E, PD3=Sg_D, PD1=Sg_C, PD0=Sg_G

; *** reserved *** 0
; none

;==========================
; *** PROGRAM constants ***
;==========================

#define b_ADIF   0x06,4         ; ADC Interrupt Flag

#define L_2V56   (1<<6|1<<7)    ; ADC ref is 2V56, b_REFS1:0=11
#define ADC1     0x01           ; for Vhi, input voltage
#define ADC2     0x02           ; for Vlo, input voltage
#define ADC3     0x03           ; for  Ii, input current

; for ADMUX
.equ ADCloV = L_2V56+ADC1       ; 2V56, right adjusted, Vhi
.equ ADChiV = L_2V56+ADC2       ; 2V56, right adjusted, Vlo
.equ ADCinC = L_2V56+ADC3       ; 2V56, right adjusted, Cin

; for ADCport
.equ RD_Vlo = ADC1              ; for ADCport Vlo
.equ RD_Vhi = ADC2              ; for ADCport Vhi
.equ RD_Cin = ADC3              ; for ADCport Cin

; Enable, Start, Free Run Select, (2^6) 8000/(64)=125 KHz, 104us
.equ ADC_init = 1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06  ; POLL b_ADIF
; ADEN , ADSC , ADFR , ADIF , ADIE , ADPS2 , ADPS1 , ADPS0
;  1      1      1      0      0      1       1       0

; 1/(240*104u)=40 Hz , 1/(148*104u)=64.9 Hz
.equ MAX_smpl = 240               ; Hz, lowest  frequency
.equ MIN_smpl = 148               ; Hz, highest frequency

;D:\L500\LTC\LTspiceIV\Projects\OfficeTest\ADC\Vac\Vi2ADC_250V_02.asc
.equ Vlo2bcd =  7112              ; = 0x1BC8
;D:\L500\LTC\LTspiceIV\Projects\OfficeTest\ADC\Vac\Vi2ADC_440V.asc
.equ Vhi2bcd = 12483              ; = 0x30C3
.equ VltAdjt = 22010              ; = 0x55FA

;D:\L500\LTC\LTspiceIV\Projects\OfficeTest\OpAmp\CurrentSense\
;   ACcurrent_04-mono_Pmeter.asc
.equ Cin2bcd = 9910               ; = 0x26B6
.equ CurAdjt = 8000               ; = 0x1F40

.equ ADDloVh = 0x0010             ; EEARL of gainVloH , then gainVloL
.equ ADDhiVh = 0x0014             ; EEARL of gainVhiH , then gainVhiL
.equ ADDinCh = 0x0018             ; EEARL of gainCinH , then gainCinL

;===

; init "errHzDly" in mains cycles
.equ HZerrDly = 10

;===

.set CYCLnmbr = 16
#ifdef Simu_1
; number of cycles of V or I average
.set CYCLnmbr = 4
#endif ; Simu_1

.set N_chkHz=64                 ; 64 mains cycles, 1.280 sec
#ifdef Simu_1
.set N_chkHz=8                  ;  8 mains cycles, 0.160 sec
#endif ; Simu_1

.set SHWhz=1000                 ; show Hz for 2 sec
#ifdef Simu_1
;.set SHWhz=125                  ; show Hz for 250 ms
.set SHWhz=25                   ; show Hz for 50 ms
#endif ; Simu_1

.set simuDly = 250
#ifdef Simu_1
.set simuDly = 1                ; for DLYqSec
#endif ; Simu_1

; 4000ms/20ms = 200
.equ SCRdlyK = 200

.equ ADJdely = 100              ; 100 * 20ms = 2000 ms press key delay

;=============================
; *** PROGRAM hi-registers ***
;=============================
; specific hi-registers
.def R1flags  = r25   ; general flags 1
.def R2flags  = r24   ; general flags 2
.def Keyflags = r23   ; read via PIND

;.def tmpState = r22     ; temporary prvState
.def loopHi   = r21     ; loop counter

; Division 24/16, 414 cycles, no rounding ***
; D16u16rd: , D24u16u:
.def steps = r21        ; loop counter
.def dv_H  = r20        ; divisor, high
.def dv_L  = r19        ; divisor, low
.def dd_U  = r18        ; divident, upper [ destroyed ]
.def dd_H  = r17        ; divident, high  [ destroyed ]
.def dd_L  = r16        ; divident, low   [ destroyed ]

.def res_U = r15        ; result, upper
.def rmd_H = r14        ; remainder, high
.def rmd_L = r13        ; remainder, low
.def res_H = r1         ; result, high
.def res_L = r0         ; result, low

; GLOBAL  hi-registers
;.def tmpHiU   = r18   ; tempprary for program when necessary
;.def tmpHiH   = r17   ; for ADDII
;.def tmpHiL   = r16   ; for macros

;=============================
; *** PROGRAM lo-registers ***
;=============================
; GLOBAL  lo-registers
;.def zero     = r15   ; zero value
;.def tmpLoH   = r14   ; temporary for program
;.def tmpLoL   = r13   ; temporary for program

; specific lo-registers
.def VxCyclC  = r11   ; Vx interval cycles counter

.def ADCrd_H  = r10   ;
.def ADCrd_L  = r9    ;

.def digtN    = r8    ; current display digit
.def DspOff   = r7    ; DspOff=0, offtime=256*19*104us=506ms

.def N_stage  = r6    ; 

.def zero     = r3   ; zero value

; r1 & r0 for MUL and others

.equ REGstr = 1
.equ REGend = 25                ; for loop to clear registers

;======================
; *** PROGRAM flags ***
;======================
; Bx for SBRC, SBRS
; Fx for SBR, CBR

;.def R1flags  = r25            ; general flags 1, basic
;-------------------------------------------------------

#define B_end2Vi r25,7          ; 1 = end interval for Vi, CYCLnmbr
#define F_end2Vi r25,0x80

#define B_end2Vo r25,6          ; 1 = end interval for Vo, CYCLnmbr
#define F_end2Vo r25,0x40

#define B_shwInf r25,5          ; 1 = show info [like Hz]
#define F_shwInf r25,0x20

#define B_noEEst r25,4          ; 1 = disable 220V setting on EE
#define F_noEEst r25,0x10

#define B_dot_On r25,3          ; 1 = turn on the digit dot
#define F_dot_On r25,0x08

#define B_modeVi r25,2          ; 1 = input  volt mode
#define F_modeVi r25,0x04

#define B_modeVo r25,1          ; 1 = output volt mode
#define F_modeVo r25,0x02

#define B_dspOff r25,0          ; 1 = temporary display off
#define F_dspOff r25,0x01
#define X_dspOff 0b00000001     ; for on-off display

;=============

;.def R2flags  = r24            ; general flags 2
;------------------------------------------------
#define B_dspPwr r24,7          ; 1 = display power, 8888
#define F_dspPwr r24,0x80

#define B_dspVlt r24,6          ; 1 = display voltage
#define F_dspVlt r24,0x40

#define B_dspCin r24,5          ; 1 = display current, 88.88
#define F_dspCin r24,0x20

#define B_dspRes r24,4          ; 1 = display resistance
#define F_dspRes r24,0x10

#define B_dsplHz r24,3          ; 1 = display Hz, 88.88
#define F_dsplHz r24,0x08

#define B_err_Hz r24,2          ; 1 = mains frequency beyond limits
#define F_err_Hz r24,0x04

#define B_shwErr r24,1          ; 1 = display on-off screen
#define F_shwErr r24,0x02

;#define B_rd_Vhi r24,0          ; 1 = read ADC Vhi and Cin
;#define F_rd_Vhi r24,0x01

;.def R2flags  = r23            ; general flags 3
;------------------------------------------------
#define B_endVlo r23,7          ; 1 = end interval of Vlo, CYCLnmbr
#define F_endVlo r23,0x80

#define B_endVhi r23,6          ; 1 = end interval of Vhi, CYCLnmbr
#define F_endVhi r23,0x40

#define B_endCin r23,5          ; 1 = end interval of Cin, CYCLnmbr
#define F_endCin r23,0x20

#define B_rd_Vhi r23,4          ; 1 = read ADC Vhi and Cin
#define F_rd_Vhi r23,0x10       ; 0 = read ADC Vlo and Cin

#define B_wasCin r23,3          ; 1 = previous ADC was for Cin
#define F_wasCin r23,0x08

#define B_kyVoff r23,2          ; 1 = adjust key of Vi is off for 4 sec
#define F_kyVoff r23,0x04

#define B_kyCoff r23,1          ; 1 = adjust key of Vi is off for 4 sec
#define F_kyCoff r23,0x02

;---------------------------------

.equ keyActS_ = 0x09       ; flags using UBRRL
#define S_GvVxOn 0x09,7    ; 1 = setting adjust Vx key is on for 2 sec
#define S_GvCiOn 0x09,6    ; 1 = setting adjust Ci key is on for 2 sec

#define S_GvVxSv 0x09,5    ; 1 = saving Vx gain is in progress
#define S_GvCiSv 0x09,4    ; 1 = saving Ci gain is in progress

;========================================================================

    .org 0x0000

; MCUCSR: * , * , * , * , WDRF , BORF , EXTRF , PORF
    rjmp RESET      ; Reset Handler

    rjmp EXT_INT0   ; IRQ0 Handler
    rjmp EXT_INT1   ; IRQ1 Handler
    rjmp TIM2_COMP  ; Timer2 Compare Handler
    rjmp TIM2_OVF   ; Timer2 Overflow Handler
    rjmp TIM1_CAPT  ; Timer1 Capture Handler
    rjmp TIM1_COMPA ; Timer1 CompareA Handler
    rjmp TIM1_COMPB ; Timer1 CompareB Handler
    rjmp TIM1_OVF   ; Timer1 Overflow Handler
    rjmp TIM0_OVF   ; Timer0 Overflow Handler
    rjmp SPI_STC    ; SPI Transfer Complete Handler
    rjmp USART_RXC  ; USART RX Complete Handler
    rjmp USART_UDRE ; UDR Empty Handler
    rjmp USART_TXC  ; USART TX Complete Handler
    rjmp ADC_RDY    ; ADC Conversion Complete Handler
    rjmp EE_RDY     ; EEPROM Ready Handler
    rjmp ANA_COMP   ; Analog Comparator Handler
    rjmp TWSI       ; Two-wire Serial Interface Handler
    rjmp SPM_RDY    ; Store Program Memory Ready Handler

;---------------------
; 16 bytes Name & City
;---------------------

SIGNAT0:
   .db "AUTOLIGHT-ALEPPO"

SIGNAT1:
   .db  0x00, HEX_year, HEX_month, HEX_day ; number of bytes should be even
SIGNAT2:
   .db  sourceP
   .db  sourceB

   .db  __DATE__
   .db  __TIME__

;=============================
; *RI* Interrupts Handlers ***
;=============================

; IRQ0: PD2, pin4 [MCUCR , GICR , GIFR]
EXT_INT0:
    RETI

; IRQ1: PD3, pin5 [MCUCR , GICR , GIFR]
EXT_INT1:
    RETI

; Timer2 Compare: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_COMP:
    RETI

; Timer2 Overflow: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_OVF:
    RETI

; Timer1 Capture: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_CAPT:
    RETI

; Timer1 CompareA: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPA:
    RETI

; Timer1 CompareB: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPB:
    RETI

; Timer1 Overflow: [TCNT1H/L, TIMSK , TIFR]
TIM1_OVF:
    RETI

; Timer0 Overflow: [TCCR0 , TCNT0]
TIM0_OVF:
    RETI

; SPI Transfer Complete: [SPCR , SPSR , SPDR]
SPI_STC:            ;
    RETI

; USART: RX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_RXC:
    RETI

; USART: UDR Empty: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_UDRE:
    RETI

; USART: TX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_TXC:
    RETI

; ADC Conversion Complete: [ADCH/L , ADMUX , ADCSRA]
ADC_RDY:            ;
    RETI

; EEPROM Ready: [EEARH/L, EEDR , EECR]
EE_RDY:
    RETI

; Analog Comparator: [SFIOR , ACSR]
ANA_COMP:
    RETI

; Two-wire Serial Interface: [TWAR , TWDR , TWBR , TWCR , TWSR]
TWSI:
    RETI

; Store Program Memory Ready: [SPMCR]
SPM_RDY:
    RETI

;===================
; *** MAIN entry ***
;===================

RESET:
; SPH\L [Stack Pointer] = RAMEND [top of SRAM, 0x045F]
    LDI   r16,  low(RAMEND)
    LDI   r17, high(RAMEND)
    OUT   SPL, r16
    OUT   SPH, r17

; DDRB=DDRBini0
    LDI   r16, DDRBini0
    OUT   DDRB, r16
; PORTB=PRTBini0
    LDI   r17, PRTBini0
    OUT   PORTB, r17

; DDRC=DDRCini0
    LDI   r16, DDRCini0
    OUT   DDRC, r16
; PORTC=PRTCini0
    LDI   r17, PRTCini0
    OUT   PORTC, r17

; DDRD=DDRDini0
    LDI   r16, DDRDini0
    OUT   DDRD, r16
; PORTD=PRTDini0
    LDI   r17, PRTDini0
    OUT   PORTD, r17

; Wait for stable Vcc (the fuse BODEN should be enabled)
    IN    r16, MCUCSR           ; MCU Control and Status Register
    SBRS  r16, BORF             ; Test Brown-out Reset Flag
    RJMP  RST_cnt               ; Continue if 0

    CLR   r16                   ; Brown-out Reset Flag is 1
    OUT   MCUCSR, r16           ; Clear all flags
    RJMP  RESET                 ;  and reboot

;====================================================================
; clear low and high registers
RST_cnt:
    CLR   r0
    LDI   XH, high(REGstr)
    LDI   XL,  low(REGstr)      ; start of variables in low registers
CLR_lp1:
    ST    X+, r0
    CPI   XL, REGend+1          ; end of variables in high registers
    BREQ  CLRend1

    RJMP  CLR_lp1

CLRend1:
; clear extended static RAM registers
    LDI   XH, high(SRAMstr)
    LDI   XL,  low(SRAMstr)     ; 0x60
CLR_lp2:
    ST    X+, r0

#ifndef SRAMall
    TST   XL
    BREQ  CLRend2               ; 0x60 =< XL =< 0xFF (160)

    RJMP  CLR_lp2
#else ; no SRAMall
    CPI   XH, high(RAMEND+1)    ; 0x04 , RAMEND+1 = 0x0460
    BRLO  CLR_lp2
    CPI   XL,  low(RAMEND+1)    ; 0x60
    BRLO  CLR_lp2
#endif ; SRAMall

CLRend2:
    OUT   keyActS_, r0          ; r0 already cleared

;==========================================
; ============ init variables =============
;==========================================

;stp01: key Strt_In should be off
;stp02: pin AdjV_In? low/F_noEEst=1 [adjust mode]
;stp03: check and display Hz
;stp04: EE_init: and READall
;stp05: prepare to read volt only [N_stage=0]

BOOT_lp:
    SBIS  Strt_In
    RJMP  BOOT_lp

; if AdjV_In=0 [shorted], disable 220V & 8A settings
    SBIC  AdjV_In
    RJMP  INIint0

    SBR   F_noEEst

INIint0:
; call INI_Hz_: [check mains frequency, MIDboot dimmed if no mains]
    RCALL INI_Hz_
    RCALL DSPL_hz

; b7, Input Capture Noise Canceler for ICP1 input
; b6, Input Capture Edge Select for ICP1 input, rising edge
; b2:0=010, /8 ==> 1us
    LDI   r16, 0b11000010
    OUT   TCCR1B, r16

; call EE_init: [if fresh save default gainVloH\L,gainVhiH\L,gainCinH\L]
; Vlo2bcd [7112,0x1BC8],Vhi2bcd [12483,0x30C3],Cin2bcd [9910,0x26B6]
    RCALL EE_init
; call RD_Vx_G: [get gainVx_H\L from EE]
    RCALL READall

    SBR   F_rd_Vhi
    RCALL VxReset
/*
; ADMUX=ADChiV [L_2V56+ADC2, right adjusted, high Voltage]
    LDI   r16, ADChiV
    OUT   ADMUX, r16

    LDI   r16, RD_Vhi
    STS   ADCport, r16
*/
; ADCSRA=ADC_init [1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06]
;       =[Enable,Start,Free Run,8000/64=125 KHz] 104us/832c slide time
    LDI   r16, ADC_init
    OUT   ADCSRA, r16

; errHzDly=HZerrDly [reset Hz error counter, 10 cycles]
    LDI   r16, HZerrDly
    STS   errHzDly, r16

;    RCALL VxReset
;  [reset counter of Vi average cycles]
; VxCyclC=CYCLnmbr=16, curSplVx=sum1VxU\H\L=sum2VloH\L=sum2VhiH\L=sum2CinH\L0

MAINini:
; loop till ADC ends
    SBIS  b_ADIF
    RJMP  MAINini

; clear ADC flag [ by setting it to 1 ]
    SBI   b_ADIF

;------------------
; *** Main Loop ***
;------------------

MAIN_lp:
; if b_ADIF=0, goto MAIN_lp: [wait ADC]
    SBIS  b_ADIF
    RJMP  MAIN_lp

; b_ADIF=1 [clear ADC flag by setting it to 1]
    SBI   b_ADIF

; *** Common code ***
; ADCrd_H\L [lo_reg] = ADCH\L
    IN    ADCrd_L, ADCL         ; r9
    IN    ADCrd_H, ADCH         ; r10

; ZH:ZL = high(SVx_000):curSplVx
    LDS   r16, curSplVx
    LDI   ZH, high(SVx_000)
    MOV   ZL, r16
; IJMP [jump to address in ZH:ZL]
    IJMP

;====================================================================
;====================================================================

;SVx_001:
; average Vx in one cycle
Vx_new_:
; if B_err_Hz=1, goto VxNewEr:
    SBRC  B_err_Hz
    RJMP  VxNewEr

    LDS   dv_L, lstSplVx
    TST   dv_L
    BRNE  VxNewOk

VxNewEr:
; sum1VxU\H\L=0 [reset cycle average]
    CLR   r16
    STS   sum1VxU, r16
    STS   sum1VxH, r16
    STS   sum1VxL, r16

; VxCyclC=CYCLnmbr [reset counter of Vx average cycles]
    LDI   r16, CYCLnmbr      ; 16 times
    MOV   VxCyclC, r16

    RJMP  VxNewEd

VxNewOk:
    CLR   dv_H
    LDS   dd_U, sum1VxU
    LDS   dd_H, sum1VxH
    LDS   dd_L, sum1VxL

; dividend : r18(dd_U), r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r15(res_U),r1(res_H),r0(res_L)
; 414 cycles

; r1:r0 = sum1VxU\H\L / lstSplVx [Vx average in one cycle]
    RCALL D24u16u

    TST   res_U                 ; r15
    BREQ  VxNewCt

; sum1Vx/lstSplVx > 65535 [overflow]
    RJMP  FTLerr1

VxNewCt:
; sum1VxU\H\L=0 [reset cycle average]
    CLR   r16
    STS   sum1VxU, r16
    STS   sum1VxH, r16
    STS   sum1VxL, r16

    RCALL SUMprev

VxNewEd:
    RJMP  Vx_end_

;=====

SUMprev:
; do sum of the previous ADCport
    SBRS  B_wasCin
    RJMP  SUM_Vx_

SUM_Cin:
    LDS   r16, sum2CinL
    ADD   r16, r0
    STS   sum2CinL, r16

    LDS   r16, sum2CinH
    ADC   r16, r1
    STS   sum2CinH, r16

; decrement VxCyclC, if not 0 , goto SUM2VxR:
    DEC   VxCyclC               ; ; decrement VxCyclC if reading Vi & Vo
    BRNE  SUM2VxR

    LDI   r16, CYCLnmbr      ; 16 times
    MOV   VxCyclC, r16

; F_endCin=1 [signal cycles of Cin average readings is over]
    SBR   F_endCin

; F_endVlo=1 [signal cycles of Vlo average readings is over]
    SBR   F_endVlo
    SBRS  B_rd_Vhi
    RJMP  SUM2VxR

    CBR   F_endVlo
; F_endVlo=1 [signal cycles of Vlo average readings is over]
    SBR   F_endVhi

SUM2VxR:
    RET

;=== ===

SUM_Vx_:
    SBRS  B_rd_Vhi
    RJMP  SUM_Vlo

SUM_Vhi:
    LDS   r16, sum2VhiL
    ADD   r16, r0
    STS   sum2VhiL, r16

    LDS   r16, sum2VhiH
    ADC   r16, r1
    STS   sum2VhiH, r16
    RJMP  SUM2VxR               ; keep VxCyclC if it was not Cin

SUM_Vlo:
    LDS   r16, sum2VloL
    ADD   r16, r0
    STS   sum2VloL, r16

    LDS   r16, sum2VloH
    ADC   r16, r1
    STS   sum2VloH, r16
    RJMP  SUM2VxR               ; keep VxCyclC if it was not Cin

;===============================================================
;===============================================================

;SVx_002:
Vlo_avg:
; if B_err_Hz=1, goto VloAvgE:
    SBRC  B_err_Hz
    RJMP  VloAvgE

; if B_endVlo=0 [not end of Vlo average cycles], goto VloAvgE:
    SBRS  B_endVlo
    RJMP  VloAvgE

; r1:r0 = sum2VloH\L / CYCLnmbr [Vlo average]
    CLR   dv_H
    LDI   dv_L, CYCLnmbr        ; 16 times
    LDS   dd_H, sum2VloH
    LDS   dd_L, sum2VloL

; *** Division 16/16, 280 cycles, rounding res_H\L ***
; dividend : r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r1:r0

    RCALL D16u16rd

; avgVloH\L = r1:r0
    STS   avgVloH, r1
    STS   avgVloL, r0

; sum2VloH\L = 0 [reset Vlo average]
    CLR   r16
    STS   sum2VloH, r16
    STS   sum2VloL, r16

VloAvgE:
    RJMP  Vx_end_

;===============================================================

;SVx_003:
Vhi_avg:
; if B_err_Hz=1, goto VloAvgE:
    SBRC  B_err_Hz
    RJMP  VloAvgE

; if B_endVhi=0 [not end of Vhi average cycles], goto VhiAvgE:
    SBRS  B_endVhi
    RJMP  VhiAvgE

; r1:r0 = sum2VhiH\L / CYCLnmbr [Vhi average]
    CLR   dv_H
    LDI   dv_L, CYCLnmbr        ; 16 times
    LDS   dd_H, sum2VhiH
    LDS   dd_L, sum2VhiL

; *** Division 16/16, 280 cycles, rounding res_H\L ***
; dividend : r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r1:r0

    RCALL D16u16rd

; avgVhiH\L = r1:r0
    STS   avgVhiH, r1
    STS   avgVhiL, r0

; sum2VhiH\L = 0 [reset Vlo average]
    CLR   r16
    STS   sum2VhiH, r16
    STS   sum2VhiL, r16

VhiAvgE:
    RJMP  Vx_end_

;===============================================================

;SVx_004:
Cin_avg:
; if B_err_Hz=1, goto CinAvgE:
    SBRC  B_err_Hz
    RJMP  CinAvgE

; if B_endCin=0 [not end of Cin average cycles], goto CinAvgE:
    SBRS  B_endCin
    RJMP  CinAvgE

; r1:r0 = sum2CinH\L / CYCLnmbr [Cin average]
    CLR   dv_H
    LDI   dv_L, CYCLnmbr        ; 16 times
    LDS   dd_H, sum2CinH
    LDS   dd_L, sum2CinL

; *** Division 16/16, 280 cycles, rounding res_H\L ***
; dividend : r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r1:r0

    RCALL D16u16rd

; avgCinH\L = r1:r0
    STS   avgCinH, r1
    STS   avgCinL, r0

; sum2VhiH\L = 0 [reset Vlo average]
    CLR   r16
    STS   sum2CinH, r16
    STS   sum2CinL, r16

CinAvgE:
    RJMP  Vx_end_

;===============================================================
;===============================================================

;SVx_005:
Vlo_bcd:
; if B_err_Hz=1, goto VloBcdE:
    SBRC  B_err_Hz
    RJMP  VloBcdE

; if B_endVlo=0 [not end of Vlo average cycles], goto VloBcdE:
    SBRS  B_endVlo
    RJMP  VloBcdE

; nominal gainVloH\L = Vlo2bcd = 7112 = 0x1BC8
; r20:r19 = avgVloH\L * gainVloH\L / 256 [to BCD binary]
    LDS   r17, avgVloH
    LDS   r16, avgVloL
    LDS   r14, gainVloH
    LDS   r13, gainVloL

; *** 16x16 Bit Unsigned Multiplication , 24 cycles ***
; multiplicand: r17:r16 as avgCurrH\L
; multiplier  : r14:r13 as adjDECcH\L
; result out  : r21(S), r20(U), r19(H), r18(L)
; see mul16x16_32_AL.txt

    RCALL M_16x16

;; binary BCD in r20:r19 to hex BCD in r17:r16 for AL CARD
;    RCALL ADJ2hex

    STS   adjVloH, r20
    STS   adjVloL, r19
VloBcdE:
    RJMP  Vx_end_

;===============================================================

;SVx_007:
Vhi_bcd:
; if B_err_Hz=1, goto VhiBcdE:
    SBRC  B_err_Hz
    RJMP  VhiBcdE

; if B_endVhi=0 [not end of Vhi average cycles], goto VhiBcdE:
    SBRS  B_endVhi
    RJMP  VhiBcdE

; nominal gainVhiH\L = Vhi2bcd = 12483 = 0x30C3
; r20:r19 = avgVhiH\L * gainVhiH\L / 256 [to BCD binary]
    LDS   r17, avgVhiH
    LDS   r16, avgVhiL
    LDS   r14, gainVhiH
    LDS   r13, gainVhiL

; *** 16x16 Bit Unsigned Multiplication , 24 cycles ***
; multiplicand: r17:r16 as avgCurrH\L
; multiplier  : r14:r13 as adjDECcH\L
; result out  : r21(S), r20(U), r19(H), r18(L)
; see mul16x16_32_AL.txt

    RCALL M_16x16

    STS   adjVhiH, r20
    STS   adjVhiL, r19
VhiBcdE:
    RJMP  Vx_end_

;===============================================================

;SVx_008:
Cin_bcd:
; if B_err_Hz=1, goto CinBcdE:
    SBRC  B_err_Hz
    RJMP  CinBcdE

; if B_endVhi=0 [not end of Vhi average cycles], goto VhiBcdE:
    SBRS  B_endVhi
    RJMP  CinBcdE

; nominal gainCinH\L = Cin2bcd = 9910 = 0x26B6
; r20:r19 = avgCinH\L * gainCinH\L / 256 [to BCD binary]
    LDS   r17, avgCinH
    LDS   r16, avgCinL
    LDS   r14, gainCinH
    LDS   r13, gainCinL

; *** 16x16 Bit Unsigned Multiplication , 24 cycles ***
; multiplicand: r17:r16 as avgCurrH\L
; multiplier  : r14:r13 as adjDECcH\L
; result out  : r21(S), r20(U), r19(H), r18(L)
; see mul16x16_32_AL.txt

    RCALL M_16x16

    STS   adjCinH, r20
    STS   adjCinL, r19
CinBcdE:
    RJMP  Vx_end_

;===============================================================
;===============================================================

;SVx_009:
Vx_key_:
; if B_err_Hz=1, goto VxKeyEd:
    SBRC  B_err_Hz
    RJMP  VxKeyEd

    SBRC  B_noEEst
    RJMP  VxKeyEd

; if S_GvVxOn=1 [gainVloH\L & gainVhiH\L 'setting' busy], goto RSTkyOn:
    SBIC  S_GvVxOn
    RJMP  RSTkVon

; if S_GvCiSv=1 [gainCinH\L 'saving' busy], goto RSTkyOn:
    SBIC  S_GvCiSv
    RJMP  RSTkVon

; if B_kyVoff=0 [key of setting Vi gain not off for 2s], goto ISkeyOff:
    SBRS  B_kyVoff
    RJMP  ISkyVof

ISkyVon:
; if AdjV_In=1 [Vx key is off], goto RSTkVon:
    SBIC  AdjV_In
    RJMP  RSTkVon

; increment DlyKvOn, if DlyKvOn < ADJdely, goto VxKeyEd:
    LDS   r16, DlyKvOn
    INC   r16
    STS   DlyKvOn, r16
    CPI   r16, ADJdely          ; 100 ==> 2 sec
    BRLO  VxKeyEd

; F_keyOff=0 [Vi key was on for >2s]
    CBR   F_kyVoff

; S_GvVxOn=1 [Vx key was on for >2s]
    SBI   S_GvVxOn

    SBR   F_dspOff
    RJMP  VxKeyEd

;===

ISkyVof:
; if AdjV_In=0 [Vx key is on], goto RSTkVof:
    SBIS  AdjV_In
    RJMP  RSTkVof

; increment DlyKvOff, if DlyKvOff < ADJdely, goto VxKeyEd:
    LDS   r16, DlyKvOf
    INC   r16
    STS   DlyKvOf, r16
    CPI   r16, ADJdely       ; 100 ==> 2 sec
    BRLO  VxKeyEd

; F_keyOff=1 [Vi key was off for 2s]
    SBR   F_kyVoff
    RJMP  VxKeyEd

;=== ===

RSTkVof:
; DlyKvOff=0 [reset Vx key off delay]
    STS   DlyKvOf, zero
    RJMP  VxKeyEd

RSTkVon:
; DlyKvOn=0 [reset Vx key on delay]
    STS   DlyKvOn, zero
VxKeyEd:
    RJMP  Vx_end_

;==========================================

;SVx_010:
Cx_key_:
; if B_err_Hz=1, goto CiKeyEd:
    SBRC  B_err_Hz
    RJMP  CiKeyEd

    SBRC  B_noEEst
    RJMP  CiKeyEd

; if S_GvCiOn=1  [gainCinH\L 'setting' busy], goto RSTkCon:
    SBIC  S_GvCiOn
    RJMP  RSTkCon

; if S_GvVxSv=1  [gainVloH\L & gainVhiH\L 'saving' busy], goto RSTkVon:
    SBIC  S_GvVxSv
    RJMP  RSTkVon

; if B_kyCoff=0  [key of setting Ci gain not off for 2s], goto ISkyCof:
    SBRS  B_kyCoff
    RJMP  ISkyCof

ISkyCon:
; if AdjC_In=1 [Ci key is off], goto RSTkCon:
    SBIC  AdjC_In
    RJMP  RSTkCon

; increment DlyKcOn, if DlyKcOn < ADJdely, goto CiKeyEd:
    LDS   r16, DlyKcOn
    INC   r16
    STS   DlyKcOn, r16
    CPI   r16, ADJdely          ; 100 ==> 2 sec
    BRLO  CiKeyEd

; F_kyCoff=0 [Ci key was on for >2s]
    CBR   F_kyCoff

; S_GvCiOn=1 [Ci key was on for >2s]
    SBI   S_GvCiOn

    SBR   F_dspOff
    RJMP  CiKeyEd

;===

ISkyCof:
; if AdjC_In=0 [Ci key is on], goto RSTkCof:
    SBIS  AdjC_In
    RJMP  RSTkCof

; increment DlyKcOf, if DlyKcOf < ADJdely, goto CiKeyEd:
    LDS   r16, DlyKcOf
    INC   r16
    STS   DlyKcOf, r16
    CPI   r16, ADJdely       ; 100 ==> 2 sec
    BRLO  CiKeyEd

; F_kyCoff=1 [Ci key was off for 2s]
    SBR   F_kyVoff
    RJMP  CiKeyEd

;=== ===

RSTkCof:
; DlyKcOf=0 [reset Ci key off delay]
    STS   DlyKvOf, zero
    RJMP  CiKeyEd

RSTkCon:
; DlyKcOn=0 [reset Ci key on delay]
    STS   DlyKcOn, zero
CiKeyEd:
    RJMP  Vx_end_

;==========================================
;==========================================

;SVx_012:
Vlo_set:
;Vi_set_:
/*
;    RCALL SHWdspl

    SBRC  B_noEEst
    RJMP  ViSetEd

; if S_GvViOn=0 [Vi key not on for 4s], goto ViSetEd:
    SBIS  S_GvViOn
    RJMP  ViSetEd

; r1:r0 = VltAdjt * 256 / avgViH\L [call D24u16u:]
    LDI   dd_U, high(VltAdjt)   ; 22010
    LDI   dd_H,  low(VltAdjt)
    CLR   dd_L
    LDS   dv_H, avgViH
    LDS   dv_L, avgViL

; *** Division 24/16, 414 cycles, no rounding ***
; dividend : r18(dd_U), r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r15(res_U),r1(res_H),r0(res_L)
; 414 cycles

    RCALL D24u16u

; if res_U > 0 [overflow], goto FTLerr3: [250ms+250ms, 2 Hz]
    TST   res_U                 ; r15 not r2
    BREQ  ViSetCt

    RJMP  FTLerr3

ViSetCt:
; gainViH\L = r1:r0
    STS   gainViH, r1
    STS   gainViL, r0

; S_GvViSv=1 [to save every gain in EE]
    SBI   S_GvViSv

;; S_GvViSv=1 [to save gainViH\L in EE]
;    SBI   S_GvViSv

.equ ADD_Vih = 0x00              ; EEARL of gainViH , then gainViL
.equ ADD_Voh = 0x04              ; EEARL of gainVoH , then gainVoL
.equ ADDscrn = 0x08              ; EEARL of last steady screen [ScrnMd]

    LDI   r18, ADD_Vih
    STS   EEaddr_L, r18
ViSetEd:
*/
    RJMP  Vx_end_

;==========================================

;SVx_013:
Vhi_set:
;Vo_set_:
/*
;    RCALL SHWdspl

    SBRC  B_noEEst
    RJMP  VoSetEd

; if S_GvViOn=0 [Vi key not on for 4s], goto VoSetEd:
    SBIS  S_GvViOn
    RJMP  VoSetEd

; r1:r0 = VltAdjt * 256 / avgVoH\L [call D24u16u:]
    LDI   dd_U, high(VltAdjt)   ; 22010
    LDI   dd_H,  low(VltAdjt)
    CLR   dd_L
    LDS   dv_H, avgVoH
    LDS   dv_L, avgVoL

; *** Division 24/16, 414 cycles, no rounding ***
; dividend : r18(dd_U), r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r15(res_U),r1(res_H),r0(res_L)
; 414 cycles

    RCALL D24u16u

; if res_U > 0 [overflow], goto FTLerr3: [250ms+250ms, 2 Hz]
    TST   res_U                 ; r15 not r2
    BREQ  VoSetCt

    RJMP  FTLerr3

VoSetCt:
; gainVoH\L = r1:r0
    STS   gainVoH, r1
    STS   gainVoL, r0

;; S_GvVoSv=1 [to save gainVoH\L in EE]
;    SBI   S_GvVoSv

; S_GvViOn=0 [all gains are set]
    CBI   S_GvViOn

VoSetEd:
*/
    RJMP  Vx_end_

;==========================================
;==========================================

;SVx_014:
Cin_set:

;SVx_015:
Vlo_sav:
/*
;    RCALL SHWdspl

    SBRC  B_noEEst
    RJMP  ViSavEd

; if EEWE=1 [EE busy], goto ViSavEd:
    SBIC  EECR, EEWE
    RJMP  ViSavEd

; if S_GvViSv=0 [Vi saving not requested], goto ViSavEd:
    SBIS  S_GvViSv
    RJMP  ViSavEd

;; if S_GvViSv=0 [Vo saving not requested], goto ViSavEd:
;    SBIS  S_GvViSv
;    RJMP  ViSavEd

    LDI   r18, ADD_VxH       ; for EE address 0x01--
    OUT   EEARH, r18

; r16 = EEaddr_L = ADD_Vih
    LDS   r16, EEaddr_L
; if r16 != ADD_Vih, goto ViSavB2: [save low]
    CPI   r16, ADD_Vih
    BRNE  ViSavB2

ViSavB1:
; save r17= gainViH, first pass
; EEaddr_L = r16 + 1 [for the next pass ]
    INC   r16
    STS   EEaddr_L, r16

; restore ADD_Vih
    DEC   r16
; r17 = gainViH
    LDS   r17, gainViH
    RJMP  ViSavCt

ViSavB2:
; save r17= gainViL , second pass
    LDS   r17, gainViL

; prepare for Vo_sav_
    LDI   r18, ADD_Voh
    STS   EEaddr_L, r18

; S_GvViSv=0 [second byte is saved]
    CBI   S_GvViSv
    SBI   S_GvVoSv
ViSavCt:
    RCALL SAVEbyt

ViSavEd:
*/
    RJMP  Vx_end_

;==========================================

;SVx_017:
Vhi_sav:
/*
;    RCALL SHWdspl

    SBRC  B_noEEst
    RJMP  VoSavEd

; if EEWE=1 [EE busy], goto VoSavEd:
    SBIC  EECR, EEWE
    RJMP  VoSavEd

;; if S_GvViSv=0 [Vi saving not requested], goto VoSavEd:
;    SBIS  S_GvViSv
;    RJMP  VoSavEd

; if S_GvVoSv=0 [Vo saving not requested], goto VoSavEd:
    SBIS  S_GvVoSv
    RJMP  VoSavEd

    LDI   r18, ADD_VxH       ; for EE address 0x01--
    OUT   EEARH, r18

; r16 = EEaddr_L = ADD_Voh
    LDS   r16, EEaddr_L
; if r16 != ADD_Voh, goto VoSavB2: [save low]
    CPI   r16, ADD_Voh
    BRNE  VoSavB2

VoSavB1:
; save r17= gainVoH, first pass
; EEaddr_L = r16 + 1 [for the next pass ]
    INC   r16
    STS   EEaddr_L, r16

; restore ADD_Voh
    DEC   r16
; r17 = gainVoH
    LDS   r17, gainVoH
    RJMP  VoSavCt

VoSavB2:
; save r17= gainVoL , second pass
    LDS   r17, gainVoL

; S_GvVoSv=0 [second byte is saved]
    CBI   S_GvVoSv

;; S_GvViSv=0 [second byte is savd]
;    CBI   S_GvViSv

VoSavCt:
    RCALL SAVEbyt

VoSavEd:
*/
    RJMP  Vx_end_

;==========================================

SAVEbyt:
    OUT   EEARL, r16
    OUT   EEDR, r17
    CLI                         ; disable interrupts during timed sequence
    SBI   EECR, EEMWE           ; enable EEPROM write
    SBI   EECR, EEWE            ; start EEPROM write
    SEI                         ; re-enable interrupts
    RET

;==========================================

;SVx_018:
Cin_sav:

;==========================================
;==========================================

;SVx_019:
Vlo2Dgt:
; if B_err_Hz=1, goto VloDgtE:
    SBRC  B_err_Hz
    RJMP  VloDgtE

; if B_endVlo=0 [not end of Vlo average cycles], goto VloDgtE:
    SBRS  B_endVlo
    RJMP  VloDgtE

    LDS   r17, adjVloH
    LDS   r16, adjVloL
; r20:r16 (5 digits) from r17:r16 (16-bit binary)
    RCALL DEC2BCD

; r20:r17 (BCD) to DigtV4:1   [ as 888.8]
    LDI   r16, 4                ; for loop
    LDI   XH, high(17)
    LDI   XL,  low(17)

    LDI   YH, high(DigtV1)
    LDI   YL,  low(DigtV1)      ; destination
VloDgtL:
    LD    r13, X+
    ST    Y+, r13
    DEC   r16
    BRNE  VloDgtL

VloDgtE:
    RJMP  Vx_end_

;==========================================

;SVx_020:
Vhi2Dgt:
; if B_err_Hz=1, goto VhiBcdE:
    SBRC  B_err_Hz
    RJMP  VhiDgtE

; if B_endVhi=0 [not end of Vhi average cycles], goto VhiDgtE:
    SBRS  B_endVhi
    RJMP  VhiDgtE

    LDS   r17, adjVhiH
    LDS   r16, adjVhiL
; r20:r16 (5 digits) from r17:r16 (16-bit binary)
    RCALL DEC2BCD

; r20:r17 (BCD) to DigtV4:1   [ as 888.8]
    LDI   r16, 4                ; for loop
    LDI   XH, high(17)
    LDI   XL,  low(17)

    LDI   YH, high(DigtV1)
    LDI   YL,  low(DigtV1)      ; destination
VhiDgtL:
    LD    r13, X+
    ST    Y+, r13
    DEC   r16
    BRNE  VhiDgtL

VhiDgtE:
    RJMP  Vx_end_

;=================================

;SVx_022:
Cin2Dgt:
; if B_err_Hz=1, goto CinDgtE:
    SBRC  B_err_Hz
    RJMP  CinDgtE

; if B_endCin=0 [not end of Vhi average cycles], goto CinDgtE:
    SBRS  B_endCin
    RJMP  CinDgtE

    LDS   r17, adjCinH
    LDS   r16, adjCinL
; r20:r16 (5 digits) from r17:r16 (16-bit binary)
    RCALL DEC2BCD

; r20:r17 (BCD) to DigtC4:1   [ as 88.88]
    LDI   r16, 4                ; for loop
    LDI   XH, high(17)
    LDI   XL,  low(17)

    LDI   YH, high(DigtC1)
    LDI   YL,  low(DigtC1)      ; destination
CinDgtL:
    LD    r13, X+
    ST    Y+, r13
    DEC   r16
    BRNE  CinDgtL

CinDgtE:
    RJMP  Vx_end_

;=================================
;=================================

;SVx_023:
Vlo2Seg:
; if B_err_Hz=1, goto VloSegE:
    SBRC  B_err_Hz
    RJMP  VloSegE

; if B_endVlo=0 [not end of Vlo average cycles], goto VloSegE:
    SBRS  B_endVlo
    RJMP  VloSegE

; DigtV4:1 (7seg) from DigtV4:1 (BCD)
    LDI   ZH, high(DIGTtbl*2)
    LDI   r18, low(DIGTtbl*2); table must start at 0x---0
    LDI   XH, high(DigtV1)
    LDI   XL,  low(DigtV1)

    LDI   r17, 4             ; 4 digits for voltage
VloSegL:
    LD    ZL, X              ; Digit# as hex
    ANDI  ZL, 0x0F
    OR    ZL, r18            ; add table offset
    LPM   r16, Z             ; load Indirect as 7seg from table
    ST    X+, r16            ; re-save as 7seg
    DEC   r17
    BRNE  VloSegL

    LDS   r16, DigtV2
    SBR   r16, Seg_dot
    STS   DigtV2, r16

    CBR   F_endVlo
VloSegE:
    RJMP  Vx_end_

;=================================

;SVx_024:
Vhi2Seg:
; if B_err_Hz=1, goto VhiSegE:
    SBRC  B_err_Hz
    RJMP  VhiSegE

; if B_endVhi=0 [not end of Vhi average cycles], goto VhiSegE:
    SBRS  B_endVhi
    RJMP  VhiSegE

; DigtV4:1 (7seg) from DigtV4:1 (BCD)
    LDI   ZH, high(DIGTtbl*2)
    LDI   r18, low(DIGTtbl*2); table must start at 0x---0
    LDI   XH, high(DigtV1)
    LDI   XL,  low(DigtV1)

    LDI   r17, 4             ; 4 digits for voltage
VhiSegL:
    LD    ZL, X              ; Digit# as hex
    ANDI  ZL, 0x0F
    OR    ZL, r18            ; add table offset
    LPM   r16, Z             ; load Indirect as 7seg from table
    ST    X+, r16            ; re-save as 7seg
    DEC   r17
    BRNE  VhiSegL

    LDS   r16, DigtV2
    SBR   r16, Seg_dot
    STS   DigtV2, r16

    CBR   F_endVhi
VhiSegE:
    RJMP  Vx_end_

;=================================

;SVx_025:
Cin2Seg:
; if B_err_Hz=1, goto CinSegE:
    SBRC  B_err_Hz
    RJMP  CinSegE

; if B_endCin=0 [not end of Cin average cycles], goto CinSegE:
    SBRS  B_endCin
    RJMP  CinSegE

; DigtC4:1 (7seg) from DigtC4:1 (BCD)
    LDI   ZH, high(DIGTtbl*2)
    LDI   r18, low(DIGTtbl*2); table must start at 0x---0
    LDI   XH, high(DigtC1)
    LDI   XL,  low(DigtC1)

    LDI   r17, 4             ; 4 digits for current
CinSegL:
    LD    ZL, X              ; Digit# as hex
    ANDI  ZL, 0x0F
    OR    ZL, r18            ; add table offset
    LPM   r16, Z             ; load Indirect as 7seg from table
    ST    X+, r16            ; re-save as 7seg
    DEC   r17
    BRNE  CinSegL

    LDS   r16, DigtC3
    SBR   r16, Seg_dot
    STS   DigtC3, r16

    CBR   F_endCin
CinSegE:
    RJMP  Vx_end_

;=================================
;=================================

;SMPL027:
KEYscrn:
; if Scrn_In=low [shorted], goto KEYscrE: [do nothing]
    SBIS  Scrn_In
    RJMP  KEY_C_R

KEY_P_V:
    LDS   r16, ScrDly
    DEC   r16
    STS   ScrDly, r16
    BRNE  KEYscrE

    LDI   r16, SCRdlyK       ; init screen delay
    STS   ScrDly, r16

    SBRC  B_dspPwr
    RJMP  DOdsp_V

DOdsp_P:
    SBR  F_dspPwr
    CBR  F_dspVlt
    RJMP KEYscrE

DOdsp_V:
    CBR  F_dspPwr
    SBR  F_dspVlt
    RJMP KEYscrE

;===

KEY_C_R:
    LDS   r16, ScrDly
    DEC   r16
    STS   ScrDly, r16
    BRNE  KEYscrE

    LDI   r16, SCRdlyK       ; init screen delay
    STS   ScrDly, r16

    SBRC  B_dspCin
    RJMP  DOdsp_R

DOdsp_C:
    SBR  F_dspCin
    CBR  F_dspRes
    RJMP KEYscrE

DOdsp_R:
    CBR  F_dspCin
    SBR  F_dspRes

KEYscrE:
    RJMP  Vx_end_

;==========================================
;==========================================

SETdgts:
    SBRS  B_dsplHz
    RJMP  ISdsplV

    LDS   r16, DigtH1
    STS   Digt_1, r16
    LDS   r16, DigtH2
    STS   Digt_2, r16
    LDS   r16, DigtH3
    STS   Digt_3, r16
    LDS   r16, DigtH4
    STS   Digt_4, r16
    RJMP  SETdgtR

ISdsplV:
    SBRS  B_dspVlt
    RJMP  ISdsplC

    LDS   r16, DigtV1
    STS   Digt_1, r16
    LDS   r16, DigtV2
    STS   Digt_2, r16
    LDS   r16, DigtV3
    STS   Digt_3, r16
    LDS   r16, DigtV4
    STS   Digt_4, r16
    RJMP  SETdgtR

ISdsplC:
    SBRS  B_dspCin
    RJMP  ISdsplP

    LDS   r16, DigtC1
    STS   Digt_1, r16
    LDS   r16, DigtC2
    STS   Digt_2, r16
    LDS   r16, DigtC3
    STS   Digt_3, r16
    LDS   r16, DigtC4
    STS   Digt_4, r16
    RJMP  SETdgtR

ISdsplP:
    SBRS  B_dspPwr
    RJMP  ISdsplR

    LDS   r16, DigtP1
    STS   Digt_1, r16
    LDS   r16, DigtP2
    STS   Digt_2, r16
    LDS   r16, DigtP3
    STS   Digt_3, r16
    LDS   r16, DigtP4
    STS   Digt_4, r16
    RJMP  SETdgtR

ISdsplR:
    SBRS  B_dspRes
    RJMP  FTLerr0               ; no display mode specified

    LDS   r16, DigtR1
    STS   Digt_1, r16
    LDS   r16, DigtR2
    STS   Digt_2, r16
    LDS   r16, DigtR3
    STS   Digt_3, r16
    LDS   r16, DigtR4
    STS   Digt_4, r16

SETdgtR:
    RET

;----------------------------------------------------------------
; *F/R* Show Display for battery volt, user Vhi, error or PWM ***
;----------------------------------------------------------------

;SMPLxxx: every 5 samples
SHWdspl:
    INC   digtN                 ; r8=0,1,2,3 ==> d1,d2,d3,d4
    MOV   r16, digtN            ; rate = 8*2[smpls]*104us = 1.664ms, 150Hz
    CPI   r16, 0x04
    BRNE  SHWdSkp

    RCALL SETdgts
    CLR   r16                   ; as a counter from 0 to 2 only
    CLR   digtN

SHWdSkp:
    TST   r16
    BRNE  SHWdgt2

SHWdgt1:
    LDI   r17, DIGIT1on
    LDS   r13, Digt_1

    RJMP  SHWdEnd

SHWdgt2:
    DEC   r16
    BRNE  SHWdgt3

    LDI   r17, DIGIT2on
    LDS   r13, Digt_2

    RJMP  SHWdEnd

SHWdgt3:
    DEC   r16
    BRNE  SHWdgt4

    LDI   r17, DIGIT3on
    LDS   r13, Digt_3

    RJMP  SHWdEnd

SHWdgt4:
    LDI   r17, DIGIT4on
    LDS   r13, Digt_4

SHWdEnd:

;===

ISonOff:
;    SBRS  B_ftlErr
    SBRS  B_shwErr
    RJMP  DSPLoff

/* <no comment if Simu_1>
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
*/ ; <no comment if Simu_1>

    DEC   dspOff
    BRNE  DSPLoff_

    LDI   r16, X_dspOff
    EOR   R1flags, r16          ; flip F_dspOff

DSPLoff_:
    SBRS  B_dspOff
    RJMP  DSPL_on

    CLR   r13
    RJMP  DSPL_on

DSPLoff:

;===

    SBRS  B_dspOff
    RJMP  DSPL_on

    CLR   r13

/* <no comment if Simu_1>
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
*/ ; <no comment if Simu_1>

    DEC   dspOff
    BRNE  DSPL_on

    CBR   F_dspOff              ; dspOff=0, offtime=256/16*104us=426ms

DSPL_on:
    IN    r16, DDRB             ; was PORTB
    ANDI  r16, DIGITSof         ; turn off all digit
    OUT   DDRB, r16             ; was PORTB
    NOP
    OUT   DDRD, r13             ; set 7-seg outs, was PORTD
    OR    r16, r17              ; r16=0b11100011, r17=0b00000100
    OUT   DDRB, r16             ; turn on digit, was PORTB

    SBRS  B_shwInf
    RJMP  Vx_end_
;    RJMP  END_act

    RET

;==========================================
;==========================================
;==========================================

Vx_end_:
; increment curSplVx
    LDS   r16, curSplVx
    INC   r16
    STS   curSplVx, r16

;    LDI   r17, (1<<ICF1)
    LDI   r17, 0xFF
; if curSplVx=0 [curSplVx=256], goto CHKhzNo:
    BREQ  CHKhzNo

; call Vx_sum1 [sum1VxU\H\L = sum1VxU\H\L + ADCrd_H\L]
    RCALL Vx_sum1

;==========================================

CHCK_Hz:
    SBIS  Hz_In
    RJMP  END_act

    NOP
    NOP
    NOP
    NOP
    NOP
    NOP

; if ICF1=0, goto END_act:
    IN    r17, TIFR
    SBRS  r17, ICF1
    RJMP  END_act

    NOP

CHKhzNo:
; reset ICP1 interrupt flag
    OUT   TIFR, r17
;    OUT   TIFR, zero


; if (r16=curSplVx) > MIN_smpl [148, F < 64.9 Hz], goto CHK_HzC:
    LDS   r16, curSplVx
    CPI   r16, MIN_smpl
    BRSH  CHK_HzC

HZerror:
; F_err_Hz=1 [signal Hz error]
    SBR   F_err_Hz

    RCALL VxReset

; decrement errHzDly (init as 10), if 0 , goto RESET:
    LDS   r16, errHzDly
    DEC   r16
    STS   errHzDly, r16
    BRNE  CHK_HzE

    RJMP  RESET                 ; mains Hz error, no voltage

CHK_HzC:
; if (r16=curSplVx) > MAX_smpl [240, F < 40.0 Hz], goto HZerror:
    CPI   r16, MAX_smpl
    BRSH  HZerror

HZ_okay:
; lstSplVx=curSplVx [save last count of samples of the cycle]
    STS   lstSplVx, r16

; F_err_Hz=0 [signal Hz is normal]
    CBR   F_err_Hz

; errHzDly=HZerrDly=10 [reset Hz error counter]
    LDI   r16, HZerrDly
    STS   errHzDly, r16

;====

CHK_HzE:
; clear counter of Vi samples
    CLR   r16
    STS   curSplVx, r16

;===

; prepare for ADMUX
    LDS   r16, ADCport
    CPI   r16, RD_Cin
    BREQ  DOrd_Vx

DOrdCin:
    CBR   F_wasCin
    LDI   r16, RD_Cin
    RJMP  CHKskip

DOrd_Vx:
    SBR   F_wasCin
    LDI   r16, RD_Vlo
    SBRC  B_rd_Vhi
    LDI   r16, RD_Vhi

CHKskip:
    STS   ADCport, r16

    IN    r17, ADMUX
    ANDI  r17, 0xF0
    OR    r17, r16
; ADMUX [L_2V56+ADCx, 2V56, right adjusted, ADCport]
    OUT   ADMUX, r17

; goto END_act:
    RJMP  END_act

;==========================================
;==========================================
;==========================================

Vx_sum1:
    LDS   r16, sum1VxL
    ADD   r16, ADCrd_L
    STS   sum1VxL, r16

    LDS   r16, sum1VxH
    ADC   r16, ADCrd_H
    STS   sum1VxH, r16

    LDS   r16, sum1VxU
    CLR   r17
    ADC   r16, r17
    STS   sum1VxU, r16

    RET

;=============

VxReset:
; VxCyclC=CYCLnmbr [reset counter of Vi average cycles]
    LDI   r16, CYCLnmbr
    MOV   VxCyclC, r16

; curSplVx=sum1VxU\H\L=sum2ViH\L=sum2VoH\L=sum2CinH\L=0
    STS   curSplVx, zero

    STS   sum1VxL, zero
    STS   sum1VxH, zero
    STS   sum1VxU, zero

    STS   sum2VloL, zero
    STS   sum2VloH, zero

    STS   sum2VhiL, zero
    STS   sum2VhiH, zero

    STS   sum2CinL, zero
    STS   sum2CinH, zero

    LDI   r16, ADCloV
    LDI   r17, RD_Vlo
    SBRS  B_rd_Vhi
    RJMP  VxRst_E

    LDI   r16, ADChiV
    LDI   r17, RD_Vhi
VxRst_E:
    OUT   ADMUX, r16
    STS   ADCport, r16

    RET

;==========================================
;==========================================

;-------------------------------------------------
; *R* EE initialization for nominal gainVx_H\L ***
;-------------------------------------------------
; if fresh
; gainVloH\L = Vlo2bcd [ 7112,0x1BC8] at ADDloVh [0x0010]
; gainVhiH\L = Vhi2bcd [12483,0x30C3] at ADDhiVh [0x0014]
; gainCinH\L = Cin2bcd [ 9910,0x26B6] at ADDinCh [0x0018]

EE_init:
    RCALL EE_wait               ; just in case

    OUT   EEARH, zero           ; always 0 , EEARH\L < 256

    LDI   r16, 15
    OUT   EEARL, r16            ; check 0x000F instead of 0x0000

    SBI   EECR, EERE
    IN    r17, EEDR
    CPI   r17, 0xFF
    BRNE  EEiniRt

    LDI   ZH, high(SIGNAT2*2)
    LDI   ZL,  low(SIGNAT2*2)

    LDI   r19, 16               ; to save 16 characters
    CLR   r16

SIGN_lp:
    OUT   EEARL, r16            ; start at 0x0000
    LPM   r17, Z+               ; load Indirect
    RCALL SV_byte

    INC   r16
    DEC   r19
    BRNE  SIGN_lp

EiniVlo:
    LDI   r18, ADDloVh          ; address of gainVloH\L at 0x010\0011
    OUT   EEARL, r18

    LDI   r17, high(Vlo2bcd)    ; save nominal gainVloH\L=7112=0x1BC8
    RCALL SV_byte               ; save high , 0x1B

    INC   r18
    OUT   EEARL, r18
    LDI   r17,  low(Vlo2bcd)
    RCALL SV_byte               ; save  low , 0xC8

;===

    LDI   r18, ADDhiVh          ; address of gainVloH\L at 0x014\0015
    OUT   EEARL, r18

    LDI   r17, high(Vhi2bcd)    ; save nominal gainVhiH\L=12483=0x30C3
    RCALL SV_byte               ; save high , 0x30

    INC   r18
    OUT   EEARL, r18
    LDI   r17,  low(Vhi2bcd)
    RCALL SV_byte               ; save  low , 0xC3

;===

    LDI   r18, ADDinCh          ; address of gainCinH\L at 0x018\0019
    OUT   EEARL, r18

    LDI   r17, high(Cin2bcd)    ; save nominal gainCinH\L=9910=0x26B6
    RCALL SV_byte               ; save high , 0x26

    INC   r18
    OUT   EEARL, r18
    LDI   r17,  low(Cin2bcd)

SV_byte:
    OUT   EEDR, r17
    CLI                         ; disable interrupts during timed sequence
    SBI   EECR, EEMWE           ; enable EEPROM write
    SBI   EECR, EEWE            ; start EEPROM write
    SEI                         ; re-enable interrupts
EE_wait:
    SBIC  EECR, EEWE            ; wait to end previous saving
    RJMP  EE_wait

EEiniRt:
    RET

;-----------------------------------------------------
; *R* load   low voltage gain, gainVloH\L, from EE ***
;     load  high voltage gain, gainVhiH\L, from EE ***
;     load input current gain, gainVhiH\L, from EE ***
;-----------------------------------------------------

READall:
    RCALL EE_wait               ; redundant

    OUT   EEARH, zero

READloV:
    LDI   r18, ADDloVh
    RCALL READ_Vx
    STS   gainVloH, r17
    STS   gainVloL, r16

READhiV:
    LDI   r18, ADDhiVh
    RCALL READ_Vx
    STS   gainVhiH, r17
    STS   gainVhiL, r16

READinC:
    LDI   r18, ADDinCh
    RCALL READ_Vx
    STS   gainCinH, r17
    STS   gainCinL, r16

    RET

READ_Vx:
    OUT   EEARL, r18         ; address of gainVx_H
    SBI   EECR, EERE
    IN    r17, EEDR
    INC   r18
RDbyte:
    OUT   EEARL, r18         ; address of gainVx_L
    SBI   EECR, EERE
    IN    r16, EEDR
    RET

;==========================================
;==========================================

END_act:
; SLIDEtime=0 [PB7, pin10, was for small relay ]
;    CBI   SLIDEtime

; goto MAIN_lp
    RJMP  MAIN_lp

;==========================================
;==========================================
;==========================================

;============================================
; Division 24/16, 414 cycles, no rounding ***
;============================================
; dividend : r18(dd_U), r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
; result   : r15(res_U),r1(res_H),r0(res_L)
;; result   : r2(res_U),r1(res_H),r0(res_L)
; 414 cycles

D24u16u:
    CLR   rmd_L
    SUB   rmd_H, rmd_H            ; to clear carry
    LDI   steps, 25
    RJMP  D24u16u1

D24u16u2:
    ROL   rmd_L
    ROL   rmd_H
    SUB   rmd_L, dv_L
    SBC   rmd_H, dv_H
    BRCC  D24u16u3

    ROL   res_L
    ROL   res_H
    ROL   res_U
    ADD   rmd_L, dv_L
    ADC   rmd_H, dv_H
D24u16u1:
    ROL   dd_L
    ROL   dd_H
    ROL   dd_U
    DEC   steps
    BRNE  D24u16u2

    COM   res_L
    COM   res_H
    COM   res_U
    RET

D24u16u3:
    ROL   res_L
    ROL   res_H
    ROL   res_U
    RJMP  D24u16u1

;==========================================
;==========================================

; 4:11 PM 8/12/2017
;=================================================
; Division 16/16, 280 cycles, rounding res_H\L ***
;=================================================
; dividend : r17(dd_H) , r16(dd_L)
; divisor  : r20(dv_H) , r19(dv_L)
;; divisor  : r19(dv_H) , r18(dv_L)
; remainder: r14(rmd_H), r13(rmd_L)
; loopCount: r21(steps)
;; loopCount: r20(steps)
; result   : r1:r0, 280 cycles

; res_H\L = dd_H\L / dv_H/L , rmd_H\L remainder
; if division 16/8, r19=0

D16u16rd:
    CLR   rmd_L
    SUB   rmd_H, rmd_H            ; to clear carry
    LDI   steps, 17
    RJMP  D16u16u1

D16u16u2:
    ROL   rmd_L
    ROL   rmd_H
    SUB   rmd_L, dv_L
    SBC   rmd_H, dv_H
    BRCC  D16u16u3

    ROL   res_L
    ROL   res_H
    ADD   rmd_L, dv_L
    ADC   rmd_H, dv_H
D16u16u1:
    ROL   dd_L
    ROL   dd_H
    DEC   steps
    BRNE  D16u16u2

    COM   res_L
    COM   res_H

    CLC
    ROR   dv_H                  ; carry=0
    ROR   dv_L
    CP    dv_L, rmd_L
    CPC   dv_H, rmd_H
    BRSH  D16u16uR              ; if divisor/2 > remainder, skip rounding

    INC   res_L                 ; add 1 to resultL
    BRNE  D16u16uR              ; if resultL becomes 0, resultH+1

    INC   res_H
    BRNE  D16u16uR              ; if resultH not zero, skip

    DEC   res_H
    DEC   res_L
D16u16uR:
    RET

D16u16u3:
    ROL   res_L
    ROL   res_H
    RJMP  D16u16u1

;==========================================

; [ 16x16 Bit Unsigned Multiplication ]
; multiplicand: r17:r16
; multiplier  : r14:r13
; result out  : r21:r20:r19:r18
; see mul16x16_32_AL.txt
; 24 cycles + 2
SQ16x16:
    MOV   r14, r17              ; copy for squaring
    MOV   r13, r16
M_16x16:
    MUL   r17, r14              ; ah * bh
    MOVW  r21:r20, r1:r0
    MUL   r16, r13              ; al * bl
    MOVW  r19:r18, r1:r0
    MUL   r17, r13              ; ah * bl
    ADD   r19, r0
    ADC   r20, r1
    ADC   r21, zero
    MUL   r14, r16              ; bh * al
    ADD   r19, r0
    ADC   r20, r1
    ADC   r21, zero
    RET

;==========================================

;input: R17, R16 = 16 bit value 0 ... 65535
;output: R20, R19, R18, R17, R16 = 5 digits (ASCII)
;cycle: 20 ... 170

BIN2BCD:
    MOV   r17, r1
    MOV   r16, r0
DEC2BCD:
_bcd0:
    LDI   r20, -1
_bcd1:
    INC   r20
    SUBI  r16, low(10000)       ;-10000
    SBCI  r17, high(10000)
    BRCC  _bcd1

    LDI   r19, 10
_bcd2:
    DEC   r19
    SUBI  r16, low(-1000)       ;+1000
    SBCI  r17, high(-1000)
    BRCS  _bcd2

    LDI   r18, -1
_bcd3:
    INC   r18
    SUBI  r16, low(100)         ;-100
    SBCI  r17, high(100)
    BRCC  _bcd3

    LDI   r17, 10
_bcd4:
    DEC   r17
    SUBI  r16, -10              ;+10
    BRCS  _bcd4

    RET

;==============================
; *** check mains frequency ***  8 MHz
;==============================
;   MIDboot = 0 = on ,   MIDboot = 1 = off

INI_Hz_:
    SER   loopHi

INIwait:
    INC   loopHi

; dimming minus seg of digit1 if no mains
    SBI   MIDboot               ; Mid, segment G at digit 1 is off
    CPI   loopHi, 25
    BRSH  INIwtC1

    CBI   MIDboot               ; Mid, segment G at digit 1 is on
INIwtC1:
    SBIS  Hz_In
    RJMP  INIwait

;===

INIstrt:
    CLR   XL
    CLR   XH

.equ Addhz=2
INI_lp1:
    SBIS  Hz_In
    RJMP  INI_lp2

    ADIW  XL, Addhz
    CBI   MIDboot
    BRCS  DO_hzLo

    RJMP  INI_lp1   

INI_lp2:
    SBIC  Hz_In
    RJMP  INI_end

    ADIW  XL, Addhz
    SBI   MIDboot
    BRCS  DO_hzLo

    RJMP  INI_lp2   

INI_end:
    NOP

; 40 Hz 0xc34e 44442
; 66 Hz 0x765c 26934
.equ Hz_Lo=44442
.equ Hz_Hi=26934

IS_hzLo:
    LDI   r16,  low(Hz_Lo)
    LDI   r17, high(Hz_Lo)
    CP    XL, r16
    CPC   XH, r17
    BRLO  IS_hzHi

DO_hzLo:
    RJMP  DO_hzHi

IS_hzHi:
    LDI   r16,  low(Hz_Hi)
    LDI   r17, high(Hz_Hi)
    CP    XL, r16
    CPC   XH, r17
    BRSH  INI_HzE

DO_hzHi:
    SBR   F_shwErr              ; for on-off & to enable RET of STOPpwm

INI_HzE:
    RET

;================================
; *** display mains frequency ***  8 MHz
;================================

DSPL_hz:
.equ K_hz=177768000
; Hz = K_hz / XH:XL
; example Xh:XL=44442 [40 Hz], Hz = K_hz/44442 = 4000 [40.00]

    LDI   r16,   low(K_hz)
    LDI   r17,  high(K_hz)
    LDI   r18, byte3(K_hz)
    LDI   r19, byte4(K_hz)

    CLR   YL
    CLR   YH

D32_16L:
    SUB   r16, XL
    SBC   r17, XH
    SBC   r18, zero
    SBC   r19, zero
    BREQ  D32_16D

    BRCS  D32_16C

    ADIW  YL, 1
    RJMP  D32_16L

D32_16C:
    ADIW  YL, 1
D32_16D:    
    MOV   r16, YL
    MOV   r17, YH
; r20:r16 (5 digits) from r17:r16 (16-bit binary)   [ rcall DEC2BCD ]
    RCALL DEC2BCD

; r19:r16 (BCD) to DigtV2:0   [ as 000]
    LDI   r20, 4                ; for loop
    LDI   XH, high(16)
    LDI   XL,  low(16)          ; source

    LDI   YH, high(DigtH1)
    LDI   YL,  low(DigtH1)      ; destination
Hz2DgtL:
    LD    r13, X+
    ST    Y+, r13
    DEC   r20
    BRNE  Hz2DgtL

; DigtH4:1 (7seg) from DigtH4:1 (BCD) [table DIGTtbl]
    LDI   ZH, high(DIGTtbl*2)
    LDI   r18, low(DIGTtbl*2); table must start at 0x---0
    LDI   XH, high(DigtH1)
    LDI   XL,  low(DigtH1)

    LDI   r17, 4             ; 4 digits for Hz
Hz2SegL:
    LD    ZL, X              ; Digit# as hex
    ANDI  ZL, 0x0F
    OR    ZL, r18            ; add table offset
    LPM   r16, Z             ; load Indirect as 7seg from table
    ST    X+, r16            ; re-save as 7seg
    DEC   r17
    BRNE  Hz2SegL

    LDS   r16, DigtH3
    SBR   r16, Seg_dot
    STS   DigtH3, r16

    SBR   F_dsplHz
    CLR   XL
    CLR   XH

HZdsplL:
    LDI   r17, 2
    RCALL DLYmSec

    SBR   F_shwInf
    RCALL SHWdspl
    CBR   F_shwInf

    ADIW  XL, 1
    LDI   r16,  low(SHWhz)       ; show Hz for 2 sec
    LDI   r17, high(SHWhz)
    CP    XL, r16
    CPC   XH, r17
    BRLO  HZdsplL

    SBRC  B_shwErr
    RJMP  RESET

    RET

;=============================
; *** signal fatal errors ***
;=============================

FTL_err:
    STS   DigtE1, r16

;FTLerrC:
;    RCALL STOPpwm
    SBR   F_shwErr              ; for on-off & to enable RET of STOPpwm

    LDI   r16, SEGS__E
    STS   DigtE4, r16

    LDI   r16, SEGS_r_
    STS   DigtE3, r16
    STS   DigtE2, r16


;    SBR   F_shwLmt              ; to enable RET of SHWdspl:
;    SBR   F_shwerr              ; to enable RET of SHWdspl:
;    SBR   F_vltMod
;    CBR   F_usrVhi
;    CBR   F_usrEnd
;    CBR   F_pwmMod

FTLloop:
    LDI   r17, 2
    RCALL DLYmSec

    RCALL SHWdspl

    SBIS  Strt_In
    RJMP  RESET                 ; reboot if user key pressed

    RJMP  FTLloop

;===

; [Err0] ==> no display mode specified
FTLerr0:
    LDI   r16, SEGS_0_
    RJMP  FTL_err

; [Err1] ==> sum1Vx/lstSplVx > 65535 [overflow]
FTLerr1:
    LDI   r16, SEGS_1_
    RJMP  FTL_err

; [Err2] ==>
FTLerr2:
    LDI   r16, SEGS_2_
    RJMP  FTL_err

; [Err3] ==>
FTLerr3:
    LDI   r16, SEGS_3_
    RJMP  FTL_err

;========================
; *** reset all ports ***
;========================
RSTprts:
; DDRB=DDRBini0
    LDI   r16, DDRBini0
    OUT   DDRB, r16
; PORTB=PRTBini0
    LDI   r16, PRTBini0
    OUT   PORTB, r16

; DDRC=DDRCini0
    LDI   r16, DDRCini0
    OUT   DDRC, r16
; PORTC=PRTCini0
    LDI   r16, PRTCini0
    OUT   PORTC, r16

; DDRD=DDRDini0
    LDI   r16, DDRDini0
    OUT   DDRD, r16
; PORTD=PRTDini0
    LDI   r16, PRTDini0
    OUT   PORTD, r16

    RET

;----------------------------------
;----------------------------------
; *R* Delay, multiple of 1 msec *** 8 MHz
;----------------------------------
;----------------------------------
; r17 = t (ms)
; used and then restored: r16 and r17
; delay= [ (28+3)*256 + (4+3*20) ] * 250 * 0.125 = 250 ms

DLYqSec:                        ;+2c call
    PUSH   r17                  ; 2c, added
    LDI    r17, simuDly         ; 1c, was 250
    RJMP   DLYsecC              ; 2c, added

DLYmSec:
    PUSH   r17               ; 2c, added
DLYsecC:
    PUSH   r16                  ; 2c, added
DLYsecL:
    CLR    r16                  ; 1c
DlyM_lp:
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    DEC   r16                   ; 1c
    BRNE  DlyM_lp               ; 2/1c

    LDI   r16, 20               ; 1c
    NOP                         ; 1c, added for timing
INNERlp:
    DEC   r16                   ; 1c
    BRNE  INNERlp               ; 2/1c

    DEC   r17                ; 1c
    BRNE  DLYsecL               ; 2/1c

    POP   r16                   ; 2c, added
    POP   r17                ; 2c, added
    RET                         ; 2c

;====================================================================
;====================================================================
;====================================================================

;---------------
; *** Tables ***
;---------------

    .org 0x0E00

; D:\L500\Koko_all\Work\projects\Utility\ASM-7Seg_dspl.xlsx
; sheet "Ampere_03" for extended symbols, PCB: A29
DIGTtbl:                      ;       N/Y          N/Y
;        bfaedpcg
   .db 0b11111010, 0b10000010 ; 0, 0xFA/FE ; 1, 0x82/86
   .db 0b10111001, 0b10101011 ; 2, 0xB9/BD ; 3, 0xAB/AF
   .db 0b11000011, 0b01101011 ; 4, 0xC3/C7 ; 5, 0x6B/6F
   .db 0b01111011, 0b10100010 ; 6, 0x7B/7F ; 7, 0xA2/A6
   .db 0b11111011, 0b11101011 ; 8, 0xFB/FF ; 9, 0xEB/EF

; D:\L500\Koko_all\Work\projects\Utility\ASM-7Seg_dspl.xlsx
; sheet "symb_Ampere_03" for extended symbols, PCB: A29
Symbols:
;                bfaedpcg
.equ SEGS_0_ = 0b11111010 ; 0xFA
.equ SEGS_1_ = 0b10000010 ; 0x82
.equ SEGS_2_ = 0b10111001 ; 0xB9
.equ SEGS_3_ = 0b10101011 ; 0xAB
.equ SEGS_4_ = 0b11000011 ; 0xC3
.equ SEGS_5_ = 0b01101011 ; 0x6B
.equ SEGS_6_ = 0b01111011 ; 0x7B
.equ SEGS_7_ = 0b10100010 ; 0xA2
.equ SEGS_8_ = 0b11111011 ; 0xFB
.equ SEGS_9_ = 0b11101011 ; 0xEB
.equ SEGSblk = 0b00000000 ; 0x00
.equ SEGS_lo = 0b00001000 ; 0x08
.equ SEGS_md = 0b00000001 ; 0x01
.equ SEGS_hi = 0b00100000 ; 0x20
.equ SEGS__L = 0b01011000 ; 0x58
.equ SEGS__H = 0b11010011 ; 0xD3
.equ SEGS__E = 0b01111001 ; 0x79
.equ SEGS_r_ = 0b00010001 ; 0x11
.equ SEGS_u_ = 0b00011010 ; 0x1A
.equ SEGS_t_ = 0b01011001 ; 0x59
.equ SEGS_o_ = 0b00011011 ; 0x1B
.equ SEGS__C = 0b01111000 ; 0x78
.equ SEGS_c_ = 0b00011001 ; 0x19
.equ SEGS_d_ = 0b10011011 ; 0x9B
.equ SEGS__U = 0b11011010 ; 0xDA
.equ SEGS__A = 0b11110011 ; 0xF3
.equ SEGS_n_ = 0b00010011 ; 0x13
.equ SEGS__F = 0b01110001 ; 0x71
.equ SEGS__P = 0b11110001 ; 0xF1
.equ SEGS_3L = 0b00101001 ; 0x29
.equ SEGS_h_ = 0b01010011 ; 0x53
.equ SEGS_b_ = 0b01011011 ; 0x5B

.equ SGminus = 0b00000001 ; 0x01

;-----------------------
; *** Indirect jumps ***
;-----------------------

    .org 0x0F00

SVx_000: RJMP  SHWdspl ;

SVx_001: RJMP  Vx_new_ ; average of Vlo|Vhi & Cin [in one cycle]
SVx_002: RJMP  Vlo_avg ; average Vin low or high in interval
SVx_003: RJMP  Vhi_avg ; average Vin high in interval
SVx_004: RJMP  Cin_avg ; average Cin      in interval
SVx_005: RJMP  Vlo_bcd ; binary-bcd of interval Vin low

SVx_006: RJMP  SHWdspl ;

SVx_007: RJMP  Vhi_bcd ; binary-bcd of interval Vin high
SVx_008: RJMP  Cin_bcd ; binary-bcd of interval Cin
SVx_009: RJMP  Vx_key_ ; sense Vx key for Vlo & Vhi
SVx_010: RJMP  Cx_key_ ; sense Cx key for Cin

SVx_011: RJMP  SHWdspl ;

SVx_012: RJMP  Vlo_set ; set new Vin low  gain
SVx_013: RJMP  Vhi_set ; set new Vin high gain
SVx_014: RJMP  Cin_set ; set new Cin
SVx_015: RJMP  Vlo_sav ; save new Vin low gain on EE

SVx_016: RJMP  SHWdspl ;

SVx_017: RJMP  Vhi_sav ; save new Vin high gain on EE
SVx_018: RJMP  Cin_sav ; save new Cin      gain on EE
SVx_019: RJMP  Vlo2Dgt ;
SVx_020: RJMP  Vhi2Dgt ;

SVx_021: RJMP  SHWdspl ;

SVx_022: RJMP  Cin2Dgt ;
SVx_023: RJMP  Vlo2Seg ;
SVx_024: RJMP  Vhi2Seg ;
SVx_025: RJMP  Cin2Seg ;

SVx_026: RJMP  SHWdspl ;

SVx_027: RJMP  KEYscrn ;
SVx_028: RJMP  Vx_end_ ;
SVx_029: RJMP  Vx_end_ ;
SVx_030: RJMP  Vx_end_ ;

SVx_031: RJMP  SHWdspl ;

SVx_032: RJMP  Vx_end_ ;
SVx_033: RJMP  Vx_end_ ;
SVx_034: RJMP  Vx_end_ ;
SVx_035: RJMP  Vx_end_ ;

SVx_036: RJMP  SHWdspl ;

SVx_037: RJMP  Vx_end_ ;
SVx_038: RJMP  Vx_end_ ;
SVx_039: RJMP  Vx_end_ ;
SVx_040: RJMP  Vx_end_ ;

SVx_041: RJMP  SHWdspl ;

SVx_042: RJMP  Vx_end_ ;
SVx_043: RJMP  Vx_end_ ;
SVx_044: RJMP  Vx_end_ ;
SVx_045: RJMP  Vx_end_ ;

SVx_046: RJMP  SHWdspl ;

SVx_047: RJMP  Vx_end_ ;
SVx_048: RJMP  Vx_end_ ;
SVx_049: RJMP  Vx_end_ ;
SVx_050: RJMP  Vx_end_ ;

SVx_051: RJMP  SHWdspl ;

SVx_052: RJMP  Vx_end_ ;
SVx_053: RJMP  Vx_end_ ;
SVx_054: RJMP  Vx_end_ ;
SVx_055: RJMP  Vx_end_ ;

SVx_056: RJMP  SHWdspl ;

SVx_057: RJMP  Vx_end_ ;
SVx_058: RJMP  Vx_end_ ;
SVx_059: RJMP  Vx_end_ ;
SVx_060: RJMP  Vx_end_ ;

SVx_061: RJMP  SHWdspl ;

SVx_062: RJMP  Vx_end_ ;
SVx_063: RJMP  Vx_end_ ;
SVx_064: RJMP  Vx_end_ ;
SVx_065: RJMP  Vx_end_ ;

SVx_066: RJMP  SHWdspl ;

SVx_067: RJMP  Vx_end_ ;
SVx_068: RJMP  Vx_end_ ;
SVx_069: RJMP  Vx_end_ ;
SVx_070: RJMP  Vx_end_ ;

SVx_071: RJMP  SHWdspl ;

SVx_072: RJMP  Vx_end_ ;
SVx_073: RJMP  Vx_end_ ;
SVx_074: RJMP  Vx_end_ ;
SVx_075: RJMP  Vx_end_ ;

SVx_076: RJMP  SHWdspl ;

SVx_077: RJMP  Vx_end_ ;
SVx_078: RJMP  Vx_end_ ;
SVx_079: RJMP  Vx_end_ ;
SVx_080: RJMP  Vx_end_ ;

SVx_081: RJMP  SHWdspl ;

SVx_082: RJMP  Vx_end_ ;
SVx_083: RJMP  Vx_end_ ;
SVx_084: RJMP  Vx_end_ ;
SVx_085: RJMP  Vx_end_ ;

SVx_086: RJMP  SHWdspl ;

SVx_087: RJMP  Vx_end_ ;
SVx_088: RJMP  Vx_end_ ;
SVx_089: RJMP  Vx_end_ ;
SVx_090: RJMP  Vx_end_ ;

SVx_091: RJMP  SHWdspl ;

SVx_092: RJMP  Vx_end_ ;
SVx_093: RJMP  Vx_end_ ;
SVx_094: RJMP  Vx_end_ ;
SVx_095: RJMP  Vx_end_ ;

SVx_096: RJMP  SHWdspl ;

SVx_097: RJMP  Vx_end_ ;
SVx_098: RJMP  Vx_end_ ;
SVx_099: RJMP  Vx_end_ ;
SVx_100: RJMP  Vx_end_ ;

SVx_101: RJMP  SHWdspl ;

SVx_102: RJMP  Vx_end_ ;
SVx_103: RJMP  Vx_end_ ;
SVx_104: RJMP  Vx_end_ ;
SVx_105: RJMP  Vx_end_ ;

SVx_106: RJMP  SHWdspl ;

SVx_107: RJMP  Vx_end_ ;
SVx_108: RJMP  Vx_end_ ;
SVx_109: RJMP  Vx_end_ ;
SVx_110: RJMP  Vx_end_ ;

SVx_111: RJMP  SHWdspl ;

SVx_112: RJMP  Vx_end_ ;
SVx_113: RJMP  Vx_end_ ;
SVx_114: RJMP  Vx_end_ ;
SVx_115: RJMP  Vx_end_ ;

SVx_116: RJMP  SHWdspl ;

SVx_117: RJMP  Vx_end_ ;
SVx_118: RJMP  Vx_end_ ;
SVx_119: RJMP  Vx_end_ ;
SVx_120: RJMP  Vx_end_ ;

SVx_121: RJMP  SHWdspl ;

SVx_122: RJMP  Vx_end_ ;
SVx_123: RJMP  Vx_end_ ;
SVx_124: RJMP  Vx_end_ ;
SVx_125: RJMP  Vx_end_ ;

SVx_126: RJMP  SHWdspl ;

SVx_127: RJMP  Vx_end_ ;
SVx_128: RJMP  Vx_end_ ;
SVx_129: RJMP  Vx_end_ ;
SVx_130: RJMP  Vx_end_ ;

SVx_131: RJMP  SHWdspl ;

SVx_132: RJMP  Vx_end_ ;
SVx_133: RJMP  Vx_end_ ;
SVx_134: RJMP  Vx_end_ ;
SVx_135: RJMP  Vx_end_ ;

SVx_136: RJMP  SHWdspl ;

SVx_137: RJMP  Vx_end_ ;
SVx_138: RJMP  Vx_end_ ;
SVx_139: RJMP  Vx_end_ ;
SVx_140: RJMP  Vx_end_ ;

SVx_141: RJMP  SHWdspl ;

SVx_142: RJMP  Vx_end_ ;
SVx_143: RJMP  Vx_end_ ;
SVx_144: RJMP  Vx_end_ ;
SVx_145: RJMP  Vx_end_ ;

SVx_146: RJMP  SHWdspl ;

SVx_147: RJMP  Vx_end_ ;
SVx_148: RJMP  Vx_end_ ;
SVx_149: RJMP  Vx_end_ ;
SVx_150: RJMP  Vx_end_ ;

SVx_151: RJMP  SHWdspl ;

SVx_152: RJMP  Vx_end_ ;
SVx_153: RJMP  Vx_end_ ;
SVx_154: RJMP  Vx_end_ ;
SVx_155: RJMP  Vx_end_ ;

SVx_156: RJMP  SHWdspl ;

SVx_157: RJMP  Vx_end_ ;
SVx_158: RJMP  Vx_end_ ;
SVx_159: RJMP  Vx_end_ ;
SVx_160: RJMP  Vx_end_ ;

SVx_161: RJMP  SHWdspl ;

SVx_162: RJMP  Vx_end_ ;
SVx_163: RJMP  Vx_end_ ;
SVx_164: RJMP  Vx_end_ ;
SVx_165: RJMP  Vx_end_ ;

SVx_166: RJMP  SHWdspl ;

SVx_167: RJMP  Vx_end_ ;
SVx_168: RJMP  Vx_end_ ;
SVx_169: RJMP  Vx_end_ ;
SVx_170: RJMP  Vx_end_ ;

SVx_171: RJMP  SHWdspl ;

SVx_172: RJMP  Vx_end_ ;
SVx_173: RJMP  Vx_end_ ;
SVx_174: RJMP  Vx_end_ ;
SVx_175: RJMP  Vx_end_ ;

SVx_176: RJMP  SHWdspl ;

SVx_177: RJMP  Vx_end_ ;
SVx_178: RJMP  Vx_end_ ;
SVx_179: RJMP  Vx_end_ ;
SVx_180: RJMP  Vx_end_ ;

SVx_181: RJMP  SHWdspl ;

SVx_182: RJMP  Vx_end_ ;
SVx_183: RJMP  Vx_end_ ;
SVx_184: RJMP  Vx_end_ ;
SVx_185: RJMP  Vx_end_ ;

SVx_186: RJMP  SHWdspl ;

SVx_187: RJMP  Vx_end_ ;
SVx_188: RJMP  Vx_end_ ;
SVx_189: RJMP  Vx_end_ ;
SVx_190: RJMP  Vx_end_ ;

SVx_191: RJMP  SHWdspl ;

SVx_192: RJMP  Vx_end_ ;
SVx_193: RJMP  Vx_end_ ;
SVx_194: RJMP  Vx_end_ ;
SVx_195: RJMP  Vx_end_ ;

SVx_196: RJMP  SHWdspl ;

SVx_197: RJMP  Vx_end_ ;
SVx_198: RJMP  Vx_end_ ;
SVx_199: RJMP  Vx_end_ ;
SVx_200: RJMP  Vx_end_ ;

SVx_201: RJMP  SHWdspl ;

SVx_202: RJMP  Vx_end_ ;
SVx_203: RJMP  Vx_end_ ;
SVx_204: RJMP  Vx_end_ ;
SVx_205: RJMP  Vx_end_ ;

SVx_206: RJMP  SHWdspl ;

SVx_207: RJMP  Vx_end_ ;
SVx_208: RJMP  Vx_end_ ;
SVx_209: RJMP  Vx_end_ ;
SVx_210: RJMP  Vx_end_ ;

SVx_211: RJMP  SHWdspl ;

SVx_212: RJMP  Vx_end_ ;
SVx_213: RJMP  Vx_end_ ;
SVx_214: RJMP  Vx_end_ ;
SVx_215: RJMP  Vx_end_ ;

SVx_216: RJMP  SHWdspl ;

SVx_217: RJMP  Vx_end_ ;
SVx_218: RJMP  Vx_end_ ;
SVx_219: RJMP  Vx_end_ ;
SVx_220: RJMP  Vx_end_ ;

SVx_221: RJMP  SHWdspl ;

SVx_222: RJMP  Vx_end_ ;
SVx_223: RJMP  Vx_end_ ;
SVx_224: RJMP  Vx_end_ ;
SVx_225: RJMP  Vx_end_ ;

SVx_226: RJMP  SHWdspl ;

SVx_227: RJMP  Vx_end_ ;
SVx_228: RJMP  Vx_end_ ;
SVx_229: RJMP  Vx_end_ ;
SVx_230: RJMP  Vx_end_ ;

SVx_231: RJMP  SHWdspl ;

SVx_232: RJMP  Vx_end_ ;
SVx_233: RJMP  Vx_end_ ;
SVx_234: RJMP  Vx_end_ ;
SVx_235: RJMP  Vx_end_ ;

SVx_236: RJMP  SHWdspl ;

SVx_237: RJMP  Vx_end_ ;
SVx_238: RJMP  Vx_end_ ;
SVx_239: RJMP  Vx_end_ ;
SVx_240: RJMP  Vx_end_ ;

SVx_241: RJMP  SHWdspl ;

SVx_242: RJMP  Vx_end_ ;
SVx_243: RJMP  Vx_end_ ;
SVx_244: RJMP  Vx_end_ ;
SVx_245: RJMP  Vx_end_ ;

SVx_246: RJMP  SHWdspl ;

SVx_247: RJMP  Vx_end_ ;
SVx_248: RJMP  Vx_end_ ;
SVx_249: RJMP  Vx_end_ ;
SVx_250: RJMP  Vx_end_ ;

SVx_251: RJMP  SHWdspl ;

SVx_252: RJMP  Vx_end_ ;
SVx_253: RJMP  Vx_end_ ;
SVx_254: RJMP  Vx_end_ ;
SVx_255: RJMP  Vx_end_ ;

;====
;.ESEG
;====

;    .org 0x0000

; see EE_init:
;0x0000: .db 16-byte SIGNAT2
;ADDloVh=0x0010: .db  gainVloH, gainVloL, 0xFF,0xFF,
;ADDhiVh=0x0014: .db  gainVhiH, gainVhiL, 0xFF,0xFF,
;ADDinCh=0x0018: .db  gainCinH, gainCinL, 0xFF,0xFF,

;initial values:
; gainVloH\L = Vlo2bcd [ 7112,0x1BC8]
; gainVhiH\L = Vhi2bcd [12483,0x30C3]
; gainCinH\L = Cin2bcd [ 9910,0x26B6]

.exit

#ifdef MCUinfo

; <do>
; D:\L500\AVRprojects\ATmega8\Projects_62\REGULATOR\REG_5BD\REG_5BD_02.bat
rem
rem internal RC , 8.0 MHz
rem
rem
rem
rem 6 ck + 65 ms, slowly rising power
rem Brown-out Detection enabled
rem BOD(bot)=4V
rem
rem Reset at 0x0000
rem Bootsize 1024 words 32 pages
rem Chip Erase erases EEPROM
rem
rem disable Serial Downloading
rem WDT turns on by Software only
rem PC6 for I/O pin
rem
rem No further programming & reading
rem LPM only is allowed from BLS to ApS
rem LPM only is allowed from ApS to BLS

#endif ; MCUinfo

/*
;----------------------------------------------------------------------
; DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT
;----------------------------------------------------------------------

*/
