; Compiler: Avrasm2

#define Simu_1
#ifdef Simu_1
#include "m8Adef.inc"
#endif ; Simu_1

#define A22_10K_120_10  ; NEWjob2, 220V +/- 10V, 10KA_80x10_120V_A22

#define AMIR_dw4_up11    ; A53
.set OUT_max = 24600     ; 246.0 Vrms
.set OUT_min = 17000     ; 170.0 Vrms 

;========================================================================
;========================================================================

;                 "1234567812345678
#define sourceP   "REG_5BD_10-54___"   ; of Project
#define sourceB   "RA10_54_A22_____"   ; on MCU
#define HEX_year  0x24
#define HEX_month 0x10
#define HEX_day   0x16
; __DATE__ , __TIME__ are in bin file

#define delay_1          ; delay 35 samples [3.646 ms]
;#define delay_0          ; delay 28 samples [2.917 ms]

.equ CYCLnmbr = 8
.equ Vi_2bcd = 10687     ; 0x29BF , MCU: 01240925 , RA_54
.equ Vo_2bcd = 9530      ; 0x253A , MCU: 01240925 , RA_54

;========================================================================
;========================================================================

;====
.DSEG
;====

    .org 0x0060

curSplVx: .Byte 1 ;60 current sample of input or output voltage readings
lstSplVx: .Byte 1 ;61 last    sample of input or output voltage readings

;===

; upper display on A31
Dgt1_Vo:  .Byte 1 ;62 digit 1 (  1's) of Vo
Dgt2_Vo:  .Byte 1 ;63 digit 2 ( 10's) of Vo
Dgt3_Vo:  .Byte 1 ;64 digit 3 (100's) of Vo

; lower display on A31
Dgt1_Vi:  .Byte 1 ;65 digit 3 (  1's) of Vi
Dgt2_Vi:  .Byte 1 ;66 digit 4 ( 10's) of Vi
Dgt3_Vi:  .Byte 1 ;67 digit 5 (100's) of Vi

; for SHWdspl:
; upper Digt_3 , Digt_2 , Digt_1  [for Vo]
; lower Digt_6 , Digt_5 , Digt_4  [for Vi]
Digt_1:   .Byte 1 ;68 for Dgt1_Vo
Digt_2:   .Byte 1 ;69 for Dgt2_Vo
Digt_3:   .Byte 1 ;6A for Dgt4_Vo

Digt_4:   .Byte 1 ;6B for Dgt1_Vi
Digt_5:   .Byte 1 ;6C for Dgt2_Vi
Digt_6:   .Byte 1 ;6D for Dgt3_Vi

;===

ADCport:  .Byte 1 ;6E current ADC port, ADC_Vo or ADC_Vi

sum1VxL:  .Byte 1 ;6F sum of in or out voltage samples in one cycle, low
sum1VxH:  .Byte 1 ;70 sum of in or out voltage samples in one cycle, high
sum1VxU:  .Byte 1 ;71 sum of in or out voltage samples in one cycle, upper

;===

sum2ViL:  .Byte 1 ;72 sum of input voltage values in interval, low
sum2ViH:  .Byte 1 ;73 sum of input voltage values in interval, high

avgViL:   .Byte 1 ;74 binary average of input voltage values, low
avgViH:   .Byte 1 ;75 binary average of input voltage values, high

adjViL:   .Byte 1 ;76 adjusted avgVi as BCD HEX, low
adjViH:   .Byte 1 ;77 adjusted avgVi as BCD HEX, high

gainVi_L: .Byte 1 ;78 gain of input voltage, low
gainVi_H: .Byte 1 ;79 gain of input voltage, high

;===

sum2VoL:  .Byte 1 ;7A sum of input voltage values in interval, low
sum2VoH:  .Byte 1 ;7B sum of input voltage values in interval, high

avgVoL:   .Byte 1 ;7C binary average of input voltage values, low
avgVoH:   .Byte 1 ;7D binary average of input voltage values, high

adjVoL:   .Byte 1 ;7E adjusted avgVo as BCD HEX, low
adjVoH:   .Byte 1 ;7F adjusted avgVo as BCD HEX, high

gainVo_L: .Byte 1 ;80 gain of input voltage, low
gainVo_H: .Byte 1 ;81 gain of input voltage, high

;===

tmpViL:   .Byte 1 ;82 bin average, saved for Vi gain, low
tmpViH:   .Byte 1 ;83 bin average, saved for Vi gain, high
tmpVoL:   .Byte 1 ;84 bin average, saved for Vo gain, low
tmpVoH:   .Byte 1 ;85 bin average, saved for Vo gain, high

;===

DlyKoff:  .Byte 1 ;86 to be compared to ADJdely=200 [4s key delay]
DlyK_on:  .Byte 1 ;87 to be compared to ADJdely=200 [4s key delay]

curState: .Byte 1 ;88
prvState: .Byte 1 ;89
curStViH: .Byte 1 ;8A
curStViL: .Byte 1 ;8B

errHzDly: .Byte 1 ;8C 10 times, cycle time too small or too big

EEaddr_L: .Byte 1 ;8D image of EEARL

cutRelay: .Byte 1 ;8E for ORing tempOut to activate protection relay
                  ; or ANDing if protection relay reversed

; lower display on A31
Dgt1stp:  .Byte 1 ;8F digit 3 (  1's) of step
Dgt2stp:  .Byte 1 ;90 digit 4 ( 10's) of step
Dgt3stp:  .Byte 1 ;91 digit 5 blank

ScrnDly:  .Byte 1 ;92 screen delay counter for vi and step

lstState: .Byte 1 ;93 for FLPscrn:

;---------------------

; for loop, to clear registers
.equ SRAMstr = 0x60             ; up to 0x00FF (160 SRAM bytes)
;#define SRAMall                 ; to clear all 1024 registers

; more variables in EE, see EE_init and READ_EE

;============================================================================

;====
.CSEG
;====

;==========================
; **** SYSTEM constants ***
;==========================

; X2/TOSC2, X1/TOSC1, SCK, MISO, MOSI/OC2, SS/OC1B, OC1A, ICP1
; RL6=outL,ADJ=inP,Dg6=outH,Dg3=inP,Dg2=inP,Dg1=inP,Dg5=inP,Dg4=inP
.equ DDRBini0 = 0b10000000      ; o i iiiiii
.equ PRTBini0 = 0b01111111      ; L P PPPPPP

; *** inputs *** 1
#define Adj_In PINB,6

; *** outputs *** 7
#define RLY6_Out PORTB,7

; IMPORTANT: for DDRB (not PORTB), PORTB fixed & DDRB changed
#define DGTport DDRB
;                   632154
.equ DIGITSof = 0b11000000      ; ?? LLLLLL, all off  [AND DDRB]

.equ DIGIT1on = 0b00000100      ; ?? LLLHLL, Dgt1 only on [then OR]
.equ DIGIT2on = 0b00001000      ; ?? LLHLLL, Dgt2 only on [then OR]
.equ DIGIT3on = 0b00010000      ; ?? LHLLLL, Dgt3 only on [then OR]

.equ DIGIT4on = 0b00000001      ; ?? LLLLLH, Dgt4 only on [then OR]
.equ DIGIT5on = 0b00000010      ; ?? LLLLHL, Dgt5 only on [then OR]
.equ DIGIT6on = 0b00100000      ; ?? HLLLLL, Dgt6 only on [then OR]

; *** reserved *** 0
; none

;=== ===

; N/A, RESET(inP), ADC5/SCL, ADC4/SDA, ADC3, ADC2, ADC1, ADC0
; N/A,RLY5=outL,RL3=outL,RL2=outL,RLY1=outL,RLY4=outL,ADVo=inT,ADVi=inT
.equ DDRCini0  = 0b0_11111_00     ; x ooooo ii
.equ PRTCini0  = 0b0_00000_00     ; x LLLLL TT

; *** inputs *** 2
; PC0=ADC_Vin
; PC1=ADC_Vout

; *** outputs *** 5
#define RLY1_Out PORTC,3
#define RLY2_Out PORTC,4
#define RLY3_Out PORTC,5
#define RLY4_Out PORTC,2

#define RLY_port PORTC

;------------------------------;  RLY1,RLY2,RLY3,RLY4, RLY5
.equ ANDouts = 0b00_0_0_0_0_11 ;  off  off  off  off   off  reset

;=== ===

;------------------------------;  RLY1,RLY2,RLY3,RLY4, RLY5
; [AND]          x5 3 2 1 4 xx
.equ DO_cutR = 0b00_1_1_1_1_11 ;   -    -    -    -    off , overV  input
.equ NO_cutR = 0b01_1_1_1_1_11 ;   -    -    -    -    on  , do output

; [OR]
;                x5 3 2 1 4 xx
.equ DO_Rly4 = 0b00_0_0_0_1_00 ;   -    -    -   on    off , RLY4 only
.equ NO_Rly4 = 0b00_0_0_0_0_00 ;   -    -    -   on    off , normal

;                x5 3 2 1 4 xx
.equ OR_high = 0b01_0_0_0_0_00 ;  off  off  off  off   on  , high4, highest
.equ OR_outF = 0b01_0_0_0_0_00 ;  off  off  off  off   on  , high4, highest
.equ OR_outE = 0b01_0_0_1_0_00 ;  on   off  off  off   on  , high3
.equ OR_outD = 0b01_0_1_0_0_00 ;  off  on   off  off   on  , high2
.equ OR_outC = 0b01_0_1_1_0_00 ;  on   on   off  off   on  , high1
.equ OR_outB = 0b01_1_0_0_0_00 ;  off  off  on   off   on  , normal
.equ OR_outA = 0b01_1_0_1_0_00 ;  on   off  on   off   on  , low1
.equ OR_out9 = 0b01_1_1_0_0_00 ;  off  on   on   off   on  , low2
.equ OR_out8 = 0b01_1_1_1_0_00 ;  on   on   on   off   on  , low3
.equ OR_out7 = 0b01_0_0_0_1_00 ;  off  off  off  on    on  , low4
.equ OR_out6 = 0b01_0_0_1_1_00 ;  on   off  off  on    on  , low5
.equ OR_out5 = 0b01_0_1_0_1_00 ;  off  on   off  on    on  , low6
.equ OR_out4 = 0b01_0_1_1_1_00 ;  on   on   off  on    on  , low7
.equ OR_out3 = 0b01_1_0_0_1_00 ;  off  off  on   on    on  , low8
.equ OR_out2 = 0b01_1_0_1_1_00 ;  on   off  on   on    on  , low9
.equ OR_out1 = 0b01_1_1_0_1_00 ;  off  on   on   on    on  , low10
.equ OR_out0 = 0b01_1_1_1_1_00 ;  on   on   on   on    on  , low11, lowest

;=== ===

; *** reserved *** 1[N/A]
; PC7(N/A)

;======

; AIN1, AIN0, T1, XCK/T0, INT1, INT0, TXD, RXD
; SgG=outL,SgC=inT,SgD=inT,SgE=inT,Hz=inT,SgB=inT,SgF=inT,SgA=outL
; IMPORTANT: freeze PORTD and change DDRD
.equ DDRDini0 = 0b1000_0_000      ; oiii_i_iii
.equ PRTDini0 = 0b0000_0_000      ; LTTT_T_TTT

; *** inputs *** 1
;#define Hz_In PIND,3 ; see INTF1

; *** outputs *** 7
#define SEGport DDRD
#define Mid_Out DDRD,7 ; 1=on
; 7 LED Segments

; *** reserved *** 0
; none

;==========================
; *** PROGRAM constants ***
;==========================

.equ StBoot = 16 ; redundant?
.equ StateF = 15
.equ StateE = 14
.equ StateD = 13
.equ StateC = 12
.equ StateB = 11 ; normal
.equ StateA = 10
.equ State9 = 9
.equ State8 = 8
.equ State7 = 7
.equ State6 = 6
.equ State5 = 5
.equ State4 = 4
.equ State3 = 3
.equ State2 = 2
.equ State1 = 1
.equ State0 = 0

;===

.equ lmt_F = 32
.equ mid_E_F = 30
.equ mid_D_E = 28
.equ mid_C_D = 26
.equ mid_B_C = 24
.equ mid_A_B = 22
.equ mid_9_A = 20
.equ mid_8_9 = 18
.equ mid_7_8 = 16
.equ mid_6_7 = 14
.equ mid_5_6 = 12
.equ mid_4_5 = 10
.equ mid_3_4 = 8
.equ mid_2_3 = 6
.equ mid_1_2 = 4
.equ mid_0_1 = 2
.equ lmt_0 = 0

;=== ===

#define b_ADIF   0x06,4       ; ADC Interrupt Flag
#define L_2V56   (1<<6|1<<7)  ; ADC ref is 2V56, b_REFS1:0=11

#define ADC_Vo   0x01         ; for output voltage
#define ADC_Vi   0x00         ; for input voltage

.equ ADC_Vout = L_2V56+ADC_Vo ; 2V56, right adjusted
.equ ADC_Vin  = L_2V56+ADC_Vi ; 2V56, right adjusted

; Enable, Start, Free Run Select, (2^6) 8000/(64)=125 KHz, 104us
.equ ADC_init = 1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06  ; POLL b_ADIF
; ADEN , ADSC , ADFR , ADIF , ADIE , ADPS2 , ADPS1 , ADPS0
;  1      1      1      0      0      1       1       0

;.equ ADC_boot = 1<<ADEN | 1<<ADSC | 0x06  ; POLL b_ADIF
.equ ADC_boot = 1<<ADEN | 0x06  ; POLL b_ADIF

;=== ===
 
; 1/(240*104u)=40 Hz , 1/(148*104u)=64.9 Hz
.equ MAX_smpl = 240               ; Hz, lowest  frequency
.equ MIN_smpl = 148               ; Hz, highest frequency

;=== ===

.equ VltAdjt = 22000            ; 0x55F0

.equ ADDRvi_h = 0x10             ; EEARL of gainVi_H [Vi_2bcd], H then L
.equ ADDRvo_h = 0x20             ; EEARL of gainVo_H [Vo_2bcd], H then L

;=== ===

#ifndef Simu_1
.equ ADJdely = 100              ; 100*20ms= 2s key's delay [DlyKoff]
#else ; no Simu_1
.equ ADJdely = 10                ; 10*20ms= 200ms key's delay [DlyKoff]
#endif ; Simu_1

.equ LVLnmbr = 16               ; for both LVLhiVi and LVLloVi [32 both]

.equ StHigh = LVLnmbr-1    

;=== ===

; init "errHzDly" in mains cycles
.equ HZerrDly = 10

;===

;.equ OvrVoIdl = 4 ;  4*20ms*CYCLnmbr*2 =  1280 ms =  1.28 sec
.equ OvrVoIdl = 1280/20/CYCLnmbr/2  ; 4 ==> 1.28 sec

;.equ LowVoIdl = 38    ; 38*20ms*CYCLnmbr*2 = 12160 ms = 12.16 sec
.set LowVoIdl = 12160/20/CYCLnmbr/2 ; 38 ==> 12.16 sec
#ifdef Simu_1 
.set LowVoIdl = 3
#endif ; Simu_1

; in sec [to init "lmtDlyH\L" in ADC average time]
; *** IMPORTANT: VovrDlyT should be equal to VblwDlyT ***
#ifndef Simu_1
.equ VovrDlyT = 15               ; was 30s
.equ VblwDlyT = 15               ; as VovrDlyT
.equ BOOTdlyT = 14               ;  +1s HzBoot
#else ; no Simu_1
.equ VovrDlyT = 1                ; +1, see below 
.equ VblwDlyT = 1                ; as VovrDlyT 
.equ BOOTdlyT = 1                ; +1, see below
#endif ; Simu_1

; 15s * 1000ms / 20ms / (16 cycles *2 ) + 1 = 24 or 47 
.equ VovrDly = VovrDlyT*1000/20/(CYCLnmbr*2)+1
; 15s * 1000ms / 20ms / (16 cycles *2 ) + 1 = 24 or 47 
.equ VblwDly = VblwDlyT*1000/20/(CYCLnmbr*2)+1
; 14s * 1000ms / 20ms / (16 cycles *2 ) + 1 = 22 or 44
.equ BOOTdly = BOOTdlyT*1000/20/(CYCLnmbr*2)+1

#ifndef Simu_1
.equ T2_5sec = 125              ; 125*20ms = 2500ms
#else ; no Simu_1
.equ T2_5sec =  25              ;  25*20ms =  500ms
#endif ; Simu_1

;=============================
; *** PROGRAM hi-registers ***
;=============================
; specific hi-registers
.def R1flags  = r25   ; general flags 1
.def R2flags  = r24   ; general flags 2
;.def Keyflags = r23   ; 

.def tmpState = r22   ; temporary prvState
.def loopHi   = r21   ; loop counter

;=============================
; *** PROGRAM lo-registers ***
;=============================
; specific lo-registers
.def digtN    = r12   ; current display digit, 0 to 5
.def dspOff   = r11   ; dspOff=0, offtime=256*10 samples*104us=266ms

.def ovrVoDly = r10   ; time counter before output overVoltage cut (~2.5s)
;.def lmtDlyH  = r9    ; before return to normal delay after over/below voltage
.def lmtDlyL  = r8    ; before return to normal delay after over/below voltage

.def VxCyclC  = r7    ; Vi interval cycles counter
.def tempOut  = r6    ; temporary byte for relay outputs

.def ADCrd_H  = r5    ;
.def ADCrd_L  = r4    ;

.def lowVoDly = r3    ; time counter before output low voltage cut (~15s)

; r2 & r1 & r0 for MUL and others

.equ REGstr = 1
.equ REGend = 25                ; for loop to clear registers

;======================
; *** PROGRAM flags ***
;======================

;.def R1flags  = r25            ; general flags 1, basic
;-------------------------------------------------------

#define B_end2Vi r25,7          ; 1 = end interval for Vi, CYCLnmbr
#define F_end2Vi r25,0x80

#define B_end2Vo r25,6          ; 1 = end interval for Vo, CYCLnmbr
#define F_end2Vo r25,0x40

#define B_ovr_Vi r25,5          ; 1 = over input voltage status
#define F_ovr_Vi r25,0x20

#define B_blw_Vi r25,4          ; 1 = below input voltage status
#define F_blw_Vi r25,0x10

#define B_stpMod r25,3          ; 1 = screen step mode, 0 = screen vi mode
#define F_stpMod r25,0x08

#define B_lmtDly r25,2          ; 1 = out-limit voltage timer active
#define F_lmtDly r25,0x04

#define B_Vo_min r25,1          ; 1 = output volatge very low
#define F_Vo_min r25,0x02

#define B_dspOff r25,0          ; 1 = temporary display off
#define F_dspOff r25,0x01
#define X_dspOff 0b00000001     ; for on-off display

;.def R2flags  = r24            ; general flags 2
;------------------------------------------------

#define B_Vo_max r24,5          ; 1 = Vo very high
#define F_Vo_max r24,0x20

#define B_HzHigh r24,4          ; 1 = mains Hz high , 0 = low
#define F_HzHigh r24,0x10

#define B_noEEst r24,3          ; 1 = disable 220V setting on EE
#define F_noEEst r24,0x08

#define B_noVoEr r24,2          ; 1 = no error if Vo low or high
#define F_noVoEr r24,0x04

#define B_err_Hz r24,1          ; 1 = mains frequency beyond limits
#define F_err_Hz r24,0x02

#define B_keyOff r24,0          ; 1 = adjust key of Vx is off for 2 sec
#define F_keyOff r24,0x01

;---------------------------------

.equ keyActS1 = 0x09            ; flags using UBRRL
#define S_tmp_ok 0x09,7         ; 1= avgViH\L and avgVoH\L saved for setting
#define S_GvVxSt 0x09,6         ; 1 = setting key is on for 2 sec

#define S_GvVxSv 0x09,5         ; 1 = saving voltage gains is active
#define S_GvVoSv 0x09,4         ; 1 = to save save output gain [or active]
#define S_GvViSv 0x09,3         ; 1 = to save save  input gain [or active]

#define S_doRly6 0x09,2         ; 1 = connect mains voltage 
#define S_ftlErr 0x09,0         ; 1= fatal error, [for SHWdspl, RET]

;========================================================================

    .org 0x0000

; MCUCSR: * , * , * , * , WDRF , BORF , EXTRF , PORF
    rjmp RESET      ; Reset Handler

    rjmp EXT_INT0   ; IRQ0 Handler
    rjmp EXT_INT1   ; IRQ1 Handler
    rjmp TIM2_COMP  ; Timer2 Compare Handler
    rjmp TIM2_OVF   ; Timer2 Overflow Handler
    rjmp TIM1_CAPT  ; Timer1 Capture Handler
    rjmp TIM1_COMPA ; Timer1 CompareA Handler
    rjmp TIM1_COMPB ; Timer1 CompareB Handler
    rjmp TIM1_OVF   ; Timer1 Overflow Handler
    rjmp TIM0_OVF   ; Timer0 Overflow Handler
    rjmp SPI_STC    ; SPI Transfer Complete Handler
    rjmp USART_RXC  ; USART RX Complete Handler
    rjmp USART_UDRE ; UDR Empty Handler
    rjmp USART_TXC  ; USART TX Complete Handler
    rjmp ADC_RDY    ; ADC Conversion Complete Handler
    rjmp EE_RDY     ; EEPROM Ready Handler
    rjmp ANA_COMP   ; Analog Comparator Handler
    rjmp TWSI       ; Two-wire Serial Interface Handler
    rjmp SPM_RDY    ; Store Program Memory Ready Handler

;---------------------
; 16 bytes Name & City
;---------------------

SIGNAT0:
   .db "AUTOLIGHT-ALEPPO"

SIGNAT1:
   .db  0x00, HEX_year, HEX_month, HEX_day ; number of bytes should be even
SIGNAT2:
   .db  sourceP
   .db  sourceB

   .db  __DATE__
   .db  __TIME__

;=============================
; *RI* Interrupts Handlers ***
;=============================

; IRQ0: PD2, pin4 [MCUCR , GICR , GIFR]
EXT_INT0:
    RETI

; IRQ1: PD3, pin5 [MCUCR , GICR , GIFR]
EXT_INT1:
    RETI

; Timer2 Compare: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_COMP:
    RETI

; Timer2 Overflow: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_OVF:
    RETI

; Timer1 Capture: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_CAPT:
    RETI

; Timer1 CompareA: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPA:
    RETI

; Timer1 CompareB: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPB:
    RETI

; Timer1 Overflow: [TCNT1H/L, TIMSK , TIFR]
TIM1_OVF:
    RETI

; Timer0 Overflow: [TCCR0 , TCNT0]
TIM0_OVF:
    RETI

; SPI Transfer Complete: [SPCR , SPSR , SPDR]
SPI_STC:            ;
    RETI

; USART: RX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_RXC:
    RETI

; USART: UDR Empty: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_UDRE:
    RETI

; USART: TX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_TXC:
    RETI

; ADC Conversion Complete: [ADCH/L , ADMUX , ADCSRA]
ADC_RDY:            ;
    RETI

; EEPROM Ready: [EEARH/L, EEDR , EECR]
EE_RDY:
    RETI

; Analog Comparator: [SFIOR , ACSR]
ANA_COMP:
    RETI

; Two-wire Serial Interface: [TWAR , TWDR , TWBR , TWCR , TWSR]
TWSI:
    RETI

; Store Program Memory Ready: [SPMCR]
SPM_RDY:
    RETI

;===================
; *** MAIN entry ***
;===================

RESET:
; SPH\L [Stack Pointer] = RAMEND [top of SRAM, 0x045F]
    LDI   r16,  low(RAMEND)
    LDI   r17, high(RAMEND)
    OUT   SPL, r16
    OUT   SPH, r17

; DDRB=DDRBini0
    LDI   r16, DDRBini0
    OUT   DDRB, r16
; PORTB=PRTBini0
    LDI   r17, PRTBini0
    OUT   PORTB, r17

; DDRC=DDRCini0
    LDI   r16, DDRCini0
    OUT   DDRC, r16
; PORTC=PRTCini0
    LDI   r17, PRTCini0
    OUT   PORTC, r17

; DDRD=DDRDini0
    LDI   r16, DDRDini0
    OUT   DDRD, r16
; PORTD=PRTDini0
    LDI   r17, PRTDini0
    OUT   PORTD, r17

; Wait for stable Vcc (the fuse BODEN should be enabled)
    IN    r16, MCUCSR           ; MCU Control and Status Register
    SBRS  r16, BORF             ; Test Brown-out Reset Flag
    RJMP  RST_cnt               ; Continue if 0

    CLR   r16                   ; Brown-out Reset Flag is 1
    OUT   MCUCSR, r16           ; Clear all flags
    RJMP  RESET                 ;  and reboot

;====================================================================
; clear low and high registers
RST_cnt:
    CLR   r0
    LDI   XH, high(REGstr)
    LDI   XL,  low(REGstr)      ; start of variables in low registers
CLR_lp1:
    ST    X+, r0
    CPI   XL, REGend+1          ; end of variables in high registers
    BREQ  CLRend1

    RJMP  CLR_lp1

CLRend1:
; clear extended static RAM registers
    LDI   XH, high(SRAMstr)
    LDI   XL,  low(SRAMstr)     ; 0x60
CLR_lp2:
    ST    X+, r0

#ifndef SRAMall
    TST   XL
    BREQ  CLRend2               ; 0x60 =< XL =< 0xFF (160)

    RJMP  CLR_lp2
#else ; no SRAMall
    CPI   XH, high(RAMEND+1)    ; 0x04 , RAMEND+1 = 0x0460
    BRLO  CLR_lp2
    CPI   XL,  low(RAMEND+1)    ; 0x60
    BRLO  CLR_lp2
#endif ; SRAMall

CLRend2:
    OUT   keyActS1, r0          ; r0 already cleared

;==========================================
; ============ init variables =============
;==========================================

; assume it will be for adjust mode [Adj_In not grounded] 
    SBR   F_noVoEr

; if Adj_In=0 [shorted], disable 220V setting
    SBIC  Adj_In
    RJMP  INIint0

    SBR   F_noEEst
    CBR   F_noVoEr

INIint0:
    LDI   r16,  low(BOOTdly)
    MOV   lmtDlyL, r16
    SBR   F_lmtDly

    LDI   tmpState, StBoot      ; redundant?
    STS   prvState, tmpState
    STS   curState, tmpState

    IN    r16, RLY_port
    ANDI  r16, ANDouts          ; 0b00_0000_11 [boot state, all relays off] 
    OUT   RLY_port, r16

    CBI   RLY6_Out

; MCUCR=0b00001111 [set INT1 rising edge, also of INT0 though not used]
    LDI   r16, 0b00001111
    OUT   MCUCR, r16

; call INI_Hz_: [check mains frequency, led dimmed if no mains]
    RCALL INI_Hz_               ; good <do>

; call EE_init: [save default gainVi_H\L & gainVo_H\L in EE if fresh]
    RCALL EE_init

; call RD_Vx_G: [get gainVi_H\L & gainVo_H\L from EE]
    RCALL RD_Vx_G

; ADMUX=ADC_Vout [2V56, right adjusted, Vo @ADC0]
    LDI   r16, ADC_Vout
    OUT   ADMUX, r16

    LDI   r16, ADC_Vo
    STS   ADCport, r16

; ADCSRA=ADC_init [1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06]
; [Enable,Start,Free Run,8000/64=125 KHz] 104us/832c slide time
    LDI   r16, ADC_init
    OUT   ADCSRA, r16

; errHzDly=HZerrDly [reset Hz error counter, 10 cycles]
    LDI   r16, HZerrDly
    STS   errHzDly, r16

    RCALL VxReset

; no delay before cut for Vi over voltage
; delay before cut for Vo over voltage
    LDI   r16, OvrVoIdl         ; output high delay,  4*32*20ms =  2.56 sec
    MOV   ovrVoDly, r16

; delay before cut for Vo over voltage
    LDI   r16, LowVoIdl         ; output low  delay, 24*32*20ms = 15.36 sec
    MOV   lowVoDly, r16

    LDI   r16, SEGSblk
    RCALL  DGTsAll

    SBR   F_blw_Vi

    CBI   S_doRly6

;------------------
; *** Main Loop ***
;------------------

MAIN_lp:
; if b_ADIF=0, goto MAIN_lp: [wait ADC]
    SBIS  b_ADIF
    RJMP  MAIN_lp

; b_ADIF=1 [clear ADC flag by setting it to 1]
    SBI   b_ADIF

; *** Common code ***
; ADCrd_H\L [lo_reg] = ADCH\L
    IN    ADCrd_L, ADCL
    IN    ADCrd_H, ADCH

; ZH:ZL = high(SVx_000):curSplVx
    LDS   r16, curSplVx
    LDI   ZH, high(SVx_000)
    MOV   ZL, r16
; IJMP [jump to address in ZH:ZL]
    IJMP

;==============================================================

;--------------------------------------------------------------------------
; SMPL001: find Vi or Vo averages [sum2ViH\L or sum2VoH\L] of one cycle ***
;--------------------------------------------------------------------------

Vx_new_:
; if B_err_Hz=1, goto VxNewEr:
    SBRC  B_err_Hz
    RJMP  VxNewEr

    LDS   r19, lstSplVx
    TST   r19
    BRNE  VxNewOk

VxNewEr:
; sum1VxU\H\L=0 [reset cycle average]
    CLR   r16
    STS   sum1VxU, r16
    STS   sum1VxH, r16
    STS   sum1VxL, r16

; VxCyclC=CYCLnmbr [reset counter of Vx average cycles]
    LDI   r16, CYCLnmbr         ; 16 times
    MOV   VxCyclC, r16

; F_err_Hz=1 [signal Hz error]
    SBR   F_err_Hz
    RJMP  VxNewEd

;===

VxNewOk:
    CLR   r20                   ; r19 = lstSplVx
    LDS   r18, sum1VxU
    LDS   r17, sum1VxH
    LDS   r16, sum1VxL

; *** Division 24/16, 429 cycles, with rounding ***
; dividend : r18:r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r2:r1:r0
; maximum tested 414 cycles + 15 for rounding

; r1:r0 = sum1VxU\H\L / lstSplVx [Vx average in one cycle, call D24u16rd:]
    RCALL D24u16rd

; if r2\H\L > 1023 [overflow], goto FTLerr2: [Vi] or FTLerr3: [Vo]
    TST   r2
    BRNE  VxNewEr

    MOV   r16, r0               ; r0 
    CPI   r16,  low(1024)
    LDI   r17, high(1024)
    CPC   r1, r17               ; r1
    BRLO  VxNewCt

VxNwErr:
    LDS   r18, ADCport
    CPI   r18, ADC_Vi
    BRNE  FTLerVo

    RJMP  FTLerr2

FTLerVo:
    RJMP  FTLerr3

VxNewCt:
; sum1VxU\H\L=0 [reset cycle average]
    CLR   r16
    STS   sum1VxU, r16
    STS   sum1VxH, r16
    STS   sum1VxL, r16

    RCALL SUM2Vx_

VxNewEd:
    RJMP  Vx_end_

;=====

SUM2Vx_:
; do sum of the previous ADCport
    LDS   r18, ADCport
    CPI   r18, ADC_Vi
    BREQ  SUM2Vo_

; was ADCport=ADC_Vi
SUM2Vi_:
; sum2ViH\L = sum2ViH\L + r1:r0
    LDS   r16, sum2ViL
    ADD   r16, r0
    STS   sum2ViL, r16

    LDS   r16, sum2ViH
    ADC   r16, r1
    STS   sum2ViH, r16
    RJMP  SUM2VxR

; was ADCport=ADC_Vo
SUM2Vo_:
; sum2VoH\L = sum2VoH\L + r1:r0
    LDS   r16, sum2VoL
    ADD   r16, r0
    STS   sum2VoL, r16

    LDS   r16, sum2VoH
    ADC   r16, r1
    STS   sum2VoH, r16

; decrement VxCyclC, if not 0 , goto SUM2VxR:
    DEC   VxCyclC               ; decrement VxCyclC if reading Vi & Vo
    BRNE  SUM2VxR

    LDI   r16, CYCLnmbr         ; 16 times
    MOV   VxCyclC, r16

; F_end2Vi=1 [signal cycles of Vi average readings is over]
    SBR   F_end2Vi

; F_end2Vo=1 [signal cycles of Vo average readings is over]
    SBR   F_end2Vo

SUM2VxR:
    RET

;==============================================================

;---------------------------------------------------------------
; SMPL002: find Vi average bin [avgViH\L] of CYCLnmbr cycles ***
;---------------------------------------------------------------

Vi_avg_:
; if B_end2Vi=0 [not end of Vi average cycles], goto ViAvgEd:
    SBRS  B_end2Vi
    RJMP  ViAvgEd

; r1:r0 = sum2ViH\L / CYCLnmbr [Vi average, call D16u16rd:]
    CLR   r20
    LDI   r19, CYCLnmbr         ; 16 times <do>
    LDS   r17, sum2ViH
    LDS   r16, sum2ViL

; *** Division 16/16, 280 cycles, rounding r1\L ***
; dividend : r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r1:r0

    RCALL D16u16rd

; avgViH\L = r1:r0
    STS   avgViH, r1
    STS   avgViL, r0

; sum2ViH\L = 0 [reset Vi average]
    CLR   r16
    STS   sum2ViH, r16
    STS   sum2ViL, r16
ViAvgEd:
    RJMP  Vx_end_

;==============================================================

;---------------------------------------------------------------
; SMPL003: find Vo average bin [avgVoH\L] of CYCLnmbr cycles ***
;---------------------------------------------------------------

Vo_avg_:
; if B_end2Vo=0 [not end of Vo average cycles], goto VoAvgEd:
    SBRS  B_end2Vo
    RJMP  VoAvgEd

; r1:r0 = sum2VoH\L / CYCLnmbr [Vo average, call D16u16rd:]
    CLR   r20
    LDI   r19, CYCLnmbr         ; 16 times <do>
    LDS   r17, sum2VoH
    LDS   r16, sum2VoL

; *** Division 16/16, 280 cycles, rounding r1:r0 ***
; dividend : r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r1:r0

    RCALL D16u16rd

; avgVoH\L = r1:r0
    STS   avgVoH, r1
    STS   avgVoL, r0

; sum2VoH\L = 0 [reset Vo average]
    CLR   r16
    STS   sum2VoH, r16
    STS   sum2VoL, r16
VoAvgEd:
    RJMP  Vx_end_

;==============================================================

;----------------------------------------------------------------------------
; SMPL004: Vi average bin [avgViH\L] to BCD bin [adjViH\L] & 7-seg digits ***
;----------------------------------------------------------------------------

Vi_bcd_:
; if B_end2Vi=0 [not end of Vi average cycles], goto ViDecEd:
    SBRS  B_end2Vi
    RJMP  ViDecEd

; nominal gainVi_H\L = Vi_2bcd = 26852 = 0x68E4
; r20:r19 = avgViH\L * gainVi_H\L / 256 [to BCD binary, call M_16x16:]
    LDS   r17, avgViH
    LDS   r16, avgViL
    LDS   r14, gainVi_H
    LDS   r13, gainVi_L

; *** 16x16 Bit Unsigned Multiplication , 24 cycles ***
; multiplicand: r17:r16
; multiplier  : r14:r13
; result out  : r21:r20:r19:r18
; see mul16x16_32_AL.txt

    RCALL M_16x16

    STS   adjViH, r20
    STS   adjViL, r19

    MOV   r17, r20
    MOV   r16, r19

; input: R17, R16  [ value 0 to 1023 ]
;output: R20, R19, R18, R17, R16 = 5 digits (ASCII)
    RCALL  DEC2BCD

; rounding r17:r16 DEC digit
    CPI   r17, 5
    BRLO  Vi_bcdC

    INC   r18
    CPI   r18, 10
    BRLO  Vi_bcdC

    CLR   r18                  ; reset to 0
    INC   r19
    CPI   r19, 10
    BRLO  Vi_bcdC

    CLR   r19                  ; reset to 0
    INC   r20
    CPI   r20, 10
    BRLO  Vi_bcdC

; if Vi BCD > 999 , goto FTLerr6:
    RJMP  FTLerr6

Vi_bcdC:
    LDI   YH, high(Dgt1_Vi)
    LDI   YL,  low(Dgt1_Vi)     ; destination

    LDI   XH, high(18)          ; source, r18 to r20
    LDI   XL,  low(18)
    LDI   r21, 3                ; 3 digits, input voltage

DGTviLp:
    LD    r16, X+               ; Digit# as hex
    RCALL BCD2sgF               ; Z used
    ST    Y+, r16               ; save as 7seg

    DEC   r21
    BRNE  DGTviLp

    NOP                         ; for simulation
ViDecEd:
    RJMP  Vx_end_

;==============================================================

;----------------------------------------------------------------------------
; SMPL005: Vo average bin [avgVoH\L] to BCD bin [adjVoH\L] & 7-seg digits ***
;----------------------------------------------------------------------------

Vo_bcd_:
; if B_end2Vo=0 [not end of Vo average cycles], goto VoDecEd:
    SBRS  B_end2Vo
    RJMP  VoDecEd

; nominal gainVo_H\L = Vo_2bcd = 7458 = 0x1d22
; r20:r19 = avgVoH\L * gainVo_H\L / 256 [to BCD binary, call M_16x16:]
    LDS   r17, avgVoH
    LDS   r16, avgVoL
    LDS   r14, gainVo_H
    LDS   r13, gainVo_L

; *** 16x16 Bit Unsigned Multiplication , 24 cycles ***
; multiplicand: r17:r16
; multiplier  : r14:r13
; result out  : r21:r20:r19:r18
; see mul16x16_32_AL.txt

    RCALL M_16x16

    STS   adjVoH, r20
    STS   adjVoL, r19

    MOV   r17, r20
    MOV   r16, r19

; input: R17, R16  [ value 0 to 1023 ]
;output: R20, R19, R18, R17, R16 = 5 digits (ASCII)
    RCALL  DEC2BCD

; rounding r17:r16 DEC digit
    CPI   r17, 5
    BRLO  Vo_bcdC

    INC   r18
    CPI   r18, 10
    BRLO  Vo_bcdC

    CLR   r18                   ; reset to 0
    INC   r19
    CPI   r19, 10
    BRLO  Vo_bcdC

    CLR   r19                   ; reset to 0
    INC   r20
    CPI   r20, 10
    BRLO  Vi_bcdC

; if Vo BCD > 999 , goto FTLerr7:
    RJMP  FTLerr7

Vo_bcdC:
    LDI   YH, high(Dgt1_Vo)
    LDI   YL,  low(Dgt1_Vo)     ; destination

    LDI   XH, high(18)          ; source, r18 to r20
    LDI   XL,  low(18)
    LDI   r21, 3                ; 3 digits, input voltage

DGTvoLp:
    LD    r16, X+               ; Digit# as hex
    RCALL BCD2sgF               ; Z used
    ST    Y+, r16               ; save as 7seg

    DEC   r21
    BRNE  DGTvoLp

    RJMP  VoDecEd

    NOP                         ; for simulation
VoDecEd:
    RJMP  Vx_end_

;==============================================================

;-----------------------------------------------------------
; SMPL006: adjust key for input and output voltage gains ***
;-----------------------------------------------------------

Vx_key_:
    SBRC  B_noEEst
    RJMP  ViKeyEd

; if S_GvVxSt=1 [voltage gains 'setting' is busy], goto RSTk_On:
    SBIC  S_GvVxSt
    RJMP  RSTk_On

; if S_GvVxSv=1 [voltage gain 'saving'  is busy], goto RSTk_On:
    SBIC  S_GvVxSv
    RJMP  RSTk_On

; if B_keyOff=0 [key of setting Vx gain not off for 2s], goto ISkeyOff:
    SBRS  B_keyOff
    RJMP  ISkeyOff

ISkeyOn:
; if Adj_In=1 [Vx key is off], goto RSTk_On:
    SBIC  Adj_In
    RJMP  RSTk_On

    SBIC  S_tmp_ok
    RJMP  KEYdlay

    LDS   r17, avgViH
    LDS   r16, avgViL
    STS   tmpViH, r17
    STS   tmpViL, r16

    LDS   r17, avgVoH
    LDS   r16, avgVoL
    STS   tmpVoH, r17
    STS   tmpVoL, r16

    SBI   S_tmp_ok

KEYdlay:
; increment DlyK_on, if DlyK_on < ADJdely, goto ViKeyEd:
    LDS   r16, DlyK_on
    INC   r16
    STS   DlyK_on, r16
    CPI   r16, ADJdely          ; 100 ==> 2 sec
    BRLO  ViKeyEd

; F_keyOff=0 [Vx key was on for >2s]
    CBR   F_keyOff

; S_GvVxSt=1 [Vx key was on for >2s, save voltages]
    SBI   S_GvVxSt

    SBR   F_dspOff
    CLR   DspOff
    RJMP  ViKeyEd

;===

ISkeyOff:
; if Adj_In=0 [Vx key is on], goto RSTkOff:
    SBIS  Adj_In
    RJMP  RSTkOff

; increment DlyKoff, if DlyKoff < ADJdely, goto ViKeyEd:
    LDS   r16, DlyKoff
    INC   r16
    STS   DlyKoff, r16
    CPI   r16, ADJdely          ; 100 ==> 2 sec
    BRLO  ViKeyEd

; F_keyOff=1 [Vx key was off for 2s]
    SBR   F_keyOff

    RJMP  ViKeyEd

;===

RSTkOff:
; DlyKoff=0 [reset Vx key off delay]
    CLR   r16
    STS   DlyKoff, r16
    CBI   S_tmp_ok
    RJMP  ViKeyEd

RSTk_On:
; DlyK_on=0 [reset Vx key on delay]
    CLR   r16
    STS   DlyK_on, r16
    CBI   S_tmp_ok
ViKeyEd:
    RJMP  Vx_end_

;==============================================================

;-------------------------------------------------
; SMPL008: set input voltage gain [gainVi_H\L] ***
;-------------------------------------------------

Vi_set_:
    SBRC  B_noEEst
    RJMP  ViSetEd

; if S_GvVxSt=0 [Vi key not on for 2s], goto VoSetEd:
    SBIS  S_GvVxSt
    RJMP  ViSetEd

    LDI   r18, high(VltAdjt)    ; 22010
    LDI   r17,  low(VltAdjt)
    CLR   r16
    LDS   r20, tmpViH
    LDS   r19, tmpViL

; *** Division 24/16, 429 cycles, with rounding ***
; dividend : r18:r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r2:r1:r0
; maximum tested 414 cycles + 15 for rounding

; r1:r0 = VltAdjt * 256 / avgViH\L [call D24u16rd:]
    RCALL D24u16rd

; if r2 > 0 [overflow], goto FTLerr4:
    TST   r2
    BREQ  ViSetCt

    RJMP  FTLerr4

ViSetCt:
; gainVi_H\L = r1:r0
    STS   gainVi_H, r1
    STS   gainVi_L, r0

; S_GvVxSv=1 [to save every gain in EE]
    SBI   S_GvVxSv

; S_GvViSv=1 [to save gainVi_H\L in EE]
    SBI   S_GvViSv

; prepare for Vi_sav_
    LDI   r18, ADDRvi_h
    STS   EEaddr_L, r18

ViSetEd:
    RJMP  Vx_end_

;--------------------------------------------------
; SMPL009: set output voltage gain [gainVo_H\L] ***
;--------------------------------------------------

Vo_set_:
    SBRC  B_noEEst
    RJMP  VoSetEd

; if S_GvVxSt=0 [Vo key not on for 2s], goto VoSetEd:
    SBIS  S_GvVxSt
    RJMP  VoSetEd

; r1:r0 = VltAdjt * 256 / avgVoH\L [call D24u16u:]
    LDI   r18, high(VltAdjt)    ; 22010
    LDI   r17,  low(VltAdjt)
    CLR   r16
    LDS   r20, tmpVoH
    LDS   r19, tmpVoL

; *** Division 24/16, 429 cycles, with rounding ***
; dividend : r18:r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r2:r1:r0
; maximum tested 414 cycles + 15 for rounding

    RCALL D24u16rd

; if r2 > 0 [overflow], goto FTLerr5:
    TST   r2
    BREQ  VoSetCt

    RJMP  FTLerr5

VoSetCt:
; gainVo_H\L = r1:r0
    STS   gainVo_H, r1
    STS   gainVo_L, r0

; S_GvVxSt=0 [two gains are set]
    CBI   S_GvVxSt

VoSetEd:
    RJMP  Vx_end_

;---------------------------------------------------------
; SMPL010: save input voltage gain [gainVi_H\L] in EE  ***
;---------------------------------------------------------

Vi_sav_:
    SBRC  B_noEEst
    RJMP  ViSavEd

; if EEWE=1 [EE busy], goto ViSavEd:
    SBIC  EECR, EEWE
    RJMP  ViSavEd

; if S_GvVxSv=0 [Vx saving not requested], goto ViSavEd:
    SBIS  S_GvVxSv
    RJMP  ViSavEd

; if S_GvViSv=0 [Vi saving not requested], goto ViSavEd:
    SBIS  S_GvViSv
    RJMP  ViSavEd

    CLR   r18
    OUT   EEARH, r18

; r16 = EEaddr_L = ADDRvi_h?
    LDS   r16, EEaddr_L
; if r16 != ADDRvi_h, goto ViSavB2: [save low]
    CPI   r16, ADDRvi_h
    BRNE  ViSavB2

ViSavB1:
; save r17= gainVi_H, first pass
; EEaddr_L = r16 + 1 [for the next pass ]
    INC   r16
    STS   EEaddr_L, r16

; restore ADDRvi_h
    DEC   r16
; r17 = gainVi_H
    LDS   r17, gainVi_H
    RJMP  ViSavCt

ViSavB2:
; save r17= gainVi_L , second pass
    LDS   r17, gainVi_L

; S_GvViSv=0 [second byte is saved]
    CBI   S_GvViSv

; prepare for Vo_sav_
    LDI   r18, ADDRvo_h
    STS   EEaddr_L, r18

; S_GvVoSv=1 [to save gainVo_H\L in EE]
    SBI   S_GvVoSv

ViSavCt:
    RCALL SAVEbyt

ViSavEd:
    RJMP  Vx_end_

;----------------------------------------------------------
; SMPL012: save output voltage gain [gainVo_H\L] in EE  ***
;----------------------------------------------------------

Vo_sav_:
    SBRC  B_noEEst
    RJMP  VoSavEd

; if EEWE=1 [EE busy], goto VoSavEd:
    SBIC  EECR, EEWE
    RJMP  VoSavEd

; if S_GvVxSv=0 [Vx saving not requested], goto VoSavEd:
    SBIS  S_GvVxSv
    RJMP  VoSavEd

; if S_GvViSv=1 [Vi saving busy], goto VoSavEd:
    SBIC  S_GvViSv
    RJMP  VoSavEd

; if S_GvVoSv=0 [Vo saving not requested], goto VoSavEd:
    SBIS  S_GvVoSv
    RJMP  VoSavEd

    CLR   r18
    OUT   EEARH, r18

; r16 = EEaddr_L = ADDRvo_h?
    LDS   r16, EEaddr_L
; if r16 != ADDRvo_h, goto VoSavB2: [save low]
    CPI   r16, ADDRvo_h
    BRNE  VoSavB2

VoSavB1:
; save r17= gainVo_H, first pass
; EEaddr_L = r16 + 1 [for the next pass ]
    INC   r16
    STS   EEaddr_L, r16

    DEC   r16
; r17 = gainVo_H
    LDS   r17, gainVo_H
    RJMP  VoSavCt

VoSavB2:
; save r17= gainVo_L , second pass
    LDS   r17, gainVo_L

; S_GvVoSv=0 [second byte is saved]
    CBI   S_GvVoSv

; S_GvVxSv=0 [second byte is saved]
    CBI   S_GvVxSv

VoSavCt:
    RCALL SAVEbyt

VoSavEd:
    RJMP  Vx_end_

;==========================================

SAVEbyt:
    OUT   EEARL, r16
    OUT   EEDR, r17
    CLI                         ; disable interrupts during timed sequence
    SBI   EECR, EEMWE           ; enable EEPROM write
    SBI   EECR, EEWE            ; start EEPROM write
    SEI                         ; re-enable interrupts
    RET

;-------------------------------------------------------------
; SMPL023: find input voltage state from high limits table ***
;-------------------------------------------------------------

LVLhiVi:
; if B_err_Hz=1, goto LVhiViR:
    SBRC  B_err_Hz
    RJMP  LVhiViR

; if B_end2Vi=0 [not end of Vi average cycles], goto LVhiViR:
    SBRS  B_end2Vi
    RJMP  LVhiViR

; prvState = curState
    LDS   r16, curState
    STS   prvState, r16

; r18 = LVLnmbr [16 levels above 0 level]
    LDI   r18, LVLnmbr

; r17\L = adjViH\L [Vi voltage in BCD binary]
    LDS   r17, adjViH
    LDS   r16, adjViL

; ZH:ZL = (TBLvltH*2) [of the BCD binary 16 hi-limit levels]
    LDI   ZH, high(TBLvltH*2)   ; address in bytes
    LDI   ZL,  low(TBLvltH*2)   ;

LVhViLp:
; r20:r19 = TBLvltH:(Z):TBLvltH:(Z+1) [low then high byte]
    LPM   r19, Z+               ; low  byte
    LPM   r20, Z+               ; high byte

; if TBLvltH:(Z) < adjViH\L , goto LVhiViE: [level number in r18]
    CP    r19, r16              ;Compare low byte
    CPC   r20, r17              ;Compare high byte with carry
    BRLO  LVhiViE

; decrement r18 [level number], if not 0 , goto Flvl_lp:
    DEC   r18
    BRNE  LVhViLp

LVhiViE:
; curStViH = r18 [=16 if Vi very high, =0 if Vi low]
    STS   curStViH, r18

; assume no over input voltage
    CBR   F_ovr_Vi

    CPI   r18, LVLnmbr
    BRNE  LVhiViR

    DEC   r18
    STS   curStViH, r18         ; StateF=15 or StateF=5

    SBR   F_ovr_Vi

    LDI   r16,  low(VovrDly)
    MOV   lmtDlyL, r16
    SBR   F_lmtDly

LVhiViR:
    RJMP  Vx_end_

;------------------------------------------------------------
; SMPL024: find input voltage state from low limits table ***
;------------------------------------------------------------

LVLloVi:
; if B_err_Hz=1, goto LVloViR:
    SBRC  B_err_Hz
    RJMP  LVloViR

; if B_end2Vi=0 [not end of Vi average cycles], goto LVloViR:
    SBRS  B_end2Vi
    RJMP  LVloViR

; if B_ovr_Vi=1 [over input voltage], goto LVloViR:
    SBRC  B_ovr_Vi
    RJMP  LVloViR

; r18 = LVLnmbr [16 levels above StBoot]
    LDI   r18, LVLnmbr

; r17:r16 = adjViH\L [Vi voltage in BCD binary]
    LDS   r17, adjViH
    LDS   r16, adjViL

; ZH:ZL = (TBLvltL*2) [of the BCD binary 16 lo-limit levels]
    LDI   ZH, high(TBLvltL*2)   ; address in bytes
    LDI   ZL,  low(TBLvltL*2)   ;

LVlViLp:
; r20:r19 = TBLvolt:(Z)\TBLvolt:(Z+1) [low then high byte]
    LPM   r19, Z+               ; low  byte
    LPM   r20, Z+               ; high byte

; if TBLvltL:(Z) < adjViH\L , goto LVloViE: [level number in r18]
    CP    r19, r16           ;Compare low byte
    CPC   r20, r17           ;Compare high byte with carry
    BRLO  LVloViE

; decrement r18 [level number], if not 0 , goto Flvl_lp:
    DEC   r18
    BRNE  LVlViLp

    LDI   r18, StBoot           ; redundant?
    STS   curStViL, r18

    LDI   r16,  low(VblwDly)
    MOV   lmtDlyL, r16
    SBR   F_lmtDly

    SBR   F_blw_Vi
    RJMP  LVloViR

LVloViE:
    CBR   F_blw_Vi

    DEC   r18
; curStViL = r18 [=15 if Vi high, =0 Vi low]
    STS   curStViL, r18

LVloViR:
    RJMP  Vx_end_

;-----------------------------------------------------------
; SMPL025: check output voltage for possible relay error ***
;-----------------------------------------------------------

FNDlvl1:
; if B_err_Hz=1, goto FNDlvlR:
    SBRC  B_err_Hz
    RJMP  FDlvl_R

; if B_end2Vo=0 [not end of Vo average cycles], goto FDlvl_R:
    SBRS  B_end2Vo
    RJMP  FDlvl_R

    CBR   F_end2Vo

; r17\L = adjVoH\L [Vo voltage in BCD binary]
    LDS   r17, adjVoH
    LDS   r16, adjVoL

ISvoMin:
    LDI   r20, high(OUT_min)
    LDI   r19,  low(OUT_min)

; if OUT_min > adjVoH\L , goto DOvoMin
    CP    r19, r16              ;Compare low byte
    CPC   r20, r17              ;Compare high byte with carry
    BRSH  DOvoMin

ISvoMax:
    LDI   r20, high(OUT_max)
    LDI   r19,  low(OUT_max)

; if OUT_max < adjVoH\L , goto DOvoMax
    CP    r19, r16              ;Compare low byte
    CPC   r20, r17              ;Compare high byte with carry
    BRLO  DOvoMax

;FDlvlE1:
FDlvl_E:
    CBR   F_Vo_max
    LDI   r16, OvrVoIdl         ; output high delay, 4*32*20ms = 2.56 sec
    MOV   ovrVoDly, r16

    CBR   F_Vo_min
    LDI   r16, LowVoIdl         ; output low delay, 4*32*20ms = 15 sec
    MOV   LowVoDly, r16

; OUT_min < adjVoH\L < OUT_max, reset Vo limit delay
FDlvl_R:
    RJMP  Vx_end_

;===

DOvoMin:
; if Vi is low, Vo can be low
    SBRC  B_blw_Vi
    RJMP  FDlvl_E

    SBRC  B_noVoEr
    RJMP  FDlvl_E

    SBIS  RLY6_Out

    RJMP  FDlvl_E

    SBR   F_Vo_min
    CBR   F_Vo_max

; output protecting relay is on
    DEC   lowVoDly
    BRNE  FDlvl_R

    RJMP  OUT_err

;===

DOvoMax:
    SBRC  B_noVoEr
    RJMP  FDlvl_E

    SBRC  B_ovr_Vi
    RJMP  FDlvl_R

    SBR   F_Vo_max
    CBR   F_Vo_min

    DEC   ovrVoDly
    BRNE  FDlvl_R


;============================
; *** signal OUTPUT error ***
;============================

OUT_err:
    RCALL RSTprts

    LDI   r16, SEGS_0_
    STS   Dgt3_Vo, r16

    LDI   r16, SEGS_u_
    STS   Dgt2_Vo, r16

    LDI   r16, SEGS_t_
    STS   Dgt1_Vo, r16

    LDI   r16, SEGSblk
    STS   Dgt3_Vi, r16

; assume Vo low [DOerrLo] < 170V
    LDI   r16, SEGS__L
    STS   Dgt2_Vi, r16

    LDI   r16, SEGS_o_
    STS   Dgt1_Vi, r16

    SBRC  B_Vo_min
    RJMP  DOerOut

DOerrHi:
; Vo > 240V
    LDI   r16, SEGS__H
    STS   Dgt2_Vi, r16

    LDI   r16, SEGS__I
    STS   Dgt1_Vi, r16

DOerOut:
    SBI   S_ftlErr

    RJMP  FTLloop

;===============================================================
;===============================================================

;--------------------------------
; SMPL027: find current state ***
;--------------------------------

; NEWjob2
DO_job_:
; if B_err_Hz=1, goto DO_jobR:
    SBRC  B_err_Hz
    RJMP  DO_jobR

; if B_end2Vi=0 [not end of Vi average cycles], goto DO_jobR:
    SBRS  B_end2Vi
    RJMP  DO_jobR

    SBRS  B_ovr_Vi
    RJMP  DO_stgs

; curState = StateF
    LDI   tmpState, StHigh      ; to turn off protection relay
    RJMP  DO_jobE               ; curState=tmpState

;=== ===

DO_stgs:
; assume below input voltage
    LDI   tmpState, StBoot      ; redundant?

    SBRC  B_blw_Vi
    RJMP  DO_jobE               ; curState=tmpState

;===

    LDS   tmpState, prvState

    LDS   r18, curStViH
    LDS   r17, curStViL

    CP    tmpState, r18         ; tmpState=r22
    BRNE  DOstgC1

    RJMP  DO_jobR

DOstgC1:
    CP    tmpState, r17
    BRNE  DOstgC2

    RJMP  DO_jobR

DOstgC2:
    MOV   tmpState, r17         ; jump to curStViL
DO_jobE:
    STS   curState, tmpState

DO_jobR:
    RJMP  Vx_end_

;==============================================================
;==============================================================

#include "AMIR_dw4_up11_volts_2.txt"
;#include "AL_dw0_up15_volts.txt"

;---------------------------
;SVx_028: update outputs ***
;---------------------------

UpdtOut:
; if B_err_Hz=1, goto UpdOutR:
    SBRC  B_err_Hz
    RJMP  UpdOutR

; if B_end2Vi=0 [not end of Vi average cycles], goto UpdOutR:
    SBRS  B_end2Vi
    RJMP  UpdOutR

; F_end2Vi=0 [signal Vi average reading is serviced]
    CBR   F_end2Vi

; if B_blw_Vi=1, call Upd_Blw:
    SBRC  B_blw_Vi
    RJMP  Upd_Blw

; if B_ovr_Vi=1, call Upd_Ovr:
    SBRC  B_ovr_Vi
    RJMP  Upd_Ovr

;---

    SBRS  B_lmtDly
    RJMP  UpdOutX

    MOV   r16, lmtDlyL
    CPI   r16, VovrDly+1        ; same as VblwDly+1
    BRSH  UpdOutX

    DEC   lmtDlyL
    BRNE  UpdOut_

UpdOutX:
    CLR   lmtDlyL
    CBR   F_lmtDly

    SBI   S_doRly6

UpdOut_:
    LDS   r18, curState

UpdOut0:
    STS   prvState, r18
    CPI   r18, State0
    BRNE  UpdOut1

    LDI   r16, OR_out0
    RJMP  Upd_Out

UpdOut1:
    CPI   r18, State1
    BRNE  UpdOut2

    LDI   r16, OR_out1
    RJMP  Upd_Out

UpdOut2:
    CPI   r18, State2
    BRNE  UpdOut3

    LDI   r16, OR_out2
    RJMP  Upd_Out

UpdOut3:
    CPI   r18, State3
    BRNE  UpdOut4

    LDI   r16, OR_out3
    RJMP  Upd_Out

UpdOut4:
    CPI   r18, State4
    BRNE  UpdOut5

    LDI   r16, OR_out4
    RJMP  Upd_Out

UpdOut5:
    CPI   r18, State5
    BRNE  UpdOut6

    LDI   r16, OR_out5
    RJMP  Upd_Out

UpdOut6:
    CPI   r18, State6
    BRNE  UpdOut7

    LDI   r16, OR_out6
    RJMP  Upd_Out

UpdOut7:
    CPI   r18, State7
    BRNE  UpdOut8

    LDI   r16, OR_out7
    RJMP  Upd_Out

UpdOut8:
    CPI   r18, State8
    BRNE  UpdOut9

    LDI   r16, OR_out8
    RJMP  Upd_Out

UpdOut9:
    CPI   r18, State9
    BRNE  UpdOutA

    LDI   r16, OR_out9
    RJMP  Upd_Out

UpdOutA:
    CPI   r18, StateA
    BRNE  UpdOutB

    LDI   r16, OR_outA
    RJMP  Upd_Out

UpdOutB:
    CPI   r18, StateB
    BRNE  UpdOutC

    LDI   r16, OR_outB
    RJMP  Upd_Out

UpdOutC:
    CPI   r18, StateC
    BRNE  UpdOutD

    LDI   r16, OR_outC
    RJMP  Upd_Out

UpdOutD:
    CPI   r18, StateD
    BRNE  UpdOutE

    LDI   r16, OR_outD
    RJMP  Upd_Out

UpdOutE:
    CPI   r18, StateE
    BRNE  UpdOutF

    LDI   r16, OR_outE
    RJMP  Upd_Out

UpdOutF:
    LDI   r16, OR_outF          ; 0b01_0000_00

Upd_Out:
    MOV   tempOut, r16

    SBI   RLY6_Out
    SBIS  S_doRly6
    CBI   RLY6_Out

    IN    r16, RLY_port
    ANDI  r16, ANDouts          ; 0b10_00000_11
    OR    r16, tempOut          ; from OR_out0 to OR_outF
    OUT   RLY_port, r16         ; running relays

UpdOutR:
    RJMP  Vx_end_

;=== ===

Upd_Ovr:
    LDI   tmpState, StHigh      ;  last state
    STS   prvState, tmpState    ; redundant <do>
    STS   curState, tmpState

    CBI   S_doRly6
    CBI   RLY6_Out

    LDI   r16, OR_high
    MOV   tempOut, r16

    IN    r16, RLY_port
    ANDI  r16, ANDouts          ; 0b00000000
    OR    r16, tempOut          ; OR_outF
    OUT   RLY_port, r16         ; over relays

    RJMP  UpdOutR

;=== ===

Upd_Blw:
    CBI   S_doRly6
    CBI   RLY6_Out

    LDI   tmpState, StBoot      ; redundant?
    STS   prvState, tmpState
    STS   curState, tmpState

NO_OUTs:
    IN    r16, RLY_port
    ANDI  r16, ANDouts          ; 0b00_0000_11 [boot state, all relays off] 
    OUT   RLY_port, r16         ; below relays

    RJMP  UpdOutR

;-------------------------------------------------------
; SMPL029 set step digits, Dgt3stp, Dgt2stp, Dgt1stp ***
;-------------------------------------------------------

STEPdgt:
; assume Dgt2stp is blank
    LDI   r17, SEGSblk
    STS   Dgt2stp, r17

    LDS   r18, curState
    CPI   r18, 12
    BRLO  LOWstep

; curState > 11
; Dgt2stp is minus
    LDI   r17, SEGS_md
    STS   Dgt2stp, r17

; r18 = curState - 11 [-1 to -4]
    SUBI  r18, 11
    RJMP  DO_dgt1

;===

LOWstep: 
; r16 = curState - 11 [0 to 11]
    LDI   r16, 11
    SUB   r16, r18
    CPI   r16, 10
    BRLO  DOdgt1C

; curState is 10 or 11
    LDI   r17, SEGS_1_
    STS   Dgt2stp, r17

; r18 = one's = r16 - 10
    SUBI  r16, 10
DOdgt1C:
    MOV   r18, r16
    RJMP  DO_dgt1

;===

DO_dgt1:
    MOV   r16, r18
    RCALL BCD2sgF               ; Z used
    STS   Dgt1stp, r16

STPdgtE:
    LDI   r17, SEGSblk
    SBIS  RLY6_Out

    LDI   r17, SEGS_3L
   
    STS   Dgt3stp, r17
    RJMP  Vx_end_

;-------------------------------------------------------
; SMPL029 set step digits, Dgt3stp, Dgt2stp, Dgt1stp ***
;-------------------------------------------------------

FLPscrn:
    LDS   r18, curState
    LDS   r19, lstState
    CP    r18, r19
    BREQ  FLPscrC  

    LDI   r16, T2_5sec*3/5
    RJMP  FLP2stp

FLPscrC:
    LDS   r16, ScrnDly
    INC   r16
    CPI   r16, T2_5sec
    BRNE  FLPscrE

    CLR   r16
    SBRC  B_stpMod
    RJMP  FLP2vi_

FLP2stp:
    SBR   F_stpMod
    RJMP  FLPscrE

FLP2vi_:
    CBR   F_stpMod

FLPscrE:
    STS   lstState, r18
    STS   ScrnDly, r16
    RJMP  Vx_end_

;---------------------------------------------------------------
; SMPL??1 or SMPL??6 : Show Display for Vi and Vo, or status ***
;---------------------------------------------------------------

SHWdspl:
    MOV   r16, digtN
    CPI   r16, 5                ; end of digit_6
    BREQ  DO_dgts

    RJMP  SHWcnt1

DO_dgts:
    SBIC  S_ftlErr              ; [bug in v20]
    RJMP  SHWcnt0

    SBRS  B_err_Hz
    RJMP  DOdgtsC

    LDI   r16, SEGS__E
    STS   Digt_3, r16
    LDI   r16, SEGS_r_
    STS   Digt_2, r16
    LDI   r16, SEGS_r_
    STS   Digt_1, r16

; assume Hz high
    LDI   r16, SEGSblk
    STS   Digt_6, r16
    LDI   r16, SEGS__H
    STS   Digt_5, r16
    LDI   r16, SEGS__I
    STS   Digt_4, r16

    SBRC  B_HzHigh  
    RJMP  SHWcnt1

; it is low
    LDI   r16, SEGS__L
    STS   Digt_5, r16
    LDI   r16, SEGS_o_
    STS   Digt_4, r16
   
    RJMP  SHWcnt1

SHWcnt0:
    LDS   r16, Dgt1_Vo
    STS   Digt_1, r16
    LDS   r16, Dgt2_Vo
    STS   Digt_2, r16
    LDS   r16, Dgt3_Vo
    STS   Digt_3, r16

    LDS   r16, Dgt1_Vi
    STS   Digt_4, r16
    LDS   r16, Dgt2_Vi
    STS   Digt_5, r16
    LDS   r16, Dgt3_Vi
    STS   Digt_6, r16

    RJMP  SHWcnt1

DOdgtsC:
    LDS   r16, Dgt1_Vo
    STS   Digt_1, r16
    LDS   r16, Dgt2_Vo
    STS   Digt_2, r16
    LDS   r16, Dgt3_Vo
    STS   Digt_3, r16

    SBRS  B_noEEst
    RJMP  DOdgtsV

    SBRC  B_blw_Vi
    RJMP  DOdgtsV

    SBRC  B_stpMod
    RJMP  DOdgtsS

DOdgtsV:
    LDS   r16, Dgt1_Vi
    STS   Digt_4, r16
    LDS   r16, Dgt2_Vi
    STS   Digt_5, r16
    LDS   r16, Dgt3_Vi
    STS   Digt_6, r16
    RJMP  SHWcnt1

DOdgtsS:
    LDS   r16, Dgt1stp
    STS   Digt_4, r16
    LDS   r16, Dgt2stp
    STS   Digt_5, r16
    LDS   r16, Dgt3stp
    STS   Digt_6, r16
;    RJMP  SHWcnt1

;==

SHWcnt1:
    INC   digtN
    MOV   r16, digtN            ; rate = 10*104us = 1ms/dgt, 250Hz 4-dgt
    CPI   r16, 6
    BRNE  SHWcnt2

    CLR   digtN
    CLR   r16

SHWcnt2:
    LDI   YH, high(Digt_1)      ; B3scrnVo=1
    LDI   YL,  low(Digt_1)      ; source as Vo 7seg

SHWdgts:
    LD    r13, Y+               ; Load Indirect of segments
    TST   r16
    BRNE  IS_dgt2

SHWdgt1:
    LDI   r17, DIGIT1on
    RJMP  SHWdEnd

;----

IS_dgt2:
    LD    r13, Y+               ; Load Indirect of segments
    DEC   r16
    BRNE  IS_dgt3

SHWdgt2:
    LDI   r17, DIGIT2on
    RJMP  SHWdEnd

;----

IS_dgt3:
    LD    r13, Y+               ; Load Indirect of segments
    DEC   r16
    BRNE  IS_dgt4

SHWdgt3:
    LDI   r17, DIGIT3on
    RJMP  SHWdEnd

;----

IS_dgt4:
    LD    r13, Y+               ; Load Indirect of segments
    DEC   r16
    BRNE  IS_dgt5

SHWdgt4:
    LDI   r17, DIGIT4on
    RJMP  SHWdEnd

;----

IS_dgt5:
    LD    r13, Y+               ; Load Indirect of segments
    DEC   r16
    BRNE  SHWdgt6

SHWdgt5:
    LDI   r17, DIGIT5on
    RJMP  SHWdEnd

;----

SHWdgt6:
    LD    r13, Y                ; Load Indirect of segments
    LDI   r17, DIGIT6on

SHWdEnd:
ISonOff:
    SBRC  B_ovr_Vi
    RJMP  DOonOff

    SBRC  B_blw_Vi
    RJMP  DOonOff

    SBRC  B_Vo_max
    RJMP  DOonOff

    SBRC  B_Vo_min
    RJMP  DOonOff

    SBIS  S_ftlErr
    RJMP  DSPLoff

DOonOff:
;/* <simu>
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
;*/ ; <simu>
    DEC   dspOff
    BRNE  DSPLoff_

    LDI   r16, X_dspOff
    EOR   R1flags, r16          ; flip F_dspOff

DSPLoff_:
    SBRS  B_dspOff
    RJMP  DSPL_on

    CLR   r13                   ; all off
    RJMP  DSPL_on

DSPLoff:
    SBRS  B_dspOff
    RJMP  DSPL_on

    CLR   r13                   ; all off
;/* <simu>
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
    DEC   dspOff
;*/ ; <simu>
    DEC   DspOff
    BRNE  DSPL_on

    CBR   F_dspOff              ; DspOff=0, offtime=256*10*104us=266ms

;===

DSPL_on:
    IN    r16, DGTport          ; DDRB
    ANDI  r16, DIGITSof         ; 0b11000000, [turn off all 6 digits]
    OUT   DGTport, r16          ; DDRB

    NOP
    OUT   SEGport, r13          ; set 7-seg outs, DDRD

; r16=DGTport, r17=DIGIT?on
    OR    r16, r17              ; turn on digit
    OUT   DGTport, r16

    SBIC  S_ftlErr              ; if fatal error
    RET

    RJMP  Vx_end_

;==========================================
;==========================================
;==========================================

CHECKhz:
    LDI   r17, (1<<INTF1|1<<INTF0)
    RJMP  CHKhzNo

Vx_end_:
; increment curSplVx
    LDS   r16, curSplVx
    INC   r16
    STS   curSplVx, r16

; if curSplVx=0 [curSplVx=256], goto CHECKhz:
    BREQ  CHECKhz

; call Vx_sum1 [sum1VxU\H\L = sum1VxU\H\L + ADCrd_H\L]
    RCALL Vx_sum1

;==========================================

CHCK_Hz:
; if INTF1=0, goto END_act:
    IN    r17, GIFR
    SBRS  r17, INTF1
    RJMP  END_act

CHKhzNo:
; reset INT1 interrupt flag
    OUT   GIFR, r17

; [assume signal Hz error, Hz low]
    CBR   F_HzHigh

; if (r16=curSplVx) > MIN_smpl [148, F < 64.9 Hz], goto CHK_HzC:
    LDS   r16, curSplVx
    CPI   r16, MIN_smpl
    BRSH  CHK_HzC

; [signal Hz error, Hz high]
    SBR   F_HzHigh

HZerror:
; F_err_Hz=1, [see F_HzHigh]
    SBR   F_err_Hz

    RCALL VxReset

; decrement errHzDly (init as 10), if 0 , goto RESET:
    LDS   r16, errHzDly
    DEC   r16
    STS   errHzDly, r16
    BRNE  CHK_HzE

    RJMP  RESET                 ; mains Hz error, no voltage

CHK_HzC:
; if (r16=curSplVx) > MAX_smpl [240, F < 40.0 Hz], goto HZerror:
    CPI   r16, MAX_smpl
    BRSH  HZerror               ; Reset after 

HZ_okay:
; lstSplVx=curSplVx [save last count of samples of the cycle]
    STS   lstSplVx, r16

; F_err_Hz=0 [signal Hz is normal]
    CBR   F_err_Hz

; errHzDly=HZerrDly=10 [reset Hz error counter]
    LDI   r16, HZerrDly
    STS   errHzDly, r16

;====

CHK_HzE:
; clear counter of Vx samples
    CLR   r16
    STS   curSplVx, r16

; prepare for ADMUX
    LDS   r16, ADCport
    CPI   r16, ADC_Vi
    BRNE  DOadcVi

DOadcVo:
    LDI   r16, ADC_Vo
    RJMP  CHKskip

DOadcVi:
    LDI   r16, ADC_Vi

CHKskip:
    STS   ADCport, r16

    IN    r17, ADMUX
    ANDI  r17, 0xF0
    OR    r17, r16
; ADMUX=L_2V56+ADC_Vx [2V56, right adjusted, ADCport]
    OUT   ADMUX, r17

; goto END_act:
    RJMP  END_act

;==========================================
;==========================================
;==========================================

Vx_sum1:
    LDS   r16, sum1VxL
    ADD   r16, ADCrd_L
    STS   sum1VxL, r16

    LDS   r16, sum1VxH
    ADC   r16, ADCrd_H
    STS   sum1VxH, r16

    LDS   r16, sum1VxU
    CLR   r17
    ADC   r16, r17
    STS   sum1VxU, r16

    RET

;=============

VxReset:
; VxCyclC=CYCLnmbr [reset counter of Vx average cycles]
    LDI   r16, CYCLnmbr
    MOV   VxCyclC, r16

; curSplVx=sum1VxU\H\L=sum2ViH\L=0
    CLR   r16
    STS   curSplVx, r16

    STS   sum1VxU, r16
    STS   sum1VxH, r16
    STS   sum1VxL, r16

    STS   sum2ViH, r16
    STS   sum2ViL, r16

    STS   sum2VoH, r16
    STS   sum2VoL, r16

    RET

;==========================================
;==========================================

;--------------------------
; *R* EE initialization ***
;--------------------------

; upload SIGNAT2 [16B]
; upload Vi_2bcd [2B], in EE if fresh
; upload Vo_2bcd [2B], in EE if fresh

; Vi_2bcd=  26852= 0x68E4= gainVi_H\L , ADDRvi_h = 0x0010, [H] then [L]
; Vo_2bcd=  16757= 0x4175= gainVo_H\L , ADDRvo_h = 0x0020, [H] then [L]

EE_init:
    RCALL EE_wait               ; just in case

    CLR   r16
    OUT   EEARH, r16            ; always 0 , EEARH\L < 256

    LDI   r16, 1
    OUT   EEARL, r16            ; check 0x0001 instead of 0x0000

    SBI   EECR, EERE
    IN    r17, EEDR
    CPI   r17, 0xFF
    BRNE  EEiniRt

    LDI   ZH, high(SIGNAT2*2)
    LDI   ZL,  low(SIGNAT2*2)

    LDI   r19, 16               ; to save 16 characters
    CLR   r16

SIGN_lp:
    OUT   EEARL, r16            ; start at 0x0000
    LPM   r17, Z+               ; load Indirect
    RCALL SV_byte

    INC   r16                   ; address of currG_L, 0x0011
    DEC   r19
    BRNE  SIGN_lp

EEiniVi:
    LDI   r16, ADDRvi_h         ; address of gainVi_H, 0x0010
    OUT   EEARL, r16
    LDI   r17, high(Vi_2bcd)
    RCALL SV_byte

    INC   r16                   ; address of gainVi_L, 0x0011
    OUT   EEARL, r16
    LDI   r17, low(Vi_2bcd)
    RCALL SV_byte

;===

    LDI   r16, ADDRvo_h         ; address of gainVo_H, 0x0020
    OUT   EEARL, r16
    LDI   r17, high(Vo_2bcd)
    RCALL SV_byte

    INC   r16                   ; address of gainVo_L, 0x0021
    OUT   EEARL, r16
    LDI   r17, low(Vo_2bcd)

;=== ===

SV_byte:
    OUT   EEARL, r16
    OUT   EEDR, r17
    CLI                         ; disable interrupts during timed sequence
    SBI   EECR, EEMWE           ; enable EEPROM write
    SBI   EECR, EEWE            ; start EEPROM write
    SEI                         ; re-enable interrupts

EE_wait:
    SBIC  EECR, EEWE            ; wait to end previous saving
    RJMP  EE_wait

EEiniRt:
    RET

;-------------------------------------------------------------------
; *R* load input voltage gains, gainVi_H\L & gainVo_H\L, from EE ***
;-------------------------------------------------------------------

RD_Vx_G:
    RCALL EE_wait               ; redundant

    CLR   r18
    OUT   EEARH, r18

RD_Vi:
    LDI   r18, ADDRvi_h
    RCALL RD_Vx
    STS   gainVi_H, r17
    STS   gainVi_L, r16

RD_Vo:
    LDI   r18, ADDRvo_h
    RCALL RD_Vx
    STS   gainVo_H, r17
    STS   gainVo_L, r16

    RET

RD_Vx:
    OUT   EEARL, r18            ; address of gainV?_H
    SBI   EECR, EERE
    IN    r17, EEDR
    INC   r18
    OUT   EEARL, r18            ; address of gainV?_L
    SBI   EECR, EERE
    IN    r16, EEDR
    RET

;==========================================
;==========================================

END_act:
; goto MAIN_lp
    RJMP  MAIN_lp

;==========================================
;==========================================
;==========================================

;==================================================
; Division 24/16, 429 cycles, rounding r2:r1:r0 ***
;==================================================
; dividend : r18:r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r2:r1:r0 , 414 cycles
; maximum tested 414 cycles + 15 for rounding

; if division 24/8, r20=0

; 12 bytes + SREG (in case PUSH and POP)

D24u16rd:
    CLR   r13
    SUB   r14, r14              ; to clear carry
    LDI   r21, 25
    RJMP  D24u16u1

D24u16u2:
    ROL   r13
    ROL   r14
    SUB   r13, r19
    SBC   r14, r20
    BRCC  D24u16u3

    ROL   r0
    ROL   r1
    ROL   r2
    ADD   r13, r19
    ADC   r14, r20
D24u16u1:
    ROL   r16
    ROL   r17
    ROL   r18
    DEC   r21
    BRNE  D24u16u2

    COM   r0
    COM   r1
    COM   r2

; rounding begin
    LSR   r20
    ROR   r19
    CP    r19, r13
    CPC   r20, r14
    BRPL  D24u16uR              ; if divisor/2 > remainder, skip rounding

    INC   r0                    ; add 1 to resultL
    BRNE  D24u16uR              ; if resultL becomes 0, resultH+1

    INC   r1
    BRNE  D24u16uR              ; if resultH not zero, skip

    INC   r2
    BRNE  D24u16uR              ; if resultU not zero, skip

    DEC   r2
    DEC   r1
    DEC   r0
D24u16uR:
; rounding end
    RET

D24u16u3:
    ROL   r0
    ROL   r1
    ROL   r2
    RJMP  D24u16u1

;==========================================
;==========================================

; 4:11 PM 8/12/2017
;===============================================
; Division 16/16, 280 cycles, rounding r1:r0 ***
;===============================================
; dividend : r17:r16
; divisor  : r20:r19
; remainder: r14:r13
; loopCount: r21
; result   : r1:r0, 280 cycles

; if division 16/8, r19=0

D16u16rd:
    CLR   r13
    SUB   r14, r14              ; to clear carry
    LDI   r21, 17
    RJMP  D16u16u1

D16u16u2:
    ROL   r13
    ROL   r14
    SUB   r13, r19
    SBC   r14, r20
    BRCC  D16u16u3

    ROL   r0
    ROL   r1
    ADD   r13, r19
    ADC   r14, r20
D16u16u1:
    ROL   r16
    ROL   r17
    DEC   r21
    BRNE  D16u16u2

    COM   r0
    COM   r1

    CLC
    ROR   r20                   ; carry=0
    ROR   r19
    CP    r19, r13
    CPC   r20, r14
    BRSH  D16u16uR              ; if divisor/2 > remainder, skip rounding

    INC   r0                    ; add 1 to resultL
    BRNE  D16u16uR              ; if resultL becomes 0, resultH+1

    INC   r1
    BRNE  D16u16uR              ; if resultH not zero, skip

    DEC   r1
    DEC   r0
D16u16uR:
    RET

D16u16u3:
    ROL   r0
    ROL   r1
    RJMP  D16u16u1

;==========================================

; [ 16x16 Bit Unsigned Multiplication ]
; multiplicand: r17:r16
; multiplier  : r14:r13
; result out  : r21:r20:r19:r18
; see mul16x16_32_AL.txt
; 24 cycles + 2
SQ16x16:
    MOV   r14, r17              ; copy for squaring
    MOV   r13, r16
M_16x16:
    MUL   r17, r14              ; ah * bh
    MOVW  r21:r20, r1:r0
    MUL   r16, r13              ; al * bl
    MOVW  r19:r18, r1:r0
    MUL   r17, r13              ; ah * bl
    CLR   r13
    ADD   r19, r0
    ADC   r20, r1
    ADC   r21, r13
    MUL   r14, r16              ; bh * al
    ADD   r19, r0
    ADC   r20, r1
    ADC   r21, r13
    RET

;====================================
; *R14* quasi-decimal binary to BCD ***
;====================================
; input: R17, R16 = 16 bit; value 0 to 65535
;output: R20, R19, R18, R17, R16 = 5 digits (ASCII)
;cycles: 20 ... 170

DEC2BCD:
    LDI   r20, -1               ; -1 will be 0 at first pass
_bcd1:
    INC   r20
    SUBI  r16, low(10000)       ; -10000 because r17:r16 positive
    SBCI  r17, high(10000)
    BRCC  _bcd1
;---
    LDI   r19, 10               ; 10 will be 9 at first pass
_bcd2:
    DEC   r19
    SUBI  r16, low(-1000)       ; +1000 because r17:r16 negative
    SBCI  r17, high(-1000)
    BRCS  _bcd2
;---
    LDI   r18, -1               ; -1 will be 0 at first pass
_bcd3:
    INC   r18
    SUBI  r16, low(100)         ; -100 because r17:r16 positive
    SBCI  r17, high(100)
    BRCC  _bcd3
;---
    LDI   r17, 10               ; 10 will be 9 at first pass
_bcd4:
    DEC   r17
    SUBI  r16, -10              ; +10 because r17:r16 negative
    BRCS  _bcd4

    RET                         ; r17:r16 positive

;=======================================
; *** digit in BIN to digit in 7-seg ***
;=======================================
;  in: r16
; usd: Z
; out: r16

BCD2sgF:
    LDI   ZH, high(DIGTtbl*2)   ; table must start at 0x--00
    MOV   ZL, r16               ; digit in hex (0-F)
    ANDI  ZL, 0x0F              ; just in case
    LPM   r16, Z                ; load Indirect as 7seg from table
    RET                         ; or LPM only to r0 if r16 is important

;==============================
; *** check mains frequency ***
;==============================

INI_Hz_:
    IN    r18, GIFR
    OUT   GIFR, r18
    SER   loopHi

INIwait:
; dimming LED loop if no mains
    INC   loopHi
    CBI   Mid_Out
    CPI   loopHi, 25
    BRSH  INIwtC1

    SBI   Mid_Out

INIwtC1:
    IN    r18, GIFR
    SBRS  r18, INTF1
    RJMP  INIwait

;===
; reset mains interrupt
    OUT   GIFR, r18

; 64 mains cycles, about 1.25 sec
;    LDI   loopHi, 64 ; <noSimu>
    LDI   loopHi, 8  ; <simu>
INI_lp0:
    LDI   r17, 130
    CLR   r16
INI_lp1:
; (6a*255 + 8b)*130*1/8MHz = 24992.5 us = 25 ms [F>40Hz]
    IN    r18, GIFR             ;1a,1b
    SBRC  r18, INTF1            ;2a,2b
    RJMP  INIlp1E

    DEC   r16                   ;1a,1b
    BRNE  INI_lp1               ;2a,1b

    DEC   r17                   ;  ,1b
    BRNE  INI_lp1               ;  ,2b

    RJMP  RESET

INIlp1E:
    OUT   GIFR, r18

    SBRC  loopHi, 2
    RJMP  LED_off

    SBI   Mid_Out
    RJMP  LED_cnt

LED_off:
    CBI   Mid_Out
    NOP
LED_cnt:
; 130-78 = 52
; (6a*255 + 8b)*78*1/8MHz = 14995.5 us = 15 ms [F<66Hz]
    CPI   r17, 130-78
    BRLO  INIlp1C

    RJMP  RESET

INIlp1C:
    DEC   loopHi
    BRNE  INI_lp0

    RET

;=================================
; *** set all digits by r16 ***
;=================================

DGTsAll:
    STS   Dgt1_Vo, r16
    STS   Dgt2_Vo, r16
    STS   Dgt3_Vo, r16
    
    STS   Dgt1_Vi, r16
    STS   Dgt2_Vi, r16
    STS   Dgt3_Vi, r16

    RET

;=============================
; *** signal fatal errors ***
;=============================

; Vo BCD > 999 , goto FTLerr7:
FTLerr7:
    LDI   r16, SEGS_7_          ; 0x45
    RJMP  FTLerr0

; Vi BCD > 999 , goto FTLerr6:
FTLerr6:
    LDI   r16, SEGS_6_          ; 0xF6
    RJMP  FTLerr0

; gainVo_H\L > 65535
FTLerr5:
    LDI   r16, SEGS_5_          ; 0xE6
    RJMP  FTLerr0

; gainVi_H\L > 65535
FTLerr4:
    LDI   r16, SEGS_4_          ; 0xC3
    RJMP  FTLerr0

; Vo average of one cycle > 1023
FTLerr3:
    LDI   r16, SEGS_3_          ; 0xE5
    RJMP  FTLerr0

; Vi average of one cycle > 1023
FTLerr2:
    LDI   r16, SEGS_2_          ; 0xB5
    RJMP  FTLerr0

; Vi ~< 80Vac
FTLerr1:
    LDI   r16, SEGS_1_          ; 0x41

FTLerr0:
    STS   Dgt2_Vi, r16
    RCALL RSTprts

    LDI   r16, SEGSblk
    STS   Dgt3_Vi, r16
    STS   Dgt1_Vi, r16

    LDI   r16, SEGS__E
    STS   Dgt3_Vo, r16

    LDI   r16, SEGS_r_
    STS   Dgt2_Vo, r16
    STS   Dgt1_Vo, r16

    SBI   S_ftlErr

FTLloop:
    LDI   r17, 2
    RCALL DLYmSec

    RCALL SHWdspl
    RJMP  FTLloop

;========================
; *** reset all ports ***
;========================

RSTprts:
; DDRB=DDRBini0
    LDI   r16, DDRBini0
    OUT   DDRB, r16
; PORTB=PRTBini0
    LDI   r16, PRTBini0
    OUT   PORTB, r16

; DDRC=DDRCini0
    LDI   r16, DDRCini0
    OUT   DDRC, r16
; PORTC=PRTCini0
    LDI   r16, PRTCini0
    OUT   PORTC, r16

; DDRD=DDRDini0
    LDI   r16, DDRDini0
    OUT   DDRD, r16
; PORTD=PRTDini0
    LDI   r16, PRTDini0
    OUT   PORTD, r16

    RET

;----------------------------------
;----------------------------------
; *R* Delay, multiple of 1 msec *** 8 MHz
;----------------------------------
;----------------------------------
; r17 = t (ms)
; used and then restored: r16 and r17
; delay= [ (28+3)*256 + (4+3*20) ] * 250 * 0.125 = 250 ms

DLYqSec:                        ;+2c call
    PUSH   r17                  ; 2c, added
    LDI    r17, 250             ; 1c
    RJMP   DLYsecC              ; 2c, added

DLYmSec:
    PUSH   r17                  ; 2c, added
DLYsecC:
    PUSH   r16                  ; 2c, added
DLYsecL:
    CLR    r16                  ; 1c
DlyM_lp:
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    NOP                         ; 1c
    DEC   r16                   ; 1c
    BRNE  DlyM_lp               ; 2/1c

    LDI   r16, 20               ; 1c
    NOP                         ; 1c, added for timing
INNERlp:
    DEC   r16                   ; 1c
    BRNE  INNERlp               ; 2/1c

    DEC   r17                   ; 1c
    BRNE  DLYsecL               ; 2/1c

    POP   r16                   ; 2c, added
    POP   r17                   ; 2c, added
    RET                         ; 4c

;====================================================================
;====================================================================
;====================================================================

;---------------
; *** Tables ***
;---------------

    .org 0x0E00


;D:\KiCad\Projects\StoreCir\REG_mix\REG_mix_09, {A30}

; D:\L500\Koko_all\Work\projects\Utility\ASM-7Seg_dspl.xlsx
; sheet "A30" for extended symbols, PCB: A30,A31
DIGTtbl:
;        gcdepbfa
   .db 0b01110111, 0b01000100 ; 0  , 0x77  ; 1  , 0x44
   .db 0b10110101, 0b11100101 ; 2  , 0xB5  ; 3  , 0xE5
   .db 0b11000110, 0b11100011 ; 4  , 0xC6  ; 5  , 0xE3
   .db 0b11110011, 0b01000101 ; 6  , 0xF3  ; 7  , 0x45
   .db 0b11110111, 0b11100111 ; 8  , 0xF7  ; 9  , 0xE7

; D:\L500\Koko_all\Work\projects\Utility\ASM-7Seg_dspl.xlsx
; sheet "symb_A30" for extended symbols, PCB: A30,31
Symbols:
;                gcdepbfa
.equ SEGS_0_ = 0b01110111 ; 0x77
.equ SEGS_1_ = 0b01000100 ; 0x44
.equ SEGS_2_ = 0b10110101 ; 0xB5
.equ SEGS_3_ = 0b11100101 ; 0xE5
.equ SEGS_4_ = 0b11000110 ; 0xC6
.equ SEGS_5_ = 0b11100011 ; 0xE3
.equ SEGS_6_ = 0b11110011 ; 0xF3
.equ SEGS_7_ = 0b01000101 ; 0x45
.equ SEGS_8_ = 0b11110111 ; 0xF7
.equ SEGS_9_ = 0b11100111 ; 0xE7
.equ SEGSblk = 0b00000000 ; 0x00
.equ SEGS_lo = 0b00100000 ; 0x20
.equ SEGS_md = 0b10000000 ; 0x80
.equ SEGS_hi = 0b00000001 ; 0x01
.equ SEGS__L = 0b00110010 ; 0x32
.equ SEGS__H = 0b11010110 ; 0xD6
.equ SEGS__E = 0b10110011 ; 0xB3
.equ SEGS_r_ = 0b10010000 ; 0x90
.equ SEGS_u_ = 0b01110000 ; 0x70
.equ SEGS_t_ = 0b10110010 ; 0xB2
.equ SEGS_o_ = 0b11110000 ; 0xF0
.equ SEGS__I = 0b00010010 ; 0x12
.equ SEGS__C = 0b00110011 ; 0x33
.equ SEGS_c_ = 0b10110000 ; 0xB0
.equ SEGS_d_ = 0b11110100 ; 0xF4
.equ SEGS__U = 0b01110110 ; 0x76
.equ SEGS__A = 0b11010111 ; 0xD7
.equ SEGS_n_ = 0b11010000 ; 0xD0
.equ SEGS__F = 0b10010011 ; 0x93
.equ SEGS_b_ = 0b11110010 ; 0xF2
.equ SEGS_3L = 0b10100001 ; 0xA1

;-----------------------
; *** Indirect jumps ***
;-----------------------
    .org 0x0F00

SVx_000: RJMP  SHWdspl ;

SVx_001: RJMP  Vx_new_ ; average of [Vi] and [Vo] in one cycle
SVx_002: RJMP  Vi_avg_ ; average [Vi] in interval
SVx_003: RJMP  Vo_avg_ ; average [Vo] in interval
SVx_004: RJMP  Vi_bcd_ ; binary-bcd of interval [Vi]
SVx_005: RJMP  Vo_bcd_ ; binary-bcd of interval [Vo]

SVx_006: RJMP  SHWdspl ;

SVx_007: RJMP  Vx_key_ ; sense Vx key
SVx_008: RJMP  Vi_set_ ; set new [Vi] gain
SVx_009: RJMP  Vo_set_ ; set new [Vo] gain
SVx_010: RJMP  Vi_sav_ ; save new [Vi] gain on EE

SVx_011: RJMP  SHWdspl ;

SVx_012: RJMP  Vo_sav_ ; save new [Vo] gain on EE
SVx_013: RJMP  Vx_end_ ;
SVx_014: RJMP  Vx_end_ ;
SVx_015: RJMP  Vx_end_ ;

SVx_016: RJMP  SHWdspl ;

SVx_017: RJMP  Vx_end_ ;
SVx_018: RJMP  Vx_end_ ;
SVx_019: RJMP  Vx_end_ ;
SVx_020: RJMP  Vx_end_ ;

SVx_021: RJMP  SHWdspl ;

SVx_022: RJMP  Vx_end_ ;
SVx_023: RJMP  LVLhiVi ;
SVx_024: RJMP  LVLloVi ;
SVx_025: RJMP  FNDlvl1 ;

SVx_026: RJMP  SHWdspl ;

SVx_027: RJMP  DO_job_ ;

#ifdef delay_0
SVx_028: RJMP  UpdtOut ;
#endif ; delay_0

#ifndef delay_0
SVx_028: RJMP  Vx_end_ ;
#endif ; delay_0

SVx_029: RJMP  STEPdgt ;
SVx_030: RJMP  FLPscrn ;

SVx_031: RJMP  SHWdspl ;

SVx_032: RJMP  Vx_end_ ;
SVx_033: RJMP  Vx_end_ ;
SVx_034: RJMP  Vx_end_ ;

#ifdef delay_1
SVx_035: RJMP  UpdtOut ;
#endif ; delay_0

#ifndef delay_1
SVx_035: RJMP  Vx_end_ ;
#endif ; delay_0

SVx_036: RJMP  SHWdspl ;

SVx_037: RJMP  Vx_end_ ;
SVx_038: RJMP  Vx_end_ ;
SVx_039: RJMP  Vx_end_ ;
SVx_040: RJMP  Vx_end_ ;

SVx_041: RJMP  SHWdspl ;

SVx_042: RJMP  Vx_end_ ;
SVx_043: RJMP  Vx_end_ ;
SVx_044: RJMP  Vx_end_ ;
SVx_045: RJMP  Vx_end_ ;

SVx_046: RJMP  SHWdspl ;

SVx_047: RJMP  Vx_end_ ;
SVx_048: RJMP  Vx_end_ ;
SVx_049: RJMP  Vx_end_ ;
SVx_050: RJMP  Vx_end_ ;

SVx_051: RJMP  SHWdspl ;

SVx_052: RJMP  Vx_end_ ;
SVx_053: RJMP  Vx_end_ ;
SVx_054: RJMP  Vx_end_ ;
SVx_055: RJMP  Vx_end_ ;

SVx_056: RJMP  SHWdspl ;

SVx_057: RJMP  Vx_end_ ;
SVx_058: RJMP  Vx_end_ ;
SVx_059: RJMP  Vx_end_ ;
SVx_060: RJMP  Vx_end_ ;

SVx_061: RJMP  SHWdspl ;

SVx_062: RJMP  Vx_end_ ;
SVx_063: RJMP  Vx_end_ ;
SVx_064: RJMP  Vx_end_ ;
SVx_065: RJMP  Vx_end_ ;

SVx_066: RJMP  SHWdspl ;

SVx_067: RJMP  Vx_end_ ;
SVx_068: RJMP  Vx_end_ ;
SVx_069: RJMP  Vx_end_ ;
SVx_070: RJMP  Vx_end_ ;

SVx_071: RJMP  SHWdspl ;

SVx_072: RJMP  Vx_end_ ;
SVx_073: RJMP  Vx_end_ ;
SVx_074: RJMP  Vx_end_ ;
SVx_075: RJMP  Vx_end_ ;

SVx_076: RJMP  SHWdspl ;

SVx_077: RJMP  Vx_end_ ;
SVx_078: RJMP  Vx_end_ ;
SVx_079: RJMP  Vx_end_ ;
SVx_080: RJMP  Vx_end_ ;

SVx_081: RJMP  SHWdspl ;

SVx_082: RJMP  Vx_end_ ;
SVx_083: RJMP  Vx_end_ ;
SVx_084: RJMP  Vx_end_ ;
SVx_085: RJMP  Vx_end_ ;

SVx_086: RJMP  SHWdspl ;

SVx_087: RJMP  Vx_end_ ;
SVx_088: RJMP  Vx_end_ ;
SVx_089: RJMP  Vx_end_ ;
SVx_090: RJMP  Vx_end_ ;

SVx_091: RJMP  SHWdspl ;

SVx_092: RJMP  Vx_end_ ;
SVx_093: RJMP  Vx_end_ ;
SVx_094: RJMP  Vx_end_ ;
SVx_095: RJMP  Vx_end_ ;

SVx_096: RJMP  SHWdspl ;

SVx_097: RJMP  Vx_end_ ;
SVx_098: RJMP  Vx_end_ ;
SVx_099: RJMP  Vx_end_ ;
SVx_100: RJMP  Vx_end_ ;

SVx_101: RJMP  SHWdspl ;

SVx_102: RJMP  Vx_end_ ;
SVx_103: RJMP  Vx_end_ ;
SVx_104: RJMP  Vx_end_ ;
SVx_105: RJMP  Vx_end_ ;

SVx_106: RJMP  SHWdspl ;

SVx_107: RJMP  Vx_end_ ;
SVx_108: RJMP  Vx_end_ ;
SVx_109: RJMP  Vx_end_ ;
SVx_110: RJMP  Vx_end_ ;

SVx_111: RJMP  SHWdspl ;

SVx_112: RJMP  Vx_end_ ;
SVx_113: RJMP  Vx_end_ ;
SVx_114: RJMP  Vx_end_ ;
SVx_115: RJMP  Vx_end_ ;

SVx_116: RJMP  SHWdspl ;

SVx_117: RJMP  Vx_end_ ;
SVx_118: RJMP  Vx_end_ ;
SVx_119: RJMP  Vx_end_ ;
SVx_120: RJMP  Vx_end_ ;

SVx_121: RJMP  SHWdspl ;

SVx_122: RJMP  Vx_end_ ;
SVx_123: RJMP  Vx_end_ ;
SVx_124: RJMP  Vx_end_ ;
SVx_125: RJMP  Vx_end_ ;

SVx_126: RJMP  SHWdspl ;

SVx_127: RJMP  Vx_end_ ;
SVx_128: RJMP  Vx_end_ ;
SVx_129: RJMP  Vx_end_ ;
SVx_130: RJMP  Vx_end_ ;

SVx_131: RJMP  SHWdspl ;

SVx_132: RJMP  Vx_end_ ;
SVx_133: RJMP  Vx_end_ ;
SVx_134: RJMP  Vx_end_ ;
SVx_135: RJMP  Vx_end_ ;

SVx_136: RJMP  SHWdspl ;

SVx_137: RJMP  Vx_end_ ;
SVx_138: RJMP  Vx_end_ ;
SVx_139: RJMP  Vx_end_ ;
SVx_140: RJMP  Vx_end_ ;

SVx_141: RJMP  SHWdspl ;

SVx_142: RJMP  Vx_end_ ;
SVx_143: RJMP  Vx_end_ ;
SVx_144: RJMP  Vx_end_ ;
SVx_145: RJMP  Vx_end_ ;

SVx_146: RJMP  SHWdspl ;

SVx_147: RJMP  Vx_end_ ;
SVx_148: RJMP  Vx_end_ ;
SVx_149: RJMP  Vx_end_ ;
SVx_150: RJMP  Vx_end_ ;

SVx_151: RJMP  SHWdspl ;

SVx_152: RJMP  Vx_end_ ;
SVx_153: RJMP  Vx_end_ ;
SVx_154: RJMP  Vx_end_ ;
SVx_155: RJMP  Vx_end_ ;

SVx_156: RJMP  SHWdspl ;

SVx_157: RJMP  Vx_end_ ;
SVx_158: RJMP  Vx_end_ ;
SVx_159: RJMP  Vx_end_ ;
SVx_160: RJMP  Vx_end_ ;

SVx_161: RJMP  SHWdspl ;

SVx_162: RJMP  Vx_end_ ;
SVx_163: RJMP  Vx_end_ ;
SVx_164: RJMP  Vx_end_ ;
SVx_165: RJMP  Vx_end_ ;

SVx_166: RJMP  SHWdspl ;

SVx_167: RJMP  Vx_end_ ;
SVx_168: RJMP  Vx_end_ ;
SVx_169: RJMP  Vx_end_ ;
SVx_170: RJMP  Vx_end_ ;

SVx_171: RJMP  SHWdspl ;

SVx_172: RJMP  Vx_end_ ;
SVx_173: RJMP  Vx_end_ ;
SVx_174: RJMP  Vx_end_ ;
SVx_175: RJMP  Vx_end_ ;

SVx_176: RJMP  SHWdspl ;

SVx_177: RJMP  Vx_end_ ;
SVx_178: RJMP  Vx_end_ ;
SVx_179: RJMP  Vx_end_ ;
SVx_180: RJMP  Vx_end_ ;

SVx_181: RJMP  SHWdspl ;

SVx_182: RJMP  Vx_end_ ;
SVx_183: RJMP  Vx_end_ ;
SVx_184: RJMP  Vx_end_ ;
SVx_185: RJMP  Vx_end_ ;

SVx_186: RJMP  SHWdspl ;

SVx_187: RJMP  Vx_end_ ;
SVx_188: RJMP  Vx_end_ ;
SVx_189: RJMP  Vx_end_ ;
SVx_190: RJMP  Vx_end_ ;

SVx_191: RJMP  SHWdspl ;

SVx_192: RJMP  Vx_end_ ;
SVx_193: RJMP  Vx_end_ ;
SVx_194: RJMP  Vx_end_ ;
SVx_195: RJMP  Vx_end_ ;

SVx_196: RJMP  SHWdspl ;

SVx_197: RJMP  Vx_end_ ;
SVx_198: RJMP  Vx_end_ ;
SVx_199: RJMP  Vx_end_ ;
SVx_200: RJMP  Vx_end_ ;

SVx_201: RJMP  SHWdspl ;

SVx_202: RJMP  Vx_end_ ;
SVx_203: RJMP  Vx_end_ ;
SVx_204: RJMP  Vx_end_ ;
SVx_205: RJMP  Vx_end_ ;

SVx_206: RJMP  SHWdspl ;

SVx_207: RJMP  Vx_end_ ;
SVx_208: RJMP  Vx_end_ ;
SVx_209: RJMP  Vx_end_ ;
SVx_210: RJMP  Vx_end_ ;

SVx_211: RJMP  SHWdspl ;

SVx_212: RJMP  Vx_end_ ;
SVx_213: RJMP  Vx_end_ ;
SVx_214: RJMP  Vx_end_ ;
SVx_215: RJMP  Vx_end_ ;

SVx_216: RJMP  SHWdspl ;

SVx_217: RJMP  Vx_end_ ;
SVx_218: RJMP  Vx_end_ ;
SVx_219: RJMP  Vx_end_ ;
SVx_220: RJMP  Vx_end_ ;

SVx_221: RJMP  SHWdspl ;

SVx_222: RJMP  Vx_end_ ;
SVx_223: RJMP  Vx_end_ ;
SVx_224: RJMP  Vx_end_ ;
SVx_225: RJMP  Vx_end_ ;

SVx_226: RJMP  SHWdspl ;

SVx_227: RJMP  Vx_end_ ;
SVx_228: RJMP  Vx_end_ ;
SVx_229: RJMP  Vx_end_ ;
SVx_230: RJMP  Vx_end_ ;

SVx_231: RJMP  SHWdspl ;

SVx_232: RJMP  Vx_end_ ;
SVx_233: RJMP  Vx_end_ ;
SVx_234: RJMP  Vx_end_ ;
SVx_235: RJMP  Vx_end_ ;

SVx_236: RJMP  SHWdspl ;

SVx_237: RJMP  Vx_end_ ;
SVx_238: RJMP  Vx_end_ ;
SVx_239: RJMP  Vx_end_ ;
SVx_240: RJMP  Vx_end_ ;

SVx_241: RJMP  SHWdspl ;

SVx_242: RJMP  Vx_end_ ;
SVx_243: RJMP  Vx_end_ ;
SVx_244: RJMP  Vx_end_ ;
SVx_245: RJMP  Vx_end_ ;

SVx_246: RJMP  SHWdspl ;

SVx_247: RJMP  Vx_end_ ;
SVx_248: RJMP  Vx_end_ ;
SVx_249: RJMP  Vx_end_ ;
SVx_250: RJMP  Vx_end_ ;

SVx_251: RJMP  SHWdspl ;

SVx_252: RJMP  Vx_end_ ;
SVx_253: RJMP  Vx_end_ ;
SVx_254: RJMP  Vx_end_ ;
SVx_255: RJMP  Vx_end_ ;

;====
;.ESEG
;====

;    .org 0x0000

; see EE_init: 
;0x0000: .db 16-byte SIGNAT2
;0x0010: .db gainVi_H ,gainVi_L,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
;0x0020: .db gainVo_H ,gainVo_L,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF

;initial gains for VltAdjt = 22000 = 0x55F0
; @ADDRvi_h, gainVi_H\L = Vi_2bcd = 7635 = 0x1DD3 
; @ADDRvo_h, gainVo_H\L = Vo_2bcd = 7635 = 0x1DD3

.exit

#ifdef MCUinfo

; <do>
; D:\L500\AVRprojects\ATmega8\Projects_62\REGULATOR\REG_5BD\REG_5BD_02.bat
rem
rem internal RC , 8.0 MHz
rem
rem
rem
rem 6 ck + 65 ms, slowly rising power
rem Brown-out Detection enabled
rem BOD(bot)=4V
rem
rem Reset at 0x0000
rem Bootsize 1024 words 32 pages
rem Chip Erase erases EEPROM
rem
rem disable Serial Downloading
rem WDT turns on by Software only
rem PC6 for I/O pin
rem
rem No further programming & reading
rem LPM only is allowed from BLS to ApS
rem LPM only is allowed from ApS to BLS

#endif ; MCUinfo

/*
;----------------------------------------------------------------------
; DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT - DRAFT
;----------------------------------------------------------------------



*/
