// LED MATRIX COUNTER, 6 DIGITS 7X3. DEFRAN 24.

#include <U8g2lib.h>
U8G2_MAX7219_32X8_F_4W_SW_SPI u8g2(U8G2_R0,8,7,6,U8X8_PIN_NONE,U8X8_PIN_NONE); // clock, data, cs, DC, RESET
byte digits[6]={0,0,0,0,0,0};      // DIGITS 7X3 MATRIX
byte offsetPerc[6]={0,0,0,0,0,0};  // OFFSET MATRIX
char Char[2];                      // STYLE
char CharNext[2];                  // STORING STYLE
float Offset;                      // OFFSET CHAR
int Selv=1;
int pre=1;
int Sel=4;
int Rese=5;
int Mon=13;

void setup(void) 
{
  u8g2.begin();
  u8g2.setContrast(15*16);                    // LED BRIGHT
  u8g2.setFont(u8g2_font_minuteconsole_tr);	  // FONT FOR 7x3
  pinMode(Sel, INPUT_PULLUP);                 // SELECTOR
  pinMode(Rese, INPUT_PULLUP);                // RESET
  pinMode(Mon, OUTPUT);                       // MONITOR LED
}

void loop(void) 
{
  if (digitalRead(Rese)==LOW) {res(); u8g2.clearBuffer(); u8g2.sendBuffer();}  // RESET
  Selv=digitalRead(Sel);                     // MANUAL ACTIVE: LOW
  if(Selv!=pre)                              // TOGGLE SIGNAL
  {
    if(Selv==1) 
    {
      if (offsetPerc[5]==0) offsetPerc[5]=2;  // LAST DIGIT ANIMATE AND INCREMENT
      digitalWrite(Mon,HIGH);                 // MON HIHG
      delay(60);                              // TIME FOR MON LED
      digitalWrite(Mon,LOW);                  // MON LOW
    }
  }
  pre=Selv;
  u8g2.clearBuffer();	                        // MEMORY CLEAR
  for (int i=5; i>=0; i--) 
  {
    if (offsetPerc[i]>0)                      // FROM LAST DIGIT TO THE FIRST ANIMATION
    { 
      offsetPerc[i]=offsetPerc[i]+10;         // INCREMENT OFFSET PERCENTAGE
      if ((digits[i]==9) && (offsetPerc[i-1]==0) && (offsetPerc[i]>20)) 
      {
        offsetPerc[i-1]=2;                    // FROM 9 TO 0, INCREASE LEFT DIGIT
      }
      if (offsetPerc[i] >= 100)               // NEXT DIGIT IF ANIMATE DONE
      { 
        offsetPerc[i]=0;                      // STOP ANIMATION
        digits[i]=digits[i]+1;                // INCREASE
        if (digits[i]==10) {digits[i]=0;}     // FROM 10 TO 0
      }
    }
    Offset=round((1-((cos(offsetPerc[i]/100.0*3.141592654)/2.0)+0.5))*8.0);
    itoa(digits[i], Char,10);                  // NUMBER TO STYLE
    itoa((digits[i]+1) % 10, CharNext,10);     // NEXT NUMBER TO STYLE
    u8g2.drawStr(i*4, 7-Offset, Char);         // DARW CHARACTER
    u8g2.drawStr(i*4, 7-Offset+8, CharNext);   // DRAW NEXT CHAR
    delay(10);                                 // SLIDING TIME
  }
  u8g2.sendBuffer();  // MEMORY TO DISPLAY
}

void res()            // RESET SUBRUTINE
{
  for (int i=5; i>=0; i--)
  digits[i]=0;
} // Wokw. insp.

