// RTC DS307. STABLE CLOCK SIGNAL FROM SQW PIN. DEFRAN 24.

#include <RTClib.h>
#define RTC_ADDR 0x68  // RTC ADDRESS
int Fset;
Ds1307SqwPinMode Freq[]={DS1307_OFF, DS1307_ON, DS1307_SquareWave1HZ, DS1307_SquareWave4kHz, DS1307_SquareWave8kHz, DS1307_SquareWave32kHz};
RTC_DS1307 RTC;

void setup()
{
  pinMode(13, OUTPUT);  // Monitor
  RTC.begin();
  int pines[]={2,3,4,5,6,7};
  for(int i=0; i<6; i++) {pinMode(pines[i], INPUT_PULLUP);}
}

void loop()
{
  if(digitalRead(2)==LOW) Fset=0;   // OFF
  if(digitalRead(3)==LOW) Fset=1;   // ON
  if(digitalRead(4)==LOW) Fset=2;   // 1K
  if(digitalRead(5)==LOW) Fset=3;   // 4K
  if(digitalRead(6)==LOW) Fset=4;   // 8K
  if(digitalRead(7)==LOW) Fset=5;   // 32K
  RTC.writeSqwPinMode(Freq[Fset]);
  digitalWrite(13,1);
  delay(1200);
  digitalWrite(13,0);  // Monitor
  delay(800);
}

// https://www.alldatasheet.com/datasheet-pdf/download/58481/DALLAS/DS1307.html
// https://www.alldatasheet.com/datasheet-pdf/download/112132/DALLAS/DS3231.html

