// AIR QUALITY DISPLAY. DEFRAN 24.

// MQ2: Methane, Butane and Smoke.
// MQ3: Alcohol y Ethanol.
// MQ4: Methane.
// MQ5: Natural Gas.
// MQ6: Natural Butane.
// MQ7: Carbon Monoxide.
// MQ8: Natural Hydrogen.
// MQ9: Carbon Monoxide and flammable gases.
// MQ135: Benzene, Alcohol and Smoke.

#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Fonts/FreeSans9pt7b.h> 
#include <Fonts/FreeMonoOblique9pt7b.h>
#include <DHT.h>
Adafruit_SSD1306 display(128, 64, &Wire, 4); // WIDTH, HEIGHT, WIRE, RESET.
#define MQ A3                             // GAS Sensor pin
#define DHTPIN 2                             // DHT pin
#define DHTTYPE DHT22
DHT dht(DHTPIN,  DHTTYPE);
String Gas="";
int MQval=0;
int son=7;
int mon=13;
int fijo=0;

void setup() 
{
  dht.begin();
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {while (true);}
  pinMode(MQ,INPUT);
  pinMode(mon, OUTPUT);
  pinMode(son, OUTPUT);
}

void loop() 
{
  digitalWrite(mon,HIGH);
  display.clearDisplay();
  display.drawLine(0,0,126,0,WHITE);       // LINE X,Y,WIDTH, Y FIN
  display.setTextColor(BLACK, WHITE);
  display.setCursor(0,5); display.println(" AIR QUALITY MONITOR ");
  display.setTextColor(WHITE);
  display.drawLine(0,16,126,16,WHITE);    // LINE X,Y,WIDTH, Y FIN
  MQval=analogRead(MQ);
  if(MQval<181) {Gas="  GOOD!"; digitalWrite(son,LOW); fijo=0;}
  else if (MQval>181 && MQval<225) {Gas="  Poor!"; fijo=1;}
  else if (MQval>225 && MQval<300) {Gas="Very bad!"; fijo=1;}
  else if (MQval>300 && MQval<350) {Gas="  Toxic!"; fijo=1; digitalWrite(son,HIGH);}
  else {Gas=" Lethal!"; fijo=1; digitalWrite(son,HIGH);}
  display.setTextColor(WHITE);
  display.drawLine(0,38,126,38,WHITE);          // LINE X,Y,WIDTH, Y FIN
  display.setTextSize(1);
  display.setCursor(1,26);
  display.setFont();                            // Standard Font
  display.println(" AIR:");
  display.setTextSize(1);
  display.setCursor(30,26);
  display.setFont(&FreeMonoOblique9pt7b);       // Big Font
  delay(100);
  if (fijo) digitalWrite(mon,HIGH); else digitalWrite(mon,LOW);
  display.println(Gas);                        // Print Air Gas
  float h=dht.readHumidity();
  float t=dht.readTemperature();
  display.setTextColor(WHITE);
  display.setTextSize(1);
  display.setFont();
  display.setCursor(0,44); display.println(" Temperature: ");
  display.setCursor(84,44);
  display.println(t,1);                            // Print Temperature, 1 ten
  display.setCursor(117,44); display.println("C");
  display.drawRect(112,44,3,3, WHITE);             // Degree symbol
  display.setCursor(0,55); display.println(" RH Humidity:");
  display.setCursor(84,55);
  display.println(h,1);                            // Print humidity, 1 ten
  display.setCursor(117,55); display.println("%");
  display.display(); 
  delay(60); 
} // pjthub insp.

