// Timer0 --------------------------------

uint16_t T0Prescalers[5] = {1, 8, 64, 256, 1024};

void T85_Timer0_Stop() {
  GTCCR |= (1 << TSM) | (1 << PSR0);
}

void T85_Timer0_Start() {
  TCNT0 = 0;
  GTCCR &= 0b01111111;
}

void T85_Timer0_Frequency(uint32_t hz) {
  T85_Timer0_Stop();
  
  uint32_t SysFreq = F_CPU;
  uint16_t WantedPS = (SysFreq/hz)/256;
  uint8_t Prescaler;    
  for(Prescaler=0;Prescaler<4;Prescaler++) {
    if(T0Prescalers[Prescaler] > WantedPS) {
      break;
    }
  }
  
  TCCR0A = (1 << WGM01); //CTC
  TCCR0B = Prescaler+1; //+1 CS00  //TODO: change only bits //(0b010 << CS00);//
 
  OCR0A = (SysFreq/T0Prescalers[Prescaler])/hz;
}



// OWB --------------------------------

volatile uint8_t OWB_flags = 0;
volatile uint8_t datatest[4] = {0x50, 0x55, 0x55, 0x00};
volatile uint8_t idx = 0;

void OWB_send_test() {
  T85_Timer0_Stop();
  OWB_flags = 1; //sending flag

  idx = 0;

  PORTB |= 1; // PB0 high ; must be high to be driven by USI / does not work if low (datasheet error ?)
  DDRB |= 1;  // PB0 direction out

  USISR = 8 | (1 << USIOIF);  // 16-8 clock size & clear pending interrupt
  USICR = (1 << USIOIE)       // interrupt cnt overflow enable
          | (0b10 << USIWM0)  // 2wire mode (but only one pin really used : PIN0/SDA)
          | (1 << USICS0);    //clock mode timer0
  USIDR = 0b01010000;         // 0101 sync + (len-1)
 
  T85_Timer0_Start();
}

void OWB_init(uint16_t baud) {
  T85_Timer0_Frequency(baud); //set freq & pause timer
  OWB_flags = 0;
}

ISR(USI_OVF_vect) { // end of byte
  if (OWB_flags == 1) {
    USIDR = datatest[idx];
    idx++;
    USISR = 8 | (1 << USIOIF); //reset interrupt    
  }
  // else // RX code removed to simplify 
  
  if (idx==4) { // end of TRX msg
    DDRB &= 0b11111110; //pin0 become input
    OWB_flags = OWB_flags | 0b00000100; // end of TRX flag
    USICR = 0;
    USISR = 0;
  }  
}


// main --------------------------------

void delay_s(uint8_t seconds) { //quick and dirty delay
  uint32_t ticks = (F_CPU/6)*seconds;
  do {
    __asm__ __volatile__("nop");
    ticks--;
  } while (ticks!=0);
}

void setup() {
  OWB_init(8000);  
  DDRB |= (1 << PB4);
  sei();  
}

void loop() {
  if (OWB_flags == 0) {
    OWB_send_test();
    PORTB |= (1 << PB4);
    delay_s(1);
    OWB_flags = 0;
    PORTB &= ~(1 << PB4);
    delay_s(1);
  } 
}

int main(void) {
  setup();
  for (;;)
    loop();
}
