;------------------------
; Assembly Code
;------------------------
#define __SFR_OFFSET 0x00
#include "avr/io.h"
;------------------------
.global timer0
;===============================================================
timer0:
    SBI   DDRB, 4         ;set PB4 for o/p
    CBI   PORTB, 4        ;PB4 = 0
    ;--------------------------------------------
    LDI   R18, 61         ;set loop counter
blink_l: 
    RCALL delay_timer0    ;apply delay via timer0
    DEC   R18
    BRNE  blink_l             ;& go back & repeat
    ;--------------------------------------------
    SBI   PINB, 4
    LDI   R18, 61              ;re-set loop counter
    RJMP  blink_l              ;go back & repeat toggle
;===============================================================
delay_timer0:             ;0.64 ms delay via Timer0
    ;---------------------------------------------------------
    CLR   R20
    OUT   TCNT0, R20      ;initialize timer0 with count=0
    LDI   R20,127
    OUT   OCR0A, R20      ;OCR0 = 9
    LDI   R20, 0b00000010
    OUT   TCCR0A, R20     ;timer0: CTC mode
    LDI   R20, 0b00000101
    OUT   TCCR0B, R20     ;prescaler 1024
    ;---------------------------------------------------------
ocf_l: 
    IN    R20, TIFR0         ;get TIFR0 byte & check
    SBRS  R20, OCF0A         ;if OCF0=1, skip next instruction
    RJMP  ocf_l              ;else, loop back & check OCF0 flag
    ;---------------------------------------------------------
    CLR   R20
    OUT   TCCR0B, R20     ;stop timer0
    ;---------------------------------------------------------
    LDI   R20, (1<<OCF0A)
    OUT   TIFR0, R20      ;clear OCF0 flag
    RET
