;--------------------------------------------;
; Program : 12f675.asm                       ;
;--------------------------------------------;
; Exercise from the book "Pic in Practice"   ;
; Chapter 15                                 ;
; Led chaser with 16F675                     ;
;--------------------------------------------;
; Leds on pins 2,3,5,6,7                     ;
;--------------------------------------------; 

; Disable 302 Assembler Message
ERRORLEVEL -302

    processor p12f675
    #include "./p12f675.inc"

; Using internal oscillator
   ; __CONFIG H'3F84'
    __CONFIG _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _WDT_OFF & _CP_OFF 
    
; -----------------------------------
; Main 
; -----------------------------------
;     
  
; Local Variables
    cblock 0x20
        COUNT       ; Generic counter for delays
    endc    
    
    org 0x00
;------------ Configuration Section -------------------------
    banksel ADRESL
        movlw       B'00010000'     ; ALL I/O Digital
        movwf       ADRESL
        
        movlw       B'00001000'
        movwf       TRISIO          ; ALL I/O as output except GPIO3 (only Input)
        
        movlw       B'00000111'
        movwf       OPTION_REG      ; Prescaler is 1/256
        
        call        0x3FF           ; Standard call for
        movwf       OSCCAL          ; oscillator calibration
     banksel GPIO          
        movlw       0x07
        movwf       CMCON           ; Turns off comparator
        clrf        GPIO            ; Clear outputs
        bsf         ADCON0,0        ; Turns ON A/D converter. Why???

; ------------- Main Loop ---------------------------------
    
Start:
        movlw       B'00000001'
        movwf       GPIO
        call        Delay_P5
        
        movlw       B'00000010'
        movwf       GPIO
        call        Delay_P5
        
        movlw       B'00000100'
        movwf       GPIO
        call        Delay_P5
        
        movlw       B'00010000'
        movwf       GPIO
        call        Delay_P5
        
        movlw       B'00100000'
        movwf       GPIO
        call        Delay_P5
        
        goto        Start

; --------------------------------------
;       Delays Soubroutines
; --------------------------------------
; 1/100 Sec. Delay
Delay_P1:
        clrf        TMR0
Loop_A:
        movf        TMR0,W
        sublw       D'39'
        btfss       STATUS,Z
        goto        Loop_A
        retlw       0
        
; .5 Sec. Delay
Delay_P5:
        movlw       D'50'
        movwf       COUNT
        call        Delay_P1
        decfsz      COUNT,F
        goto        $-2
        retlw       0
    
    end 
