    #include <xc.inc>
      CONFIG  FOSC = HS             
      CONFIG  WDTE = OFF            
      CONFIG  PWRTE = OFF           
      CONFIG  BOREN = OFF           
      CONFIG  LVP = OFF             
      CONFIG  CPD = OFF             
      CONFIG  WRT = OFF             
      CONFIG  CP = OFF              
    bit_counter equ 0x70	;variable to store the number of right shifts required in the captured key value     
    rwFlag equ 0x72	;this variable is to store the number of complete cycle for high burst in the 562.5us duration
    tempVar equ 0x73	;this variable is to store the number of complete cycle for high burst in the 9ms duration 
    impliedVal equ 0x74	; this variable is to store the implied value from the key pressed by user.
    slave_address equ 0x71  ; to store the slave address
    A_COUNTER equ 0x76	; a counter
    loop_1 equ 0x77
    loop_2 equ 0x78
    loop_extra equ 0x79
    tempPageVar equ 0x75
    printVal equ 0x7A
    scroll_direction equ 0x20 
    normalInverseFlag equ 0x21
    normalInverseVar equ 0x22 
    vScroll_counter equ 0x23
 
; ==== Program Flows ====== 

;=========  Example3 uart =========
     psect RESET_VECT,class=CODE,delta=2
    RESET_VECT:		;reset vector
	goto setup
    psect INT_VECT,class=CODE,delta=2 ;pic10/12/16
    INT_VECT:		;interrupt vector
	retfie
    setup:		; All of these address needs to be in capital letter
	; ======== bank1 here ==================
	bsf STATUS,5	; bank1 is selected 
	clrf TRISB	;set all PORTB pins as output
	movlw 0b11110000 ; assigns binary 11111111 to W
	movwf TRISC	; set PORTD as input pins	
	movlw 0b00000000 ; assigns binary 0000000 to W
	movwf TRISD	; set PORTD as output pins		
	clrf impliedVal ; clear the variable that stores the value of the pressed key. 
	movlw 0x08	; assign 8 to the bit counter
	movwf bit_counter   ; -> bit counter It nees to right shift 1 more times after 8 counts because the last bit7 is in the carry position.  
			; it needs to shift 1 more time to get all the bit back to the initial position as carry bit is included.
	clrf rwFlag	; by default 0 is write and 1 is read		
	movlw 0x78	; set the slaves address as 0111100 7 bits only
	movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
	
	; ======== bank0 here ========================
	bcf STATUS,5	; now, bank0 is selected
	clrf PORTB  ;initialization
	bsf PORTD,7 ; set PORTD<7,6> high as default. SCL
	bsf PORTD,6 ; SDA
	clrf normalInverseFlag
	; =========== end ===============================================
    main:
	clrf rwFlag
	bcf STATUS,5	; now, bank0 is selected
	call clr_output_D_pins
	bsf PORTC,0	; row 1 set as high
	call check_cols_row1
	call clr_output_D_pins	
	bsf PORTC,1	; row 2 is set as high
	call check_cols_row2	
	call clr_output_D_pins	
	bsf PORTC,2	; row 3 is set as high
	call check_cols_row3
	call clr_output_D_pins	
	bsf PORTC,3	; row 4 is set as high
	call check_cols_row4		
	; no need to further check the the 3rd and 4th row in this example 
	; because we only expect user input of 1 to 5
	; repeat the monitoring
	goto main
    pause:
    
	goto pause
    ; === check pressed keys ====	
    check_cols_row1:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000001    ; set MUX ratio
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00000010    ; assign 2 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00000011    ; assign 3 to W		
	; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return
    check_cols_row2:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000100    ; assign 4 to W
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00000101    ; assign 5 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00000110    ; assign 3 to W			
	; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return		
    check_cols_row3:
	movlw 0b00000000    ; assign 0 to W
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00000111    ; assign 4 to W
	btfsc PORTC,5	; column 2 is selected if false	
	movlw 0b00001000    ; assign 5 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00001001    ; assign 3 to W			
		; if none of the above return to check row2 else goto pic_tx for transmission	
	call check_if_selected
	return			
    check_cols_row4:
    	movlw 0b11111111    ; assign 0 to W	
	btfsc PORTC,6	; column 1 is selected if false	
	movlw 0b00001010    ; assign 10 to W
	btfsc PORTC,5	; column 3 is selected if false		
	movlw 0b00000000    ; assign 0 to W	
	btfsc PORTC,4	; column 3 is selected if false	
	movlw 0b00001011 ; assign 11 to W	
	call check_if_last_row_selected
	return			
    check_if_selected:
	bcf STATUS,5	; bank1 is selected 
	movwf impliedVal
	incf impliedVal,1   ; increase impliedVal by 1 bit
	decfsz impliedVal,1 ; check if decrease the impliedVal return zero, if yes, W and impliedVal have not captured the user input
	goto pic_tx ; else goto transmission
	return
    check_if_last_row_selected:
    	movwf impliedVal
	movlw 0b11111111
	subwf impliedVal,0
        btfsc STATUS,2   ; if Z=1, impliedVal=0    
	return
	goto pic_tx ; else goto transmission
	
    clr_output_D_pins:
	bcf STATUS,5	; now, bank0 is selected    
	bcf PORTC,0
	bcf PORTC,1
	bcf PORTC,2
	bcf PORTC,3	
	return
	
    ; === end of pressed keys detection ===========
pic_pre_tx:
    movwf impliedVal    
pic_tx:
    ;== in order to avoid the situation where user keeps holding the pressed key ==
    ;== the transmission only starts when the pressed keys is released ===
    check_keys_released:
    btfsc PORTC,6
    goto check_keys_released
    btfsc PORTC,5
    goto check_keys_released
    btfsc PORTC,4
    goto check_keys_released    
    ; = first send the SoF (Start of Frame) ===
    call startTx
    goto main

    
pic_rx:
    bsf rwFlag,0
    goto pic_tx
    
    
startTx:
;    movlw 0x01
;    subwf impliedVal,0 ; W=impliedVal-1
;    btfsc STATUS,2	; if Z=1, impliedVal=0
;    goto setup_process

    movlw 0x08	; pressed '8' 
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0
    goto display_Offset_m      
    movlw 0x26	; right scroll
    movwf scroll_direction    
    movlw 0x06	; pressed '6'
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0
    goto horizontal_scroll    
    movlw 0x29	; up and right scroll   
    movwf scroll_direction    
    movlw 0b00001001	; pressed '9' 
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0    
    goto Vertical_horizontal_scroll
    movlw 0x2A	; down and left scroll   
    movwf scroll_direction    
    movlw 0b00000111	; pressed '7' 
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0    
    goto Vertical_horizontal_scroll    
    movlw 0x27	; left scroll   
    movwf scroll_direction    
    movlw 0x04	; pressed '4' 
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0
    goto horizontal_scroll  
    movlw 0x05	; pressed '5' 
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0
    goto stop_scrolling
    movlw 0b00001011 ;  '#' is pressed
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0    
    goto send_something
    movlw 0b00001010 ;  '*' is pressed
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0        
    goto normal_inverse
    movlw 0x02 ;  '2' is pressed
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0        
    goto vertical_scroll    
    movlw 0b00000000	;'0' is pressed
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0        
    goto leftRightFlip     
    movlw 0b00000011	;'3' is pressed
    subwf impliedVal,0 ; W=impliedVal-1
    btfsc STATUS,2	; if Z=1, impliedVal=0        
    goto writeSpecificArea         
    
    return

setup_process:
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter
    movlw 0x78	; set the slaves address as 0111100 7 bits only
    movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
    call SDA_tx_mode    
    ;==== START CONDITIONS  ===
    ;== pull SDA low ===
    bcf PORTD,6 ; SDA to low for 2.5us
    call delay_2_5us ; delay for 2.5us
    bcf PORTD,7 ; SCL to low 
    ; === Send the slave address ===
    call us_1 ; delay for 1us+(6xinsx cycle=1.5us) from call write_data,bcf,btfsc,...,bsf PORTD)=2.5us in total
    call send_address
    ; Fundamental cmd
    ; 1.  Display Off AE == 
    call control_cmd
    movlw 0xAE	; send AF cmd 0b10101110
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 2. set contrast control 81
;    call control_cmd
    call SDA_tx_mode
    movlw 0x81	; 0b10000001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address           
;    call control_data
    call SDA_tx_mode
    movlw 0xFF	; send the contrast value as 255 in dec or 0b11111111 or 0xFF
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address               
    ; 3. set normal display A6 ==
;    call control_cmd
    call SDA_tx_mode
    movlw 0xA6	; send A6 cmd 0b10100110
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    
    

    ; Harware config cmds
    ; 5.5 set display start line 40
;    call control_cmd
    call SDA_tx_mode
    movlw 0x40	; send 0b01000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                    
    
    ; 6. Set segment re-map
;    call control_cmd
    call SDA_tx_mode
    movlw 0xA0	; send 0b10100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 7. set MUX Ratio A8
;    call control_cmd
    call SDA_tx_mode
    movlw 0xA8	; send A8 cmd 0b10101000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
;    call control_data        
    call SDA_tx_mode
    movlw 0x3F	; RESET value **111111 as the data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; 8. Set COM output scan direction C0
;    call control_cmd
    call SDA_tx_mode
    movlw 0xC0	; cmd 0b11000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    ; 9. Set display offset D3
;    call control_cmd
    call SDA_tx_mode
    movlw 0xD3	; cmd 0b11010011
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0x00	; RESET value 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; 10. set COM PINS hardware DA
;    call control_cmd
    call SDA_tx_mode
    movlw 0xDA	; cmd 0b11011010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0b00010010	; RESET value 0b00010010 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    
    ; Timing and driving
    ; 11. Set display clock divide ratio D5
;    call control_cmd
    call SDA_tx_mode
    movlw 0xD5	; cmd 0b11010101
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0x80	; RESET value 0b10000000  
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                                
    ; 12. Set precharge period D9
;    call control_cmd
    call SDA_tx_mode
    movlw 0xD9	; cmd 0b11011001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0x22	; RESET value 0b00100010  
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                            
    ; 13. Set Vcomh Deselect level DB
;    call control_cmd
    call SDA_tx_mode
    movlw 0xDB	; cmd 0b11011011
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0x20	; RESET value 0b00100000 ~0.77xVcc RESET 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                        
    
    ; Charge pump regulator
    ; 14. Set charge pump 8D
;    call control_cmd
    call SDA_tx_mode
    movlw 0x8D	; cmd 0b10001101
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
;    call control_data        
    call SDA_tx_mode
    movlw 0x14	; charge pump enabled 0b00010100 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                        
    
    ; turn the screen back on
;    call control_cmd
    call SDA_tx_mode
    movlw 0xA4	; send AF cmd 0b10100100
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address   
;    call control_cmd
    call SDA_tx_mode
    movlw 0xAF	; send AF cmd 0b10101111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call trigger_Stop
    
    return

send_something:
    call setup_process
    ;call page_addressing
    call horizontal_addressing
    start_printing_content:
    movlw 0x00
    movwf tempVar
    movwf tempPageVar
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter
    movlw 0x78	; set the slaves address as 0111100 7 bits only
    movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
    call SDA_tx_mode    
    ;==== START CONDITIONS  ===
    ;== pull SDA low ===
    bcf PORTD,6 ; SDA to low for 2.5us
    call delay_2_5us ; delay for 2.5us
    bcf PORTD,7 ; SCL to low 
    ; === Send the slave address ===
    call us_1 ; delay for 1us+(6xinsx cycle=1.5us) from call write_data,bcf,btfsc,...,bsf PORTD)=2.5us in total
    call send_address
    ; == write some data === 
    ; == draw a sine graph ===
    call control_data_M
    page_rep_here:
    incf tempPageVar,1
    
    rep_here:
    incf tempVar,1
    movlw 0x01	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0    
    call page0_spec
    movlw 0x02	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page1_spec
    movlw 0x03	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page2_spec
    movlw 0x04	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page3_spec    
    movlw 0x05	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page4_spec    
    movlw 0x06	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page5_spec        
    movlw 0x07	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page6_spec        
    movlw 0x08	
    subwf tempPageVar,0
    btfsc STATUS,2   ; if Z=1, impliedVal=0        
    call page7_spec    
    
    
    
    pre_sending:
    call SDA_tx_mode
;    movlw 0x00	; send 0b00000000
    movf printVal,0
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    ; == counter check ==
    movlw 0x80	; 128 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0    
    goto rep_here
    movlw 0x00
    movwf tempVar    
    movlw 0x08	; 8 in dec
    subwf tempPageVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0        
    goto page_rep_here
    call trigger_Stop        
    goto main

print_single:    
    call SDA_tx_mode
;    movlw 0x00	; send 0b00000000
    movf printVal,0
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    return
    
page0_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page0_g
    movlw 0b11110000
    movwf printVal
    goto pre_sending
    page0_g:
    movlw 0x26	; 38 in dec
    subwf tempVar,0
    btfsc STATUS,0	; if C=1, tempVar>=W      
    call page0_g1
    movlw 0x2A	; 42 in dec
    subwf tempVar,0
    btfss STATUS,0	; if C=1, tempVar<W          
    goto pre_sending
    movlw 0b00000000
    movwf printVal
    goto pre_sending    
    page0_g1:
    movlw 0b10000000
    movwf printVal
    return
    
    
page1_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page1_g
    movlw 0b11111111
    movwf printVal
    goto pre_sending
    page1_g:
    movlw 0x19	; 25 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page1_1g    
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b10000000	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b01000000	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00100000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	; 7.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000100	; 8.
    movwf printVal
    call print_single	
    incf tempVar,1
    movlw 0b00000010	; 9.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000010	; 10.
    movwf printVal
    call print_single	
    incf tempVar,1
    movlw 0b00000001	; 11
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000001	; 12
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000001	; 13
    movwf printVal
    goto pre_sending        
    page1_1g:    
    movlw 0x2A	; 42 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the DOWN slope portion of the sine curve under PAGE1 == 
    movlw 0b00000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000001	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000001	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000010	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000010	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	; 7.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00001000	; 8.
    movwf printVal
    call print_single	
    incf tempVar,1
    movlw 0b00010000	; 9.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	; 10.
    movwf printVal
    call print_single	
    incf tempVar,1
    movlw 0b00100000	; 11
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b01000000	; 12
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b10000000	; 13
    movwf printVal
    goto pre_sending        
    return        


page2_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page2_g
    movlw 0b11111111
    movwf printVal
    goto pre_sending
    page2_g:
    movlw 0x12	; 18 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page2_2g    
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b01000000	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00100000	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000010	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000001	; 7.
    movwf printVal
    goto pre_sending        
    page2_2g:    
    movlw 0x37	; 55 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the DOWN slope portion of the sine curve under PAGE1 == 
    movlw 0b00000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000010	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00100000	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b01000000	; 7.
    movwf printVal
    goto pre_sending        
    return
page3_spec:
    movlw 0b10000000	; the default is not 0x00, the default is the one with an X-Axis
    movwf printVal
    movlw 0x06	; 6 in dec
    subwf tempVar,0
    btfsc STATUS,0	; if C=0, tempVar<6 => print 0x00 instead      
    goto page3_g
    movlw 0b00000000
    movwf printVal
    goto pre_sending    
    page3_g:
    movlw 0x7A	; 122 in dec
    subwf tempVar,0
    btfss STATUS,0	; if C=1, tempVar>=122 => print 0x00 instead      
    goto page3_2g
    movlw 0b00000000
    movwf printVal
    goto pre_sending        
    page3_2g:
    movlw 0x0B	; 11 in dec print Y-Axis?
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page3_3g
    movlw 0b11111111
    movwf printVal
    goto pre_sending    
    page3_3g:    
    movlw 0x0C	; 12 in dec is this the start of the up slope?
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page3_4g        
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b11000000	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b10010000	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10001000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10000100	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10000010	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10000001	; 6. 
    movwf printVal
    goto pre_sending
    page3_4g:
    movlw 0x3E	; 62 in dec. is this the start of the down slope?
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the DOWN slope portion of the sine curve under PAGE1 == 
    movlw 0b10000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b10000010	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10000100	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10010000	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b11000000	; 6. 
    movwf printVal
    goto pre_sending  
    return
    
page4_spec:    
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page4_g
    movlw 0b11111111
    movwf printVal
    goto pre_sending
    page4_g:
    movlw 0x45	; 69 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page4_2g    
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b00000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000100	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00100000	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b01000000	; 6. 
    movwf printVal
    goto pre_sending        
    page4_2g:    
    movlw 0x73	; 115 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the DOWN slope portion of the sine curve under PAGE1 == 
    movlw 0b01000000	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00100000	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000001	; 6. 
    movwf printVal
    goto pre_sending        
    return    
page5_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page5_g
    movlw 0b11111111
    movwf printVal
    goto pre_sending
    page5_g:
    movlw 0x4B	; 75 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page5_2g    
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b00000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000010	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00100000	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b01000000	; 7.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b10000000	; 8.
    movwf printVal    
    goto pre_sending        
    page5_2g:    
    movlw 0x6B	; 107 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the DOWN slope portion of the sine curve under PAGE1 == 
    movlw 0b10000000	; 0.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b01000000	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00100000	; 2.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00010000	; 3.
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00001000	;4. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000100	;5. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000010	; 6. 
    movwf printVal
    call print_single
    incf tempVar,1    
    movlw 0b00000001	; 7.
    movwf printVal
    goto pre_sending            
    return
page6_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto page6_g
    movlw 0b11111111
    movwf printVal
    goto pre_sending
    page6_g:
    movlw 0x53	; 83 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending    
    ; == start printing the cells for the up slope portion of the sine curve under PAGE1 == 
    movlw 0b00000001	; 1.
    movwf printVal
    call print_single
    incf tempVar,1
    movlw 0b00000010	; 2.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000100	; 3.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000100	; 4.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00001000	; 5.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00010000	; 6.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00010000	; 7.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00100000	; 8.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00100000	; 9.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00100000	; 10.
    movwf printVal
    call print_single
    incf tempVar,1                
    movlw 0b01000000	; 11.
    movwf printVal
    call print_single
    incf tempVar,1                    
    movlw 0b01000000	; 12.
    movwf printVal
    call print_single
    incf tempVar,1                    
    movlw 0b01000000	; 13.
    movwf printVal
    call print_single
    incf tempVar,1                    
    movlw 0b01000000	; 14.
    movwf printVal
    call print_single
    incf tempVar,1                    
    movlw 0b00100000	; 8.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00100000	; 9.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00100000	; 10.
    movwf printVal
    call print_single
    incf tempVar,1     
    movlw 0b00010000	; 6.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00010000	; 7.
    movwf printVal
    call print_single
    incf tempVar,1            
    movlw 0b00001000	; 5.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000100	; 3.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000100	; 4.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000010	; 2.
    movwf printVal
    call print_single
    incf tempVar,1        
    movlw 0b00000001	; 1.
    movwf printVal
    goto pre_sending
    return    

page7_spec:
    movlw 0b00000000
    movwf printVal
    movlw 0x0B	; 11 in dec
    subwf tempVar,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
    goto pre_sending
    movlw 0b00001111
    movwf printVal
    goto pre_sending    
    return    
    
;With Co = 1 you can send data and commands in the same transmission, but you must send a control byte for each data/command.
;After sending a control byte with Co = 0 the following bytes must be only data or only commands until the end of transmission.
;When I say "commands" I mean commands and command parameters.
;Data refers to data to be saved to Display RAM.
;Everybody uses Co = 0 because it seems more convenient.

control_cmd_M:
    ; == send control byte for multiple cmds to follow ==
    call SDA_tx_mode
    movlw 0b10000000	; control byte:10+000000+ack for cmd byte rather than data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return
control_cmd:
    ; == send control byte for a single cmd to follow ==
    call SDA_tx_mode
    movlw 0x00	; control byte:00+000000+ack for cmd byte rather than data byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return    
control_data_M:
    ; == send control byte for a single data byte to follow ==
    call SDA_tx_mode
    movlw 0b01000000	; control byte:01+000000+ack for data byte rather than cmd byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return
control_data:
    ; == send control byte for multiple data bytes to follow ==
    call SDA_tx_mode
    movlw 0b11000000	; control byte:01+000000+ack for data byte rather than cmd byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    return    
send_address:
    call write_data	; After this, there are 6 insx or 1.5us before the next HIGH value of SCL. The 6 insx cycles are returnx2, decfsz, gotox2, btfsc, 
    decfsz bit_counter,1    ;
    goto the_next_bit	;    
    ; === address bits and W/R bit are all sent 
    ; == change PORTD<6> to RX and continue the SCL ==========
    call SDA_rx_mode ; At the end of this call, 2.75us has passed	
    call delay_2us ; 2us: call a delay of 3.5us so that the total of 3.5us+2.75us=6.25us (half cycle)
    call us_1	; 1us
    movlw 0x04	;  0.25us 
    movwf A_COUNTER ;0.25us We'll repeat a Max of 4 SCL cycles to wait for any slave response.
    ; == turn the SCL to run while listening to the low pulse pull from the slave ===
    call SCL_Listener ;next_SCL  ;In stead of calling SCL_Listener, 
	    ; we call the LOW SCL first in order to avoid the HIGH SDA signal while the MAster is changing from tx to rx 
	    ; and the slave is changing from rx to tx.
    bsf PORTB,0
    bcf PORTD,7	;    this is to start with SCL LOW cycle after ACK received.
    return

trigger_Stop:    
    call SDA_tx_mode	; 6insx=1.5us
    bcf PORTD,6		;0.25us
    call delay_2us	;2us
    call delay_2us	;2us
    nop			;0.25x2=0.5us => total 6.25us (half cycle of SCL)
    nop
    ; == trigger the STOP CONDITION ====    
    bsf PORTD,7	;    
    call delay_2_5us
    bsf PORTD,6    
    return
trigger_start:
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter
    movlw 0x78	; set the slaves address as 0111100 7 bits only
    movwf slave_address ; We'll use slave_address<0> to indicate W/R (0/1)=> slave_address=01111000 
    call SDA_tx_mode    
    ;==== START CONDITIONS  ===
    ;== pull SDA low ===
    bcf PORTD,6 ; SDA to low for 2.5us
    call delay_2_5us ; delay for 2.5us
    bcf PORTD,7 ; SCL to low 
    ; === Send the slave address ===
    call us_1 ; delay for 1us+(6xinsx cycle=1.5us) from call write_data,bcf,btfsc,...,bsf PORTD)=2.5us in total
    call send_address    
    return

page_addressing:
    call trigger_start
    call control_cmd
    call SDA_tx_mode
    movlw 0x20	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call SDA_tx_mode
    movlw 0x02	; send 0b00000010 page address
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
    call SDA_tx_mode
    movlw 0x22	; send 0b00100010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call SDA_tx_mode
    movlw 0x02	; send 0b00000001 page start address
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address           
    call SDA_tx_mode
    movlw 0x02	; send 0b00000010 page end address
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address               
    call SDA_tx_mode
    movlw 0x06	; send 0b00000010 page start column
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                   
    call SDA_tx_mode
    movlw 0x21	; send 0b00010101 page end column
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                   
    call trigger_Stop
    return

horizontal_addressing:
    call trigger_start
    call control_cmd    
    ; Address cmd
    ; 5. set memory address mode 0x20 ===
    call SDA_tx_mode
    movlw 0x20	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizintal address
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
    ; === Set PAGE addresses 0x22 ============
    call SDA_tx_mode
    movlw 0x22	; send 0b00100010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start PAGE and end PAGE addresses
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address     
    call SDA_tx_mode
    movlw 0x07	; send 0b00000111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; === set column address 0x21 ===
    call SDA_tx_mode
    movlw 0x21	; send 0b00100001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start column and end column addresses
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address   
    call SDA_tx_mode
    movlw 0x7F	; send 0b01111111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    call trigger_Stop
    return

horizontal_addressing_specArea:
    call trigger_start
    call control_cmd    
    ; Address cmd
    ; 5. set memory address mode 0x20 ===
    call SDA_tx_mode
    movlw 0x20	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizintal address
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
    ; === Set PAGE addresses 0x22 ============
    call SDA_tx_mode
    movlw 0x22	; send 0b00100010
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start PAGE and end PAGE addresses
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address     
    call SDA_tx_mode
    movlw 0x00	; send 0b00000111
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    ; === set column address 0x21 ===
    call SDA_tx_mode
    movlw 0x21	; send 0b00100001
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    ; == data byte start column and end column addresses
    call SDA_tx_mode
    movlw 0x41	; 65 dec
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address   
    call SDA_tx_mode
    movlw 0x5C	; 92 dec
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address                
    call trigger_Stop
    return    
    
horizontal_scroll:
    ; scrolling cmd
    ; 4. deActivate Scroll ==
;    call control_cmd    
    call trigger_start
    call control_cmd        
;    call control_cmd
    call SDA_tx_mode
    movf scroll_direction,0
    ;movlw 0x26	; send 0b00100000
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
;    call control_data_M
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
;    call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;    call control_data
    call SDA_tx_mode
    movlw 0b00000111	; 2 frames freq
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode
    movlw 0x07	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode
    movlw 0x00	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;    call control_data
    call SDA_tx_mode
    movlw 0xFF	; send 0b00000000 horizontal
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
    
    call SDA_tx_mode
    movlw 0x2F	; activate scroll
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call trigger_Stop
    goto main
Vertical_horizontal_scroll:
    ; scrolling cmd
    ; 4. deActivate Scroll ==
;    call control_cmd    
    call trigger_start
    call control_cmd        
;    call control_cmd
    call SDA_tx_mode
    movf scroll_direction,0
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address            
;    call control_data_M
    call SDA_tx_mode
    movlw 0x00	; dummy byte
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address       
;    call control_data
    call SDA_tx_mode
    movlw 0x00	; start page
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;    call control_data
    call SDA_tx_mode
    movlw 0b00000111	; 2 frames freq
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode
    movlw 0x07	; end page
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
;   call control_data
    call SDA_tx_mode	
    movlw 0x01	; vertical scroll offset row 1 upward
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    
    call SDA_tx_mode
    movlw 0x2F	; activate scroll
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call trigger_Stop
    goto main    

stop_scrolling:
    call trigger_start
    call control_cmd        
    call SDA_tx_mode
    movlw 0x2E	; activate scroll
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call trigger_Stop    
    goto main

norInvFlagOp:
    bcf normalInverseFlag,0
    movlw 0xA6 ; normal display
    movwf normalInverseVar    
    goto normalInvTransmission
    
    
normal_inverse:
    btfsc normalInverseFlag,0	; if bit7=1 => normal display else invers is required
    goto norInvFlagOp
    ; inverse the display and set normalInverseFlag 0x01
    bsf normalInverseFlag,0
    movlw 0xA7 ; Inverse display
    movwf normalInverseVar    
    normalInvTransmission:
    call trigger_start
    call control_cmd        
    call SDA_tx_mode
    ;movlw 0x2E	; activate scroll
    movf normalInverseVar,0
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call trigger_Stop        
    goto main

vertical_scroll:
    call trigger_start
    call control_cmd       
    call SDA_tx_mode
    movlw 0xA3	; set vertical scroll area
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    
    call SDA_tx_mode
    movlw 0x00	; Fixed area 0x00 => no fixed area 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    

    call SDA_tx_mode
    movlw 0x40 ;0x40	; scoll the entire area 64 rows
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    

    call SDA_tx_mode
    movlw 0x2F	; activate scroll
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    
    call trigger_Stop            
    goto main
    
leftRightFlip:
    call trigger_start
    call control_cmd        
    call SDA_tx_mode
    movlw 0xA1	; left right flip
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call trigger_Stop        
    goto main

writeSpecificArea:
    call horizontal_addressing_specArea
    
    call trigger_start
    call control_data_M 
    ; === Y ===    
    call SDA_tx_mode
    movlw 0b01001110	; 
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode
    movlw 0b10010000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address 
    call SDA_tx_mode
    movlw 0b10010000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call SDA_tx_mode    
    movlw 0b01111110	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call SDA_tx_mode    
    movlw 0b00000000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    ; == '='
    call SDA_tx_mode    
    movlw 0b00101000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call SDA_tx_mode    
    movlw 0b00101000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call SDA_tx_mode    
    movlw 0b00000000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    ; = S --
    call SDA_tx_mode    
    movlw 0b01001100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter   
    call SDA_tx_mode    
    call send_address
    call SDA_tx_mode    
    movlw 0b10010010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address
    call SDA_tx_mode    
    movlw 0b10010010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b01100100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00000000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    ; == i ==
    call SDA_tx_mode    
    movlw 0b11111010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00000000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address         
    ; == n ==
    call SDA_tx_mode    
    movlw 0b00000010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address      
    call SDA_tx_mode    
    movlw 0b11111100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00000010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address         
    call SDA_tx_mode    
    movlw 0b00000010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b11111100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address         
    call SDA_tx_mode    
    movlw 0x00	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    ; === x===
    call SDA_tx_mode    
    movlw 0b10000010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b01000100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00101000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00010000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b00101000	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b01000100	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode    
    movlw 0b10000010	; write a vertical line
    movwf slave_address
    movlw 0x08	; assign 8 to the bit counter
    movwf bit_counter    
    call send_address        
    
    call trigger_Stop                
    goto main
display_Offset_m:
    ; if vScroll_counter increases from 0x00 to 0x3F, it scrolls downwards
    ; if vScroll_counter decreases from 0x3F to 0x00, it scrolls upwards
    movlw 0x00 ;0x3F  ;0x00
    movwf vScroll_counter
    offset_m:
    call trigger_start
    call control_cmd        
    call SDA_tx_mode
    movlw 0xD3	; display offset
    movwf slave_address
    movlw 0x08	
    movwf bit_counter    
    call send_address    
    call SDA_tx_mode
    ;movlw 0x10	; display offset
    movf vScroll_counter,0
    movwf slave_address
    movlw 0x08	
    movwf bit_counter    
    call send_address        
    call trigger_Stop
    call delay_0_5s
    incf vScroll_counter
    movlw 0x3F
    subwf vScroll_counter,0
    btfss STATUS,2	; if Z=1, impliedVal=0      
;    decfsz vScroll_counter,1
    goto offset_m
    goto main
    
write_data:      
;    bcf PORTD,7
    btfsc slave_address,7   ; address is 7bits + write bit & send the MSB first, thus, it starts at slave_address<7>    
    goto set_1_delay
    goto set_0_delay
    end_setting:
    call delay_1_75us	; further 2.5us low for SCL before turning it high
    bsf PORTD,7		; set SCL=1 for 6.25us in total
    call delay_2_5us	; + remaining insxs
    call delay_2_25us
    call delay_1_25us
    bcf PORTD,7
    ;call delay_2us	; delay a totla of 5us=2.5us+2us+2xinsx from the return
    return

scl_High_ONLY:
    bsf PORTD,7
;    call us_1	; There are a total of 5.25us insx time after this line before SCL is turned to LOW.
		; Thus we only need to delay 1us so that a total of 6.25us (half cycle) to be delayed
    return  ;0.25usx2

   
    
set_1_delay:
    nop
    bsf PORTD,6
    goto end_setting
set_0_delay:
    bcf PORTD,6
    goto end_setting
the_next_bit:
    rlf slave_address,1
    goto send_address

    ;==== Master to receive from Slaves ===========
SDA_rx_mode:
    bsf STATUS,5	; bank 1 is selected
    movlw 0x40 ;0b01000000 ; assigns binary 0100000 to W
    movwf TRISD	; set ONLY PORTD<6> as input pin	
    bcf STATUS,5	; bank 0 is selected	
    return

SDA_tx_mode:
    bsf STATUS,5	; bank 1 is selected
    movlw 0x00  ;0b00000000 ; assigns binary 0100000 to W
    movwf TRISD	; set ONLY PORTD<6> as input pin		
    bcf STATUS,5	; bank 0 is selected	
    return
    
SCL_Listener:
    bsf PORTD,7		; set SCL=1
    btfsc PORTD,6   ; it satisfies the condition of both HIGH SCL and LOW SDA in the beginning
    nop		    ; 0.5us upto here	
;    goto next_SCL
    call delay_2_5us ; 2.5us
    call delay_2_5us  ;2.5us    
    btfss PORTD,6   ; if SDA is LOW, 0.25us, at the end of high SCL as well =>ACK received
    return	; if SDA is LOW return to write_register, this will be executed=>0.5us => a total of 0.5us+2.5us+2.5us+0.25us+0.5us=6.25us (half cycle)
    next_SCL:
    nop		    ; last 0.25us from HIGH SCL
    bcf PORTD,7	    ; 0.25us
    call delay_2_5us ; 2.5us
    call delay_2_5us  ;2.5us
    nop		    ; 0.25us
    decfsz A_COUNTER,1	; 0.25us / 0.5us if true
    goto SCL_Listener	;0.5us => a total of delay at LOW SCL=6.25us (half cycle at low)
    ; == process STOP command as there is no response after 255 SCL cycles 
    stop_cmd:
    call SDA_tx_mode
    bcf PORTD,6  
    call us_1
    bsf PORTD,7		; set SCL=1
    call delay_2_5us
    bsf PORTD,6
    goto main

read_byte_2_LED:
    movf impliedVal,0 
    movwf PORTB
    return
    
    
    
    
    ; ===== delay modules =================================================
    delay_xms:	
	inner_loop:
	call us_1
	decfsz loop_1,1	
	goto inner_loop
	call ms_9_loop_1_reset
	decfsz loop_2,1		
	goto inner_loop
	return	

    us_1:
	return

    ms_9_loop_1_reset:
	movlw 0xE8	; 232->W
	movwf loop_1	; -> loop_1	    
	return

    delay_extra:
	inner_loop_extra:
	decfsz loop_extra,1	
	goto inner_loop_extra
	return
    delay_2_5us:
	nop
	nop
	nop
	nop
	nop
	nop
	return
    delay_2_25us:
	nop
	nop
	nop
	nop
	nop
;	nop
	return	
    delay_1_75us:
	nop
	nop
	nop
	return		
    delay_2us:
	nop
	nop
	nop
	nop
	return		
    delay_1_25us:
	nop
;	nop
;	nop
;	nop
	return		
    delay_1s:
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	; == repeat the above for 8 times then add another 180 x 255 loop
	; == total delap will then be around 0.9951 seconds ====
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
	; === now 180 x 255 loops ==
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xB4	; 180->W
	movwf loop_2	; -> loop_1	    
	call delay_xms		
	return
	
    delay_0_5s:
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms
	; == repeat the above for 8 times then add another 180 x 255 loop
	; == total delap will then be around 0.9951 seconds ====
	movlw 0xFF	; 255->W
	movwf loop_1	; -> loop_1	    
	movlw 0xFF	; 255->W
	movwf loop_2	; -> loop_1	    	
	call delay_xms	
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms	
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms	
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms	
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xFF	; 255->W
;	movwf loop_2	; -> loop_1	    	
;	call delay_xms	
	; === now 180 x 255 loops ==
;	movlw 0xFF	; 255->W
;	movwf loop_1	; -> loop_1	    
;	movlw 0xB4	; 180->W
;	movwf loop_2	; -> loop_1	    
;	call delay_xms		
	return
	
	
; === End of deloay modules ==================	
	
END RESET_VECT